/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.MyUserDetails;
import com.hmdrinks.Entity.Token;
import com.hmdrinks.Entity.User;
import com.hmdrinks.Enum.Role;
import com.hmdrinks.Enum.Sex;
import com.hmdrinks.Enum.TypeLogin;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Exception.ConflictException;
import com.hmdrinks.Exception.NotFoundException;
import com.hmdrinks.Repository.TokenRepository;
import com.hmdrinks.Repository.UserRepository;
import com.hmdrinks.Request.LoginBasicReq;
import com.hmdrinks.Request.UserCreateReq;
import com.hmdrinks.Response.AuthenticationResponse;
import com.hmdrinks.Service.JwtService;
import com.hmdrinks.Service.UserInfoService;
import io.jsonwebtoken.MalformedJwtException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationService {
    private final UserRepository userRepository;
    private final UserInfoService myUserDetailsService;
    private final TokenRepository tokenRepository;
    private final PasswordEncoder passwordEncoder;
    private final JwtService jwtService;
    private final AuthenticationManager authenticationManager;
    @Value(value="${application.security.jwt.expiration}")
    private long jwtExpiration;

    public AuthenticationResponse register(UserCreateReq userCreateReq) {
        Optional userCheck = this.userRepository.findByUserNameAndIsDeletedFalse(userCreateReq.getUserName());
        if (userCheck.isPresent()) {
            throw new ConflictException("User name already exists");
        }
        LocalDate currentDate1 = LocalDate.now();
        User user1 = new User();
        user1.setType(TypeLogin.BASIC);
        user1.setEmail("None");
        user1.setRole(Role.CUSTOMER);
        user1.setIsDeleted(Boolean.valueOf(false));
        user1.setUserName(userCreateReq.getUserName());
        user1.setAvatar("None");
        user1.setDistrict("None");
        user1.setCity("None");
        user1.setStreet("None");
        user1.setSex(Sex.OTHER);
        user1.setDateCreated((java.util.Date)Date.valueOf(currentDate1));
        user1.setPhoneNumber("None");
        user1.setPassword(this.passwordEncoder.encode((CharSequence)userCreateReq.getPassword()));
        user1.setFullName(userCreateReq.getFullName());
        this.userRepository.save((Object)user1);
        Token token = new Token();
        MyUserDetails myUserDetails = this.myUserDetailsService.createMyUserDetails(user1);
        java.util.Date currentDate = new java.util.Date();
        String jwtToken = this.jwtService.generateToken((UserDetails)myUserDetails, String.valueOf(user1.getUserId()), user1.getRole().toString());
        String refreshToken = this.jwtService.generateRefreshToken((UserDetails)myUserDetails, String.valueOf(user1.getUserId()), user1.getRole().toString());
        token.setAccessToken(jwtToken);
        token.setRefreshToken(refreshToken);
        token.setExpire(currentDate);
        token.setUser(user1);
        this.tokenRepository.save((Object)token);
        return AuthenticationResponse.builder().accessToken(jwtToken).refreshToken(refreshToken).build();
    }

    public AuthenticationResponse authenticate(LoginBasicReq request) {
        User user = (User)this.userRepository.findByUserNameAndIsDeletedFalse(request.getUserName()).orElseThrow(() -> new UsernameNotFoundException("Not found user name"));
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getUserName(), (Object)request.getPassword()));
        Token token = this.tokenRepository.findByUserUserId(Integer.valueOf(user.getUserId()));
        if (token == null) {
            token = new Token();
            token.setUser(user);
        }
        MyUserDetails myUserDetails = this.myUserDetailsService.createMyUserDetails(user);
        java.util.Date currentDate = new java.util.Date();
        String jwtToken = this.jwtService.generateToken((UserDetails)myUserDetails, String.valueOf(user.getUserId()), user.getRole().toString());
        String refreshToken = this.jwtService.generateRefreshToken((UserDetails)myUserDetails, String.valueOf(user.getUserId()), user.getRole().toString());
        token.setAccessToken(jwtToken);
        token.setRefreshToken(refreshToken);
        token.setExpire(currentDate);
        this.tokenRepository.save((Object)token);
        return AuthenticationResponse.builder().accessToken(jwtToken).refreshToken(refreshToken).build();
    }

    public AuthenticationResponse refreshToken(HttpServletRequest request, HttpServletResponse response) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            throw new BadRequestException("header is null or didnt not start with Bearer");
        }
        String refreshToken = authHeader.substring(7);
        String userName = this.jwtService.extractUsername(refreshToken);
        if (userName != null) {
            User user = (User)this.userRepository.findByUserNameAndIsDeletedFalse(userName).orElseThrow(() -> new NotFoundException("REFRESH token not found or expired"));
            MyUserDetails myUserDetails = this.myUserDetailsService.createMyUserDetails(user);
            java.util.Date currentDate = new java.util.Date();
            Token token = (Token)this.tokenRepository.findByRefreshToken(refreshToken).orElseThrow(() -> new NotFoundException("REFRESH token not found or expired "));
            if (this.jwtService.isTokenValid(refreshToken, (UserDetails)myUserDetails)) {
                String accessToken = this.jwtService.generateToken((UserDetails)myUserDetails, String.valueOf(user.getUserId()), user.getRole().toString());
                token.setAccessToken(accessToken);
                token.setExpire(currentDate);
                this.tokenRepository.save((Object)token);
                return AuthenticationResponse.builder().accessToken(accessToken).refreshToken(refreshToken).build();
            }
        }
        throw new MalformedJwtException("token invalid");
    }

    public AuthenticationService(UserRepository userRepository, UserInfoService myUserDetailsService, TokenRepository tokenRepository, PasswordEncoder passwordEncoder, JwtService jwtService, AuthenticationManager authenticationManager) {
        this.userRepository = userRepository;
        this.myUserDetailsService = myUserDetailsService;
        this.tokenRepository = tokenRepository;
        this.passwordEncoder = passwordEncoder;
        this.jwtService = jwtService;
        this.authenticationManager = authenticationManager;
    }
}

