/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.Category;
import com.hmdrinks.Entity.Product;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Repository.CategoryRepository;
import com.hmdrinks.Repository.ProductRepository;
import com.hmdrinks.Request.CRUDCategoryRequest;
import com.hmdrinks.Request.CreateCategoryRequest;
import com.hmdrinks.Response.CRUDCategoryResponse;
import com.hmdrinks.Response.CRUDProductResponse;
import com.hmdrinks.Response.GetViewProductCategoryResponse;
import com.hmdrinks.Response.ListCategoryResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private ProductRepository productRepository;

    public CRUDCategoryResponse crateCategory(CreateCategoryRequest req) {
        Category category = this.categoryRepository.findByCateName(req.getCateName());
        if (category != null) {
            throw new BadRequestException("cateName exists");
        }
        Category cate = new Category();
        cate.setCateName(req.getCateName());
        cate.setCateImg(req.getCateImg());
        this.categoryRepository.save((Object)cate);
        return new CRUDCategoryResponse(cate.getCateId(), cate.getCateName(), cate.getCateImg());
    }

    public CRUDCategoryResponse getOneCategory(Integer id) {
        Category category = this.categoryRepository.findByCateId(id);
        if (category == null) {
            throw new BadRequestException("cateId not exists");
        }
        return new CRUDCategoryResponse(category.getCateId(), category.getCateName(), category.getCateImg());
    }

    public CRUDCategoryResponse updateCategory(CRUDCategoryRequest req) {
        Category category = this.categoryRepository.findByCateId(Integer.valueOf(req.getCateId()));
        if (category == null) {
            throw new BadRequestException("cateId not exists");
        }
        Category category1 = this.categoryRepository.findByCateNameAndCateIdNot(req.getCateName(), Integer.valueOf(req.getCateId()));
        if (category1 != null) {
            throw new BadRequestException("cateName exists");
        }
        category.setCateName(category.getCateName());
        category.setCateImg(category.getCateImg());
        this.categoryRepository.save((Object)category);
        return new CRUDCategoryResponse(req.getCateId(), req.getCateName(), req.getCateImg());
    }

    public ListCategoryResponse listCategory() {
        List categoryList = this.categoryRepository.findAll();
        ArrayList<CRUDCategoryResponse> crudCategoryResponseList = new ArrayList<CRUDCategoryResponse>();
        for (Category category : categoryList) {
            crudCategoryResponseList.add(new CRUDCategoryResponse(category.getCateId(), category.getCateName(), category.getCateImg()));
        }
        return new ListCategoryResponse(crudCategoryResponseList);
    }

    public GetViewProductCategoryResponse getAllProductFromCategory(int id) {
        Category category = this.categoryRepository.findByCateId(Integer.valueOf(id));
        if (category == null) {
            throw new BadRequestException("cateId not exists");
        }
        List productList = this.productRepository.findByCategory_CateId(id);
        ArrayList<CRUDProductResponse> crudProductResponseList = new ArrayList<CRUDProductResponse>();
        for (Product product1 : productList) {
            crudProductResponseList.add(new CRUDProductResponse(product1.getProId(), product1.getCategory().getCateId(), product1.getProName(), product1.getProImg(), product1.getDescription(), product1.getIsDeleted().booleanValue(), product1.getDateDeleted()));
        }
        return new GetViewProductCategoryResponse(id, crudProductResponseList);
    }
}

