/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.cloudinary.Cloudinary;
import com.cloudinary.utils.ObjectUtils;
import com.hmdrinks.Entity.Category;
import com.hmdrinks.Entity.Post;
import com.hmdrinks.Entity.Product;
import com.hmdrinks.Entity.User;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Exception.NotFoundException;
import com.hmdrinks.Repository.CategoryRepository;
import com.hmdrinks.Repository.PostRepository;
import com.hmdrinks.Repository.ProductRepository;
import com.hmdrinks.Repository.UserRepository;
import com.hmdrinks.Response.ImgResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImgService {
    @Value(value="${cloudinary.url}")
    private String cloudinaryUrl;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private PostRepository postRepository;
    @Autowired
    private UserRepository userRepository;

    public ImgResponse uploadImgUser(MultipartFile multipartFile, int userId) throws IOException {
        if (!this.processFile(multipartFile)) {
            throw new BadRequestException("Incorrect formatting");
        }
        User users = this.userRepository.findByUserId(userId);
        if (users == null) {
            throw new NotFoundException("Not found userId");
        }
        Cloudinary cloudinary = new Cloudinary(this.cloudinaryUrl);
        cloudinary.config.secure = true;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            Map params = ObjectUtils.asMap((Object[])new Object[]{"use_filename", true, "unique_filename", false, "overwrite", true});
            File tempFile = File.createTempFile("upload-", ".tmp");
            multipartFile.transferTo(tempFile);
            Map uploadResult = cloudinary.uploader().upload((Object)tempFile, params);
            String imageUrl = (String)uploadResult.get("secure_url");
            ImgResponse imgResponse = new ImgResponse();
            imgResponse.setUrl(imageUrl);
            User user = this.userRepository.findByUserId(userId);
            if (user == null) {
                throw new RuntimeException("Khong ton tai userId");
            }
            user.setAvatar(imageUrl);
            this.userRepository.save((Object)user);
            return imgResponse;
        }
        catch (Exception e) {
            System.out.println("Error uploading image: " + e.getMessage());
            throw new IOException("Could not upload image: " + e.getMessage());
        }
    }

    public ImgResponse uploadImgCategory(MultipartFile multipartFile, int cateId) throws IOException {
        if (!this.processFile(multipartFile)) {
            throw new BadRequestException("Incorrect formatting");
        }
        Category category = this.categoryRepository.findByCateId(Integer.valueOf(cateId));
        if (category == null) {
            throw new NotFoundException("Not found cateId");
        }
        Cloudinary cloudinary = new Cloudinary(this.cloudinaryUrl);
        cloudinary.config.secure = true;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            Map params = ObjectUtils.asMap((Object[])new Object[]{"use_filename", true, "unique_filename", false, "overwrite", true});
            File tempFile = File.createTempFile("upload-", ".tmp");
            multipartFile.transferTo(tempFile);
            Map uploadResult = cloudinary.uploader().upload((Object)tempFile, params);
            String imageUrl = (String)uploadResult.get("secure_url");
            ImgResponse imgResponse = new ImgResponse();
            imgResponse.setUrl(imageUrl);
            category.setCateImg(imageUrl);
            this.categoryRepository.save((Object)category);
            return imgResponse;
        }
        catch (Exception e) {
            System.out.println("Error uploading image: " + e.getMessage());
            throw new IOException("Could not upload image: " + e.getMessage());
        }
    }

    public ImgResponse uploadImgPost(MultipartFile multipartFile, int postId) throws IOException {
        if (!this.processFile(multipartFile)) {
            throw new BadRequestException("Incorrect formatting");
        }
        Post post = this.postRepository.findByPostId(postId);
        Cloudinary cloudinary = new Cloudinary(this.cloudinaryUrl);
        cloudinary.config.secure = true;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            Map params = ObjectUtils.asMap((Object[])new Object[]{"use_filename", true, "unique_filename", false, "overwrite", true});
            File tempFile = File.createTempFile("upload-", ".tmp");
            multipartFile.transferTo(tempFile);
            Map uploadResult = cloudinary.uploader().upload((Object)tempFile, params);
            String imageUrl = (String)uploadResult.get("secure_url");
            ImgResponse imgResponse = new ImgResponse();
            imgResponse.setUrl(imageUrl);
            post.setBannerUrl(imageUrl);
            this.postRepository.save((Object)post);
            return imgResponse;
        }
        catch (Exception e) {
            System.out.println("Error uploading image: " + e.getMessage());
            throw new IOException("Could not upload image: " + e.getMessage());
        }
    }

    public ImgResponse uploadImgProduct(MultipartFile multipartFile, int proId) throws IOException {
        if (!this.processFile(multipartFile)) {
            throw new BadRequestException("Incorrect formatting");
        }
        Product product = this.productRepository.findByProId(Integer.valueOf(proId));
        if (product == null) {
            throw new NotFoundException("Not found proId");
        }
        Cloudinary cloudinary = new Cloudinary(this.cloudinaryUrl);
        cloudinary.config.secure = true;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            Map params = ObjectUtils.asMap((Object[])new Object[]{"use_filename", true, "unique_filename", false, "overwrite", true});
            File tempFile = File.createTempFile("upload-", ".tmp");
            multipartFile.transferTo(tempFile);
            Map uploadResult = cloudinary.uploader().upload((Object)tempFile, params);
            String imageUrl = (String)uploadResult.get("secure_url");
            ImgResponse imgResponse = new ImgResponse();
            imgResponse.setUrl(imageUrl);
            product.setProImg(imageUrl);
            this.productRepository.save((Object)product);
            return imgResponse;
        }
        catch (Exception e) {
            System.out.println("Error uploading image: " + e.getMessage());
            throw new IOException("Could not upload image: " + e.getMessage());
        }
    }

    public boolean processFile(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        String contentType = file.getContentType();
        return originalFilename != null && (originalFilename.endsWith(".jpg") || originalFilename.endsWith(".png") || originalFilename.endsWith(".jpeg") || originalFilename.endsWith(".raw") || originalFilename.endsWith(".psd") || originalFilename.endsWith(".tif") || originalFilename.endsWith(".tiff") || originalFilename.endsWith(".gif") || originalFilename.endsWith(".webp") || originalFilename.endsWith(".bmp") || originalFilename.endsWith(".heif") || originalFilename.endsWith(".xcf") || contentType.startsWith("image/"));
    }
}

