/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.Token;
import com.hmdrinks.Repository.TokenRepository;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.stereotype.Service;

@Service
public class LogoutService
implements LogoutHandler {
    private final TokenRepository tokenRepository;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            return;
        }
        String jwt = authHeader.substring(7);
        Token storedToken = this.tokenRepository.findByAccessToken(jwt).orElse(null);
        if (storedToken != null) {
            storedToken.setAccessToken("");
            storedToken.setRefreshToken("");
            this.tokenRepository.save((Object)storedToken);
            SecurityContextHolder.clearContext();
        }
    }

    public LogoutService(TokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
    }
}

