/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.Product;
import com.hmdrinks.Entity.ProductVariants;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Repository.ProductRepository;
import com.hmdrinks.Repository.ProductVariantsRepository;
import com.hmdrinks.Request.CRUDProductVarReq;
import com.hmdrinks.Request.CreateProductVarReq;
import com.hmdrinks.Response.CRUDProductVarResponse;
import com.hmdrinks.Response.ListProductVarResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductVarService {
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private ProductVariantsRepository proVarRepository;

    public CRUDProductVarResponse crateProductVariants(CreateProductVarReq req) {
        Product product = this.productRepository.findByProId(Integer.valueOf(req.getProId()));
        if (product == null) {
            throw new BadRequestException("proId not exists");
        }
        ProductVariants productVariants = this.proVarRepository.findBySizeAndProduct_ProId(req.getSize(), Integer.valueOf(req.getProId()));
        if (productVariants != null) {
            throw new BadRequestException("production size exists");
        }
        ProductVariants productVariants1 = new ProductVariants();
        productVariants1.setProduct(product);
        productVariants1.setSize(req.getSize());
        productVariants1.setStock(req.getStock());
        productVariants1.setPrice(req.getPrice().doubleValue());
        productVariants1.setIsDeleted(Boolean.valueOf(false));
        this.proVarRepository.save((Object)productVariants1);
        return new CRUDProductVarResponse(productVariants1.getVarId(), productVariants1.getProduct().getProId(), productVariants1.getSize(), Double.valueOf(productVariants1.getPrice()), productVariants1.getStock(), productVariants1.getIsDeleted().booleanValue(), productVariants1.getDateDeleted());
    }

    public CRUDProductVarResponse getOneVarProduct(Integer id) {
        ProductVariants productVariants1 = this.proVarRepository.findByVarId(id);
        if (productVariants1 == null) {
            throw new BadRequestException("production id not exists");
        }
        return new CRUDProductVarResponse(productVariants1.getVarId(), productVariants1.getProduct().getProId(), productVariants1.getSize(), Double.valueOf(productVariants1.getPrice()), productVariants1.getStock(), productVariants1.getIsDeleted().booleanValue(), productVariants1.getDateDeleted());
    }

    public CRUDProductVarResponse updateProduct(CRUDProductVarReq req) {
        Product product = this.productRepository.findByProId(Integer.valueOf(req.getProId()));
        if (product == null) {
            throw new BadRequestException("proId not exists");
        }
        ProductVariants productVariants = this.proVarRepository.findBySizeAndProduct_ProIdAndVarIdNot(req.getSize(), Integer.valueOf(req.getProId()), Integer.valueOf(req.getVarId()));
        if (productVariants != null) {
            throw new BadRequestException("production size exists");
        }
        ProductVariants productVariants1 = this.proVarRepository.findByVarId(Integer.valueOf(req.getVarId()));
        if (productVariants1 == null) {
            throw new BadRequestException("production variations id not exists");
        }
        productVariants1.setProduct(product);
        productVariants1.setSize(req.getSize());
        productVariants1.setStock(req.getStock());
        productVariants1.setPrice(req.getPrice().doubleValue());
        productVariants1.setIsDeleted(Boolean.valueOf(false));
        this.proVarRepository.save((Object)productVariants1);
        return new CRUDProductVarResponse(productVariants1.getVarId(), productVariants1.getProduct().getProId(), productVariants1.getSize(), Double.valueOf(productVariants1.getPrice()), productVariants1.getStock(), productVariants1.getIsDeleted().booleanValue(), productVariants1.getDateDeleted());
    }

    public ListProductVarResponse listProduct() {
        List productList = this.proVarRepository.findAll();
        ArrayList<CRUDProductVarResponse> crudProductVarResponseList = new ArrayList<CRUDProductVarResponse>();
        for (ProductVariants product1 : productList) {
            crudProductVarResponseList.add(new CRUDProductVarResponse(product1.getVarId(), product1.getProduct().getProId(), product1.getSize(), Double.valueOf(product1.getPrice()), product1.getStock(), product1.getIsDeleted().booleanValue(), product1.getDateDeleted()));
        }
        return new ListProductVarResponse(crudProductVarResponseList);
    }
}

