/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.OTP;
import com.hmdrinks.Entity.User;
import com.hmdrinks.Enum.Sex;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Exception.ConflictException;
import com.hmdrinks.Exception.NotFoundException;
import com.hmdrinks.Repository.OtpRepository;
import com.hmdrinks.Repository.UserRepository;
import com.hmdrinks.Request.ChangePasswordReq;
import com.hmdrinks.Request.UserInfoUpdateReq;
import com.hmdrinks.Response.ChangePasswordResponse;
import com.hmdrinks.Response.DetailUserResponse;
import com.hmdrinks.Response.GetDetailUserInfoResponse;
import com.hmdrinks.Response.ListAllUserResponse;
import com.hmdrinks.Response.MessageResponse;
import com.hmdrinks.Response.SendEmailResponse;
import com.hmdrinks.Response.UpdateUserInfoResponse;
import com.hmdrinks.SupportFunction.SupportFunction;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private final UserRepository userRepository;
    private final OtpRepository otpRepository;
    private final SupportFunction supportFunction;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private JavaMailSender javaMailSender;

    public ListAllUserResponse getListAllUser() {
        List userList = this.userRepository.findAll();
        ArrayList<DetailUserResponse> detailUserResponseList = new ArrayList<DetailUserResponse>();
        for (User user : userList) {
            String fullLocation = user.getStreet() + "," + user.getDistrict() + "," + user.getCity();
            detailUserResponseList.add(new DetailUserResponse(Integer.valueOf(user.getUserId()), user.getUserName(), user.getFullName(), user.getAvatar(), user.getBirthDate(), fullLocation, user.getEmail(), user.getPhoneNumber(), user.getSex().toString(), user.getType().toString(), user.getIsDeleted(), user.getDateDeleted(), user.getDateUpdated(), user.getDateCreated(), user.getRole().toString()));
        }
        return new ListAllUserResponse(detailUserResponseList);
    }

    public GetDetailUserInfoResponse getDetailUserInfoResponse(Integer id) {
        User userList = this.userRepository.findByUserId(id.intValue());
        if (userList == null) {
            throw new RuntimeException("Khong ton tai user");
        }
        String fullLocation = userList.getStreet() + "," + userList.getDistrict() + "," + userList.getCity();
        return new GetDetailUserInfoResponse(Integer.valueOf(userList.getUserId()), userList.getUserName(), userList.getFullName(), userList.getAvatar(), userList.getBirthDate(), fullLocation, userList.getEmail(), userList.getPhoneNumber(), userList.getSex().toString(), userList.getType().toString(), userList.getIsDeleted(), userList.getDateDeleted(), userList.getDateUpdated(), userList.getDateCreated(), userList.getRole().toString());
    }

    public UpdateUserInfoResponse updateUserInfoResponse(UserInfoUpdateReq req) {
        User userList = this.userRepository.findByUserId(req.getUserId().intValue());
        if (userList == null) {
            throw new NotFoundException("User does not exist");
        }
        Optional user = this.userRepository.findByEmailAndUserIdNot(req.getEmail(), req.getUserId());
        if (user.isPresent()) {
            throw new ConflictException("Email already exists");
        }
        this.supportFunction.checkPhoneNumber(req.getPhoneNumber(), req.getUserId(), this.userRepository);
        User userWithEmail = this.userRepository.findByEmail(req.getEmail());
        LocalDate currentDate = LocalDate.now();
        String[] locationParts = req.getAddress().split(",");
        userList.setEmail(req.getEmail());
        userList.setFullName(req.getFullName());
        userList.setPhoneNumber(req.getPhoneNumber());
        userList.setAvatar(req.getAvatar());
        userList.setSex(Sex.valueOf((String)req.getSex()));
        userList.setBirthDate(req.getBirthDay());
        userList.setDateUpdated((java.util.Date)Date.valueOf(currentDate));
        if (locationParts.length < 3) {
            throw new BadRequestException("Invalid address format");
        }
        String street = locationParts[0].trim();
        String district = locationParts[1].trim();
        String city = locationParts[2].trim();
        userList.setCity(city);
        userList.setStreet(street);
        userList.setDistrict(district);
        this.userRepository.save((Object)userList);
        return new UpdateUserInfoResponse(Integer.valueOf(userList.getUserId()), userList.getUserName(), userList.getFullName(), userList.getAvatar(), userList.getBirthDate(), req.getAddress(), userList.getEmail(), userList.getPhoneNumber(), userList.getSex().toString(), userList.getType().toString(), userList.getIsDeleted(), userList.getDateDeleted(), userList.getDateUpdated(), userList.getDateCreated(), userList.getRole().toString());
    }

    public SendEmailResponse sendEmail(String email) {
        Random random = new Random();
        User users = this.userRepository.findByEmail(email);
        if (users == null) {
            throw new NotFoundException("Username or email does not exist");
        }
        OTP otpEntity = this.otpRepository.findByEmail(email);
        if (otpEntity != null) {
            this.otpRepository.deleteById((Object)otpEntity.getOtpId());
        }
        int randomNumber = random.nextInt(900000) + 100000;
        String to = users.getEmail();
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom("HMDRINKS");
        message.setTo(to);
        String text = "Dear user,\n\nWe have received a request to reset the password for your account.\nPlease use the following One-Time Password (OTP) to proceed with the password recovery process:\n\nYour Password Recovery OTP: " + randomNumber + "\n\nThis OTP is valid for a single use and will expire in 10 minutes for security reasons.\nPlease make sure to use the OTP within this timeframe.\n\nFor security purposes, do not share this OTP with anyone.\nIf you did not initiate this request, you can safely ignore this email.\nPlease ensure the security of your account and do not reply to this message.\n\nBest regards,\nYour Application Support Team";
        message.setSubject("Password Recovery OTP");
        message.setText(text);
        this.javaMailSender.send(message);
        LocalDateTime currentDateTime = LocalDateTime.now();
        OTP otp = new OTP();
        otp.setEmail(users.getEmail());
        otp.setUserName(users.getUserName());
        otp.setOtp(String.valueOf(randomNumber));
        otp.setTimeOtp(currentDateTime);
        otp.setStatus(Boolean.TRUE);
        this.otpRepository.save((Object)otp);
        return new SendEmailResponse(otp.getEmail(), "OTP has been sent to your email.");
    }

    public MessageResponse AcceptOTP(String email, int OTP2) {
        String newPass = "pass12345";
        OTP otp = this.otpRepository.findOTP(email, String.valueOf(OTP2));
        User users = this.userRepository.findByEmail(email);
        if (otp != null && OTP2 == Integer.parseInt(otp.getOtp())) {
            boolean isWithinTenMinutes;
            LocalDateTime currentDateTime = LocalDateTime.now();
            LocalDateTime tenMinutesAgo = currentDateTime.minusMinutes(10L);
            boolean bl = isWithinTenMinutes = otp.getTimeOtp().isAfter(tenMinutesAgo) && otp.getTimeOtp().isBefore(currentDateTime);
            if (isWithinTenMinutes) {
                users.setPassword(this.passwordEncoder.encode((CharSequence)newPass));
                this.userRepository.save((Object)users);
                String to = users.getEmail();
                SimpleMailMessage message = new SimpleMailMessage();
                message.setFrom("HMDRINKS");
                message.setTo(to);
                String text = "Hello user,\n\nWe have received a password recovery request for your account. Below is your new password:\n\nUsername:" + users.getUserName() + "\n\nNew Password: " + newPass + "\n\nPlease make sure to copy the password above and paste it into the login page to avoid any errors.\n\nIf you did not initiate this request, please disregard this email and ensure the security of your account.\n\nBest regards,\nYour Application Support Team";
                message.setSubject("Password Recovery Information for Your Account");
                message.setText(text);
                this.javaMailSender.send(message);
                otp.setStatus(Boolean.FALSE);
                this.otpRepository.save((Object)otp);
                return new MessageResponse("Your new password was sent to your email. Please check email.");
            }
            otp.setStatus(Boolean.FALSE);
            this.otpRepository.save((Object)otp);
            return new MessageResponse("OTP existing time is expired.");
        }
        return new MessageResponse("Your username, email or OTP is not correct.");
    }

    public ChangePasswordResponse changePasswordResponse(ChangePasswordReq req) {
        User users = this.userRepository.findByUserId(req.getUserId().intValue());
        if (users == null) {
            throw new NotFoundException("Not found user");
        }
        if (!this.passwordEncoder.matches((CharSequence)req.getCurrentPassword(), users.getPassword())) {
            throw new BadRequestException("The current password is incorrect");
        }
        if (req.getNewPassword().equals(req.getCurrentPassword())) {
            throw new BadRequestException("You're using an old password");
        }
        if (!req.getNewPassword().matches(req.getConfirmNewPassword())) {
            throw new BadRequestException("No overlap");
        }
        users.setPassword(this.passwordEncoder.encode((CharSequence)req.getNewPassword()));
        this.userRepository.save((Object)users);
        String message = "Password change successfully";
        return new ChangePasswordResponse(message, req.getNewPassword());
    }

    public UserService(UserRepository userRepository, OtpRepository otpRepository, SupportFunction supportFunction) {
        this.userRepository = userRepository;
        this.otpRepository = otpRepository;
        this.supportFunction = supportFunction;
    }
}

