/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.SupportFunction;

import com.hmdrinks.Entity.User;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Exception.ConflictException;
import com.hmdrinks.Repository.UserRepository;
import com.hmdrinks.Service.JwtService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupportFunction {
    private UserRepository userRepository;
    private final JwtService jwtService;

    @Autowired
    public SupportFunction(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    public boolean checkRole(String role) {
        return role.equals("ADMIN") || role.equals("CUSTOMER") || role.equals("SHIPPER");
    }

    public void checkUserAuthorization(HttpServletRequest httpRequest, Long userIdFromRequest) {
        String authHeader = httpRequest.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            throw new BadRequestException("Authorization header is missing or invalid");
        }
        String jwt = authHeader.substring(7);
        String userIdFromToken = this.jwtService.extractUserId(jwt);
        if (!String.valueOf(userIdFromRequest).equals(userIdFromToken)) {
            throw new BadRequestException("You do not have permission to perform this action");
        }
    }

    public void checkPhoneNumber(String phoneNumber, Integer userId, UserRepository userRepository) {
        User existingUser;
        if (phoneNumber == null || phoneNumber.length() != 10) {
            throw new BadRequestException("S\u1ed1 \u0111i\u1ec7n tho\u1ea1i kh\u00f4ng h\u1ee3p l\u1ec7. Ph\u1ea3i ch\u1ee9a 10 ch\u1eef s\u1ed1.");
        }
        Optional existingUserOptional = userRepository.findByPhoneNumberAndIsDeletedFalse(phoneNumber);
        if (existingUserOptional.isPresent() && (existingUser = (User)existingUserOptional.get()).getUserId() != userId.intValue()) {
            throw new ConflictException("S\u1ed1 \u0111i\u1ec7n tho\u1ea1i \u0111\u00e3 t\u1ed3n t\u1ea1i.");
        }
    }
}

