## food.py
import random
import pygame
from constants import SCREEN_WIDTH, SCREEN_HEIGHT, FOOD_SIZE, FOOD_COLOR

class Food:
    def __init__(self):
        self.position = (0, 0)  # Default position
        self.spawn()

    def spawn(self):
        # Set the position of the food to a random coordinate on the screen
        # The position is adjusted by FOOD_SIZE to avoid spawning outside the screen boundaries
        self.position = (
            random.randint(0, (SCREEN_WIDTH - FOOD_SIZE) // FOOD_SIZE) * FOOD_SIZE,
            random.randint(0, (SCREEN_HEIGHT - FOOD_SIZE) // FOOD_SIZE) * FOOD_SIZE
        )

    def draw(self, screen: pygame.Surface):
        # Draw the food as a square on the screen at the food's position
        pygame.draw.rect(
            screen,
            FOOD_COLOR,
            pygame.Rect(self.position[0], self.position[1], FOOD_SIZE, FOOD_SIZE)
        )
