/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.statistical;

import edu.stanford.nlp.coref.CorefDocumentProcessor;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.statistical.Compressor;
import edu.stanford.nlp.coref.statistical.DocumentExamples;
import edu.stanford.nlp.coref.statistical.FeatureExtractor;
import edu.stanford.nlp.coref.statistical.StatisticalCorefTrainer;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FeatureExtractorRunner
implements CorefDocumentProcessor {
    private final FeatureExtractor extractor;
    private final Compressor<String> compressor;
    private final Map<Integer, Map<Pair<Integer, Integer>, Boolean>> dataset;
    private final List<DocumentExamples> documents = new ArrayList<DocumentExamples>();

    public FeatureExtractorRunner(Properties props, Dictionaries dictionaries) {
        this.compressor = new Compressor();
        this.extractor = new FeatureExtractor(props, dictionaries, this.compressor);
        try {
            this.dataset = (Map)IOUtils.readObjectFromFile(StatisticalCorefTrainer.datasetFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing FeatureExtractorRunner", e);
        }
    }

    @Override
    public void process(int id, Document document) {
        if (this.dataset.containsKey(id)) {
            this.documents.add(this.extractor.extract(id, document, this.dataset.get(id)));
        }
    }

    @Override
    public void finish() throws Exception {
        IOUtils.writeObjectToFile(this.documents, StatisticalCorefTrainer.extractedFeaturesFile);
        IOUtils.writeObjectToFile(this.compressor, StatisticalCorefTrainer.compressorFile);
    }
}

