/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.statistical;

import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.statistical.Clusterer;
import edu.stanford.nlp.coref.statistical.DatasetBuilder;
import edu.stanford.nlp.coref.statistical.FeatureExtractorRunner;
import edu.stanford.nlp.coref.statistical.MetaFeatureExtractor;
import edu.stanford.nlp.coref.statistical.MetadataWriter;
import edu.stanford.nlp.coref.statistical.PairwiseModel;
import edu.stanford.nlp.coref.statistical.PairwiseModelTrainer;
import edu.stanford.nlp.coref.statistical.StatisticalCorefProperties;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Properties;

public class StatisticalCorefTrainer {
    public static final String CLASSIFICATION_MODEL = "classification";
    public static final String RANKING_MODEL = "ranking";
    public static final String ANAPHORICITY_MODEL = "anaphoricity";
    public static final String CLUSTERING_MODEL_NAME = "clusterer";
    public static final String EXTRACTED_FEATURES_NAME = "features";
    public static String trainingPath;
    public static String pairwiseModelsPath;
    public static String clusteringModelsPath;
    public static String predictionsName;
    public static String datasetFile;
    public static String goldClustersFile;
    public static String wordCountsFile;
    public static String mentionTypesFile;
    public static String compressorFile;
    public static String extractedFeaturesFile;

    private static void makeDir(String path) {
        File outDir = new File(path);
        if (!outDir.exists()) {
            outDir.mkdir();
        }
    }

    public static void setTrainingPath(Properties props) {
        trainingPath = StatisticalCorefProperties.trainingPath(props);
        pairwiseModelsPath = trainingPath + "pairwise_models/";
        clusteringModelsPath = trainingPath + "clustering_models/";
        StatisticalCorefTrainer.makeDir(pairwiseModelsPath);
        StatisticalCorefTrainer.makeDir(clusteringModelsPath);
    }

    public static void setDataPath(String name) {
        String dataPath = trainingPath + name + "/";
        String extractedFeaturesPath = dataPath + EXTRACTED_FEATURES_NAME + "/";
        StatisticalCorefTrainer.makeDir(dataPath);
        StatisticalCorefTrainer.makeDir(extractedFeaturesPath);
        datasetFile = dataPath + "dataset.ser";
        predictionsName = name + "_predictions";
        goldClustersFile = dataPath + "gold_clusters.ser";
        mentionTypesFile = dataPath + "mention_types.ser";
        compressorFile = extractedFeaturesPath + "compressor.ser";
        extractedFeaturesFile = extractedFeaturesPath + "compressed_features.ser";
    }

    public static String fieldValues(Object o) {
        Field[] fields;
        String s = "";
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                s = s + field.getName() + " = " + field.get(o) + "\n";
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting field value for " + field.getName(), e);
            }
        }
        return s;
    }

    private static void preprocess(Properties props, Dictionaries dictionaries, boolean isTrainSet) throws Exception {
        (isTrainSet ? new DatasetBuilder(StatisticalCorefProperties.minClassImbalance(props), StatisticalCorefProperties.maxTrainExamplesPerDocument(props)) : new DatasetBuilder()).runFromScratch(props, dictionaries);
        new MetadataWriter(isTrainSet).runFromScratch(props, dictionaries);
        new FeatureExtractorRunner(props, dictionaries).runFromScratch(props, dictionaries);
    }

    public static void doTraining(Properties props) throws Exception {
        StatisticalCorefTrainer.setTrainingPath(props);
        Dictionaries dictionaries = new Dictionaries(props);
        StatisticalCorefTrainer.setDataPath("train");
        wordCountsFile = trainingPath + "train/word_counts.ser";
        CorefProperties.setInput(props, CorefProperties.Dataset.TRAIN);
        StatisticalCorefTrainer.preprocess(props, dictionaries, true);
        StatisticalCorefTrainer.setDataPath("dev");
        CorefProperties.setInput(props, CorefProperties.Dataset.DEV);
        StatisticalCorefTrainer.preprocess(props, dictionaries, false);
        StatisticalCorefTrainer.setDataPath("train");
        dictionaries = null;
        PairwiseModel classificationModel = PairwiseModel.newBuilder(CLASSIFICATION_MODEL, MetaFeatureExtractor.newBuilder().build()).build();
        PairwiseModel rankingModel = PairwiseModel.newBuilder(RANKING_MODEL, MetaFeatureExtractor.newBuilder().build()).build();
        PairwiseModel anaphoricityModel = PairwiseModel.newBuilder(ANAPHORICITY_MODEL, MetaFeatureExtractor.anaphoricityMFE()).trainingExamples(5000000).build();
        PairwiseModelTrainer.trainRanking(rankingModel);
        PairwiseModelTrainer.trainClassification(classificationModel, false);
        PairwiseModelTrainer.trainClassification(anaphoricityModel, true);
        StatisticalCorefTrainer.setDataPath("dev");
        PairwiseModelTrainer.test(classificationModel, predictionsName, false);
        PairwiseModelTrainer.test(rankingModel, predictionsName, false);
        PairwiseModelTrainer.test(anaphoricityModel, predictionsName, true);
        new Clusterer().doTraining(CLUSTERING_MODEL_NAME);
    }

    public static void main(String[] args) throws Exception {
        StatisticalCorefTrainer.doTraining(StringUtils.argsToProperties(args));
    }
}

