/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.KBPRelationExtractor;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.semgrex.SemgrexBatchParser;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KBPSemgrexExtractor
implements KBPRelationExtractor {
    protected final Redwood.RedwoodChannels logger = Redwood.channels(KBPSemgrexExtractor.class);
    @ArgumentParser.Option(name="dir", gloss="The semgrex directory")
    public static String DIR = "edu/stanford/nlp/models/kbp/english/semgrex";
    @ArgumentParser.Option(name="test", gloss="The dataset to test on")
    public static File TEST_FILE = new File("test.conll");
    @ArgumentParser.Option(name="predictions", gloss="Dump model predictions to this file")
    public static Optional<String> PREDICTIONS = Optional.empty();
    private final Map<KBPRelationExtractor.RelationType, Collection<SemgrexPattern>> rules = new HashMap<KBPRelationExtractor.RelationType, Collection<SemgrexPattern>>();

    public KBPSemgrexExtractor(String semgrexdir) throws IOException {
        this(semgrexdir, false);
    }

    public KBPSemgrexExtractor(String semgrexdir, boolean verbose) throws IOException {
        if (verbose) {
            this.logger.log("Creating SemgrexRegexExtractor");
        }
        for (KBPRelationExtractor.RelationType rel : KBPRelationExtractor.RelationType.values()) {
            String relFileNameComponent = rel.canonicalName.replaceAll(":", "_");
            String filename = semgrexdir + File.separator + relFileNameComponent.replace("/", "SLASH") + ".rules";
            if (!IOUtils.existsInClasspathOrFileSystem(filename)) continue;
            List<SemgrexPattern> rulesforrel = SemgrexBatchParser.compileStream(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filename));
            if (verbose) {
                this.logger.log("Read " + rulesforrel.size() + " rules from " + filename + " for relation " + (Object)((Object)rel));
            }
            this.rules.put(rel, rulesforrel);
        }
    }

    @Override
    public Pair<String, Double> classify(KBPRelationExtractor.KBPInput input) {
        for (KBPRelationExtractor.RelationType rel : KBPRelationExtractor.RelationType.values()) {
            if (!this.rules.containsKey((Object)rel) || rel.entityType != input.subjectType || !rel.validNamedEntityLabels.contains((Object)input.objectType)) continue;
            Collection<SemgrexPattern> rulesForRel = this.rules.get((Object)rel);
            CoreMap sentence = input.sentence.asCoreMap(Sentence::nerTags, Sentence::dependencyGraph);
            SemgrexPattern matchedPattern = this.matches(sentence, rulesForRel, input, (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class));
            if (matchedPattern == null) {
                matchedPattern = this.matches(sentence, rulesForRel, input, (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class));
            }
            if (matchedPattern == null) continue;
            return Pair.makePair(rel.canonicalName, 1.0);
        }
        return Pair.makePair("no_relation", 1.0);
    }

    private SemgrexPattern matches(CoreMap sentence, Collection<SemgrexPattern> rulesForRel, KBPRelationExtractor.KBPInput input, SemanticGraph graph) {
        int i;
        if (graph == null || graph.isEmpty()) {
            return null;
        }
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        Iterator<Serializable> iterator = input.subjectSpan.iterator();
        while (iterator.hasNext()) {
            i = iterator.next();
            if (!"O".equals(((CoreLabel)tokens.get(i)).ner())) continue;
            ((CoreLabel)tokens.get(i)).setNER(input.subjectType.name);
        }
        iterator = input.objectSpan.iterator();
        while (iterator.hasNext()) {
            i = iterator.next();
            if (!"O".equals(((CoreLabel)tokens.get(i)).ner())) continue;
            ((CoreLabel)tokens.get(i)).setNER(input.objectType.name);
        }
        for (SemgrexPattern p : rulesForRel) {
            SemgrexMatcher n = p.matcher(graph);
            while (n.find()) {
                boolean hasObject;
                IndexedWord entity = n.getNode("entity");
                IndexedWord slot = n.getNode("slot");
                if (entity == null) {
                    this.logger.warn("Found a relation with a missing entity: " + p);
                    continue;
                }
                if (slot == null) {
                    this.logger.warn("Found a relation with a missing slot: " + p);
                    continue;
                }
                boolean hasSubject = entity.index() >= input.subjectSpan.start() + 1 && entity.index() <= input.subjectSpan.end();
                boolean bl = hasObject = slot.index() >= input.objectSpan.start() + 1 && slot.index() <= input.objectSpan.end();
                if (!hasSubject || !hasObject) continue;
                return p;
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        RedwoodConfiguration.standard().apply();
        ArgumentParser.fillOptions(KBPSemgrexExtractor.class, args);
        KBPSemgrexExtractor extractor = new KBPSemgrexExtractor(DIR);
        List<Pair<KBPRelationExtractor.KBPInput, String>> testExamples = KBPRelationExtractor.readDataset(TEST_FILE);
        extractor.computeAccuracy(testExamples.stream(), PREDICTIONS.map(x -> {
            try {
                return "stdout".equalsIgnoreCase((String)x) ? System.out : new PrintStream(new FileOutputStream((String)x));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }));
    }
}

