/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.EventMention;
import edu.stanford.nlp.ie.machinereading.structure.ExtractionObject;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.machinereading.structure.RelationMentionFactory;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class AnnotationUtils {
    private static final Redwood.RedwoodChannels log = Redwood.channels(AnnotationUtils.class);

    private AnnotationUtils() {
    }

    public static Annotation createDataset(List<CoreMap> sentences) {
        Annotation dataset = new Annotation("");
        AnnotationUtils.addSentences(dataset, sentences);
        return dataset;
    }

    public static void shuffleSentences(CoreMap dataset) {
        List sentences = (List)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        Collections.shuffle(sentences, new Random(0L));
        dataset.set(CoreAnnotations.SentencesAnnotation.class, sentences);
    }

    public static List<List<CoreLabel>> entityMentionsToCoreLabels(CoreMap dataset, Set<String> annotationsToSkip, boolean useSubTypes, boolean useBIO) {
        ArrayList<List<CoreLabel>> retVal = new ArrayList<List<CoreLabel>>();
        List sentences = (List)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            List<CoreLabel> labeledSentence = AnnotationUtils.sentenceEntityMentionsToCoreLabels(sentence, true, annotationsToSkip, null, useSubTypes, useBIO);
            assert (labeledSentence != null);
            retVal.add(labeledSentence);
        }
        return retVal;
    }

    public static List<CoreLabel> sentenceEntityMentionsToCoreLabels(CoreMap sentence, boolean addAnswerAnnotation, Set<String> annotationsToSkip, Set<String> mentionTypesToUse, boolean useSubTypes, boolean useBIO) {
        List entities;
        ArrayList<CoreLabel> labels = new ArrayList<CoreLabel>();
        for (CoreLabel l : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
            CoreLabel nl = new CoreLabel(l);
            if (addAnswerAnnotation) {
                nl.set(CoreAnnotations.AnswerAnnotation.class, "O");
            }
            labels.add(nl);
        }
        if (addAnswerAnnotation && (entities = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) != null) {
            for (EntityMention entity : entities) {
                if (annotationsToSkip != null && annotationsToSkip.contains(entity.getType()) || mentionTypesToUse != null && !mentionTypesToUse.contains(entity.getMentionType()) || entity.getHead() == null) continue;
                for (int i = entity.getHeadTokenStart(); i < entity.getHeadTokenEnd(); ++i) {
                    String tag = entity.getType();
                    if (useSubTypes && entity.getSubType() != null) {
                        tag = tag + "-" + entity.getSubType();
                    }
                    if (useBIO) {
                        tag = i == entity.getHeadTokenStart() ? "B-" + tag : "I-" + tag;
                    }
                    ((CoreLabel)labels.get(i)).set(CoreAnnotations.AnswerAnnotation.class, tag);
                }
            }
        }
        return labels;
    }

    public static CoreMap getSentence(CoreMap dataset, int i) {
        return (CoreMap)((List)dataset.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
    }

    public static int sentenceCount(CoreMap dataset) {
        List sents = (List)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        if (sents != null) {
            return sents.size();
        }
        return 0;
    }

    public static void addSentence(CoreMap dataset, CoreMap sentence) {
        ArrayList<CoreMap> sents = (ArrayList<CoreMap>)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        if (sents == null) {
            sents = new ArrayList<CoreMap>();
            dataset.set(CoreAnnotations.SentencesAnnotation.class, sents);
        }
        sents.add(sentence);
    }

    public static void addSentences(CoreMap dataset, List<CoreMap> sentences) {
        ArrayList<CoreMap> sents = (ArrayList<CoreMap>)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        if (sents == null) {
            sents = new ArrayList<CoreMap>();
            dataset.set(CoreAnnotations.SentencesAnnotation.class, sents);
        }
        sents.addAll(sentences);
    }

    public static Annotation deepMentionCopy(CoreMap dataset) {
        Annotation newDataset = new Annotation("");
        List sents = (List)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        ArrayList<CoreMap> newSents = new ArrayList<CoreMap>();
        if (sents != null) {
            for (CoreMap sent : sents) {
                if (!(sent instanceof Annotation)) {
                    throw new RuntimeException("ERROR: Sentences must instantiate Annotation!");
                }
                Annotation newSent = AnnotationUtils.sentenceDeepMentionCopy((Annotation)sent);
                newSents.add(newSent);
            }
        }
        AnnotationUtils.addSentences(newDataset, newSents);
        return newDataset;
    }

    public static Annotation sentenceDeepMentionCopy(Annotation sentence) {
        List<EventMention> evs;
        List<RelationMention> rels;
        Annotation newSent = new Annotation((String)sentence.get(CoreAnnotations.TextAnnotation.class));
        newSent.set(CoreAnnotations.TokensAnnotation.class, sentence.get(CoreAnnotations.TokensAnnotation.class));
        newSent.set(TreeCoreAnnotations.TreeAnnotation.class, sentence.get(TreeCoreAnnotations.TreeAnnotation.class));
        newSent.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        newSent.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
        newSent.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class));
        newSent.set(CoreAnnotations.DocIDAnnotation.class, sentence.get(CoreAnnotations.DocIDAnnotation.class));
        List<EntityMention> ents = AnnotationUtils.getEntityMentions(sentence);
        if (!ents.isEmpty()) {
            newSent.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, new ArrayList<EntityMention>(ents));
        }
        if (!(rels = AnnotationUtils.getRelationMentions(sentence)).isEmpty()) {
            newSent.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, new ArrayList<RelationMention>(rels));
        }
        if (!(evs = AnnotationUtils.getEventMentions(sentence)).isEmpty()) {
            newSent.set(MachineReadingAnnotations.EventMentionsAnnotation.class, new ArrayList<EventMention>(evs));
        }
        return newSent;
    }

    public static RelationMention getRelation(RelationMentionFactory factory, CoreMap sentence, ExtractionObject ... args) {
        return AnnotationUtils.getRelations(factory, sentence, args).get(0);
    }

    public static List<RelationMention> getRelations(RelationMentionFactory factory, CoreMap sentence, ExtractionObject ... args) {
        List<RelationMention> relationMentions = AnnotationUtils.getRelationMentions(sentence);
        ArrayList<RelationMention> matchingRelationMentions = new ArrayList<RelationMention>();
        for (RelationMention rel : relationMentions) {
            if (!rel.argsMatch(args)) continue;
            matchingRelationMentions.add(rel);
        }
        if (matchingRelationMentions.isEmpty()) {
            matchingRelationMentions.add(RelationMention.createUnrelatedRelation(factory, args));
        }
        return matchingRelationMentions;
    }

    public static List<RelationMention> getAllRelations(RelationMentionFactory factory, CoreMap sentence, boolean createUnrelatedRelations) {
        List<RelationMention> relationMentions = AnnotationUtils.getRelationMentions(sentence);
        ArrayList<RelationMention> allRelations = new ArrayList<RelationMention>(relationMentions);
        if (createUnrelatedRelations) {
            allRelations.addAll(AnnotationUtils.getAllUnrelatedRelations(factory, sentence, true));
        }
        return allRelations;
    }

    public static List<RelationMention> getAllUnrelatedRelations(RelationMentionFactory factory, CoreMap sentence, boolean checkExisting) {
        List<RelationMention> relationMentions = checkExisting ? AnnotationUtils.getRelationMentions(sentence) : null;
        List<EntityMention> entityMentions = AnnotationUtils.getEntityMentions(sentence);
        ArrayList<RelationMention> nonRelations = new ArrayList<RelationMention>();
        for (int i = 0; i < entityMentions.size(); ++i) {
            for (int j = 0; j < entityMentions.size(); ++j) {
                if (i == j) continue;
                EntityMention arg1 = entityMentions.get(i);
                EntityMention arg2 = entityMentions.get(j);
                boolean match = false;
                if (relationMentions != null) {
                    for (RelationMention rel : relationMentions) {
                        if (!rel.argsMatch(arg1, arg2)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) continue;
                nonRelations.add(RelationMention.createUnrelatedRelation(factory, arg1, arg2));
            }
        }
        return nonRelations;
    }

    public static void addEntityMention(CoreMap sentence, EntityMention arg) {
        ArrayList<EntityMention> l = (ArrayList<EntityMention>)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
        if (l == null) {
            l = new ArrayList<EntityMention>();
            sentence.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, l);
        }
        l.add(arg);
    }

    public static void addEntityMentions(CoreMap sentence, Collection<EntityMention> args) {
        ArrayList<EntityMention> l = (ArrayList<EntityMention>)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
        if (l == null) {
            l = new ArrayList<EntityMention>();
            sentence.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, l);
        }
        l.addAll(args);
    }

    public static List<EntityMention> getEntityMentions(CoreMap sent) {
        List sentEntities = sent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class) == null ? new ArrayList() : (List)sent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
        return Collections.unmodifiableList(sentEntities);
    }

    public static void addRelationMention(CoreMap sentence, RelationMention arg) {
        ArrayList<RelationMention> l = (ArrayList<RelationMention>)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
        if (l == null) {
            l = new ArrayList<RelationMention>();
            sentence.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, l);
        }
        l.add(arg);
    }

    public static void addRelationMentions(CoreMap sentence, Collection<RelationMention> args) {
        ArrayList<RelationMention> l = (ArrayList<RelationMention>)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
        if (l == null) {
            l = new ArrayList<RelationMention>();
            sentence.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, l);
        }
        l.addAll(args);
    }

    public static List<RelationMention> getRelationMentions(CoreMap sent) {
        List sentRelations = sent.get(MachineReadingAnnotations.RelationMentionsAnnotation.class) == null ? new ArrayList() : (List)sent.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
        return Collections.unmodifiableList(sentRelations);
    }

    public static void addEventMention(CoreMap sentence, EventMention arg) {
        ArrayList<EventMention> l = (ArrayList<EventMention>)sentence.get(MachineReadingAnnotations.EventMentionsAnnotation.class);
        if (l == null) {
            l = new ArrayList<EventMention>();
            sentence.set(MachineReadingAnnotations.EventMentionsAnnotation.class, l);
        }
        l.add(arg);
    }

    public static void addEventMentions(CoreMap sentence, Collection<EventMention> args) {
        ArrayList<EventMention> l = (ArrayList<EventMention>)sentence.get(MachineReadingAnnotations.EventMentionsAnnotation.class);
        if (l == null) {
            l = new ArrayList<EventMention>();
            sentence.set(MachineReadingAnnotations.EventMentionsAnnotation.class, l);
        }
        l.addAll(args);
    }

    public static List<EventMention> getEventMentions(CoreMap sent) {
        List sentEvents = sent.get(MachineReadingAnnotations.EventMentionsAnnotation.class) == null ? new ArrayList() : (List)sent.get(MachineReadingAnnotations.EventMentionsAnnotation.class);
        return Collections.unmodifiableList(sentEvents);
    }

    public static String prettify(String s) {
        if (s == null) {
            return "";
        }
        return s.replace(" ,", ",").replace(" .", ".").replace(" :", ":").replace("( ", "(").replace("[ ", "[").replace(" )", ")").replace(" ]", "]").replace(" - ", "-").replace(" '", "'").replace("-LRB- ", "(").replace(" -RRB-", ")").replace("` ` ", "\"").replace(" ' '", "\"").replace(" COMMA", ",");
    }

    public static String getTextContent(CoreMap sent, Span span) {
        List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
        StringBuilder buf = new StringBuilder();
        assert (span != null);
        for (int i = span.start(); i < span.end(); ++i) {
            if (i > span.start()) {
                buf.append(' ');
            }
            buf.append(((CoreLabel)tokens.get(i)).word());
        }
        return buf.toString();
    }

    public static String sentenceToString(CoreMap sent) {
        StringBuilder sb = new StringBuilder(512);
        List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
        sb.append("\"").append(StringUtils.join(tokens, " ")).append("\"");
        sb.append("\n");
        List<RelationMention> relationMentions = AnnotationUtils.getRelationMentions(sent);
        for (RelationMention rel : relationMentions) {
            sb.append("\n");
            sb.append(rel);
        }
        return sb.toString();
    }

    public static String tokensAndNELabelsToString(CoreMap sentence) {
        StringBuilder os = new StringBuilder();
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens != null) {
            boolean first = true;
            for (CoreLabel token : tokens) {
                if (!first) {
                    os.append(" ");
                }
                os.append(token.word());
                if (token.ner() != null && !token.ner().equals("O")) {
                    os.append("/").append(token.ner());
                }
                first = false;
            }
        }
        return os.toString();
    }

    public static String datasetToString(CoreMap dataset) {
        List sents = (List)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        StringBuilder sb = new StringBuilder();
        if (sents != null) {
            for (CoreMap sent : sents) {
                sb.append(AnnotationUtils.sentenceToString(sent));
            }
        }
        return sb.toString();
    }

    public static String tokensToString(List<CoreLabel> tokens) {
        StringBuilder os = new StringBuilder();
        boolean first = true;
        for (CoreLabel t : tokens) {
            if (!first) {
                os.append(" ");
            }
            os.append(t.word()).append("{").append(t.beginPosition()).append(", ").append(t.endPosition()).append("}");
            first = false;
        }
        return os.toString();
    }

    public static void updateOffsets(List<Word> tokens, int offset) {
        for (Word l : tokens) {
            l.setBeginPosition(l.beginPosition() + offset);
            l.setEndPosition(l.endPosition() + offset);
        }
    }

    public static void updateOffsetsInCoreLabels(List<CoreLabel> tokens, int offset) {
        for (CoreLabel l : tokens) {
            l.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, (Integer)l.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) + offset);
            l.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, (Integer)l.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) + offset);
        }
    }

    public static String excelify(String s) {
        return '\"' + s.replace("\"", "\"\"") + '\"';
    }

    public static List<CoreMap> readSentencesFromFile(String path) throws IOException, ClassNotFoundException {
        Annotation doc = (Annotation)IOUtils.readObjectFromFile(path);
        return (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
    }
}

