/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.BasicSequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.Comparators;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.regex.MatchResult;

public interface SequenceMatchResult<T>
extends MatchResult,
HasInterval<Integer> {
    public static final int GROUP_BEFORE_MATCH = Integer.MIN_VALUE;
    public static final int GROUP_AFTER_MATCH = -2147483647;
    public static final GroupToIntervalFunc TO_INTERVAL = new GroupToIntervalFunc(0);
    public static final Comparator<MatchResult> PRIORITY_COMPARATOR = (e1, e2) -> {
        double s1 = 0.0;
        if (e1 instanceof SequenceMatchResult) {
            s1 = ((SequenceMatchResult)e1).priority();
        }
        double s2 = 0.0;
        if (e2 instanceof SequenceMatchResult) {
            s2 = ((SequenceMatchResult)e2).priority();
        }
        if (s1 == s2) {
            return 0;
        }
        return s1 > s2 ? -1 : 1;
    };
    public static final Comparator<MatchResult> SCORE_COMPARATOR = (e1, e2) -> {
        double s1 = 0.0;
        if (e1 instanceof SequenceMatchResult) {
            s1 = ((SequenceMatchResult)e1).score();
        }
        double s2 = 0.0;
        if (e2 instanceof SequenceMatchResult) {
            s2 = ((SequenceMatchResult)e2).score();
        }
        if (s1 == s2) {
            return 0;
        }
        return s1 > s2 ? -1 : 1;
    };
    public static final Comparator<MatchResult> ORDER_COMPARATOR = (e1, e2) -> {
        int o1 = 0;
        if (e1 instanceof SequenceMatchResult) {
            o1 = ((SequenceMatchResult)e1).getOrder();
        }
        int o2 = 0;
        if (e2 instanceof SequenceMatchResult) {
            o2 = ((SequenceMatchResult)e2).getOrder();
        }
        if (o1 == o2) {
            return 0;
        }
        return o1 < o2 ? -1 : 1;
    };
    public static final Comparator<MatchResult> LENGTH_COMPARATOR = (e1, e2) -> {
        int len2;
        int len1 = e1.end() - e1.start();
        if (len1 == (len2 = e2.end() - e2.start())) {
            return 0;
        }
        return len1 > len2 ? -1 : 1;
    };
    public static final Comparator<MatchResult> OFFSET_COMPARATOR = (e1, e2) -> {
        if (e1.start() == e2.start()) {
            if (e1.end() == e2.end()) {
                return 0;
            }
            return e1.end() < e2.end() ? -1 : 1;
        }
        return e1.start() < e2.start() ? -1 : 1;
    };
    public static final Comparator<MatchResult> PRIORITY_SCORE_LENGTH_ORDER_OFFSET_COMPARATOR = Comparators.chain(PRIORITY_COMPARATOR, SCORE_COMPARATOR, LENGTH_COMPARATOR, ORDER_COMPARATOR, OFFSET_COMPARATOR);
    public static final Comparator<? super MatchResult> DEFAULT_COMPARATOR = PRIORITY_SCORE_LENGTH_ORDER_OFFSET_COMPARATOR;
    public static final ToDoubleFunction<MatchResult> SCORER = in -> {
        if (in instanceof SequenceMatchResult) {
            return ((SequenceMatchResult)in).score();
        }
        return 0.0;
    };

    public double score();

    public double priority();

    public List<? extends T> elements();

    public SequencePattern<T> pattern();

    public List<? extends T> groupNodes();

    public List<? extends T> groupNodes(int var1);

    public BasicSequenceMatchResult<T> toBasicSequenceMatchResult();

    public List<? extends T> groupNodes(String var1);

    @Override
    public String group(String var1);

    @Override
    public int start(String var1);

    @Override
    public int end(String var1);

    public int getOrder();

    public Object nodeMatchResult(int var1);

    public Object groupMatchResult(int var1, int var2);

    public Object groupMatchResult(String var1, int var2);

    public List<Object> groupMatchResults();

    public List<Object> groupMatchResults(int var1);

    public List<Object> groupMatchResults(String var1);

    public Object groupValue();

    public Object groupValue(int var1);

    public Object groupValue(String var1);

    public MatchedGroupInfo<T> groupInfo();

    public MatchedGroupInfo<T> groupInfo(int var1);

    public MatchedGroupInfo<T> groupInfo(String var1);

    public static final class MatchedGroupInfo<T> {
        public final String text;
        public final List<? extends T> nodes;
        public final List<Object> matchResults;
        public final Object value;
        public final String varName;

        public MatchedGroupInfo(String text, List<? extends T> nodes, List<Object> matchResults, Object value, String varName) {
            this.text = text;
            this.nodes = nodes;
            this.matchResults = matchResults;
            this.value = value;
            this.varName = varName;
        }
    }

    public static class GroupToIntervalFunc<MR extends MatchResult>
    implements Function<MR, Interval<Integer>> {
        int group;

        public GroupToIntervalFunc(int group) {
            this.group = group;
        }

        @Override
        public Interval<Integer> apply(MR in) {
            return Interval.toInterval(in.start(this.group), in.end(this.group), 2);
        }
    }
}

