/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.NaturalLogicRelation;
import edu.stanford.nlp.naturalli.NaturalLogicWeights;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.naturalli.Util;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class ForwardEntailerSearchProblem {
    private static Redwood.RedwoodChannels log = Redwood.channels(ForwardEntailerSearchProblem.class);
    public final SemanticGraph parseTree;
    public final boolean truthOfPremise;
    public final int maxTicks;
    public final int maxResults;
    public final NaturalLogicWeights weights;

    protected ForwardEntailerSearchProblem(SemanticGraph parseTree, boolean truthOfPremise, int maxResults, int maxTicks, NaturalLogicWeights weights) {
        this.parseTree = parseTree;
        this.truthOfPremise = truthOfPremise;
        this.maxResults = maxResults;
        this.maxTicks = maxTicks;
        this.weights = weights;
    }

    public List<SentenceFragment> search() {
        return this.searchImplementation().stream().map(x -> new SentenceFragment(x.tree, this.truthOfPremise, false).changeScore(x.confidence)).filter(x -> x.words.size() > 0).collect(Collectors.toList());
    }

    private List<SearchResult> searchImplementation() {
        List<IndexedWord> topologicalVertices;
        SemanticGraph parseTree = new SemanticGraph(this.parseTree);
        assert (Util.isTree(parseTree));
        ArrayList<String> determinerRemovals = new ArrayList<String>();
        parseTree.getLeafVertices().stream().filter(vertex -> "the".equalsIgnoreCase(vertex.word()) || "a".equalsIgnoreCase(vertex.word()) || "an".equalsIgnoreCase(vertex.word()) || "this".equalsIgnoreCase(vertex.word()) || "that".equalsIgnoreCase(vertex.word()) || "those".equalsIgnoreCase(vertex.word()) || "these".equalsIgnoreCase(vertex.word())).forEach(vertex -> {
            parseTree.removeVertex((IndexedWord)vertex);
            assert (Util.isTree(parseTree));
            determinerRemovals.add("det");
        });
        HashSet<SemanticGraphEdge> andsToAdd = new HashSet<SemanticGraphEdge>();
        for (IndexedWord indexedWord : parseTree.vertexSet()) {
            if (parseTree.inDegree(indexedWord) <= 1) continue;
            SemanticGraphEdge conjAnd = null;
            for (SemanticGraphEdge edge2 : parseTree.incomingEdgeIterable(indexedWord)) {
                if (!"conj:and".equals(edge2.getRelation().toString())) continue;
                conjAnd = edge2;
            }
            if (conjAnd == null) continue;
            parseTree.removeEdge(conjAnd);
            assert (Util.isTree(parseTree));
            andsToAdd.add(conjAnd);
        }
        Util.cleanTree(parseTree, this.parseTree);
        assert (Util.isTree(parseTree));
        BitSet isSubject = new BitSet(256);
        block4: for (IndexedWord vertex3 : parseTree.vertexSet()) {
            Iterator<SemanticGraphEdge> incomingEdges = parseTree.incomingEdgeIterator(vertex3);
            SemanticGraphEdge edge2 = null;
            if (incomingEdges.hasNext()) {
                edge2 = incomingEdges.next();
            }
            int numIters = 0;
            while (edge2 != null) {
                if (edge2.getRelation().toString().endsWith("subj")) {
                    assert (vertex3.index() > 0);
                    isSubject.set(vertex3.index() - 1);
                    continue block4;
                }
                incomingEdges = parseTree.incomingEdgeIterator(edge2.getGovernor());
                edge2 = incomingEdges.hasNext() ? incomingEdges.next() : null;
                if (++numIters <= 100) continue;
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        if (!determinerRemovals.isEmpty()) {
            if (andsToAdd.isEmpty()) {
                double score = Math.pow(this.weights.deletionProbability("det"), determinerRemovals.size());
                assert (!Double.isNaN(score));
                assert (!Double.isInfinite(score));
                arrayList.add(new SearchResult(parseTree, determinerRemovals, score));
            } else {
                SemanticGraph treeWithAnds = new SemanticGraph(parseTree);
                assert (Util.isTree(treeWithAnds));
                for (SemanticGraphEdge and : andsToAdd) {
                    treeWithAnds.addEdge(and.getGovernor(), and.getDependent(), and.getRelation(), Double.NEGATIVE_INFINITY, false);
                }
                assert (Util.isTree(treeWithAnds));
                arrayList.add(new SearchResult(treeWithAnds, determinerRemovals, Math.pow(this.weights.deletionProbability("det"), determinerRemovals.size())));
            }
        }
        assert (Util.isTree(parseTree));
        try {
            topologicalVertices = parseTree.topologicalSort();
        }
        catch (IllegalStateException e) {
            topologicalVertices = parseTree.vertexListSorted();
        }
        if (topologicalVertices.isEmpty()) {
            return arrayList;
        }
        Stack<SearchState> fringe = new Stack<SearchState>();
        fringe.push(new SearchState(new BitSet(256), 0, parseTree, null, null, 1.0));
        int numTicks = 0;
        block7: while (!fringe.isEmpty()) {
            Object operator;
            int nextIndex;
            if (numTicks >= this.maxTicks) {
                return arrayList;
            }
            ++numTicks;
            if (arrayList.size() >= this.maxResults) {
                return arrayList;
            }
            SearchState state = (SearchState)fringe.pop();
            assert (state.score > 0.0);
            IndexedWord currentWord = topologicalVertices.get(state.currentIndex);
            int numIters = 0;
            for (nextIndex = state.currentIndex + 1; nextIndex < topologicalVertices.size(); ++nextIndex) {
                IndexedWord nextWord = topologicalVertices.get(nextIndex);
                assert (nextWord.index() > 0);
                if (state.deletionMask.get(nextWord.index() - 1)) continue;
                fringe.push(new SearchState(state.deletionMask, nextIndex, state.tree, null, state, state.score));
                break;
            }
            boolean canDelete = !state.tree.getFirstRoot().equals(currentWord);
            for (SemanticGraphEdge edge3 : state.tree.incomingEdgeIterable(currentWord)) {
                NaturalLogicRelation projectedRelation;
                NaturalLogicRelation lexicalRelation;
                if ("CD".equals(edge3.getGovernor().tag())) {
                    canDelete = false;
                    continue;
                }
                CoreLabel token = edge3.getDependent().backingLabel();
                Polarity tokenPolarity = (Polarity)token.get(NaturalLogicAnnotations.PolarityAnnotation.class);
                if (tokenPolarity == null) {
                    tokenPolarity = Polarity.DEFAULT;
                }
                if ((operator = (OperatorSpec)token.get(NaturalLogicAnnotations.OperatorAnnotation.class)) != null) {
                    lexicalRelation = ((OperatorSpec)operator).instance.deleteRelation;
                } else {
                    assert (edge3.getDependent().index() > 0);
                    lexicalRelation = NaturalLogicRelation.forDependencyDeletion(edge3.getRelation().toString(), isSubject.get(edge3.getDependent().index() - 1));
                }
                if ((projectedRelation = tokenPolarity.projectLexicalRelation(lexicalRelation)).applyToTruthValue(this.truthOfPremise).isTrue()) continue;
                canDelete = false;
            }
            if (!canDelete) continue;
            Lazy<Pair> treeWithDeletionsAndNewMask = Lazy.of(() -> {
                SemanticGraph impl = new SemanticGraph(state.tree);
                BitSet newMask = state.deletionMask;
                for (IndexedWord vertex : state.tree.descendants(currentWord)) {
                    impl.removeVertex(vertex);
                    assert (vertex.index() > 0);
                    newMask.set(vertex.index() - 1);
                    assert (newMask.get(vertex.index() - 1));
                }
                return Pair.makePair(impl, newMask);
            });
            double newScore = state.score;
            operator = state.tree.incomingEdgeIterable(currentWord).iterator();
            while (operator.hasNext()) {
                SemanticGraphEdge edge4 = operator.next();
                double multiplier = this.weights.deletionProbability(edge4, state.tree.outgoingEdgeIterable(edge4.getGovernor()));
                assert (!Double.isNaN(multiplier));
                assert (!Double.isInfinite(multiplier));
                newScore *= multiplier;
            }
            if (!(newScore > 0.0)) continue;
            SemanticGraph resultTree = new SemanticGraph((SemanticGraph)treeWithDeletionsAndNewMask.get().first);
            andsToAdd.stream().filter(edge -> resultTree.containsVertex(edge.getGovernor()) && resultTree.containsVertex(edge.getDependent())).forEach(edge -> resultTree.addEdge(edge.getGovernor(), edge.getDependent(), edge.getRelation(), Double.NEGATIVE_INFINITY, false));
            arrayList.add(new SearchResult(resultTree, ForwardEntailerSearchProblem.aggregateDeletedEdges(state, state.tree.incomingEdgeIterable(currentWord), determinerRemovals), newScore));
            numIters = 0;
            for (nextIndex = state.currentIndex + 1; nextIndex < topologicalVertices.size(); ++nextIndex) {
                IndexedWord nextWord = topologicalVertices.get(nextIndex);
                BitSet newMask = (BitSet)treeWithDeletionsAndNewMask.get().second;
                SemanticGraph treeWithDeletions = (SemanticGraph)treeWithDeletionsAndNewMask.get().first;
                if (newMask.get(nextWord.index() - 1)) continue;
                assert (treeWithDeletions.containsVertex(topologicalVertices.get(nextIndex)));
                fringe.push(new SearchState(newMask, nextIndex, treeWithDeletions, null, state, newScore));
                continue block7;
            }
        }
        return arrayList;
    }

    private static List<String> aggregateDeletedEdges(SearchState state, Iterable<SemanticGraphEdge> justDeleted, Iterable<String> otherEdges) {
        ArrayList<String> rtn = new ArrayList<String>();
        for (SemanticGraphEdge semanticGraphEdge : justDeleted) {
            rtn.add(semanticGraphEdge.getRelation().toString());
        }
        for (String string : otherEdges) {
            rtn.add(string);
        }
        while (state != null) {
            if (state.lastDeletedEdge != null) {
                rtn.add(state.lastDeletedEdge);
            }
            state = state.source;
        }
        return rtn;
    }

    private static class SearchState {
        public final BitSet deletionMask;
        public final int currentIndex;
        public final SemanticGraph tree;
        public final String lastDeletedEdge;
        public final SearchState source;
        public final double score;

        private SearchState(BitSet deletionMask, int currentIndex, SemanticGraph tree, String lastDeletedEdge, SearchState source, double score) {
            this.deletionMask = (BitSet)deletionMask.clone();
            this.currentIndex = currentIndex;
            this.tree = tree;
            this.lastDeletedEdge = lastDeletedEdge;
            this.source = source;
            this.score = score;
        }
    }

    private static class SearchResult {
        public final SemanticGraph tree;
        public final List<String> deletedEdges;
        public final double confidence;

        private SearchResult(SemanticGraph tree, List<String> deletedEdges, double confidence) {
            this.tree = tree;
            this.deletedEdges = deletedEdges;
            this.confidence = confidence;
        }

        public String toString() {
            return StringUtils.join(this.tree.vertexListSorted().stream().map(IndexedWord::word), " ");
        }
    }
}

