/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.AbstractCollinizer;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.parser.tools.PunctEquivalenceClasser;
import edu.stanford.nlp.process.SerializableFunction;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTokenizerFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public abstract class AbstractTreebankParserParams
implements TreebankLangParserParams {
    private static Redwood.RedwoodChannels log = Redwood.channels(AbstractTreebankParserParams.class);
    protected boolean evalGF = true;
    protected String inputEncoding;
    protected String outputEncoding;
    protected TreebankLanguagePack tlp;
    protected boolean generateOriginalDependencies;
    private static final long serialVersionUID = 4299501909017975915L;
    private static final String[] EMPTY_ARGS = new String[0];

    protected AbstractTreebankParserParams(TreebankLanguagePack tlp) {
        this.tlp = tlp;
        this.inputEncoding = tlp.getEncoding();
        this.outputEncoding = tlp.getEncoding();
        this.generateOriginalDependencies = false;
    }

    @Override
    public Label processHeadWord(Label headWord) {
        return headWord;
    }

    @Override
    public void setEvaluateGrammaticalFunctions(boolean evalGFs) {
        this.evalGF = evalGFs;
    }

    @Override
    public void setInputEncoding(String encoding) {
        this.inputEncoding = encoding;
    }

    @Override
    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
    }

    @Override
    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public abstract TreeReaderFactory treeReaderFactory();

    @Override
    public AbstractEval ppAttachmentEval() {
        return null;
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory(), this.getInputEncoding());
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory(), this.getInputEncoding());
    }

    @Override
    public MemoryTreebank testMemoryTreebank() {
        return this.memoryTreebank();
    }

    @Override
    public Treebank treebank() {
        return this.diskTreebank();
    }

    @Override
    public PrintWriter pw() {
        return this.pw(System.out);
    }

    @Override
    public PrintWriter pw(OutputStream o) {
        String encoding = this.outputEncoding;
        if (!Charset.isSupported(encoding)) {
            log.info("Warning: desired encoding " + encoding + " not accepted. ");
            log.info("Using UTF-8 to construct PrintWriter");
            encoding = "UTF-8";
        }
        try {
            return new PrintWriter((Writer)new OutputStreamWriter(o, encoding), true);
        }
        catch (UnsupportedEncodingException e) {
            log.info("Warning: desired encoding " + this.outputEncoding + " not accepted. " + e);
            try {
                return new PrintWriter((Writer)new OutputStreamWriter(o, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException e1) {
                log.info("Something is really wrong.  Your system doesn't even support UTF-8!" + e1);
                return new PrintWriter(o, true);
            }
        }
    }

    @Override
    public TreebankLanguagePack treebankLanguagePack() {
        return this.tlp;
    }

    @Override
    public abstract HeadFinder headFinder();

    @Override
    public abstract HeadFinder typedDependencyHeadFinder();

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        return new BaseLexicon(op, wordIndex, tagIndex);
    }

    @Override
    public double[] MLEDependencyGrammarSmoothingParams() {
        return new double[]{16.0, 16.0, 4.0, 0.6};
    }

    @Override
    public abstract AbstractCollinizer collinizer();

    @Override
    public abstract AbstractCollinizer collinizerEvalb();

    @Override
    public abstract String[] sisterSplitters();

    @Override
    public TreeTransformer subcategoryStripper() {
        if (this.evalGF) {
            return new SubcategoryStripper();
        }
        return new RemoveGFSubcategoryStripper();
    }

    @Override
    public abstract Tree transformTree(Tree var1, Tree var2);

    @Override
    public abstract void display();

    @Override
    public int setOptionFlag(String[] args, int i) {
        return i;
    }

    @Override
    public abstract List<? extends HasWord> defaultTestSentence();

    @Override
    public TokenizerFactory<Tree> treeTokenizerFactory() {
        return new TreeTokenizerFactory(this.treeReaderFactory());
    }

    @Override
    public Extractor<DependencyGrammar> dependencyGrammarExtractor(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        return new MLEDependencyGrammarExtractor(op, wordIndex, tagIndex);
    }

    public boolean isEvalGF() {
        return this.evalGF;
    }

    public void setEvalGF(boolean evalGF) {
        this.evalGF = evalGF;
    }

    @Override
    public List<GrammaticalStructure> readGrammaticalStructureFromFile(String filename) {
        throw new UnsupportedOperationException("This language does not support GrammaticalStructures or dependencies");
    }

    @Override
    public GrammaticalStructure getGrammaticalStructure(Tree t, Predicate<String> filter, HeadFinder hf) {
        throw new UnsupportedOperationException("This language does not support GrammaticalStructures or dependencies");
    }

    @Override
    public boolean supportsBasicDependencies() {
        return false;
    }

    @Override
    public void setGenerateOriginalDependencies(boolean originalDependencies) {
        this.generateOriginalDependencies = originalDependencies;
        if (this.tlp != null) {
            this.tlp.setGenerateOriginalDependencies(originalDependencies);
        }
    }

    @Override
    public boolean generateOriginalDependencies() {
        return this.generateOriginalDependencies;
    }

    @Override
    public String[] defaultCoreNLPFlags() {
        return EMPTY_ARGS;
    }

    protected static class AnnotatePunctuationFunction
    implements SerializableFunction<TregexMatcher, String> {
        private final String key;
        private final String annotationMark;
        private static final long serialVersionUID = 1L;

        public AnnotatePunctuationFunction(String annotationMark, String key) {
            this.key = key;
            this.annotationMark = annotationMark;
        }

        @Override
        public String apply(TregexMatcher m) {
            String punc = m.getNode(this.key).value();
            String punctClass = PunctEquivalenceClasser.getPunctClass(punc);
            return punctClass.equals("") ? "" : this.annotationMark + punctClass;
        }

        public String toString() {
            return "AnnotatePunctuationFunction";
        }
    }

    protected class RemoveGFSubcategoryStripper
    implements TreeTransformer {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        protected RemoveGFSubcategoryStripper() {
        }

        @Override
        public Tree transformTree(Tree tree) {
            Label lab = tree.label();
            if (tree.isLeaf()) {
                Tree leaf = this.tf.newLeaf(lab);
                leaf.setScore(tree.score());
                return leaf;
            }
            String s = lab.value();
            s = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(s);
            s = AbstractTreebankParserParams.this.treebankLanguagePack().stripGF(s);
            int numKids = tree.numChildren();
            ArrayList<Tree> children = new ArrayList<Tree>(numKids);
            for (int cNum = 0; cNum < numKids; ++cNum) {
                Tree child = tree.getChild(cNum);
                Tree newChild = this.transformTree(child);
                children.add(newChild);
            }
            CategoryWordTag newLabel = new CategoryWordTag(lab);
            newLabel.setCategory(s);
            if (lab instanceof HasTag) {
                String tag = ((HasTag)((Object)lab)).tag();
                tag = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(tag);
                tag = AbstractTreebankParserParams.this.treebankLanguagePack().stripGF(tag);
                newLabel.setTag(tag);
            }
            Tree node = this.tf.newTreeNode(newLabel, children);
            node.setScore(tree.score());
            return node;
        }
    }

    protected class SubcategoryStripper
    implements TreeTransformer {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        protected SubcategoryStripper() {
        }

        @Override
        public Tree transformTree(Tree tree) {
            Label lab = tree.label();
            if (tree.isLeaf()) {
                Tree leaf = this.tf.newLeaf(lab);
                leaf.setScore(tree.score());
                return leaf;
            }
            String s = lab.value();
            s = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(s);
            int numKids = tree.numChildren();
            ArrayList<Tree> children = new ArrayList<Tree>(numKids);
            for (int cNum = 0; cNum < numKids; ++cNum) {
                Tree child = tree.getChild(cNum);
                Tree newChild = this.transformTree(child);
                children.add(newChild);
            }
            CategoryWordTag newLabel = new CategoryWordTag(lab);
            newLabel.setCategory(s);
            if (lab instanceof HasTag) {
                String tag = ((HasTag)((Object)lab)).tag();
                tag = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(tag);
                newLabel.setTag(tag);
            }
            Tree node = this.tf.newTreeNode(newLabel, children);
            node.setScore(tree.score());
            return node;
        }
    }
}

