/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.parser.lexparser.AbstractCollinizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Iterator;

public class NegraPennCollinizer
implements AbstractCollinizer {
    Redwood.RedwoodChannels log = Redwood.channels(NegraPennCollinizer.class);
    private TreebankLangParserParams tlpp;
    private final boolean deletePunct;
    protected TreeFactory tf = new LabeledScoredTreeFactory();

    public NegraPennCollinizer(TreebankLangParserParams tlpp) {
        this(tlpp, true);
    }

    public NegraPennCollinizer(TreebankLangParserParams tlpp, boolean deletePunct) {
        this.tlpp = tlpp;
        this.deletePunct = deletePunct;
    }

    @Override
    public Tree transformTree(Tree guess, Tree gold) {
        if (guess == null || gold == null) {
            return null;
        }
        if (guess.yield().size() != gold.yield().size()) {
            return null;
        }
        return this.transformTree(guess, Trees.preTerminals(gold).iterator());
    }

    private Tree transformTree(Tree guess, Iterator<Tree> goldPreterminals) {
        Label l = guess.label();
        if (guess.isLeaf()) {
            return this.tf.newLeaf(l);
        }
        String s = l.value();
        s = this.tlpp.treebankLanguagePack().basicCategory(s);
        if (this.deletePunct && guess.isPreTerminal()) {
            Tree goldPT = goldPreterminals.next();
            String goldTag = this.tlpp.treebankLanguagePack().basicCategory(goldPT.value());
            if (this.tlpp.treebankLanguagePack().isEvalBIgnoredPunctuationTag(goldTag)) {
                return null;
            }
        }
        if (guess.children()[0].label().value().equals("TOPP")) {
            this.log.info("Found a TOPP");
            guess.setChildren(guess.children()[0].children());
        }
        if (this.tlpp.treebankLanguagePack().isStartSymbol(s) && guess.numChildren() == 1) {
            return this.transformTree(guess.getChild(0), goldPreterminals);
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        int numC = guess.numChildren();
        for (int cNum = 0; cNum < numC; ++cNum) {
            Tree child = guess.getChild(cNum);
            Tree newChild = this.transformTree(child, goldPreterminals);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.isEmpty()) {
            return null;
        }
        return this.tf.newTreeNode(new StringLabel(s), children);
    }
}

