/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.ScoredObject;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class ExternalParserQuery
implements ParserQuery {
    final List<? extends HasWord> originalSentence;
    final List<ScoredObject<Tree>> results;
    final boolean success;

    public ExternalParserQuery(List<? extends HasWord> sentence, List<ScoredObject<Tree>> results) {
        this.originalSentence = sentence;
        this.results = results;
        this.success = results != null;
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean parseAndReport(List<? extends HasWord> sentence, PrintWriter pwErr) {
        return this.parse(sentence);
    }

    @Override
    public double getPCFGScore() {
        if (this.results == null) {
            throw new IllegalStateException("getPCFGScore called before a sentence has been parsed");
        }
        return this.results.get(0).score();
    }

    @Override
    public Tree getBestParse() {
        if (this.results == null) {
            throw new IllegalStateException("getPCFGScore called before a sentence has been parsed");
        }
        return this.results.get(0).object();
    }

    @Override
    public List<ScoredObject<Tree>> getKBestParses(int k) {
        if (this.results == null) {
            throw new IllegalStateException("getPCFGScore called before a sentence has been parsed");
        }
        if (this.results.size() > k) {
            return this.results.subList(0, k);
        }
        return this.results;
    }

    @Override
    public double getBestScore() {
        return this.getPCFGScore();
    }

    @Override
    public Tree getBestPCFGParse() {
        return this.getBestParse();
    }

    @Override
    public Tree getBestDependencyParse(boolean debinarize) {
        return null;
    }

    @Override
    public Tree getBestFactoredParse() {
        return null;
    }

    @Override
    public List<ScoredObject<Tree>> getBestPCFGParses() {
        return this.results;
    }

    @Override
    public void restoreOriginalWords(Tree tree) {
        if (this.originalSentence == null || tree == null) {
            return;
        }
        List leaves = tree.getLeaves();
        if (leaves.size() != this.originalSentence.size()) {
            throw new IllegalStateException("originalWords and sentence of different sizes: " + this.originalSentence.size() + " vs. " + leaves.size() + "\n Orig: " + SentenceUtils.listToString(this.originalSentence) + "\n Pars: " + SentenceUtils.listToString(leaves));
        }
        Iterator leafIterator = leaves.iterator();
        for (HasWord hasWord : this.originalSentence) {
            Tree leaf = (Tree)leafIterator.next();
            if (!(hasWord instanceof Label)) continue;
            leaf.setLabel((Label)((Object)hasWord));
        }
    }

    @Override
    public boolean hasFactoredParse() {
        return false;
    }

    @Override
    public List<ScoredObject<Tree>> getKBestPCFGParses(int kbestPCFG) {
        return this.getKBestParses(kbestPCFG);
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodFactoredParses(int kbest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KBestViterbiParser getPCFGParser() {
        return null;
    }

    @Override
    public KBestViterbiParser getFactoredParser() {
        return null;
    }

    @Override
    public KBestViterbiParser getDependencyParser() {
        return null;
    }

    @Override
    public void setConstraints(List<ParserConstraint> constraints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean saidMemMessage() {
        return false;
    }

    @Override
    public boolean parseSucceeded() {
        return this.success;
    }

    @Override
    public boolean parseSkipped() {
        return false;
    }

    @Override
    public boolean parseFallback() {
        return false;
    }

    @Override
    public boolean parseNoMemory() {
        return false;
    }

    @Override
    public boolean parseUnparsable() {
        return !this.success;
    }

    @Override
    public List<? extends HasWord> originalSentence() {
        return this.originalSentence;
    }
}

