/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoNLLUOutputter;
import edu.stanford.nlp.pipeline.CoNLLUReader;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class CoNLLUTagUpdater {
    public static MaxentTagger maxentTagger;

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        Properties props = StringUtils.argsToProperties(args);
        String taggerPath = props.getProperty("tagger");
        String inputPath = props.getProperty("inputFile");
        String outputPath = props.getProperty("outputFile");
        maxentTagger = new MaxentTagger(taggerPath);
        CoNLLUReader reader = new CoNLLUReader();
        List<Annotation> annotations = reader.readCoNLLUFile(inputPath);
        for (Annotation ann : annotations) {
            for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
                maxentTagger.tagCoreLabels((List)sentence.get(CoreAnnotations.TokensAnnotation.class));
            }
        }
        Properties outputProps = new Properties();
        outputProps.setProperty("output.dependenciesType", "ENHANCEDPLUSPLUS");
        CoNLLUOutputter conLLUOutputter = new CoNLLUOutputter(outputProps);
        for (Annotation ann : annotations) {
            conLLUOutputter.print(ann, new BufferedOutputStream(new FileOutputStream(outputPath)));
        }
    }
}

