/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.TreeShapedStack;
import java.util.List;

public class BinaryTransition
implements Transition {
    public final String label;
    public final Side side;
    public final boolean isRoot;
    private static final long serialVersionUID = 1L;

    public BinaryTransition(String label, Side side, boolean isRoot) {
        this.label = label;
        this.side = side;
        this.isRoot = isRoot;
    }

    @Override
    public boolean isLegal(State state, List<ParserConstraint> constraints) {
        if (state.finished) {
            return false;
        }
        if (state.stack.size() <= 1) {
            return false;
        }
        if (ShiftReduceUtils.isTemporary(state.stack.peek()) && ShiftReduceUtils.isTemporary(state.stack.pop().peek())) {
            return false;
        }
        if (ShiftReduceUtils.isTemporary(state.stack.peek())) {
            if (this.side == Side.LEFT) {
                return false;
            }
            if (!ShiftReduceUtils.isEquivalentCategory(this.label, state.stack.peek().value())) {
                return false;
            }
        }
        if (ShiftReduceUtils.isTemporary(state.stack.pop().peek())) {
            if (this.side == Side.RIGHT) {
                return false;
            }
            if (!ShiftReduceUtils.isEquivalentCategory(this.label, state.stack.pop().peek().value())) {
                return false;
            }
        }
        if (state.stack.size() == 2 && this.isBinarized() && state.endOfQueue()) {
            return false;
        }
        if (state.endOfQueue() && state.stack.size() > 2 && ShiftReduceUtils.isTemporary(state.stack.pop().pop().peek()) && this.isBinarized()) {
            return false;
        }
        if (this.isRoot && !this.isBinarized()) {
            if (state.stack.size() > 2) {
                return false;
            }
            if (state.stack.size() == 2 && !state.endOfQueue()) {
                return false;
            }
        }
        if (constraints == null) {
            return true;
        }
        Tree top = state.stack.peek();
        int leftTop = ShiftReduceUtils.leftIndex(top);
        int rightTop = ShiftReduceUtils.rightIndex(top);
        Tree next = state.stack.pop().peek();
        int leftNext = ShiftReduceUtils.leftIndex(next);
        for (ParserConstraint constraint : constraints) {
            if (leftTop == constraint.start) {
                if (rightTop == constraint.end - 1) {
                    if (ShiftReduceUtils.constraintMatchesTreeTop(top, constraint)) continue;
                    return false;
                }
                if (rightTop >= constraint.end) continue;
                return false;
            }
            if (leftTop < constraint.start || leftTop >= constraint.end) continue;
            if (leftNext < constraint.start) {
                return false;
            }
            if (leftNext > constraint.start || rightTop != constraint.end - 1 || !this.isBinarized()) continue;
            return false;
        }
        return true;
    }

    public boolean isBinarized() {
        return this.label.charAt(0) == '@';
    }

    @Override
    public State apply(State state) {
        return this.apply(state, 0.0);
    }

    @Override
    public State apply(State state, double scoreDelta) {
        Tree head;
        TreeShapedStack<Tree> stack = state.stack;
        Tree right = stack.peek();
        stack = stack.pop();
        Tree left = stack.peek();
        stack = stack.pop();
        switch (this.side) {
            case LEFT: {
                head = left;
                break;
            }
            case RIGHT: {
                head = right;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown side " + (Object)((Object)this.side));
            }
        }
        if (!(head.label() instanceof CoreLabel)) {
            throw new IllegalArgumentException("Stack should have CoreLabel nodes");
        }
        CoreLabel headLabel = (CoreLabel)head.label();
        CoreLabel production = new CoreLabel();
        production.setValue(this.label);
        production.set(TreeCoreAnnotations.HeadWordLabelAnnotation.class, headLabel.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class));
        production.set(TreeCoreAnnotations.HeadTagLabelAnnotation.class, headLabel.get(TreeCoreAnnotations.HeadTagLabelAnnotation.class));
        LabeledScoredTreeNode newTop = new LabeledScoredTreeNode(production);
        newTop.addChild(left);
        newTop.addChild(right);
        stack = stack.push(newTop);
        return new State(stack, state.transitions.push(this), state.separators, state.sentence, state.tokenPosition, state.score + scoreDelta, false);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryTransition)) {
            return false;
        }
        String otherLabel = ((BinaryTransition)o).label;
        Side otherSide = ((BinaryTransition)o).side;
        return otherSide.equals((Object)this.side) && this.label.equals(otherLabel);
    }

    public int hashCode() {
        switch (this.side) {
            case LEFT: {
                return 0x5CB1E8F ^ this.label.hashCode();
            }
            case RIGHT: {
                return 0x51AB18B ^ this.label.hashCode();
            }
        }
        throw new IllegalArgumentException("Unknown side " + (Object)((Object)this.side));
    }

    public String toString() {
        switch (this.side) {
            case LEFT: {
                return "LeftBinary" + (this.isRoot ? "*" : "") + "(" + this.label + ")";
            }
            case RIGHT: {
                return "RightBinary" + (this.isRoot ? "*" : "") + "(" + this.label + ")";
            }
        }
        throw new IllegalArgumentException("Unknown side " + (Object)((Object)this.side));
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

