/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.io.ByteArrayUtils;
import edu.stanford.nlp.util.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;

public class Weight
implements Serializable {
    static final short[] EMPTY = new short[0];
    private static final float THRESHOLD = 1.0E-5f;
    private short[] packed;
    private static final long serialVersionUID = 3L;

    public Weight() {
        this.packed = EMPTY;
    }

    public Weight(Weight other) {
        if (other.size() == 0) {
            this.packed = EMPTY;
            return;
        }
        this.packed = ArrayUtils.copy(other.packed);
        this.condense();
    }

    public int size() {
        return this.packed.length / 3;
    }

    private short unpackIndex(int i) {
        return this.packed[i * 3];
    }

    private float unpackScore(int i) {
        i = i * 3 + 1;
        int high = this.packed[i++] << 16;
        int low = this.packed[i] & 0xFFFF;
        return Float.intBitsToFloat(high | low);
    }

    private static void pack(short[] packed, int i, int index, float score) {
        if (i > Short.MAX_VALUE) {
            throw new ArithmeticException("How did you make an index with 30,000 weights??");
        }
        int pos = i * 3;
        packed[pos++] = (short)index;
        int bits = Float.floatToIntBits(score);
        packed[pos++] = (short)((bits & 0xFFFF0000) >> 16);
        packed[pos] = (short)(bits & 0xFFFF);
    }

    private void pack(int i, int index, float score) {
        if (i > Short.MAX_VALUE) {
            throw new ArithmeticException("How did you make an index with 30,000 weights??");
        }
        int pos = i * 3;
        this.packed[pos++] = (short)index;
        int bits = Float.floatToIntBits(score);
        this.packed[pos++] = (short)((bits & 0xFFFF0000) >> 16);
        this.packed[pos] = (short)(bits & 0xFFFF);
    }

    public void score(float[] scores) {
        if (this.packed.length > scores.length * 3) {
            throw new AssertionError((Object)"Called with an array of scores too small to fit");
        }
        int i = 0;
        while (i < this.packed.length) {
            short index = this.packed[i++];
            int high = this.packed[i++] << 16;
            int low = this.packed[i++] & 0xFFFF;
            int bits = high | low;
            float score = Float.intBitsToFloat(bits);
            short s = index;
            scores[s] = scores[s] + score;
        }
    }

    public void addScaled(Weight other, float scale) {
        int otherLength = other.size();
        for (int i = 0; i < otherLength; ++i) {
            short index = other.unpackIndex(i);
            float score = other.unpackScore(i);
            this.updateWeight(index, score * scale);
        }
    }

    void condense() {
        if (this.packed == null || this.packed.length == 0) {
            return;
        }
        int nonzero = 0;
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            if (!(Math.abs(this.unpackScore(i)) > 1.0E-5f)) continue;
            ++nonzero;
        }
        if (nonzero == 0) {
            this.packed = EMPTY;
            return;
        }
        if (nonzero == length) {
            return;
        }
        short[] newPacked = new short[nonzero * 3];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (Math.abs(this.unpackScore(i)) <= 1.0E-5f) continue;
            short index = this.unpackIndex(i);
            float score = this.unpackScore(i);
            Weight.pack(newPacked, j, index, score);
            ++j;
        }
        this.packed = newPacked;
    }

    public float getScore(int index) {
        if (this.packed == null) {
            return 0.0f;
        }
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            if (this.unpackIndex(i) != index) continue;
            return this.unpackScore(i);
        }
        return 0.0f;
    }

    public void updateWeight(int index, float increment) {
        if (index < 0) {
            return;
        }
        if (this.packed == null || this.packed.length == 0) {
            this.packed = new short[3];
            this.pack(0, index, increment);
            return;
        }
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            if (this.unpackIndex(i) != index) continue;
            float score = this.unpackScore(i);
            this.pack(i, index, score + increment);
            return;
        }
        short[] newPacked = new short[this.packed.length + 3];
        for (int i = 0; i < this.packed.length; ++i) {
            newPacked[i] = this.packed[i];
        }
        Weight.pack(newPacked, length, index, increment);
        this.packed = newPacked;
    }

    float maxAbs() {
        if (this.packed == null) {
            return 0.0f;
        }
        float maxScore = 0.0f;
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            float score = Math.abs(this.unpackScore(i));
            maxScore = Math.max(score, maxScore);
        }
        return maxScore;
    }

    void l1Reg(float reg) {
        if (this.packed == null) {
            return;
        }
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            short index = this.unpackIndex(i);
            float score = this.unpackScore(i);
            score = score > 0.0f ? Math.max(0.0f, score - reg) : Math.min(0.0f, score + reg);
            this.pack(i, index, score);
        }
    }

    void l2Reg(float reg) {
        if (this.packed == null) {
            return;
        }
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            short index = this.unpackIndex(i);
            float score = this.unpackScore(i);
            score -= score * reg;
            this.pack(i, index, score);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int length = this.size();
        builder.append("Weight(");
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append("  ");
            }
            builder.append(this.unpackIndex(i) + "=" + this.unpackScore(i));
        }
        builder.append(")");
        return builder.toString();
    }

    void writeBytes(ByteArrayOutputStream bout) {
        ByteArrayUtils.writeInt(bout, this.packed.length);
        for (int i = 0; i < this.packed.length; ++i) {
            ByteArrayUtils.writeShort(bout, this.packed[i]);
        }
    }

    static Weight readBytes(ByteArrayInputStream bin) {
        int len = ByteArrayUtils.readInt(bin);
        Weight weight = new Weight();
        weight.packed = new short[len];
        for (int i = 0; i < len; ++i) {
            weight.packed[i] = ByteArrayUtils.readShort(bin);
        }
        return weight;
    }
}

