/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.shiftreduce.Weight;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WeightMap
implements Serializable {
    private HashMap<String, Weight> weights = new HashMap();

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeObject(this.weights.size());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (String feature : this.weights.keySet()) {
            out2.writeObject(feature);
            this.weights.get(feature).writeBytes(bout);
        }
        out2.writeObject(bout.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Integer size = (Integer)in.readObject();
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String feature = (String)in.readObject();
            keys.add(feature);
        }
        byte[] bytes = (byte[])in.readObject();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        this.weights = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            this.weights.put((String)keys.get(i), Weight.readBytes(bin));
        }
    }

    public Weight get(String key) {
        return this.weights.get(key);
    }

    public void put(String key, Weight weight) {
        this.weights.put(key, weight);
    }

    public int size() {
        return this.weights.size();
    }

    public boolean containsKey(String key) {
        return this.weights.containsKey(key);
    }

    public Set<String> keySet() {
        return this.weights.keySet();
    }

    public Set<Map.Entry<String, Weight>> entrySet() {
        return this.weights.entrySet();
    }
}

