/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.JSONAnnotationReader;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;

public class AnnotationIterator
extends AbstractIterator<Annotation>
implements Closeable {
    String filename;
    BufferedReader br;
    InputStream input;
    Annotation nextDoc;
    AnnotationSerializer serializer;
    JSONAnnotationReader jsonReader = new JSONAnnotationReader();
    String format;
    int docCnt = 0;
    int limit = 0;

    public AnnotationIterator(String filename) throws IOException {
        this.filename = filename;
        if (filename.endsWith(".json")) {
            this.br = IOUtils.readerFromString(filename);
            this.format = "json";
        } else if (filename.endsWith(".jsonl")) {
            this.br = IOUtils.readerFromString(filename);
            this.format = "jsonl";
        } else if (filename.endsWith(".proto")) {
            this.input = IOUtils.getFileInputStream(filename);
            this.serializer = new ProtobufAnnotationSerializer();
            this.format = "proto";
        } else {
            throw new IOException("Unsupported file format: " + filename);
        }
        this.nextDoc = this.readNextDocument();
    }

    public AnnotationIterator(String filename, int limit) throws IOException {
        this(filename);
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.nextDoc != null;
    }

    @Override
    public Annotation next() {
        if (this.nextDoc == null) {
            throw new NoSuchElementException("DocumentIterator exhausted.");
        }
        Annotation curDoc = this.nextDoc;
        this.nextDoc = this.readNextDocument();
        return curDoc;
    }

    public Annotation readJsonDocument(String str) {
        return this.jsonReader.read(str);
    }

    public Annotation readNextDocument() {
        if (this.br == null && this.input == null) {
            return null;
        }
        if (this.limit > 0 && this.docCnt >= this.limit) {
            return null;
        }
        try {
            if (this.serializer != null) {
                if (this.input.available() > 0) {
                    Pair<Annotation, InputStream> pair = this.serializer.read(this.input);
                    this.input = (InputStream)pair.second;
                    ++this.docCnt;
                    return (Annotation)pair.first;
                }
            } else {
                if (this.format.equals("json")) {
                    Annotation annotation = this.readJsonDocument(IOUtils.slurpReader(this.br));
                    this.close();
                    ++this.docCnt;
                    return annotation;
                }
                if (this.format.equals("jsonl")) {
                    String line = this.br.readLine();
                    while (line != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        Annotation annotation = this.readJsonDocument(line);
                        ++this.docCnt;
                        return annotation;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error reading from " + this.filename, ex);
        }
        return null;
    }

    public int getDocCnt() {
        return this.docCnt;
    }

    @Override
    public void close() {
        if (this.br != null) {
            IOUtils.closeIgnoringExceptions(this.br);
            this.br = null;
        }
        if (this.input != null) {
            IOUtils.closeIgnoringExceptions(this.input);
            this.input = null;
        }
    }
}

