/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.WordLists;
import edu.stanford.nlp.ie.KBPBasicSpanishCorefSystem;
import edu.stanford.nlp.ie.KBPEnsembleExtractor;
import edu.stanford.nlp.ie.KBPRelationExtractor;
import edu.stanford.nlp.ie.KBPSemgrexExtractor;
import edu.stanford.nlp.ie.KBPStatisticalExtractor;
import edu.stanford.nlp.ie.KBPTokensregexExtractor;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.LanguageInfo;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.util.AcronymMatcher;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class KBPAnnotator
implements Annotator {
    private static final String NOT_PROVIDED = "none";
    private final Properties kbpProperties;
    private static final Redwood.RedwoodChannels log = Redwood.channels(KBPAnnotator.class);
    @ArgumentParser.Option(name="kbp.model", gloss="The path to the model, set to \"none\" for no model")
    private String model = "edu/stanford/nlp/models/kbp/english/tac-re-lr.ser.gz";
    @ArgumentParser.Option(name="kbp.semgrex", gloss="Semgrex patterns directory, set to \"none\" to not use semgrex")
    private String semgrexdir = "edu/stanford/nlp/models/kbp/english/semgrex";
    @ArgumentParser.Option(name="kbp.tokensregex", gloss="Tokensregex patterns directory, set to \"none\" to not use tokensregex")
    private String tokensregexdir = "edu/stanford/nlp/models/kbp/english/tokensregex";
    @ArgumentParser.Option(name="kbp.verbose", gloss="Print out KBP logging info")
    private boolean VERBOSE = false;
    private final LanguageInfo.HumanLanguage kbpLanguage;
    public final KBPRelationExtractor extractor;
    private final ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer(false);
    private KBPBasicSpanishCorefSystem spanishCorefSystem;
    private final int maxLength;
    TokenSequencePattern titlePersonPattern = TokenSequencePattern.compile("[pos:JJ & ner:O]? [ner: TITLE]+ ([ner: PERSON]+)");
    private final HashMap<String, String> relationNameConversionMap;

    public KBPAnnotator(String name, Properties props) {
        ArgumentParser.fillOptions((Object)this, name, props);
        this.kbpProperties = props;
        try {
            ArrayList<KBPRelationExtractor> extractors = new ArrayList<KBPRelationExtractor>();
            if (!this.tokensregexdir.equals(NOT_PROVIDED)) {
                extractors.add(new KBPTokensregexExtractor(this.tokensregexdir, this.VERBOSE));
            }
            if (!this.semgrexdir.equals(NOT_PROVIDED)) {
                extractors.add(new KBPSemgrexExtractor(this.semgrexdir, this.VERBOSE));
            }
            if (!this.model.equals(NOT_PROVIDED)) {
                KBPStatisticalExtractor statisticalExtractor;
                log.info("Loading KBP classifier from: " + this.model);
                Object object = IOUtils.readObjectFromURLOrClasspathOrFileSystem(this.model);
                if (object instanceof LinearClassifier) {
                    statisticalExtractor = new KBPStatisticalExtractor((Classifier)object);
                } else if (object instanceof KBPStatisticalExtractor) {
                    statisticalExtractor = (KBPStatisticalExtractor)object;
                } else {
                    throw new ClassCastException(object.getClass() + " cannot be cast into a " + KBPStatisticalExtractor.class);
                }
                extractors.add(statisticalExtractor);
            }
            this.extractor = new KBPEnsembleExtractor(extractors.toArray(new KBPRelationExtractor[0]));
            this.maxLength = Integer.parseInt(props.getProperty("kbp.maxlen", "-1"));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeIOException(e);
        }
        this.relationNameConversionMap = new HashMap();
        this.relationNameConversionMap.put("org:dissolved", "org:date_dissolved");
        this.relationNameConversionMap.put("org:founded", "org:date_founded");
        this.relationNameConversionMap.put("org:number_of_employees/members", "org:number_of_employees_members");
        this.relationNameConversionMap.put("org:political/religious_affiliation", "org:political_religious_affiliation");
        this.relationNameConversionMap.put("org:top_members/employees", "org:top_members_employees");
        this.relationNameConversionMap.put("per:member_of", "per:employee_or_member_of");
        this.relationNameConversionMap.put("per:employee_of", "per:employee_or_member_of");
        this.relationNameConversionMap.put("per:stateorprovinces_of_residence", "per:statesorprovinces_of_residence");
        this.kbpLanguage = LanguageInfo.getLanguageFromString(props.getProperty("kbp.language", "en"));
        if (LanguageInfo.HumanLanguage.SPANISH.equals((Object)this.kbpLanguage)) {
            this.spanishCorefSystem = new KBPBasicSpanishCorefSystem();
        }
    }

    public KBPAnnotator(Properties properties) {
        this("kbp", properties);
    }

    private static void acronymMatch(List<CoreMap> mentions, Map<CoreMap, Set<CoreMap>> mentionsMap) {
        String nerTag;
        int ticks = 0;
        HashMap textToMention = new HashMap();
        for (CoreMap mention : mentions) {
            List tokens;
            nerTag = (String)mention.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (nerTag == null || !nerTag.equals(KBPRelationExtractor.NERTag.ORGANIZATION.name) && !nerTag.equals(KBPRelationExtractor.NERTag.LOCATION.name) || (tokens = ((List)mention.get(CoreAnnotations.TokensAnnotation.class)).stream().map(CoreLabel::word).collect(Collectors.toList())).size() <= 1) continue;
            textToMention.put(tokens, mention);
        }
        for (CoreMap acronym : mentions) {
            String text;
            nerTag = (String)acronym.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (nerTag == null || !nerTag.equals(KBPRelationExtractor.NERTag.ORGANIZATION.name) && !nerTag.equals(KBPRelationExtractor.NERTag.LOCATION.name) || (text = (String)acronym.get(CoreAnnotations.TextAnnotation.class)).contains(" ")) continue;
            Set<CoreMap> acronymCluster = mentionsMap.get(acronym);
            if (acronymCluster == null) {
                acronymCluster = new LinkedHashSet<CoreMap>();
                acronymCluster.add(acronym);
            }
            for (Map.Entry entry : textToMention.entrySet()) {
                if (++ticks > 1000) {
                    return;
                }
                if (!AcronymMatcher.isAcronym(text, (List)entry.getKey())) continue;
                CoreMap coreferent = (CoreMap)entry.getValue();
                Set<CoreMap> coreferentCluster = mentionsMap.get(coreferent);
                if (coreferentCluster == null) {
                    coreferentCluster = new LinkedHashSet<CoreMap>();
                    coreferentCluster.add(coreferent);
                }
                LinkedHashSet<CoreMap> newCluster = new LinkedHashSet<CoreMap>();
                newCluster.addAll(acronymCluster);
                newCluster.addAll(coreferentCluster);
                for (CoreMap key : newCluster) {
                    mentionsMap.put(key, newCluster);
                }
            }
        }
    }

    public Pair<List<CoreMap>, CoreMap> corefChainToKBPMentions(CorefChain corefChain, Annotation ann, HashMap<Pair<Integer, Integer>, CoreMap> kbpMentions) {
        List annSentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        List kbpMentionsForCorefChain = corefChain.getMentionsInTextualOrder().stream().map(cm -> {
            List corefMentionTokens;
            TokenSequenceMatcher titlePersonMatcher;
            CoreMap cmSentence = (CoreMap)annSentences.get(cm.sentNum - 1);
            List cmSentenceTokens = (List)cmSentence.get(CoreAnnotations.TokensAnnotation.class);
            int cmCharBegin = (Integer)((CoreLabel)cmSentenceTokens.get(cm.startIndex - 1)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int cmCharEnd = (Integer)((CoreLabel)cmSentenceTokens.get(cm.endIndex - 2)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            CoreMap kbpMentionFound = (CoreMap)kbpMentions.get(new Pair<Integer, Integer>(cmCharBegin, cmCharEnd));
            if (kbpMentionFound == null && (titlePersonMatcher = this.titlePersonPattern.matcher(corefMentionTokens = ((List)cmSentence.get(CoreAnnotations.TokensAnnotation.class)).subList(cm.startIndex - 1, cm.endIndex - 1))).find()) {
                List overallMatch = titlePersonMatcher.groupNodes(0);
                List personWithinMatch = titlePersonMatcher.groupNodes(1);
                if (overallMatch.size() == corefMentionTokens.size()) {
                    int personBeginOffset = ((CoreLabel)personWithinMatch.get(0)).beginPosition();
                    int personEndOffset = ((CoreLabel)personWithinMatch.get(personWithinMatch.size() - 1)).endPosition();
                    Pair<Integer, Integer> personOffsets = new Pair<Integer, Integer>(personBeginOffset, personEndOffset);
                    kbpMentionFound = (CoreMap)kbpMentions.get(personOffsets);
                }
            }
            return kbpMentionFound;
        }).collect(Collectors.toList());
        List kbpMentionLengths = kbpMentionsForCorefChain.stream().map(km -> km == null ? 0 : ((String)km.get(CoreAnnotations.TextAnnotation.class)).length()).collect(Collectors.toList());
        int bestIndex = kbpMentionLengths.indexOf(kbpMentionLengths.stream().reduce(0, (a, b) -> Math.max(a, b)));
        return new Pair<List<CoreMap>, CoreMap>(kbpMentionsForCorefChain, (CoreMap)kbpMentionsForCorefChain.get(bestIndex));
    }

    private String convertRelationNameToLatest(String relationName) {
        return this.relationNameConversionMap.getOrDefault(relationName, relationName);
    }

    private static boolean kbpIsPronominalMention(CoreLabel word) {
        return WordLists.isKbpPronominalMention(word.word());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void annotate(Annotation annotation) {
        void var13_70;
        void var13_67;
        void var8_23;
        void var9_41;
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        Document doc = new Document(this.kbpProperties, this.serializer.toProto(annotation));
        ArrayList<CoreMap> mentions = new ArrayList<CoreMap>();
        for (Object sentence : sentences) {
            mentions.addAll((Collection)sentence.get(CoreAnnotations.MentionsAnnotation.class));
        }
        HashMap<Pair<Integer, Integer>, CoreMap> mentionByStartIndex = new HashMap<Pair<Integer, Integer>, CoreMap>();
        for (CoreMap coreMap : mentions) {
            for (CoreLabel coreLabel : (List)coreMap.get(CoreAnnotations.TokensAnnotation.class)) {
                mentionByStartIndex.put(Pair.makePair(coreLabel.sentIndex(), coreLabel.index()), coreMap);
            }
        }
        HashMap<CoreMap, Set<CoreMap>> mentionsMap = new HashMap<CoreMap, Set<CoreMap>>();
        if (annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class) != null) {
            for (Map.Entry entry : ((Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)).entrySet()) {
                Object var9_26 = null;
                for (CorefChain.CorefMention corefMention : ((CorefChain)entry.getValue()).getMentionsInTextualOrder()) {
                    void var9_27;
                    Object kbpMention = null;
                    for (int i = corefMention.startIndex; i < corefMention.endIndex; ++i) {
                        if (!mentionByStartIndex.containsKey(Pair.makePair(corefMention.sentNum - 1, i))) continue;
                        kbpMention = (CoreMap)mentionByStartIndex.get(Pair.makePair(corefMention.sentNum - 1, i));
                        break;
                    }
                    if (var9_27 == null) {
                        Iterator iterator = kbpMention;
                    }
                    if (kbpMention == null) continue;
                    if (!mentionsMap.containsKey(var9_27)) {
                        mentionsMap.put((CoreMap)var9_27, new LinkedHashSet());
                    }
                    ((Set)mentionsMap.get(var9_27)).add(kbpMention);
                }
            }
        }
        KBPAnnotator.acronymMatch(mentions, mentionsMap);
        for (CoreMap coreMap : new HashSet(mentionsMap.keySet())) {
            void var9_32;
            if (coreMap.get(CoreAnnotations.NamedEntityTagAnnotation.class) != null) continue;
            Object var9_30 = null;
            for (CoreMap coreMap2 : (Set)mentionsMap.get(coreMap)) {
                if (coreMap2.get(CoreAnnotations.NamedEntityTagAnnotation.class) == null) continue;
                CoreMap coreMap3 = coreMap2;
                break;
            }
            if (var9_32 != null) {
                mentionsMap.put((CoreMap)var9_32, (Set<CoreMap>)mentionsMap.remove(coreMap));
                continue;
            }
            mentionsMap.remove(coreMap);
        }
        for (Map.Entry entry : mentionsMap.entrySet()) {
            String string = (String)((CoreMap)entry.getKey()).get(CoreAnnotations.WikipediaEntityAnnotation.class);
            if (string == null) continue;
            for (CoreMap coreMap : (Set)entry.getValue()) {
                for (CoreLabel coreLabel : (List)coreMap.get(CoreAnnotations.TokensAnnotation.class)) {
                    coreLabel.set(CoreAnnotations.WikipediaEntityAnnotation.class, string);
                }
            }
        }
        HashMap<Pair<Integer, Integer>, CoreMap> hashMap = new HashMap<Pair<Integer, Integer>, CoreMap>();
        for (CoreMap coreMap : mentions) {
            int n = (Integer)coreMap.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int n2 = (Integer)coreMap.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            hashMap.put(new Pair<Integer, Integer>(n, n2), coreMap);
        }
        if (this.kbpLanguage.equals((Object)LanguageInfo.HumanLanguage.SPANISH)) {
            Map<CoreMap, CoreMap> map = this.spanishCorefSystem.canonicalMentionMapFromEntityMentions(mentions);
            if (this.VERBOSE) {
                log.info("---");
                log.info("basic spanish coref results");
                for (CoreMap coreMap : map.keySet()) {
                    if (coreMap.equals(map.get(coreMap))) continue;
                    log.info("mapped: " + coreMap + " to: " + map.get(coreMap));
                }
            }
        } else {
            HashMap hashMap2 = new HashMap();
        }
        if (annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class) != null && !this.kbpLanguage.equals((Object)LanguageInfo.HumanLanguage.SPANISH)) {
            Set set = ((Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)).entrySet();
        } else {
            HashSet hashSet = new HashSet();
        }
        for (Map.Entry entry : var9_41) {
            Iterator corefChain = (CorefChain)entry.getValue();
            Pair<List<CoreMap>, CoreMap> pair = this.corefChainToKBPMentions((CorefChain)((Object)corefChain), annotation, hashMap);
            List<CoreMap> list = pair.first();
            CoreMap bestKBPMentionForChain = pair.second();
            if (bestKBPMentionForChain == null) continue;
            for (CoreMap coreMap : list) {
                if (coreMap == null) continue;
                boolean acceptableLink = true;
                String kbpMentionNERTag = (String)coreMap.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String bestKBPMentionForChainNERTag = (String)bestKBPMentionForChain.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                if (kbpMentionNERTag != null && bestKBPMentionForChainNERTag != null && kbpMentionNERTag.equals("PERSON") && bestKBPMentionForChainNERTag.equals("PERSON") && !KBPAnnotator.kbpIsPronominalMention((CoreLabel)((List)coreMap.get(CoreAnnotations.TokensAnnotation.class)).get(0)) && !KBPAnnotator.kbpIsPronominalMention((CoreLabel)((List)bestKBPMentionForChain.get(CoreAnnotations.TokensAnnotation.class)).get(0))) {
                    boolean tokenMatchFound = false;
                    for (CoreLabel kbpToken : (List)coreMap.get(CoreAnnotations.TokensAnnotation.class)) {
                        for (CoreLabel bestKBPToken : (List)bestKBPMentionForChain.get(CoreAnnotations.TokensAnnotation.class)) {
                            if (!kbpToken.word().toLowerCase().equals(bestKBPToken.word().toLowerCase())) continue;
                            tokenMatchFound = true;
                            break;
                        }
                        if (!tokenMatchFound) continue;
                        break;
                    }
                    if (!tokenMatchFound) {
                        acceptableLink = false;
                    }
                }
                if (!acceptableLink) continue;
                var8_23.put(coreMap, bestKBPMentionForChain);
            }
        }
        mentions.stream().filter(arg_0 -> KBPAnnotator.lambda$annotate$3((Map)var8_23, arg_0)).forEach(arg_0 -> KBPAnnotator.lambda$annotate$4((Map)var8_23, arg_0));
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        block17: for (CoreMap coreMap : var8_23.keySet()) {
            Object acronymText;
            String string = (String)coreMap.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (coreMap != var8_23.get(coreMap) || string == null || !string.equals(KBPRelationExtractor.NERTag.ORGANIZATION.name) && !string.equals(KBPRelationExtractor.NERTag.LOCATION.name) || ((String)(acronymText = (String)coreMap.get(CoreAnnotations.TextAnnotation.class))).contains(" ")) continue;
            int numCoreferentsChecked = 0;
            for (CoreMap coreferentMention : mentions) {
                String coreferentText;
                if (numCoreferentsChecked > 1000) continue block17;
                if (coreMap == coreferentMention || !(coreferentText = (String)coreferentMention.get(CoreAnnotations.TextAnnotation.class)).contains(" ")) continue;
                ++numCoreferentsChecked;
                List coreferentTokenStrings = ((List)coreferentMention.get(CoreAnnotations.TokensAnnotation.class)).stream().map(CoreLabel::word).collect(Collectors.toList());
                if (!AcronymMatcher.isAcronym((String)acronymText, coreferentTokenStrings)) continue;
                if (!hashMap3.containsKey(acronymText)) {
                    hashMap3.put(acronymText, new ArrayList());
                }
                if (!hashMap4.containsKey(acronymText)) {
                    hashMap4.put(acronymText, new ArrayList());
                }
                ((List)hashMap3.get(acronymText)).add(coreferentMention);
                ((List)hashMap4.get(acronymText)).add(coreMap);
            }
        }
        for (String string : hashMap4.keySet()) {
            void var14_76;
            Object coreferentMention22;
            Object var14_75 = null;
            for (Object coreferentMention22 : (List)hashMap3.get(string)) {
                if (!((String)coreferentMention22.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals(KBPRelationExtractor.NERTag.ORGANIZATION.name)) continue;
                if (var14_76 == null) {
                    Iterator iterator = coreferentMention22;
                    continue;
                }
                if (((String)coreferentMention22.get(CoreAnnotations.TextAnnotation.class)).length() <= ((String)var14_76.get(CoreAnnotations.TextAnnotation.class)).length()) continue;
                Iterator iterator = coreferentMention22;
            }
            CoreMap bestLOC = null;
            for (CoreMap coreMap : (List)hashMap3.get(string)) {
                if (!((String)coreMap.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals(KBPRelationExtractor.NERTag.LOCATION.name)) continue;
                if (bestLOC == null) {
                    bestLOC = coreMap;
                    continue;
                }
                if (((String)coreMap.get(CoreAnnotations.TextAnnotation.class)).length() <= ((String)bestLOC.get(CoreAnnotations.TextAnnotation.class)).length()) continue;
                bestLOC = coreMap;
            }
            coreferentMention22 = ((List)hashMap4.get(string)).iterator();
            while (coreferentMention22.hasNext()) {
                CoreMap coreMap = (CoreMap)coreferentMention22.next();
                String mentionType = (String)coreMap.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                if (mentionType.equals(KBPRelationExtractor.NERTag.ORGANIZATION.name) && var14_76 != null) {
                    var8_23.put(coreMap, var14_76);
                }
                if (!mentionType.equals(KBPRelationExtractor.NERTag.LOCATION.name) || bestLOC == null) continue;
                var8_23.put(coreMap, bestLOC);
            }
        }
        List[] mentionsBySentence = new List[((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).size()];
        boolean bl = false;
        while (var13_67 < mentionsBySentence.length) {
            mentionsBySentence[var13_67] = new ArrayList();
            ++var13_67;
        }
        for (CoreMap coreMap : var8_23.keySet()) {
            mentionsBySentence[(Integer)coreMap.get(CoreAnnotations.SentenceIndexAnnotation.class)].add(coreMap);
        }
        boolean bl2 = false;
        while (var13_70 < mentionsBySentence.length) {
            HashMap<String, RelationTriple.WithLink> hashMap5 = new HashMap<String, RelationTriple.WithLink>();
            ArrayList<Object> finalTriplesList = new ArrayList();
            List candidates = mentionsBySentence[var13_70];
            int n = ((List)((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get((int)var13_70)).get(CoreAnnotations.TokensAnnotation.class)).size();
            if (this.maxLength != -1 && n > this.maxLength) {
                ((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get((int)var13_70)).set(CoreAnnotations.KBPTriplesAnnotation.class, finalTriplesList);
            } else {
                for (int subjI = 0; subjI < candidates.size(); ++subjI) {
                    CoreMap subj = (CoreMap)candidates.get(subjI);
                    int subjBegin = ((CoreLabel)((List)subj.get(CoreAnnotations.TokensAnnotation.class)).get(0)).index() - 1;
                    int subjEnd = ((CoreLabel)((List)subj.get(CoreAnnotations.TokensAnnotation.class)).get(((List)subj.get(CoreAnnotations.TokensAnnotation.class)).size() - 1)).index();
                    Optional<KBPRelationExtractor.NERTag> subjNER = KBPRelationExtractor.NERTag.fromString((String)subj.get(CoreAnnotations.NamedEntityTagAnnotation.class));
                    if (!subjNER.isPresent()) continue;
                    for (int objI = 0; objI < candidates.size(); ++objI) {
                        if (subjI == objI) continue;
                        if (Thread.interrupted()) {
                            throw new RuntimeInterruptedException();
                        }
                        CoreMap obj = (CoreMap)candidates.get(objI);
                        int objBegin = ((CoreLabel)((List)obj.get(CoreAnnotations.TokensAnnotation.class)).get(0)).index() - 1;
                        int objEnd = ((CoreLabel)((List)obj.get(CoreAnnotations.TokensAnnotation.class)).get(((List)obj.get(CoreAnnotations.TokensAnnotation.class)).size() - 1)).index();
                        Optional<KBPRelationExtractor.NERTag> objNER = KBPRelationExtractor.NERTag.fromString((String)obj.get(CoreAnnotations.NamedEntityTagAnnotation.class));
                        if (!objNER.isPresent() || !KBPRelationExtractor.RelationType.plausiblyHasRelation(subjNER.get(), objNER.get())) continue;
                        KBPRelationExtractor.KBPInput input = new KBPRelationExtractor.KBPInput(new Span(subjBegin, subjEnd), new Span(objBegin, objEnd), subjNER.get(), objNER.get(), doc.sentence((int)var13_70));
                        Pair<String, Double> prediction = this.extractor.classify(input);
                        if ("no_relation".equals(prediction.first)) continue;
                        RelationTriple.WithLink triple = new RelationTriple.WithLink((List)subj.get(CoreAnnotations.TokensAnnotation.class), (List)((CoreMap)var8_23.get(subj)).get(CoreAnnotations.TokensAnnotation.class), Collections.singletonList(new CoreLabel(new Word(this.convertRelationNameToLatest((String)prediction.first)))), (List)obj.get(CoreAnnotations.TokensAnnotation.class), (List)((CoreMap)var8_23.get(obj)).get(CoreAnnotations.TokensAnnotation.class), (Double)prediction.second, (SemanticGraph)((CoreMap)sentences.get((int)var13_70)).get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class), (String)subj.get(CoreAnnotations.WikipediaEntityAnnotation.class), (String)obj.get(CoreAnnotations.WikipediaEntityAnnotation.class));
                        String tripleString = triple.subjectGloss() + "\t" + triple.relationGloss() + "\t" + triple.objectGloss();
                        boolean acceptableTriple = true;
                        if (triple.objectGloss().equals(triple.subjectGloss()) && triple.relationGloss().endsWith("alternate_names")) {
                            acceptableTriple = false;
                        }
                        if (acceptableTriple && !hashMap5.containsKey(tripleString)) {
                            hashMap5.put(tripleString, triple);
                            continue;
                        }
                        if (!acceptableTriple || !(triple.confidence > ((RelationTriple)hashMap5.get((Object)tripleString)).confidence)) continue;
                        hashMap5.put(tripleString, triple);
                    }
                }
                finalTriplesList = new ArrayList(hashMap5.values());
                ((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get((int)var13_70)).set(CoreAnnotations.KBPTriplesAnnotation.class, finalTriplesList);
            }
            ++var13_70;
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        HashSet<Class> requirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.KBPTriplesAnnotation.class));
        return Collections.unmodifiableSet(requirements);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        HashSet<Class> requirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, CoreAnnotations.MentionsAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class));
        return Collections.unmodifiableSet(requirements);
    }

    public static void main(String[] args) throws IOException {
        Properties props = StringUtils.argsToProperties(args);
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,regexner,parse,mention,coref,kbp");
        props.setProperty("regexner.mapping", "ignorecase=true,validpospattern=(NN|JJ|ADD).*,edu/stanford/nlp/models/kbp/regexner_caseless.tab;edu/stanford/nlp/models/kbp/regexner_cased.tab");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        IOUtils.console("sentence> ", line -> {
            Annotation ann = new Annotation((String)line);
            pipeline.annotate(ann);
            for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
                ((List)sentence.get(CoreAnnotations.KBPTriplesAnnotation.class)).forEach(System.err::println);
            }
        });
    }
}

