/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;

public class LanguageInfo {
    public static final String ARABIC_PROPERTIES = "StanfordCoreNLP-arabic.properties";
    public static final String CHINESE_PROPERTIES = "StanfordCoreNLP-chinese.properties";
    public static final String ENGLISH_PROPERTIES = "StanfordCoreNLP.properties";
    public static final String FRENCH_PROPERTIES = "StanfordCoreNLP-french.properties";
    public static final String GERMAN_PROPERTIES = "StanfordCoreNLP-german.properties";
    public static final String HUNGARIAN_PROPERTIES = "StanfordCoreNLP-hungarian.properties";
    public static final String ITALIAN_PROPERTIES = "StanfordCoreNLP-italian.properties";
    public static final String SPANISH_PROPERTIES = "StanfordCoreNLP-spanish.properties";
    public static final Map<HumanLanguage, String> languageToPropertiesFile = new EnumMap<HumanLanguage, String>(HumanLanguage.class);

    private LanguageInfo() {
    }

    public static void main(String[] args) throws IllegalAccessException {
        for (Field field : LanguageInfo.class.getFields()) {
            System.out.println(field.getName() + "\t" + field.get(null));
        }
    }

    public static String getLanguagePropertiesFile(String inputString) {
        return languageToPropertiesFile.get((Object)LanguageInfo.getLanguageFromString(inputString));
    }

    public static Properties getLanguageProperties(String inputString) throws IOException {
        Properties props = new Properties();
        InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(LanguageInfo.getLanguagePropertiesFile(inputString));
        props.load(is);
        return props;
    }

    public static HumanLanguage getLanguageFromString(String inputString) {
        if (inputString.toLowerCase().equals("arabic") || inputString.toLowerCase().equals("ar")) {
            return HumanLanguage.ARABIC;
        }
        if (inputString.toLowerCase().equals("chinese") || inputString.toLowerCase().equals("zh")) {
            return HumanLanguage.CHINESE;
        }
        if (inputString.toLowerCase().equals("english") || inputString.toLowerCase().equals("en")) {
            return HumanLanguage.ENGLISH;
        }
        if (inputString.toLowerCase().equals("french") || inputString.toLowerCase().equals("fr")) {
            return HumanLanguage.FRENCH;
        }
        if (inputString.toLowerCase().equals("german") || inputString.toLowerCase().equals("de")) {
            return HumanLanguage.GERMAN;
        }
        if (inputString.toLowerCase().equals("hungarian") || inputString.toLowerCase().equals("hu")) {
            return HumanLanguage.HUNGARIAN;
        }
        if (inputString.toLowerCase().equals("italian") || inputString.toLowerCase().equals("it")) {
            return HumanLanguage.ITALIAN;
        }
        if (inputString.toLowerCase().equals("spanish") || inputString.toLowerCase().equals("es")) {
            return HumanLanguage.SPANISH;
        }
        return null;
    }

    public static boolean isStanfordCoreNLPSupportedLang(String lang) {
        return LanguageInfo.getLanguageFromString(lang) != null;
    }

    public static boolean isSegmenterLanguage(HumanLanguage language) {
        return language == HumanLanguage.ARABIC || language == HumanLanguage.CHINESE;
    }

    public static boolean isSegmenterLanguage(String inputString) {
        return LanguageInfo.isSegmenterLanguage(LanguageInfo.getLanguageFromString(inputString));
    }

    static {
        languageToPropertiesFile.put(HumanLanguage.ARABIC, ARABIC_PROPERTIES);
        languageToPropertiesFile.put(HumanLanguage.CHINESE, CHINESE_PROPERTIES);
        languageToPropertiesFile.put(HumanLanguage.ENGLISH, ENGLISH_PROPERTIES);
        languageToPropertiesFile.put(HumanLanguage.FRENCH, FRENCH_PROPERTIES);
        languageToPropertiesFile.put(HumanLanguage.GERMAN, GERMAN_PROPERTIES);
        languageToPropertiesFile.put(HumanLanguage.HUNGARIAN, HUNGARIAN_PROPERTIES);
        languageToPropertiesFile.put(HumanLanguage.ITALIAN, ITALIAN_PROPERTIES);
        languageToPropertiesFile.put(HumanLanguage.SPANISH, SPANISH_PROPERTIES);
    }

    public static enum HumanLanguage {
        ARABIC,
        CHINESE,
        ENGLISH,
        FRENCH,
        GERMAN,
        HUNGARIAN,
        ITALIAN,
        SPANISH;

    }
}

