/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.data.SpeakerInfo;
import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.ExtractionObject;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.SegmenterCoreAnnotations;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.NaturalLogicRelation;
import edu.stanford.nlp.naturalli.Operator;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.ChapterAnnotator;
import edu.stanford.nlp.quoteattribution.QuoteAttributionUtils;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IdentityHashSet;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.TwoDimensionalMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class ProtobufAnnotationSerializer
extends AnnotationSerializer {
    private static final Object globalLock = "I'm a lock :)";
    public final boolean enforceLosslessSerialization;

    public ProtobufAnnotationSerializer() {
        this(true);
    }

    public ProtobufAnnotationSerializer(boolean enforceLosslessSerialization) {
        this.enforceLosslessSerialization = enforceLosslessSerialization;
    }

    @Override
    public OutputStream write(Annotation corpus, OutputStream os) throws IOException {
        CoreNLPProtos.Document serialized = this.toProto(corpus);
        serialized.writeDelimitedTo(os);
        os.flush();
        return os;
    }

    @Override
    public Pair<Annotation, InputStream> read(InputStream is) throws IOException, ClassNotFoundException, ClassCastException {
        CoreNLPProtos.Document doc = CoreNLPProtos.Document.parseDelimitedFrom(is);
        return Pair.makePair(this.fromProto(doc), is);
    }

    public Annotation readUndelimited(File in) throws IOException {
        CoreNLPProtos.Document doc;
        try (FileInputStream delimited = new FileInputStream(in);){
            doc = CoreNLPProtos.Document.parseFrom(delimited);
        }
        catch (Exception e) {
            try (FileInputStream undelimited = new FileInputStream(in);){
                doc = CoreNLPProtos.Document.parseDelimitedFrom(undelimited);
            }
        }
        return this.fromProto(doc);
    }

    private static <E> E getAndRegister(CoreMap map, Set<Class<?>> keysToRegister, Class<? extends CoreAnnotation<E>> key) {
        keysToRegister.remove(key);
        return (E)map.get(key);
    }

    public CoreNLPProtos.Token toProto(CoreLabel coreLabel) {
        HashSet keysToSerialize = new HashSet(coreLabel.keySetNotNull());
        CoreNLPProtos.Token.Builder builder = this.toProtoBuilder(coreLabel, keysToSerialize);
        if (this.enforceLosslessSerialization && !keysToSerialize.isEmpty()) {
            throw new LossySerializationException("Keys are not being serialized: " + StringUtils.join(keysToSerialize));
        }
        return builder.build();
    }

    protected CoreNLPProtos.Token.Builder toProtoBuilder(CoreLabel coreLabel, Set<Class<?>> keysToSerialize) {
        IntPair span;
        CoreNLPProtos.Token.Builder builder = CoreNLPProtos.Token.newBuilder();
        Set<Class<?>> keySet = coreLabel.keySetNotNull();
        keysToSerialize.remove(CoreAnnotations.TextAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.SentenceIndexAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.DocIDAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.IndexAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.ParagraphAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.NumericCompositeObjectAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.ForcedSentenceUntilEndAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.ForcedSentenceEndAnnotation.class);
        keysToSerialize.remove(TreeCoreAnnotations.HeadWordLabelAnnotation.class);
        keysToSerialize.remove(TreeCoreAnnotations.HeadTagLabelAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.SectionStartAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.SectionEndAnnotation.class);
        if (coreLabel.word() != null) {
            builder.setWord(coreLabel.word());
        }
        if (keySet.contains(CoreAnnotations.PartOfSpeechAnnotation.class)) {
            builder.setPos(coreLabel.tag());
            keysToSerialize.remove(CoreAnnotations.PartOfSpeechAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.ValueAnnotation.class)) {
            builder.setValue(coreLabel.value());
            keysToSerialize.remove(CoreAnnotations.ValueAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.CategoryAnnotation.class)) {
            builder.setCategory(coreLabel.category());
            keysToSerialize.remove(CoreAnnotations.CategoryAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.BeforeAnnotation.class)) {
            builder.setBefore(coreLabel.before());
            keysToSerialize.remove(CoreAnnotations.BeforeAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.AfterAnnotation.class)) {
            builder.setAfter(coreLabel.after());
            keysToSerialize.remove(CoreAnnotations.AfterAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.OriginalTextAnnotation.class)) {
            builder.setOriginalText(coreLabel.originalText());
            keysToSerialize.remove(CoreAnnotations.OriginalTextAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            builder.setNer(coreLabel.ner());
            keysToSerialize.remove(CoreAnnotations.NamedEntityTagAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.CoarseNamedEntityTagAnnotation.class)) {
            builder.setCoarseNER((String)coreLabel.get(CoreAnnotations.CoarseNamedEntityTagAnnotation.class));
            keysToSerialize.remove(CoreAnnotations.CoarseNamedEntityTagAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class)) {
            builder.setFineGrainedNER((String)coreLabel.get(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class));
            keysToSerialize.remove(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.NamedEntityTagProbsAnnotation.class)) {
            if (((Map)coreLabel.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).keySet().size() == 0) {
                builder.addNerLabelProbs("empty");
            } else {
                for (String labelWithProb : ((Map)coreLabel.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).keySet()) {
                    Double labelProb = (Double)((Map)coreLabel.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get(labelWithProb);
                    builder.addNerLabelProbs(labelWithProb + "=" + labelProb);
                }
            }
            keysToSerialize.remove(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
            builder.setBeginChar(coreLabel.beginPosition());
            keysToSerialize.remove(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
            builder.setEndChar(coreLabel.endPosition());
            keysToSerialize.remove(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.CodepointOffsetBeginAnnotation.class)) {
            builder.setCodepointOffsetBegin((Integer)coreLabel.get(CoreAnnotations.CodepointOffsetBeginAnnotation.class));
            keysToSerialize.remove(CoreAnnotations.CodepointOffsetBeginAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.CodepointOffsetEndAnnotation.class)) {
            builder.setCodepointOffsetEnd((Integer)coreLabel.get(CoreAnnotations.CodepointOffsetEndAnnotation.class));
            keysToSerialize.remove(CoreAnnotations.CodepointOffsetEndAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.LemmaAnnotation.class)) {
            builder.setLemma(coreLabel.lemma());
            keysToSerialize.remove(CoreAnnotations.LemmaAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.UtteranceAnnotation.class)) {
            builder.setUtterance((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.UtteranceAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SpeakerAnnotation.class)) {
            builder.setSpeaker((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.SpeakerAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SpeakerTypeAnnotation.class)) {
            builder.setSpeakerType((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.SpeakerTypeAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.BeginIndexAnnotation.class)) {
            builder.setBeginIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.BeginIndexAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.EndIndexAnnotation.class)) {
            builder.setEndIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.EndIndexAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.TokenBeginAnnotation.class)) {
            builder.setTokenBeginIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.TokenBeginAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.TokenEndAnnotation.class)) {
            builder.setTokenEndIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.TokenEndAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class)) {
            builder.setNormalizedNER((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
        }
        if (keySet.contains(TimeAnnotations.TimexAnnotation.class)) {
            builder.setTimexValue(this.toProto((Timex)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, TimeAnnotations.TimexAnnotation.class)));
        }
        if (keySet.contains(CoreAnnotations.AnswerAnnotation.class)) {
            builder.setAnswer((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.AnswerAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.WikipediaEntityAnnotation.class)) {
            builder.setWikipediaEntity((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.WikipediaEntityAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.IsNewlineAnnotation.class)) {
            builder.setIsNewline((Boolean)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.IsNewlineAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.XmlContextAnnotation.class)) {
            builder.setHasXmlContext(true);
            builder.addAllXmlContext((Iterable)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.XmlContextAnnotation.class));
        } else {
            builder.setHasXmlContext(false);
        }
        if (keySet.contains(CoreAnnotations.SectionStartAnnotation.class)) {
            CoreMap sectionAnnotations = (CoreMap)coreLabel.get(CoreAnnotations.SectionStartAnnotation.class);
            if (sectionAnnotations.get(CoreAnnotations.SectionAnnotation.class) != null) {
                builder.setSectionName((String)sectionAnnotations.get(CoreAnnotations.SectionAnnotation.class));
            }
            if (sectionAnnotations.get(CoreAnnotations.AuthorAnnotation.class) != null) {
                builder.setSectionAuthor((String)sectionAnnotations.get(CoreAnnotations.AuthorAnnotation.class));
            }
            if (sectionAnnotations.get(CoreAnnotations.SectionDateAnnotation.class) != null) {
                builder.setSectionAuthor((String)sectionAnnotations.get(CoreAnnotations.SectionDateAnnotation.class));
            }
        }
        if (keySet.contains(CoreAnnotations.SectionEndAnnotation.class)) {
            builder.setSectionEndLabel((String)coreLabel.get(CoreAnnotations.SectionEndAnnotation.class));
        }
        if (keySet.contains(CorefCoreAnnotations.CorefClusterIdAnnotation.class)) {
            builder.setCorefClusterID((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CorefCoreAnnotations.CorefClusterIdAnnotation.class));
        }
        if (keySet.contains(NaturalLogicAnnotations.OperatorAnnotation.class)) {
            builder.setOperator(ProtobufAnnotationSerializer.toProto((OperatorSpec)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, NaturalLogicAnnotations.OperatorAnnotation.class)));
        }
        if (keySet.contains(NaturalLogicAnnotations.PolarityAnnotation.class)) {
            builder.setPolarity(ProtobufAnnotationSerializer.toProto((Polarity)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, NaturalLogicAnnotations.PolarityAnnotation.class)));
        }
        if (keySet.contains(NaturalLogicAnnotations.PolarityDirectionAnnotation.class)) {
            builder.setPolarityDir((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, NaturalLogicAnnotations.PolarityDirectionAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SpanAnnotation.class)) {
            span = (IntPair)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.SpanAnnotation.class);
            builder.setSpan(CoreNLPProtos.Span.newBuilder().setBegin(span.getSource()).setEnd(span.getTarget()).build());
        }
        if (keySet.contains(SentimentCoreAnnotations.SentimentClass.class)) {
            builder.setSentiment((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, SentimentCoreAnnotations.SentimentClass.class));
        }
        if (keySet.contains(CoreAnnotations.QuotationIndexAnnotation.class)) {
            builder.setQuotationIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.QuotationIndexAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.CoNLLUFeats.class)) {
            builder.setConllUFeatures(ProtobufAnnotationSerializer.toMapStringStringProto((Map)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.CoNLLUFeats.class)));
        }
        if (keySet.contains(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)) {
            span = (IntPair)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.CoNLLUTokenSpanAnnotation.class);
            builder.setConllUTokenSpan(CoreNLPProtos.Span.newBuilder().setBegin(span.getSource()).setEnd(span.getTarget()).build());
        }
        if (keySet.contains(CoreAnnotations.CoNLLUMisc.class)) {
            builder.setConllUMisc((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.CoNLLUMisc.class));
        }
        if (keySet.contains(CoreAnnotations.CoarseTagAnnotation.class)) {
            builder.setCoarseTag((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.CoarseTagAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class)) {
            builder.setConllUSecondaryDeps(ProtobufAnnotationSerializer.toMapStringStringProto((Map)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class)));
        }
        if (keySet.contains(CoreAnnotations.GenderAnnotation.class)) {
            builder.setGender((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.GenderAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.TrueCaseAnnotation.class)) {
            builder.setTrueCase((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.TrueCaseAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.TrueCaseTextAnnotation.class)) {
            builder.setTrueCaseText((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.TrueCaseTextAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.ChineseCharAnnotation.class)) {
            builder.setChineseChar((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.ChineseCharAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.ChineseSegAnnotation.class)) {
            builder.setChineseSeg((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.ChineseSegAnnotation.class));
        }
        if (keySet.contains(SegmenterCoreAnnotations.XMLCharAnnotation.class)) {
            builder.setChineseXMLChar((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, SegmenterCoreAnnotations.XMLCharAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.ArabicSegAnnotation.class)) {
            builder.setArabicSeg((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.ArabicSegAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.ParentAnnotation.class)) {
            builder.setParent((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.ParentAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.EntityMentionIndexAnnotation.class)) {
            builder.setEntityMentionIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.EntityMentionIndexAnnotation.class));
        }
        if (keySet.contains(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class)) {
            for (Integer corefMentionIndex : (Set)coreLabel.get(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class)) {
                builder.addCorefMentionIndex(corefMentionIndex);
            }
            keysToSerialize.remove(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.IsMultiWordTokenAnnotation.class)) {
            builder.setIsMWT((Boolean)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.IsMultiWordTokenAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.IsFirstWordOfMWTAnnotation.class)) {
            builder.setIsFirstMWT((Boolean)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.IsFirstWordOfMWTAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.MWTTokenTextAnnotation.class)) {
            builder.setMwtText((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.MWTTokenTextAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.NumericValueAnnotation.class)) {
            builder.setNumericValue(((Number)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.NumericValueAnnotation.class)).longValue());
        }
        if (keySet.contains(CoreAnnotations.NumericTypeAnnotation.class)) {
            builder.setNumericType((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.NumericTypeAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.NumericCompositeValueAnnotation.class)) {
            builder.setNumericCompositeValue(((Number)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.NumericCompositeValueAnnotation.class)).longValue());
        }
        if (keySet.contains(CoreAnnotations.NumericCompositeTypeAnnotation.class)) {
            builder.setNumericCompositeType((String)ProtobufAnnotationSerializer.getAndRegister(coreLabel, keysToSerialize, CoreAnnotations.NumericCompositeTypeAnnotation.class));
        }
        return builder;
    }

    public CoreNLPProtos.Sentence.Builder toProtoBuilder(CoreMap sentence) {
        return this.toProtoBuilder(sentence, Collections.emptySet());
    }

    public CoreNLPProtos.Sentence toProto(CoreMap sentence) {
        HashSet keysToSerialize = new HashSet(sentence.keySet());
        CoreNLPProtos.Sentence.Builder builder = this.toProtoBuilder(sentence, keysToSerialize);
        if (this.enforceLosslessSerialization && !keysToSerialize.isEmpty()) {
            throw new LossySerializationException("Keys are not being serialized: " + StringUtils.join(keysToSerialize));
        }
        return builder.build();
    }

    protected CoreNLPProtos.Sentence.Builder toProtoBuilder(CoreMap sentence, Set<Class<?>> keysToSerialize) {
        if (sentence instanceof CoreLabel) {
            throw new IllegalArgumentException("CoreMap is actually a CoreLabel");
        }
        CoreNLPProtos.Sentence.Builder builder = CoreNLPProtos.Sentence.newBuilder();
        keysToSerialize.remove(CoreAnnotations.TextAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.NumerizedTokensAnnotation.class);
        builder.setTokenOffsetBegin((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.TokenBeginAnnotation.class));
        builder.setTokenOffsetEnd((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.TokenEndAnnotation.class));
        Set<Class<?>> keySet = sentence instanceof ArrayCoreMap ? ((ArrayCoreMap)sentence).keySetNotNull() : new IdentityHashSet(sentence.keySet());
        if (sentence.containsKey(CoreAnnotations.TokensAnnotation.class)) {
            for (CoreLabel tok : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                builder.addToken(this.toProto(tok));
            }
            keysToSerialize.remove(CoreAnnotations.TokensAnnotation.class);
        }
        if (sentence.containsKey(SegmenterCoreAnnotations.CharactersAnnotation.class)) {
            for (CoreLabel c : (List)sentence.get(SegmenterCoreAnnotations.CharactersAnnotation.class)) {
                builder.addCharacter(this.toProto(c));
            }
            keysToSerialize.remove(SegmenterCoreAnnotations.CharactersAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.SentenceIndexAnnotation.class)) {
            builder.setSentenceIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.SentenceIndexAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.LineNumberAnnotation.class)) {
            builder.setLineNumber((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.LineNumberAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
            builder.setCharacterOffsetBegin((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.CharacterOffsetBeginAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
            builder.setCharacterOffsetEnd((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.CharacterOffsetEndAnnotation.class));
        }
        if (keySet.contains(TreeCoreAnnotations.TreeAnnotation.class)) {
            builder.setParseTree(ProtobufAnnotationSerializer.toProto((Tree)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, TreeCoreAnnotations.TreeAnnotation.class)));
        }
        if (keySet.contains(TreeCoreAnnotations.BinarizedTreeAnnotation.class)) {
            builder.setBinarizedParseTree(ProtobufAnnotationSerializer.toProto((Tree)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, TreeCoreAnnotations.BinarizedTreeAnnotation.class)));
        }
        if (keySet.contains(TreeCoreAnnotations.KBestTreesAnnotation.class)) {
            for (Tree tree : (List)sentence.get(TreeCoreAnnotations.KBestTreesAnnotation.class)) {
                builder.addKBestParseTrees(ProtobufAnnotationSerializer.toProto(tree));
                keysToSerialize.remove(TreeCoreAnnotations.KBestTreesAnnotation.class);
            }
        }
        if (keySet.contains(SentimentCoreAnnotations.SentimentAnnotatedTree.class)) {
            builder.setAnnotatedParseTree(ProtobufAnnotationSerializer.toProto((Tree)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SentimentCoreAnnotations.SentimentAnnotatedTree.class)));
        }
        if (keySet.contains(SentimentCoreAnnotations.SentimentClass.class)) {
            builder.setSentiment((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SentimentCoreAnnotations.SentimentClass.class));
        }
        if (keySet.contains(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)) {
            builder.setBasicDependencies(this.toProto((SemanticGraph)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)));
        }
        if (keySet.contains(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)) {
            builder.setCollapsedDependencies(this.toProto((SemanticGraph)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)));
        }
        if (keySet.contains(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)) {
            builder.setCollapsedCCProcessedDependencies(this.toProto((SemanticGraph)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)));
        }
        if (keySet.contains(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class)) {
            builder.setAlternativeDependencies(this.toProto((SemanticGraph)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class)));
        }
        if (keySet.contains(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class)) {
            builder.setEnhancedDependencies(this.toProto((SemanticGraph)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class)));
        }
        if (keySet.contains(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)) {
            builder.setEnhancedPlusPlusDependencies(this.toProto((SemanticGraph)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)));
        }
        if (keySet.contains(CoreAnnotations.TokensAnnotation.class) && ((List)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.TokensAnnotation.class)).size() > 0 && ((CoreLabel)((List)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.TokensAnnotation.class)).get(0)).containsKey(CoreAnnotations.ParagraphAnnotation.class)) {
            builder.setParagraph((Integer)((CoreLabel)((List)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.TokensAnnotation.class)).get(0)).get(CoreAnnotations.ParagraphAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.NumerizedTokensAnnotation.class)) {
            builder.setHasNumerizedTokensAnnotation(true);
        } else {
            builder.setHasNumerizedTokensAnnotation(false);
        }
        if (keySet.contains(NaturalLogicAnnotations.EntailedSentencesAnnotation.class)) {
            for (SentenceFragment entailedSentence : (Collection)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, NaturalLogicAnnotations.EntailedSentencesAnnotation.class)) {
                builder.addEntailedSentence(ProtobufAnnotationSerializer.toProto(entailedSentence));
            }
        }
        if (keySet.contains(NaturalLogicAnnotations.EntailedClausesAnnotation.class)) {
            for (SentenceFragment entailedClause : (Collection)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, NaturalLogicAnnotations.EntailedClausesAnnotation.class)) {
                builder.addEntailedClause(ProtobufAnnotationSerializer.toProto(entailedClause));
            }
        }
        if (keySet.contains(NaturalLogicAnnotations.RelationTriplesAnnotation.class)) {
            builder.setHasOpenieTriplesAnnotation(true);
            for (RelationTriple triple : (Collection)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, NaturalLogicAnnotations.RelationTriplesAnnotation.class)) {
                builder.addOpenieTriple(this.toProto(triple));
            }
        }
        if (keySet.contains(CoreAnnotations.KBPTriplesAnnotation.class)) {
            builder.setHasKBPTriplesAnnotation(true);
            for (RelationTriple triple : (List)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.KBPTriplesAnnotation.class)) {
                builder.addKbpTriple(this.toProto(triple));
            }
        }
        if (keySet.contains(MachineReadingAnnotations.EntityMentionsAnnotation.class)) {
            builder.setHasRelationAnnotations(true);
            for (EntityMention entity : (List)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, MachineReadingAnnotations.EntityMentionsAnnotation.class)) {
                builder.addEntity(this.toProto(entity));
            }
        } else {
            builder.setHasRelationAnnotations(false);
        }
        if (keySet.contains(MachineReadingAnnotations.RelationMentionsAnnotation.class)) {
            if (!builder.getHasRelationAnnotations()) {
                throw new IllegalStateException("Registered entity mentions without relation mentions");
            }
            for (RelationMention relation : (List)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, MachineReadingAnnotations.RelationMentionsAnnotation.class)) {
                builder.addRelation(this.toProto(relation));
            }
        }
        if (keySet.contains(CorefCoreAnnotations.CorefMentionsAnnotation.class)) {
            builder.setHasCorefMentionsAnnotation(true);
            for (Mention m : (List)sentence.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)) {
                builder.addMentionsForCoref(this.toProto(m));
            }
            keysToSerialize.remove(CorefCoreAnnotations.CorefMentionsAnnotation.class);
        }
        if (keySet.contains(CoreAnnotations.MentionsAnnotation.class)) {
            for (CoreMap mention : (List)sentence.get(CoreAnnotations.MentionsAnnotation.class)) {
                builder.addMentions(this.toProtoMention(mention));
            }
            keysToSerialize.remove(CoreAnnotations.MentionsAnnotation.class);
            builder.setHasEntityMentionsAnnotation(true);
        } else {
            builder.setHasEntityMentionsAnnotation(false);
        }
        if (keySet.contains(CoreAnnotations.SentenceIDAnnotation.class)) {
            builder.setSentenceID((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.SentenceIDAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SectionIndexAnnotation.class)) {
            builder.setSectionIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.SectionIndexAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SectionDateAnnotation.class)) {
            builder.setSectionDate((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.SectionDateAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SectionAnnotation.class)) {
            builder.setSectionName((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.SectionAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.AuthorAnnotation.class)) {
            builder.setSectionAuthor((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.AuthorAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.DocIDAnnotation.class)) {
            builder.setDocID((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.DocIDAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.QuotedAnnotation.class)) {
            builder.setSectionQuoted((Boolean)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.QuotedAnnotation.class));
        }
        if (keySet.contains(QuoteAttributionUtils.EnhancedSentenceAnnotation.class)) {
            keysToSerialize.remove(QuoteAttributionUtils.EnhancedSentenceAnnotation.class);
            CoreMap enhanced = (CoreMap)sentence.get(QuoteAttributionUtils.EnhancedSentenceAnnotation.class);
            builder.setEnhancedSentence(this.toProto(enhanced));
        }
        if (keySet.contains(ChapterAnnotator.ChapterAnnotation.class)) {
            builder.setChapterIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, ChapterAnnotator.ChapterAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.ParagraphIndexAnnotation.class)) {
            builder.setParagraphIndex((Integer)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.ParagraphIndexAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SpeakerAnnotation.class)) {
            builder.setSpeaker((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.SpeakerAnnotation.class));
        }
        if (keySet.contains(CoreAnnotations.SpeakerTypeAnnotation.class)) {
            builder.setSpeakerType((String)ProtobufAnnotationSerializer.getAndRegister(sentence, keysToSerialize, CoreAnnotations.SpeakerTypeAnnotation.class));
        }
        return builder;
    }

    public CoreNLPProtos.Document toProto(Annotation doc) {
        HashSet keysToSerialize = new HashSet(doc.keySet());
        keysToSerialize.remove(CoreAnnotations.TokensAnnotation.class);
        keysToSerialize.remove(CoreAnnotations.UseMarkedDiscourseAnnotation.class);
        CoreNLPProtos.Document.Builder builder = this.toProtoBuilder(doc, keysToSerialize);
        if (this.enforceLosslessSerialization && !keysToSerialize.isEmpty()) {
            throw new LossySerializationException("Keys are not being serialized: " + StringUtils.join(keysToSerialize));
        }
        return builder.build();
    }

    public CoreNLPProtos.Document.Builder toProtoBuilder(Annotation doc) {
        return this.toProtoBuilder(doc, Collections.emptySet());
    }

    protected CoreNLPProtos.Document.Builder toProtoBuilder(Annotation doc, Set<Class<?>> keysToSerialize) {
        CoreNLPProtos.Document.Builder builder = CoreNLPProtos.Document.newBuilder();
        builder.setText((String)doc.get(CoreAnnotations.TextAnnotation.class));
        keysToSerialize.remove(CoreAnnotations.TextAnnotation.class);
        if (doc.containsKey(CoreAnnotations.SectionsAnnotation.class)) {
            builder.setXmlDoc(true);
        } else {
            builder.setXmlDoc(false);
        }
        if (doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap coreMap : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
                builder.addSentence(this.toProto(coreMap));
            }
            keysToSerialize.remove(CoreAnnotations.SentencesAnnotation.class);
        } else if (doc.containsKey(CoreAnnotations.TokensAnnotation.class)) {
            for (CoreLabel coreLabel : (List)doc.get(CoreAnnotations.TokensAnnotation.class)) {
                builder.addSentencelessToken(this.toProto(coreLabel));
            }
        }
        if (doc.containsKey(CoreAnnotations.DocIDAnnotation.class)) {
            builder.setDocID((String)doc.get(CoreAnnotations.DocIDAnnotation.class));
            keysToSerialize.remove(CoreAnnotations.DocIDAnnotation.class);
        }
        if (doc.containsKey(CoreAnnotations.DocDateAnnotation.class)) {
            builder.setDocDate((String)doc.get(CoreAnnotations.DocDateAnnotation.class));
            keysToSerialize.remove(CoreAnnotations.DocDateAnnotation.class);
        }
        if (doc.containsKey(CoreAnnotations.CalendarAnnotation.class)) {
            builder.setCalendar(((Calendar)doc.get(CoreAnnotations.CalendarAnnotation.class)).toInstant().toEpochMilli());
            keysToSerialize.remove(CoreAnnotations.CalendarAnnotation.class);
        }
        if (doc.containsKey(CorefCoreAnnotations.CorefChainAnnotation.class)) {
            builder.setHasCorefAnnotation(true);
            for (Map.Entry entry : ((Map)doc.get(CorefCoreAnnotations.CorefChainAnnotation.class)).entrySet()) {
                builder.addCorefChain(this.toProto((CorefChain)entry.getValue()));
            }
            keysToSerialize.remove(CorefCoreAnnotations.CorefChainAnnotation.class);
        } else {
            builder.setHasCorefAnnotation(false);
        }
        if (doc.containsKey(CorefCoreAnnotations.CorefMentionsAnnotation.class)) {
            builder.setHasCorefMentionAnnotation(true);
            for (Mention mention : (List)doc.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)) {
                builder.addMentionsForCoref(this.toProto(mention));
            }
            keysToSerialize.remove(CorefCoreAnnotations.CorefMentionsAnnotation.class);
        } else {
            builder.setHasCorefMentionAnnotation(false);
        }
        if (doc.containsKey(CoreAnnotations.QuotationsAnnotation.class)) {
            for (CoreMap coreMap : (List)doc.get(CoreAnnotations.QuotationsAnnotation.class)) {
                builder.addQuote(this.toProtoQuote(coreMap));
            }
            keysToSerialize.remove(CoreAnnotations.QuotationsAnnotation.class);
        }
        if (doc.containsKey(CoreAnnotations.MentionsAnnotation.class)) {
            for (CoreMap coreMap : (List)doc.get(CoreAnnotations.MentionsAnnotation.class)) {
                builder.addMentions(this.toProtoMention(coreMap));
            }
            keysToSerialize.remove(CoreAnnotations.MentionsAnnotation.class);
            builder.setHasEntityMentionsAnnotation(true);
        } else {
            builder.setHasEntityMentionsAnnotation(false);
        }
        if (doc.containsKey(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class)) {
            Map entityMentionToCorefMention = (Map)doc.get(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class);
            int n = ((List)doc.get(CoreAnnotations.MentionsAnnotation.class)).size();
            for (int entityMentionIndex = 0; entityMentionIndex < n; ++entityMentionIndex) {
                if (entityMentionToCorefMention.keySet().contains(entityMentionIndex)) {
                    builder.addEntityMentionToCorefMentionMappings((Integer)entityMentionToCorefMention.get(entityMentionIndex));
                    continue;
                }
                builder.addEntityMentionToCorefMentionMappings(-1);
            }
            keysToSerialize.remove(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class);
        }
        if (doc.containsKey(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class)) {
            Map corefMentionToEntityMention = (Map)doc.get(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class);
            int n = ((List)doc.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)).size();
            for (int corefMentionIndex = 0; corefMentionIndex < n; ++corefMentionIndex) {
                if (corefMentionToEntityMention.keySet().contains(corefMentionIndex)) {
                    builder.addCorefMentionToEntityMentionMappings((Integer)corefMentionToEntityMention.get(corefMentionIndex));
                    continue;
                }
                builder.addCorefMentionToEntityMentionMappings(-1);
            }
            keysToSerialize.remove(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class);
        }
        if (doc.containsKey(SegmenterCoreAnnotations.CharactersAnnotation.class)) {
            for (CoreLabel coreLabel : (List)doc.get(SegmenterCoreAnnotations.CharactersAnnotation.class)) {
                builder.addCharacter(this.toProto(coreLabel));
            }
            keysToSerialize.remove(SegmenterCoreAnnotations.CharactersAnnotation.class);
        }
        if (doc.containsKey(CoreAnnotations.SectionsAnnotation.class)) {
            for (CoreMap coreMap : (List)doc.get(CoreAnnotations.SectionsAnnotation.class)) {
                builder.addSections(this.toProtoSection(coreMap));
            }
            keysToSerialize.remove(CoreAnnotations.SectionsAnnotation.class);
        }
        return builder;
    }

    public static CoreNLPProtos.ParseTree toProto(Tree parseTree) {
        Integer sentiment;
        CoreNLPProtos.ParseTree.Builder builder = CoreNLPProtos.ParseTree.newBuilder();
        for (Tree child : parseTree.children()) {
            builder.addChild(ProtobufAnnotationSerializer.toProto(child));
        }
        IntPair span = parseTree.getSpan();
        if (span != null) {
            builder.setYieldBeginIndex(span.getSource());
            builder.setYieldEndIndex(span.getTarget());
        }
        if (parseTree.label() != null) {
            builder.setValue(parseTree.label().value());
        }
        if (!Double.isNaN(parseTree.score())) {
            builder.setScore(parseTree.score());
        }
        if (parseTree.label() instanceof CoreMap && (sentiment = (Integer)((CoreMap)((Object)parseTree.label())).get(RNNCoreAnnotations.PredictedClass.class)) != null) {
            builder.setSentiment(CoreNLPProtos.Sentiment.forNumber(sentiment));
        }
        return builder.build();
    }

    public CoreNLPProtos.DependencyGraph toProto(SemanticGraph graph) {
        return this.toProto(graph, false);
    }

    public CoreNLPProtos.DependencyGraph toProto(SemanticGraph graph, boolean storeTokens) {
        CoreNLPProtos.DependencyGraph.Builder builder = CoreNLPProtos.DependencyGraph.newBuilder();
        Set rootSet = graph.getRoots().stream().map(IndexedWord::index).collect(Collectors.toCollection(IdentityHashSet::new));
        for (IndexedWord node : graph.vertexSet()) {
            CoreNLPProtos.DependencyGraph.Node.Builder nodeBuilder = CoreNLPProtos.DependencyGraph.Node.newBuilder().setSentenceIndex((Integer)node.get(CoreAnnotations.SentenceIndexAnnotation.class)).setIndex(node.index());
            if (node.copyCount() > 0) {
                nodeBuilder.setCopyAnnotation(node.copyCount());
            }
            builder.addNode(nodeBuilder.build());
            if (rootSet.contains(node.index())) {
                builder.addRoot(node.index());
            }
            if (!storeTokens) continue;
            builder.addToken(this.toProto(node.backingLabel()));
        }
        for (SemanticGraphEdge edge : graph.edgeIterable()) {
            builder.addEdge(CoreNLPProtos.DependencyGraph.Edge.newBuilder().setSource(edge.getSource().index()).setTarget(edge.getTarget().index()).setDep(edge.getRelation().toString()).setIsExtra(edge.isExtra()).setSourceCopy(edge.getSource().copyCount()).setTargetCopy(edge.getTarget().copyCount()).setLanguage(ProtobufAnnotationSerializer.toProto(edge.getRelation().getLanguage())));
        }
        return builder.build();
    }

    public CoreNLPProtos.CorefChain toProto(CorefChain chain) {
        CoreNLPProtos.CorefChain.Builder builder = CoreNLPProtos.CorefChain.newBuilder();
        builder.setChainID(chain.getChainID());
        IdentityHashMap<CorefChain.CorefMention, Integer> mentionToIndex = new IdentityHashMap<CorefChain.CorefMention, Integer>();
        for (Map.Entry<IntPair, Set<CorefChain.CorefMention>> entry : chain.getMentionMap().entrySet()) {
            for (CorefChain.CorefMention mention : entry.getValue()) {
                mentionToIndex.put(mention, mentionToIndex.size());
                builder.addMention(CoreNLPProtos.CorefChain.CorefMention.newBuilder().setMentionID(mention.mentionID).setMentionType(mention.mentionType.name()).setNumber(mention.number.name()).setGender(mention.gender.name()).setAnimacy(mention.animacy.name()).setBeginIndex(mention.startIndex - 1).setEndIndex(mention.endIndex - 1).setHeadIndex(mention.headIndex - 1).setSentenceIndex(mention.sentNum - 1).setPosition(mention.position.get(1)));
            }
        }
        builder.setRepresentative((Integer)mentionToIndex.get(chain.getRepresentativeMention()));
        return builder.build();
    }

    public CoreNLPProtos.Section toProtoSection(CoreMap section) {
        CoreNLPProtos.Section.Builder builder = CoreNLPProtos.Section.newBuilder();
        builder.setCharBegin((Integer)section.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
        builder.setCharEnd((Integer)section.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
        if (section.get(CoreAnnotations.AuthorAnnotation.class) != null) {
            builder.setAuthor((String)section.get(CoreAnnotations.AuthorAnnotation.class));
        }
        if (section.get(CoreAnnotations.SectionDateAnnotation.class) != null) {
            builder.setDatetime((String)section.get(CoreAnnotations.SectionDateAnnotation.class));
        }
        for (CoreMap sentence : (List)section.get(CoreAnnotations.SentencesAnnotation.class)) {
            int sentenceIndex = (Integer)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class);
            builder.addSentenceIndexes(sentenceIndex);
        }
        for (CoreMap quote : (List)section.get(CoreAnnotations.QuotesAnnotation.class)) {
            builder.addQuotes(this.toProtoQuote(quote));
        }
        if (section.get(CoreAnnotations.SectionAuthorCharacterOffsetBeginAnnotation.class) != null) {
            builder.setAuthorCharBegin((Integer)section.get(CoreAnnotations.SectionAuthorCharacterOffsetBeginAnnotation.class));
        }
        if (section.get(CoreAnnotations.SectionAuthorCharacterOffsetEndAnnotation.class) != null) {
            builder.setAuthorCharEnd((Integer)section.get(CoreAnnotations.SectionAuthorCharacterOffsetEndAnnotation.class));
        }
        builder.setXmlTag(this.toProto((CoreLabel)section.get(CoreAnnotations.SectionTagAnnotation.class)));
        return builder.build();
    }

    public CoreNLPProtos.IndexedWord createIndexedWordProtoFromIW(IndexedWord iw) {
        CoreNLPProtos.IndexedWord.Builder builder = CoreNLPProtos.IndexedWord.newBuilder();
        if (iw == null) {
            builder.setSentenceNum(-1);
            builder.setTokenIndex(-1);
        } else {
            builder.setSentenceNum((Integer)iw.get(CoreAnnotations.SentenceIndexAnnotation.class) - 1);
            builder.setTokenIndex((Integer)iw.get(CoreAnnotations.IndexAnnotation.class) - 1);
            builder.setCopyCount(iw.copyCount());
        }
        return builder.build();
    }

    public CoreNLPProtos.IndexedWord createIndexedWordProtoFromCL(CoreLabel cl) {
        CoreNLPProtos.IndexedWord.Builder builder = CoreNLPProtos.IndexedWord.newBuilder();
        if (cl == null) {
            builder.setSentenceNum(-1);
            builder.setTokenIndex(-1);
        } else {
            builder.setSentenceNum((Integer)cl.get(CoreAnnotations.SentenceIndexAnnotation.class) - 1);
            builder.setTokenIndex((Integer)cl.get(CoreAnnotations.IndexAnnotation.class) - 1);
        }
        return builder.build();
    }

    public CoreNLPProtos.Mention toProto(Mention mention) {
        CoreNLPProtos.Mention.Builder builder = CoreNLPProtos.Mention.newBuilder();
        if (mention.mentionType != null) {
            builder.setMentionType(mention.mentionType.name());
        }
        if (mention.gender != null) {
            builder.setGender(mention.gender.name());
        }
        if (mention.number != null) {
            builder.setNumber(mention.number.name());
        }
        if (mention.animacy != null) {
            builder.setAnimacy(mention.animacy.name());
        }
        if (mention.person != null) {
            builder.setPerson(mention.person.name());
        }
        if (mention.headString != null) {
            builder.setHeadString(mention.headString);
        }
        if (mention.nerString != null) {
            builder.setNerString(mention.nerString);
        }
        builder.setStartIndex(mention.startIndex);
        builder.setEndIndex(mention.endIndex);
        builder.setHeadIndex(mention.headIndex);
        builder.setMentionID(mention.mentionID);
        builder.setOriginalRef(mention.originalRef);
        builder.setGoldCorefClusterID(mention.goldCorefClusterID);
        builder.setCorefClusterID(mention.corefClusterID);
        builder.setMentionNum(mention.mentionNum);
        builder.setSentNum(mention.sentNum);
        builder.setUtter(mention.utter);
        builder.setParagraph(mention.paragraph);
        builder.setIsSubject(mention.isSubject);
        builder.setIsDirectObject(mention.isDirectObject);
        builder.setIsIndirectObject(mention.isIndirectObject);
        builder.setIsPrepositionObject(mention.isPrepositionObject);
        builder.setHasTwin(mention.hasTwin);
        builder.setGeneric(mention.generic);
        builder.setIsSingleton(mention.isSingleton);
        if (mention.dependents != null) {
            mention.dependents.forEach(builder::addDependents);
        }
        if (mention.preprocessedTerms != null) {
            mention.preprocessedTerms.forEach(builder::addPreprocessedTerms);
        }
        builder.setDependingVerb(this.createIndexedWordProtoFromIW(mention.dependingVerb));
        builder.setHeadIndexedWord(this.createIndexedWordProtoFromIW(mention.headIndexedWord));
        builder.setHeadWord(this.createIndexedWordProtoFromCL(mention.headWord));
        if (mention.sentenceWords != null) {
            for (CoreLabel cl : mention.sentenceWords) {
                builder.addSentenceWords(this.createIndexedWordProtoFromCL(cl));
            }
        }
        if (mention.originalSpan != null) {
            for (CoreLabel cl : mention.originalSpan) {
                builder.addOriginalSpan(this.createIndexedWordProtoFromCL(cl));
            }
        }
        builder.setHasBasicDependency(mention.basicDependency != null);
        builder.setHasEnhancedDependency(mention.enhancedDependency != null);
        builder.setHasContextParseTree(mention.contextParseTree != null);
        if (mention.appositions != null) {
            for (Mention m : mention.appositions) {
                builder.addAppositions(m.mentionID);
            }
        }
        if (mention.predicateNominatives != null) {
            for (Mention m : mention.predicateNominatives) {
                builder.addPredicateNominatives(m.mentionID);
            }
        }
        if (mention.relativePronouns != null) {
            for (Mention m : mention.relativePronouns) {
                builder.addRelativePronouns(m.mentionID);
            }
        }
        if (mention.listMembers != null) {
            for (Mention m : mention.listMembers) {
                builder.addListMembers(m.mentionID);
            }
        }
        if (mention.belongToLists != null) {
            for (Mention m : mention.belongToLists) {
                builder.addBelongToLists(m.mentionID);
            }
        }
        if (mention.speakerInfo != null) {
            builder.setSpeakerInfo(this.toProto(mention.speakerInfo));
        }
        return builder.build();
    }

    public CoreNLPProtos.SpeakerInfo toProto(SpeakerInfo speakerInfo) {
        CoreNLPProtos.SpeakerInfo.Builder builder = CoreNLPProtos.SpeakerInfo.newBuilder();
        builder.setSpeakerName(speakerInfo.getSpeakerName());
        for (Mention m : speakerInfo.getMentions()) {
            builder.addMentions(m.mentionID);
        }
        return builder.build();
    }

    public CoreNLPProtos.Timex toProto(Timex timex) {
        CoreNLPProtos.Timex.Builder builder = CoreNLPProtos.Timex.newBuilder();
        if (timex.value() != null) {
            builder.setValue(timex.value());
        }
        if (timex.altVal() != null) {
            builder.setAltValue(timex.altVal());
        }
        if (timex.text() != null) {
            builder.setText(timex.text());
        }
        if (timex.timexType() != null) {
            builder.setType(timex.timexType());
        }
        if (timex.tid() != null) {
            builder.setTid(timex.tid());
        }
        if (timex.beginPoint() >= 0) {
            builder.setBeginPoint(timex.beginPoint());
        }
        if (timex.endPoint() >= 0) {
            builder.setEndPoint(timex.endPoint());
        }
        return builder.build();
    }

    public CoreNLPProtos.Entity toProto(EntityMention ent) {
        CoreNLPProtos.Entity.Builder builder = CoreNLPProtos.Entity.newBuilder();
        if (ent.getObjectId() != null) {
            builder.setObjectID(ent.getObjectId());
        }
        if (ent.getExtent() != null) {
            builder.setExtentStart(ent.getExtent().start()).setExtentEnd(ent.getExtent().end());
        }
        if (ent.getType() != null) {
            builder.setType(ent.getType());
        }
        if (ent.getSubType() != null) {
            builder.setSubtype(ent.getSubType());
        }
        if (ent.getHead() != null) {
            builder.setHeadStart(ent.getHead().start());
            builder.setHeadEnd(ent.getHead().end());
        }
        if (ent.getMentionType() != null) {
            builder.setMentionType(ent.getMentionType());
        }
        if (ent.getNormalizedName() != null) {
            builder.setNormalizedName(ent.getNormalizedName());
        }
        if (ent.getSyntacticHeadTokenPosition() >= 0) {
            builder.setHeadTokenIndex(ent.getSyntacticHeadTokenPosition());
        }
        if (ent.getCorefID() != null) {
            builder.setCorefID(ent.getCorefID());
        }
        return builder.build();
    }

    public CoreNLPProtos.Relation toProto(RelationMention rel) {
        CoreNLPProtos.Relation.Builder builder = CoreNLPProtos.Relation.newBuilder();
        if (rel.getObjectId() != null) {
            builder.setObjectID(rel.getObjectId());
        }
        if (rel.getExtent() != null) {
            builder.setExtentStart(rel.getExtent().start()).setExtentEnd(rel.getExtent().end());
        }
        if (rel.getType() != null) {
            builder.setType(rel.getType());
        }
        if (rel.getSubType() != null) {
            builder.setSubtype(rel.getSubType());
        }
        if (rel.getArgNames() != null) {
            rel.getArgNames().forEach(builder::addArgName);
        }
        if (rel.getArgs() != null) {
            for (ExtractionObject arg : rel.getArgs()) {
                builder.addArg(this.toProto((EntityMention)arg));
            }
        }
        return builder.build();
    }

    public static CoreNLPProtos.Language toProto(Language lang) {
        switch (lang) {
            case Arabic: {
                return CoreNLPProtos.Language.Arabic;
            }
            case Chinese: {
                return CoreNLPProtos.Language.Chinese;
            }
            case UniversalChinese: {
                return CoreNLPProtos.Language.UniversalChinese;
            }
            case English: {
                return CoreNLPProtos.Language.English;
            }
            case UniversalEnglish: {
                return CoreNLPProtos.Language.UniversalEnglish;
            }
            case German: {
                return CoreNLPProtos.Language.German;
            }
            case French: {
                return CoreNLPProtos.Language.French;
            }
            case Hebrew: {
                return CoreNLPProtos.Language.Hebrew;
            }
            case Spanish: {
                return CoreNLPProtos.Language.Spanish;
            }
            case Unknown: {
                return CoreNLPProtos.Language.Unknown;
            }
            case Any: {
                return CoreNLPProtos.Language.Any;
            }
        }
        throw new IllegalStateException("Unknown language: " + (Object)((Object)lang));
    }

    public static CoreNLPProtos.Operator toProto(OperatorSpec op) {
        return CoreNLPProtos.Operator.newBuilder().setName(op.instance.name()).setQuantifierSpanBegin(op.quantifierBegin).setQuantifierSpanEnd(op.quantifierEnd).setSubjectSpanBegin(op.subjectBegin).setSubjectSpanEnd(op.subjectEnd).setObjectSpanBegin(op.objectBegin).setObjectSpanEnd(op.objectEnd).build();
    }

    public static CoreNLPProtos.Polarity toProto(Polarity pol) {
        return CoreNLPProtos.Polarity.newBuilder().setProjectEquivalence(CoreNLPProtos.NaturalLogicRelation.forNumber(pol.projectLexicalRelation((NaturalLogicRelation)NaturalLogicRelation.EQUIVALENT).fixedIndex)).setProjectForwardEntailment(CoreNLPProtos.NaturalLogicRelation.forNumber(pol.projectLexicalRelation((NaturalLogicRelation)NaturalLogicRelation.FORWARD_ENTAILMENT).fixedIndex)).setProjectReverseEntailment(CoreNLPProtos.NaturalLogicRelation.forNumber(pol.projectLexicalRelation((NaturalLogicRelation)NaturalLogicRelation.REVERSE_ENTAILMENT).fixedIndex)).setProjectNegation(CoreNLPProtos.NaturalLogicRelation.forNumber(pol.projectLexicalRelation((NaturalLogicRelation)NaturalLogicRelation.NEGATION).fixedIndex)).setProjectAlternation(CoreNLPProtos.NaturalLogicRelation.forNumber(pol.projectLexicalRelation((NaturalLogicRelation)NaturalLogicRelation.ALTERNATION).fixedIndex)).setProjectCover(CoreNLPProtos.NaturalLogicRelation.forNumber(pol.projectLexicalRelation((NaturalLogicRelation)NaturalLogicRelation.COVER).fixedIndex)).setProjectIndependence(CoreNLPProtos.NaturalLogicRelation.forNumber(pol.projectLexicalRelation((NaturalLogicRelation)NaturalLogicRelation.INDEPENDENCE).fixedIndex)).build();
    }

    public static CoreNLPProtos.SentenceFragment toProto(SentenceFragment fragment) {
        return CoreNLPProtos.SentenceFragment.newBuilder().setAssumedTruth(fragment.assumedTruth).setScore(fragment.score).addAllTokenIndex(fragment.words.stream().map(x -> x.index() - 1).collect(Collectors.toList())).setRoot(fragment.parseTree.getFirstRoot().index() - 1).build();
    }

    public CoreNLPProtos.RelationTriple toProto(RelationTriple triple) {
        CoreNLPProtos.RelationTriple.Builder builder = CoreNLPProtos.RelationTriple.newBuilder().setSubject(triple.subjectGloss()).setRelation(triple.relationGloss()).setObject(triple.objectGloss()).setConfidence(triple.confidence).addAllSubjectTokens(triple.subject.stream().map(token -> CoreNLPProtos.TokenLocation.newBuilder().setSentenceIndex(token.sentIndex()).setTokenIndex(token.index() - 1).build()).collect(Collectors.toList())).addAllRelationTokens(triple.relation.size() == 1 && triple.relation.get(0).get(CoreAnnotations.IndexAnnotation.class) == null ? Collections.emptyList() : (List)triple.relation.stream().map(token -> CoreNLPProtos.TokenLocation.newBuilder().setSentenceIndex(token.sentIndex()).setTokenIndex(token.index() - 1).build()).collect(Collectors.toList())).addAllObjectTokens(triple.object.stream().map(token -> CoreNLPProtos.TokenLocation.newBuilder().setSentenceIndex(token.sentIndex()).setTokenIndex(token.index() - 1).build()).collect(Collectors.toList()));
        Optional<SemanticGraph> treeOptional = triple.asDependencyTree();
        treeOptional.ifPresent(semanticGraph -> builder.setTree(this.toProto((SemanticGraph)semanticGraph)));
        return builder.build();
    }

    public static CoreNLPProtos.MapStringString toMapStringStringProto(Map<String, String> map) {
        CoreNLPProtos.MapStringString.Builder proto = CoreNLPProtos.MapStringString.newBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            proto.addKey(entry.getKey());
            proto.addValue(entry.getValue());
        }
        return proto.build();
    }

    public static CoreNLPProtos.MapIntString toMapIntStringProto(Map<Integer, String> map) {
        CoreNLPProtos.MapIntString.Builder proto = CoreNLPProtos.MapIntString.newBuilder();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            proto.addKey(entry.getKey());
            proto.addValue(entry.getValue());
        }
        return proto.build();
    }

    public CoreNLPProtos.Quote toProtoQuote(CoreMap quote) {
        CoreNLPProtos.Quote.Builder builder = CoreNLPProtos.Quote.newBuilder();
        if (quote.get(CoreAnnotations.TextAnnotation.class) != null) {
            builder.setText((String)quote.get(CoreAnnotations.TextAnnotation.class));
        }
        if (quote.get(CoreAnnotations.DocIDAnnotation.class) != null) {
            builder.setDocid((String)quote.get(CoreAnnotations.DocIDAnnotation.class));
        }
        if (quote.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) != null) {
            builder.setBegin((Integer)quote.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
        }
        if (quote.get(CoreAnnotations.CharacterOffsetEndAnnotation.class) != null) {
            builder.setEnd((Integer)quote.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
        }
        if (quote.get(CoreAnnotations.SentenceBeginAnnotation.class) != null) {
            builder.setSentenceBegin((Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class));
        }
        if (quote.get(CoreAnnotations.SentenceEndAnnotation.class) != null) {
            builder.setSentenceEnd((Integer)quote.get(CoreAnnotations.SentenceEndAnnotation.class));
        }
        if (quote.get(CoreAnnotations.TokenBeginAnnotation.class) != null) {
            builder.setTokenBegin((Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class));
        }
        if (quote.get(CoreAnnotations.TokenEndAnnotation.class) != null) {
            builder.setTokenEnd((Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class));
        }
        if (quote.get(CoreAnnotations.QuotationIndexAnnotation.class) != null) {
            builder.setIndex((Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class));
        }
        if (quote.get(CoreAnnotations.AuthorAnnotation.class) != null) {
            builder.setAuthor((String)quote.get(CoreAnnotations.AuthorAnnotation.class));
        }
        if (quote.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class) != null) {
            builder.setAttributionDependencyGraph(this.toProto((SemanticGraph)quote.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)));
        }
        if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) {
            builder.setMention((String)quote.get(QuoteAttributionAnnotator.MentionAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class) != null) {
            builder.setMentionBegin((Integer)quote.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.MentionEndAnnotation.class) != null) {
            builder.setMentionEnd((Integer)quote.get(QuoteAttributionAnnotator.MentionEndAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.MentionTypeAnnotation.class) != null) {
            builder.setMentionType((String)quote.get(QuoteAttributionAnnotator.MentionTypeAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.MentionSieveAnnotation.class) != null) {
            builder.setMentionSieve((String)quote.get(QuoteAttributionAnnotator.MentionSieveAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) != null) {
            builder.setSpeaker((String)quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class) != null) {
            builder.setSpeakerSieve((String)quote.get(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.CanonicalMentionAnnotation.class) != null) {
            builder.setCanonicalMention((String)quote.get(QuoteAttributionAnnotator.CanonicalMentionAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.CanonicalMentionBeginAnnotation.class) != null) {
            builder.setCanonicalMentionBegin((Integer)quote.get(QuoteAttributionAnnotator.CanonicalMentionBeginAnnotation.class));
        }
        if (quote.get(QuoteAttributionAnnotator.CanonicalMentionEndAnnotation.class) != null) {
            builder.setCanonicalMentionEnd((Integer)quote.get(QuoteAttributionAnnotator.CanonicalMentionEndAnnotation.class));
        }
        return builder.build();
    }

    public CoreNLPProtos.NERMention toProtoMention(CoreMap mention) {
        CoreNLPProtos.NERMention.Builder builder = CoreNLPProtos.NERMention.newBuilder();
        if (mention.get(CoreAnnotations.SentenceIndexAnnotation.class) != null) {
            builder.setSentenceIndex((Integer)mention.get(CoreAnnotations.SentenceIndexAnnotation.class));
        }
        if (mention.get(CoreAnnotations.TokenBeginAnnotation.class) != null) {
            builder.setTokenStartInSentenceInclusive((Integer)mention.get(CoreAnnotations.TokenBeginAnnotation.class));
        }
        if (mention.get(CoreAnnotations.TokenEndAnnotation.class) != null) {
            builder.setTokenEndInSentenceExclusive((Integer)mention.get(CoreAnnotations.TokenEndAnnotation.class));
        }
        if (mention.get(CoreAnnotations.NamedEntityTagAnnotation.class) != null) {
            builder.setNer((String)mention.get(CoreAnnotations.NamedEntityTagAnnotation.class));
        }
        if (mention.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class) != null) {
            builder.setNormalizedNER((String)mention.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
        }
        if (mention.get(CoreAnnotations.EntityTypeAnnotation.class) != null) {
            builder.setEntityType((String)mention.get(CoreAnnotations.EntityTypeAnnotation.class));
        }
        if (mention.get(TimeAnnotations.TimexAnnotation.class) != null) {
            builder.setTimex(this.toProto((Timex)mention.get(TimeAnnotations.TimexAnnotation.class)));
        }
        if (mention.get(CoreAnnotations.WikipediaEntityAnnotation.class) != null) {
            builder.setWikipediaEntity((String)mention.get(CoreAnnotations.WikipediaEntityAnnotation.class));
        }
        if (mention.get(CoreAnnotations.GenderAnnotation.class) != null) {
            builder.setGender((String)mention.get(CoreAnnotations.GenderAnnotation.class));
        }
        if (mention.get(CoreAnnotations.EntityMentionIndexAnnotation.class) != null) {
            builder.setEntityMentionIndex((Integer)mention.get(CoreAnnotations.EntityMentionIndexAnnotation.class));
        }
        if (mention.get(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class) != null) {
            builder.setCanonicalEntityMentionIndex((Integer)mention.get(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class));
        }
        if (mention.get(CoreAnnotations.TextAnnotation.class) != null) {
            builder.setEntityMentionText((String)mention.get(CoreAnnotations.TextAnnotation.class));
        }
        return builder.build();
    }

    public CoreLabel fromProto(CoreNLPProtos.Token proto) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        CoreLabel word = new CoreLabel();
        word.setWord(proto.getWord());
        if (proto.hasPos()) {
            word.setTag(proto.getPos());
        }
        if (proto.hasValue()) {
            word.setValue(proto.getValue());
        }
        if (proto.hasCategory()) {
            word.setCategory(proto.getCategory());
        }
        if (proto.hasBefore()) {
            word.setBefore(proto.getBefore());
        }
        if (proto.hasAfter()) {
            word.setAfter(proto.getAfter());
        }
        if (proto.hasOriginalText()) {
            word.setOriginalText(proto.getOriginalText());
        }
        if (proto.hasNer()) {
            word.setNER(proto.getNer());
        }
        if (proto.hasCoarseNER()) {
            word.set(CoreAnnotations.CoarseNamedEntityTagAnnotation.class, proto.getCoarseNER());
        }
        if (proto.hasFineGrainedNER()) {
            word.set(CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class, proto.getFineGrainedNER());
        }
        if (proto.hasLemma()) {
            word.setLemma(proto.getLemma());
        }
        if (proto.hasBeginChar()) {
            word.setBeginPosition(proto.getBeginChar());
        }
        if (proto.hasEndChar()) {
            word.setEndPosition(proto.getEndChar());
        }
        if (proto.hasCodepointOffsetBegin()) {
            word.set(CoreAnnotations.CodepointOffsetBeginAnnotation.class, proto.getCodepointOffsetBegin());
        }
        if (proto.hasCodepointOffsetEnd()) {
            word.set(CoreAnnotations.CodepointOffsetEndAnnotation.class, proto.getCodepointOffsetEnd());
        }
        if (proto.hasSpeaker()) {
            word.set(CoreAnnotations.SpeakerAnnotation.class, proto.getSpeaker());
        }
        if (proto.hasSpeakerType()) {
            word.set(CoreAnnotations.SpeakerTypeAnnotation.class, proto.getSpeakerType());
        }
        if (proto.hasUtterance()) {
            word.set(CoreAnnotations.UtteranceAnnotation.class, proto.getUtterance());
        }
        if (proto.hasBeginIndex()) {
            word.set(CoreAnnotations.BeginIndexAnnotation.class, proto.getBeginIndex());
        }
        if (proto.hasEndIndex()) {
            word.set(CoreAnnotations.EndIndexAnnotation.class, proto.getEndIndex());
        }
        if (proto.hasTokenBeginIndex()) {
            word.set(CoreAnnotations.TokenBeginAnnotation.class, proto.getTokenBeginIndex());
        }
        if (proto.hasTokenEndIndex()) {
            word.set(CoreAnnotations.TokenEndAnnotation.class, proto.getTokenEndIndex());
        }
        if (proto.hasNormalizedNER()) {
            word.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, proto.getNormalizedNER());
        }
        if (proto.hasTimexValue()) {
            word.set(TimeAnnotations.TimexAnnotation.class, ProtobufAnnotationSerializer.fromProto(proto.getTimexValue()));
        }
        if (proto.hasHasXmlContext() && proto.getHasXmlContext()) {
            word.set(CoreAnnotations.XmlContextAnnotation.class, proto.getXmlContextList());
        }
        if (proto.hasCorefClusterID()) {
            word.set(CorefCoreAnnotations.CorefClusterIdAnnotation.class, proto.getCorefClusterID());
        }
        if (proto.hasAnswer()) {
            word.set(CoreAnnotations.AnswerAnnotation.class, proto.getAnswer());
        }
        if (proto.hasOperator()) {
            word.set(NaturalLogicAnnotations.OperatorAnnotation.class, ProtobufAnnotationSerializer.fromProto(proto.getOperator()));
        }
        if (proto.hasPolarity()) {
            word.set(NaturalLogicAnnotations.PolarityAnnotation.class, ProtobufAnnotationSerializer.fromProto(proto.getPolarity()));
        }
        if (proto.hasPolarityDir()) {
            word.set(NaturalLogicAnnotations.PolarityDirectionAnnotation.class, proto.getPolarityDir());
        }
        if (proto.hasSpan()) {
            word.set(CoreAnnotations.SpanAnnotation.class, new IntPair(proto.getSpan().getBegin(), proto.getSpan().getEnd()));
        }
        if (proto.hasSentiment()) {
            word.set(SentimentCoreAnnotations.SentimentClass.class, proto.getSentiment());
        }
        if (proto.hasQuotationIndex()) {
            word.set(CoreAnnotations.QuotationIndexAnnotation.class, proto.getQuotationIndex());
        }
        if (proto.hasConllUFeatures()) {
            word.set(CoreAnnotations.CoNLLUFeats.class, ProtobufAnnotationSerializer.fromProto(proto.getConllUFeatures()));
        }
        if (proto.hasConllUMisc()) {
            word.set(CoreAnnotations.CoNLLUMisc.class, proto.getConllUMisc());
        }
        if (proto.hasCoarseTag()) {
            word.set(CoreAnnotations.CoarseTagAnnotation.class, proto.getCoarseTag());
        }
        if (proto.hasConllUTokenSpan()) {
            word.set(CoreAnnotations.CoNLLUTokenSpanAnnotation.class, new IntPair(proto.getConllUTokenSpan().getBegin(), proto.getSpan().getEnd()));
        }
        if (proto.hasConllUSecondaryDeps()) {
            word.set(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class, ProtobufAnnotationSerializer.fromProto(proto.getConllUSecondaryDeps()));
        }
        if (proto.hasWikipediaEntity()) {
            word.set(CoreAnnotations.WikipediaEntityAnnotation.class, proto.getWikipediaEntity());
        }
        if (proto.hasIsNewline()) {
            word.set(CoreAnnotations.IsNewlineAnnotation.class, proto.getIsNewline());
        }
        if (proto.hasChineseChar()) {
            word.set(CoreAnnotations.ChineseCharAnnotation.class, proto.getChineseChar());
        }
        if (proto.hasChineseSeg()) {
            word.set(CoreAnnotations.ChineseSegAnnotation.class, proto.getChineseSeg());
        }
        if (proto.hasChineseXMLChar()) {
            word.set(SegmenterCoreAnnotations.XMLCharAnnotation.class, proto.getChineseXMLChar());
        }
        if (proto.hasArabicSeg()) {
            word.set(CoreAnnotations.ArabicSegAnnotation.class, proto.getArabicSeg());
        }
        if (proto.hasGender()) {
            word.set(CoreAnnotations.GenderAnnotation.class, proto.getGender());
        }
        if (proto.hasTrueCase()) {
            word.set(CoreAnnotations.TrueCaseAnnotation.class, proto.getTrueCase());
        }
        if (proto.hasTrueCaseText()) {
            word.set(CoreAnnotations.TrueCaseTextAnnotation.class, proto.getTrueCaseText());
        }
        if (proto.hasSectionName() || proto.hasSectionAuthor() || proto.hasSectionDate()) {
            ArrayCoreMap sectionAnnotations = new ArrayCoreMap();
            if (proto.hasSectionName()) {
                sectionAnnotations.set(CoreAnnotations.SectionAnnotation.class, proto.getSectionName());
            }
            if (proto.hasSectionDate()) {
                sectionAnnotations.set(CoreAnnotations.SectionDateAnnotation.class, proto.getSectionDate());
            }
            if (proto.hasSectionAuthor()) {
                sectionAnnotations.set(CoreAnnotations.AuthorAnnotation.class, proto.getSectionAuthor());
            }
            word.set(CoreAnnotations.SectionStartAnnotation.class, sectionAnnotations);
        }
        if (proto.hasSectionEndLabel()) {
            word.set(CoreAnnotations.SectionEndAnnotation.class, proto.getSectionEndLabel());
        }
        if (proto.hasParent()) {
            word.set(CoreAnnotations.ParentAnnotation.class, proto.getParent());
        }
        if (proto.hasEntityMentionIndex()) {
            word.set(CoreAnnotations.EntityMentionIndexAnnotation.class, proto.getEntityMentionIndex());
        }
        if (proto.getNerLabelProbsList().size() != 0) {
            HashMap<String, Double> nerLabelProbs = new HashMap<String, Double>();
            if (!((String)proto.getNerLabelProbsList().get(0)).equals("empty")) {
                for (String nerLabelProb : proto.getNerLabelProbsList()) {
                    String[] labelAndProb = nerLabelProb.split("=");
                    Double labelProbDouble = Double.parseDouble(labelAndProb[1]);
                    nerLabelProbs.put(labelAndProb[0], labelProbDouble);
                }
            }
            word.set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, nerLabelProbs);
        }
        if (proto.hasMwtText()) {
            word.set(CoreAnnotations.MWTTokenTextAnnotation.class, proto.getMwtText());
        }
        if (proto.hasIsMWT()) {
            word.set(CoreAnnotations.IsMultiWordTokenAnnotation.class, proto.getIsMWT());
        }
        if (proto.hasIsFirstMWT()) {
            word.set(CoreAnnotations.IsFirstWordOfMWTAnnotation.class, proto.getIsFirstMWT());
        }
        if (proto.hasNumericValue()) {
            word.set(CoreAnnotations.NumericValueAnnotation.class, proto.getNumericValue());
        }
        if (proto.hasNumericType()) {
            word.set(CoreAnnotations.NumericTypeAnnotation.class, proto.getNumericType());
        }
        if (proto.hasNumericCompositeValue()) {
            word.set(CoreAnnotations.NumericCompositeValueAnnotation.class, proto.getNumericCompositeValue());
        }
        if (proto.hasNumericCompositeType()) {
            word.set(CoreAnnotations.NumericCompositeTypeAnnotation.class, proto.getNumericCompositeType());
        }
        return word;
    }

    @Deprecated
    public CoreMap fromProto(CoreNLPProtos.Sentence proto) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        CoreMap lossySentence = this.fromProtoNoTokens(proto);
        List<CoreLabel> tokens = proto.getTokenList().stream().map(this::fromProto).collect(Collectors.toList());
        lossySentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        this.setSentenceTokenAnnotations(lossySentence, proto, tokens, null);
        if (proto.getEntailedSentenceCount() > 0) {
            List entailedSentences = proto.getEntailedSentenceList().stream().map(frag -> ProtobufAnnotationSerializer.fromProto(frag, (SemanticGraph)lossySentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class))).collect(Collectors.toList());
            lossySentence.set(NaturalLogicAnnotations.EntailedSentencesAnnotation.class, entailedSentences);
        }
        if (proto.getEntailedClauseCount() > 0) {
            List entailedClauses = proto.getEntailedClauseList().stream().map(frag -> ProtobufAnnotationSerializer.fromProto(frag, (SemanticGraph)lossySentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class))).collect(Collectors.toList());
            lossySentence.set(NaturalLogicAnnotations.EntailedClausesAnnotation.class, entailedClauses);
        }
        if (proto.getOpenieTripleCount() > 0) {
            throw new IllegalStateException("Cannot deserialize OpenIE triples with this method!");
        }
        if (proto.getKbpTripleCount() > 0) {
            throw new IllegalStateException("Cannot deserialize KBP triples with this method!");
        }
        if (proto.getCharacterCount() > 0) {
            List sentenceCharacters = proto.getCharacterList().stream().map(this::fromProto).collect(Collectors.toList());
            lossySentence.set(SegmenterCoreAnnotations.CharactersAnnotation.class, sentenceCharacters);
        }
        lossySentence.set(CoreAnnotations.TextAnnotation.class, this.recoverOriginalText(tokens, proto));
        if (proto.hasSectionName()) {
            lossySentence.set(CoreAnnotations.SectionAnnotation.class, proto.getSectionName());
        }
        if (proto.hasSectionDate()) {
            lossySentence.set(CoreAnnotations.SectionDateAnnotation.class, proto.getSectionDate());
        }
        if (proto.hasSectionAuthor()) {
            lossySentence.set(CoreAnnotations.AuthorAnnotation.class, proto.getSectionAuthor());
        }
        if (proto.hasSectionIndex()) {
            lossySentence.set(CoreAnnotations.SectionIndexAnnotation.class, proto.getSectionIndex());
        }
        if (proto.hasChapterIndex()) {
            lossySentence.set(ChapterAnnotator.ChapterAnnotation.class, proto.getChapterIndex());
        }
        if (proto.hasParagraphIndex()) {
            lossySentence.set(CoreAnnotations.ParagraphIndexAnnotation.class, proto.getParagraphIndex());
        }
        if (proto.hasSpeaker()) {
            lossySentence.set(CoreAnnotations.SpeakerAnnotation.class, proto.getSpeaker());
        }
        if (proto.hasSpeakerType()) {
            lossySentence.set(CoreAnnotations.SpeakerTypeAnnotation.class, proto.getSpeakerType());
        }
        return lossySentence;
    }

    protected CoreMap fromProtoNoTokens(CoreNLPProtos.Sentence proto) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        ArrayCoreMap sentence = new ArrayCoreMap();
        sentence.set(CoreAnnotations.TokenBeginAnnotation.class, proto.getTokenOffsetBegin());
        sentence.set(CoreAnnotations.TokenEndAnnotation.class, proto.getTokenOffsetEnd());
        if (proto.hasSentenceIndex()) {
            sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, proto.getSentenceIndex());
        }
        if (proto.hasCharacterOffsetBegin()) {
            sentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, proto.getCharacterOffsetBegin());
        }
        if (proto.hasCharacterOffsetEnd()) {
            sentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, proto.getCharacterOffsetEnd());
        }
        if (proto.hasAnnotatedParseTree()) {
            sentence.set(SentimentCoreAnnotations.SentimentAnnotatedTree.class, ProtobufAnnotationSerializer.fromProto(proto.getAnnotatedParseTree()));
        }
        if (proto.hasSentiment()) {
            sentence.set(SentimentCoreAnnotations.SentimentClass.class, proto.getSentiment());
        }
        if (proto.hasHasRelationAnnotations() && proto.getHasRelationAnnotations()) {
            List entities = proto.getEntityList().stream().map(entity -> this.fromProto((CoreNLPProtos.Entity)entity, (CoreMap)sentence)).collect(Collectors.toList());
            sentence.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, entities);
            List relations = proto.getRelationList().stream().map(relation -> this.fromProto((CoreNLPProtos.Relation)relation, (CoreMap)sentence)).collect(Collectors.toList());
            sentence.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, relations);
        }
        this.loadSentenceMentions(proto, sentence);
        if (proto.hasSectionName()) {
            sentence.set(CoreAnnotations.SectionAnnotation.class, proto.getSectionName());
        }
        if (proto.hasSectionDate()) {
            sentence.set(CoreAnnotations.SectionDateAnnotation.class, proto.getSectionDate());
        }
        if (proto.hasSectionAuthor()) {
            sentence.set(CoreAnnotations.AuthorAnnotation.class, proto.getSectionAuthor());
        }
        if (proto.hasSectionIndex()) {
            sentence.set(CoreAnnotations.SectionIndexAnnotation.class, proto.getSectionIndex());
        }
        if (proto.hasSectionQuoted()) {
            sentence.set(CoreAnnotations.QuotedAnnotation.class, proto.getSectionQuoted());
        }
        if (proto.hasChapterIndex()) {
            sentence.set(ChapterAnnotator.ChapterAnnotation.class, proto.getChapterIndex());
        }
        if (proto.hasParagraphIndex()) {
            sentence.set(CoreAnnotations.ParagraphIndexAnnotation.class, proto.getParagraphIndex());
        }
        if (proto.hasSpeaker()) {
            sentence.set(CoreAnnotations.SpeakerAnnotation.class, proto.getSpeaker());
        }
        if (proto.hasSpeakerType()) {
            sentence.set(CoreAnnotations.SpeakerTypeAnnotation.class, proto.getSpeakerType());
        }
        return sentence;
    }

    protected void setSentenceTokenAnnotations(CoreMap sentence, CoreNLPProtos.Sentence protoSentence, List<CoreLabel> sentenceTokens, String docid) {
        if (protoSentence.hasParseTree()) {
            sentence.set(TreeCoreAnnotations.TreeAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getParseTree(), sentenceTokens));
        }
        if (protoSentence.hasBinarizedParseTree()) {
            sentence.set(TreeCoreAnnotations.BinarizedTreeAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getBinarizedParseTree(), sentenceTokens));
        }
        if (protoSentence.getKBestParseTreesCount() > 0) {
            List trees = protoSentence.getKBestParseTreesList().stream().map(x -> ProtobufAnnotationSerializer.fromProto(x, sentenceTokens)).collect(Collectors.toCollection(LinkedList::new));
            sentence.set(TreeCoreAnnotations.KBestTreesAnnotation.class, trees);
        }
        if (protoSentence.hasBasicDependencies()) {
            sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getBasicDependencies(), sentenceTokens, docid));
        }
        if (protoSentence.hasCollapsedDependencies()) {
            sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getCollapsedDependencies(), sentenceTokens, docid));
        }
        if (protoSentence.hasCollapsedCCProcessedDependencies()) {
            sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getCollapsedCCProcessedDependencies(), sentenceTokens, docid));
        }
        if (protoSentence.hasAlternativeDependencies()) {
            sentence.set(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getAlternativeDependencies(), sentenceTokens, docid));
        }
        if (protoSentence.hasEnhancedDependencies()) {
            sentence.set(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getEnhancedDependencies(), sentenceTokens, docid));
        }
        if (protoSentence.hasEnhancedPlusPlusDependencies()) {
            sentence.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, ProtobufAnnotationSerializer.fromProto(protoSentence.getEnhancedPlusPlusDependencies(), sentenceTokens, docid));
        }
    }

    protected void loadSentenceMentions(CoreNLPProtos.Sentence proto, CoreMap sentence) {
        if (proto.getHasCorefMentionsAnnotation()) {
            sentence.set(CorefCoreAnnotations.CorefMentionsAnnotation.class, new ArrayList());
        }
        if (proto.getMentionsForCorefList().size() != 0) {
            Mention m;
            HashMap<Integer, Mention> idToMention = new HashMap<Integer, Mention>();
            List sentenceMentions = (List)sentence.get(CorefCoreAnnotations.CorefMentionsAnnotation.class);
            for (CoreNLPProtos.Mention protoMention : proto.getMentionsForCorefList()) {
                m = this.fromProtoNoTokens(protoMention);
                sentenceMentions.add(m);
                idToMention.put(m.mentionID, m);
            }
            for (CoreNLPProtos.Mention protoMention : proto.getMentionsForCorefList()) {
                m = (Mention)idToMention.get(protoMention.getMentionID());
                if (protoMention.getAppositionsList().size() != 0) {
                    m.appositions = new HashSet<Mention>();
                    m.appositions.addAll(protoMention.getAppositionsList().stream().map(idToMention::get).collect(Collectors.toList()));
                }
                if (protoMention.getPredicateNominativesList().size() != 0) {
                    m.predicateNominatives = new HashSet<Mention>();
                    m.predicateNominatives.addAll(protoMention.getPredicateNominativesList().stream().map(idToMention::get).collect(Collectors.toList()));
                }
                if (protoMention.getRelativePronounsList().size() != 0) {
                    m.relativePronouns = new HashSet<Mention>();
                    m.relativePronouns.addAll(protoMention.getRelativePronounsList().stream().map(idToMention::get).collect(Collectors.toList()));
                }
                if (protoMention.getListMembersList().size() != 0) {
                    m.listMembers = new HashSet<Mention>();
                    m.listMembers.addAll(protoMention.getListMembersList().stream().map(idToMention::get).collect(Collectors.toList()));
                }
                if (protoMention.getBelongToListsList().size() == 0) continue;
                m.belongToLists = new HashSet<Mention>();
                m.belongToLists.addAll(protoMention.getBelongToListsList().stream().map(idToMention::get).collect(Collectors.toList()));
            }
        }
    }

    public Annotation fromProto(CoreNLPProtos.Document proto) {
        List quotes;
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        Annotation ann = new Annotation(proto.getText());
        if (proto.getCharacterCount() > 0) {
            ArrayList<CoreLabel> docChars = new ArrayList<CoreLabel>();
            for (CoreNLPProtos.Token token : proto.getCharacterList()) {
                docChars.add(this.fromProto(token));
            }
            ann.set(SegmenterCoreAnnotations.CharactersAnnotation.class, docChars);
        }
        boolean hasCorefInfo = proto.getHasCorefAnnotation();
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
        if (proto.getSentenceCount() > 0) {
            for (CoreNLPProtos.Sentence sentence : proto.getSentenceList()) {
                while (sentence.hasTokenOffsetBegin() && tokens.size() < sentence.getTokenOffsetBegin()) {
                    tokens.add(null);
                }
                for (CoreNLPProtos.Token token : sentence.getTokenList()) {
                    CoreLabel coreLabel = this.fromProto(token);
                    if (hasCorefInfo) {
                        coreLabel.set(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class, new HashSet());
                        for (Integer corefMentionIndex : token.getCorefMentionIndexList()) {
                            ((Set)coreLabel.get(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class)).add(corefMentionIndex);
                        }
                    }
                    if (proto.hasDocID()) {
                        coreLabel.setDocID(proto.getDocID());
                    }
                    if (token.hasTokenBeginIndex() && token.hasTokenEndIndex()) {
                        while (tokens.size() < sentence.getTokenOffsetEnd()) {
                            tokens.add(null);
                        }
                        for (int i = token.getTokenBeginIndex(); i < token.getTokenEndIndex(); ++i) {
                            tokens.set(token.getTokenBeginIndex(), coreLabel);
                        }
                        continue;
                    }
                    tokens.add(coreLabel);
                }
            }
        } else if (proto.getSentencelessTokenCount() > 0 && proto.getSentencelessTokenCount() > 0) {
            for (CoreNLPProtos.Token token : proto.getSentencelessTokenList()) {
                CoreLabel coreLabel = this.fromProto(token);
                if (proto.hasDocID()) {
                    coreLabel.setDocID(proto.getDocID());
                }
                tokens.add(coreLabel);
            }
        }
        if (!tokens.isEmpty()) {
            ann.set(CoreAnnotations.TokensAnnotation.class, tokens);
        }
        if (proto.getHasEntityMentionsAnnotation()) {
            ann.set(CoreAnnotations.MentionsAnnotation.class, new ArrayList());
        }
        ArrayList<CoreMap> arrayList = new ArrayList<CoreMap>(proto.getSentenceCount());
        for (int sentIndex = 0; sentIndex < proto.getSentenceCount(); ++sentIndex) {
            CoreNLPProtos.Sentence sentence = proto.getSentence(sentIndex);
            CoreMap map = this.fromProtoNoTokens(sentence);
            if (!tokens.isEmpty() && sentence.hasTokenOffsetBegin() && sentence.hasTokenOffsetEnd() && map.get(CoreAnnotations.TokensAnnotation.class) == null) {
                List mentionsOnAnnotation;
                int tokenBegin = sentence.getTokenOffsetBegin();
                int tokenEnd = sentence.getTokenOffsetEnd();
                assert (tokenBegin <= tokens.size() && tokenBegin <= tokenEnd);
                assert (tokenEnd <= tokens.size());
                map.set(CoreAnnotations.TokensAnnotation.class, tokens.subList(tokenBegin, tokenEnd));
                for (int i = tokenBegin; i < tokenEnd; ++i) {
                    CoreLabel token = (CoreLabel)tokens.get(i);
                    if (token == null) continue;
                    token.setSentIndex(sentIndex);
                    token.setIndex(i - sentence.getTokenOffsetBegin() + 1);
                    if (!sentence.hasParagraph()) continue;
                    token.set(CoreAnnotations.ParagraphAnnotation.class, sentence.getParagraph());
                }
                int characterBegin = sentence.getCharacterOffsetBegin();
                int characterEnd = sentence.getCharacterOffsetEnd();
                if (characterEnd <= proto.getText().length()) {
                    map.set(CoreAnnotations.TextAnnotation.class, proto.getText().substring(characterBegin, characterEnd));
                } else {
                    map.set(CoreAnnotations.TextAnnotation.class, this.recoverOriginalText(tokens.subList(tokenBegin, tokenEnd), sentence));
                }
                List mentions = sentence.getMentionsList().stream().map(this::fromProto).collect(Collectors.toList());
                for (Object entityMention : mentions) {
                    ArrayList entityMentionTokens = new ArrayList();
                    for (int tokenIndex = ((Integer)entityMention.get(CoreAnnotations.TokenBeginAnnotation.class)).intValue(); tokenIndex < (Integer)entityMention.get(CoreAnnotations.TokenEndAnnotation.class); ++tokenIndex) {
                        entityMentionTokens.add(tokens.get(tokenIndex));
                    }
                    int emCharOffsetBegin = (Integer)((CoreLabel)entityMentionTokens.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    int emCharOffsetEnd = (Integer)((CoreLabel)entityMentionTokens.get(entityMentionTokens.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    entityMention.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, emCharOffsetBegin);
                    entityMention.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, emCharOffsetEnd);
                    entityMention.set(CoreAnnotations.TokensAnnotation.class, entityMentionTokens);
                    HashMap<String, Double> nerLabelConfidences = EntityMentionsAnnotator.determineEntityMentionConfidences((CoreMap)entityMention);
                    entityMention.set(CoreAnnotations.NamedEntityTagProbsAnnotation.class, nerLabelConfidences);
                }
                if (sentence.getHasEntityMentionsAnnotation()) {
                    map.set(CoreAnnotations.MentionsAnnotation.class, mentions);
                }
                if ((mentionsOnAnnotation = (List)ann.get(CoreAnnotations.MentionsAnnotation.class)) != null) {
                    Object entityMention;
                    entityMention = mentions.iterator();
                    while (entityMention.hasNext()) {
                        CoreMap sentenceEM = (CoreMap)entityMention.next();
                        ((List)ann.get(CoreAnnotations.MentionsAnnotation.class)).add(sentenceEM);
                    }
                }
            }
            arrayList.add(map);
        }
        if (!arrayList.isEmpty()) {
            ann.set(CoreAnnotations.SentencesAnnotation.class, arrayList);
        }
        String docid = null;
        if (proto.hasDocID()) {
            docid = proto.getDocID();
            ann.set(CoreAnnotations.DocIDAnnotation.class, docid);
        }
        if (proto.hasDocDate()) {
            ann.set(CoreAnnotations.DocDateAnnotation.class, proto.getDocDate());
        }
        if (proto.hasCalendar()) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(proto.getCalendar());
            ann.set(CoreAnnotations.CalendarAnnotation.class, calendar);
        }
        HashMap<Integer, CorefChain> corefChains = new HashMap<Integer, CorefChain>();
        for (CoreNLPProtos.CorefChain chainProto : proto.getCorefChainList()) {
            CorefChain chain = this.fromProto(chainProto, ann);
            corefChains.put(chain.getChainID(), chain);
        }
        if (proto.getHasCorefAnnotation()) {
            ann.set(CorefCoreAnnotations.CorefChainAnnotation.class, corefChains);
        }
        if (proto.getHasCorefMentionAnnotation()) {
            ann.set(CorefCoreAnnotations.CorefMentionsAnnotation.class, new ArrayList());
        }
        HashMap<Integer, Mention> idToMention = new HashMap<Integer, Mention>();
        HashMap<Integer, CoreNLPProtos.Mention> idToProtoMention = new HashMap<Integer, CoreNLPProtos.Mention>();
        for (int sentenceIndex = 0; sentenceIndex < proto.getSentenceCount(); ++sentenceIndex) {
            CoreNLPProtos.Sentence sentence = proto.getSentenceList().get(sentenceIndex);
            CoreMap map = (CoreMap)arrayList.get(sentenceIndex);
            List sentenceTokens = (List)map.get(CoreAnnotations.TokensAnnotation.class);
            this.setSentenceTokenAnnotations(map, sentence, sentenceTokens, docid);
            if (sentence.getEntailedSentenceCount() > 0) {
                Set entailedSentences = sentence.getEntailedSentenceList().stream().map(frag -> ProtobufAnnotationSerializer.fromProto(frag, (SemanticGraph)map.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class))).collect(Collectors.toSet());
                map.set(NaturalLogicAnnotations.EntailedSentencesAnnotation.class, entailedSentences);
            }
            if (sentence.getEntailedClauseCount() > 0) {
                Set entailedClauses = sentence.getEntailedClauseList().stream().map(frag -> ProtobufAnnotationSerializer.fromProto(frag, (SemanticGraph)map.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class))).collect(Collectors.toSet());
                map.set(NaturalLogicAnnotations.EntailedClausesAnnotation.class, entailedClauses);
            }
            ArrayList<RelationTriple> triples = new ArrayList<RelationTriple>();
            if (sentence.getHasOpenieTriplesAnnotation()) {
                map.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, triples);
            }
            if (sentence.getOpenieTripleCount() > 0) {
                for (CoreNLPProtos.RelationTriple triple : sentence.getOpenieTripleList()) {
                    triples.add(ProtobufAnnotationSerializer.fromProto(triple, ann, sentenceIndex));
                }
                map.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, triples);
            }
            if (sentence.getHasKBPTriplesAnnotation()) {
                map.set(CoreAnnotations.KBPTriplesAnnotation.class, new ArrayList());
            }
            if (sentence.getKbpTripleCount() > 0) {
                for (CoreNLPProtos.RelationTriple kbpTriple : sentence.getKbpTripleList()) {
                    ((List)map.get(CoreAnnotations.KBPTriplesAnnotation.class)).add(ProtobufAnnotationSerializer.fromProto(kbpTriple, ann, sentenceIndex));
                }
            }
            if (map.containsKey(CoreAnnotations.TokensAnnotation.class) && (!sentence.hasHasNumerizedTokensAnnotation() || sentence.getHasNumerizedTokensAnnotation())) {
                map.set(CoreAnnotations.NumerizedTokensAnnotation.class, NumberNormalizer.findAndMergeNumbers(map));
            }
            int mentionInt = 0;
            for (CoreNLPProtos.Mention protoMention : sentence.getMentionsForCorefList()) {
                int ti;
                int headWordIndex;
                int dependingVerbIndex;
                Mention mentionToUpdate = (Mention)((List)map.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)).get(mentionInt);
                ArrayList<Mention> mentions = (ArrayList<Mention>)ann.get(CorefCoreAnnotations.CorefMentionsAnnotation.class);
                if (mentions == null) {
                    mentions = new ArrayList<Mention>();
                    ann.set(CorefCoreAnnotations.CorefMentionsAnnotation.class, mentions);
                }
                mentions.add(mentionToUpdate);
                idToMention.put(mentionToUpdate.mentionID, mentionToUpdate);
                idToProtoMention.put(mentionToUpdate.mentionID, protoMention);
                int headIndexedWordIndex = protoMention.getHeadIndexedWord().getTokenIndex();
                if (headIndexedWordIndex >= 0) {
                    mentionToUpdate.headIndexedWord = new IndexedWord((CoreLabel)sentenceTokens.get(protoMention.getHeadIndexedWord().getTokenIndex()));
                    mentionToUpdate.headIndexedWord.setCopyCount(protoMention.getHeadIndexedWord().getCopyCount());
                }
                if ((dependingVerbIndex = protoMention.getDependingVerb().getTokenIndex()) >= 0) {
                    mentionToUpdate.dependingVerb = new IndexedWord((CoreLabel)sentenceTokens.get(protoMention.getDependingVerb().getTokenIndex()));
                    mentionToUpdate.dependingVerb.setCopyCount(protoMention.getDependingVerb().getCopyCount());
                }
                if ((headWordIndex = protoMention.getHeadWord().getTokenIndex()) >= 0) {
                    mentionToUpdate.headWord = (CoreLabel)sentenceTokens.get(protoMention.getHeadWord().getTokenIndex());
                }
                mentionToUpdate.sentenceWords = new ArrayList<CoreLabel>();
                for (CoreNLPProtos.IndexedWord clp : protoMention.getSentenceWordsList()) {
                    ti = clp.getTokenIndex();
                    mentionToUpdate.sentenceWords.add((CoreLabel)sentenceTokens.get(ti));
                }
                mentionToUpdate.originalSpan = new ArrayList<CoreLabel>();
                for (CoreNLPProtos.IndexedWord clp : protoMention.getOriginalSpanList()) {
                    ti = clp.getTokenIndex();
                    mentionToUpdate.originalSpan.add((CoreLabel)sentenceTokens.get(ti));
                }
                if (protoMention.getHasBasicDependency()) {
                    mentionToUpdate.basicDependency = (SemanticGraph)map.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                }
                if (protoMention.getHasEnhancedDependency()) {
                    mentionToUpdate.enhancedDependency = (SemanticGraph)map.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
                }
                if (protoMention.getHasContextParseTree()) {
                    mentionToUpdate.contextParseTree = (Tree)map.get(TreeCoreAnnotations.TreeAnnotation.class);
                }
                ++mentionInt;
            }
        }
        if (proto.hasXmlDoc() && proto.getXmlDoc()) {
            ArrayList listOfSections = new ArrayList();
            ann.set(CoreAnnotations.SectionsAnnotation.class, listOfSections);
            for (CoreNLPProtos.Section section : proto.getSectionsList()) {
                CoreMap sectionCoreMap = this.fromProto(section, (List)ann.get(CoreAnnotations.SentencesAnnotation.class));
                ((List)ann.get(CoreAnnotations.SectionsAnnotation.class)).add(sectionCoreMap);
            }
        }
        if (!(quotes = proto.getQuoteList().stream().map(quote -> ProtobufAnnotationSerializer.fromProto(quote, (List<CoreLabel>)tokens)).collect(Collectors.toList())).isEmpty()) {
            ann.set(CoreAnnotations.QuotationsAnnotation.class, quotes);
            for (CoreMap quote2 : quotes) {
                ArrayList quoteTokens = new ArrayList();
                for (int quoteTokenIndex = ((Integer)quote2.get(CoreAnnotations.TokenBeginAnnotation.class)).intValue(); quoteTokenIndex <= (Integer)quote2.get(CoreAnnotations.TokenEndAnnotation.class); ++quoteTokenIndex) {
                    quoteTokens.add(((List)ann.get(CoreAnnotations.TokensAnnotation.class)).get(quoteTokenIndex));
                }
                quote2.set(CoreAnnotations.TokensAnnotation.class, quoteTokens);
            }
        }
        Iterator sentence = idToMention.keySet().iterator();
        while (sentence.hasNext()) {
            int mentionID = (Integer)sentence.next();
            Mention mentionToUpdate = (Mention)idToMention.get(mentionID);
            CoreNLPProtos.Mention correspondingProtoMention = (CoreNLPProtos.Mention)idToProtoMention.get(mentionID);
            if (!correspondingProtoMention.hasSpeakerInfo()) continue;
            SpeakerInfo speakerInfo = this.fromProto(correspondingProtoMention.getSpeakerInfo());
            Iterator<Object> iterator = correspondingProtoMention.getSpeakerInfo().getMentionsList().iterator();
            while (iterator.hasNext()) {
                int speakerInfoMentionID = (Integer)iterator.next();
                speakerInfo.addMention((Mention)idToMention.get(speakerInfoMentionID));
            }
            mentionToUpdate.speakerInfo = speakerInfo;
        }
        if (hasCorefInfo) {
            ann.set(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class, new HashMap());
            int entityMentionIndex = 0;
            for (int corefMentionForEntityMentionIndex : proto.getEntityMentionToCorefMentionMappingsList()) {
                if (corefMentionForEntityMentionIndex != -1) {
                    ((Map)ann.get(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class)).put(entityMentionIndex, corefMentionForEntityMentionIndex);
                }
                ++entityMentionIndex;
            }
            ann.set(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class, new HashMap());
            int corefMentionIndex = 0;
            for (int entityMentionForCorefMentionIndex : proto.getCorefMentionToEntityMentionMappingsList()) {
                if (entityMentionForCorefMentionIndex != -1) {
                    ((Map)ann.get(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class)).put(corefMentionIndex, entityMentionForCorefMentionIndex);
                }
                ++corefMentionIndex;
            }
        }
        return ann;
    }

    public static void toFlattenedTree(Tree tree, CoreNLPProtos.FlattenedParseTree.Builder treeBuilder) {
        CoreNLPProtos.FlattenedParseTree.Node.Builder nodeBuilder = CoreNLPProtos.FlattenedParseTree.Node.newBuilder();
        nodeBuilder.setOpenNode(true);
        treeBuilder.addNodes(nodeBuilder.build());
        if (tree.label() == null) {
            throw new UnsupportedOperationException("Empty label not supported");
        }
        nodeBuilder = CoreNLPProtos.FlattenedParseTree.Node.newBuilder();
        nodeBuilder.setValue(tree.label().value());
        if (!Double.isNaN(tree.score())) {
            nodeBuilder.setScore(tree.score());
        }
        treeBuilder.addNodes(nodeBuilder.build());
        for (Tree child : tree.children()) {
            if (child.numChildren() == 0) {
                nodeBuilder = CoreNLPProtos.FlattenedParseTree.Node.newBuilder();
                nodeBuilder.setValue(child.label().value());
                if (!Double.isNaN(child.score())) {
                    nodeBuilder.setScore(child.score());
                }
                treeBuilder.addNodes(nodeBuilder.build());
                continue;
            }
            ProtobufAnnotationSerializer.toFlattenedTree(child, treeBuilder);
        }
        nodeBuilder = CoreNLPProtos.FlattenedParseTree.Node.newBuilder();
        nodeBuilder.setCloseNode(true);
        treeBuilder.addNodes(nodeBuilder.build());
    }

    public static CoreNLPProtos.FlattenedParseTree toFlattenedTree(Tree tree) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        CoreNLPProtos.FlattenedParseTree.Builder treeBuilder = CoreNLPProtos.FlattenedParseTree.newBuilder();
        ProtobufAnnotationSerializer.toFlattenedTree(tree, treeBuilder);
        return treeBuilder.build();
    }

    public static Tree fromProto(CoreNLPProtos.FlattenedParseTree proto) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        if (proto.getNodesList().size() == 0) {
            return null;
        }
        Stack<LabeledScoredTreeNode> stack = new Stack<LabeledScoredTreeNode>();
        LabeledScoredTreeNode finished = null;
        for (CoreNLPProtos.FlattenedParseTree.Node next : proto.getNodesList()) {
            if (finished != null) {
                throw new IllegalArgumentException("Tree continued after it was already closed!  Offending proto: " + proto);
            }
            if (next.hasOpenNode()) {
                if (stack.size() > 0 && ((LabeledScoredTreeNode)stack.peek()).label() == null) {
                    throw new IllegalArgumentException("Tree added a child before a label was added to a node!  Offending proto: " + proto);
                }
                LabeledScoredTreeNode newNode = new LabeledScoredTreeNode();
                stack.push(newNode);
                if (!next.hasScore()) continue;
                newNode.setScore(next.getScore());
                continue;
            }
            if (next.hasCloseNode()) {
                if (stack.size() == 0) {
                    throw new IllegalArgumentException("Tree started with a Close, not an Open!  Offending proto: " + proto);
                }
                LabeledScoredTreeNode child = (LabeledScoredTreeNode)stack.pop();
                if (stack.size() == 0) {
                    finished = child;
                    continue;
                }
                LabeledScoredTreeNode parent = (LabeledScoredTreeNode)stack.peek();
                parent.addChild(child);
                continue;
            }
            if (stack.size() == 0) {
                throw new IllegalArgumentException("Tree started with a label, not an Open!  Offending proto: " + proto);
            }
            LabeledScoredTreeNode top = (LabeledScoredTreeNode)stack.peek();
            if (top.label() == null) {
                CoreLabel value = new CoreLabel();
                value.setCategory(next.getValue());
                value.setValue(next.getValue());
                top.setLabel(value);
                if (!next.hasScore()) continue;
                top.setScore(next.getScore());
                continue;
            }
            LabeledScoredTreeNode child = new LabeledScoredTreeNode();
            CoreLabel value = new CoreLabel();
            value.setCategory(next.getValue());
            value.setValue(next.getValue());
            child.setLabel(value);
            top.addChild(child);
            if (!next.hasScore()) continue;
            child.setScore(next.getScore());
        }
        if (finished == null) {
            throw new IllegalArgumentException("Tree never finished!  Offending proto: " + proto);
        }
        return finished;
    }

    public static Tree fromProto(CoreNLPProtos.ParseTree proto, List<CoreLabel> tokens) {
        Tree tree = ProtobufAnnotationSerializer.fromProto(proto);
        Trees.setLeafLabels(tree, tokens);
        return tree;
    }

    public static Tree fromProto(CoreNLPProtos.ParseTree proto) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        LabeledScoredTreeNode node = new LabeledScoredTreeNode();
        if (proto.hasValue()) {
            CoreLabel value = new CoreLabel();
            value.setCategory(proto.getValue());
            value.setValue(proto.getValue());
            node.setLabel(value);
            if (proto.hasYieldBeginIndex() && proto.hasYieldEndIndex()) {
                IntPair span = new IntPair(proto.getYieldBeginIndex(), proto.getYieldEndIndex());
                value.set(CoreAnnotations.SpanAnnotation.class, span);
            }
            if (proto.hasSentiment()) {
                value.set(RNNCoreAnnotations.PredictedClass.class, proto.getSentiment().getNumber());
            }
        }
        if (proto.hasScore()) {
            node.setScore(proto.getScore());
        }
        Tree[] children = new LabeledScoredTreeNode[proto.getChildCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = ProtobufAnnotationSerializer.fromProto(proto.getChild(i));
        }
        node.setChildren(children);
        return node;
    }

    public static Language fromProto(CoreNLPProtos.Language lang) {
        switch (lang) {
            case Arabic: {
                return Language.Arabic;
            }
            case Chinese: {
                return Language.Chinese;
            }
            case English: {
                return Language.English;
            }
            case German: {
                return Language.German;
            }
            case French: {
                return Language.French;
            }
            case Hebrew: {
                return Language.Hebrew;
            }
            case Spanish: {
                return Language.Spanish;
            }
            case UniversalChinese: {
                return Language.UniversalChinese;
            }
            case UniversalEnglish: {
                return Language.UniversalEnglish;
            }
            case Unknown: {
                return Language.Unknown;
            }
            case Any: {
                return Language.Any;
            }
        }
        throw new IllegalStateException("Unknown language: " + (Object)((Object)lang));
    }

    public static OperatorSpec fromProto(CoreNLPProtos.Operator operator) {
        String opName = operator.getName().toLowerCase();
        Operator op = null;
        for (Operator candidate : Operator.values()) {
            if (!candidate.name().toLowerCase().equals(opName)) continue;
            op = candidate;
            break;
        }
        return new OperatorSpec(op, operator.getQuantifierSpanBegin(), operator.getQuantifierSpanEnd(), operator.getSubjectSpanBegin(), operator.getSubjectSpanEnd(), operator.getObjectSpanBegin(), operator.getObjectSpanEnd());
    }

    public static Polarity fromProto(CoreNLPProtos.Polarity polarity) {
        byte[] projectionFn = new byte[]{(byte)polarity.getProjectEquivalence().getNumber(), (byte)polarity.getProjectForwardEntailment().getNumber(), (byte)polarity.getProjectReverseEntailment().getNumber(), (byte)polarity.getProjectNegation().getNumber(), (byte)polarity.getProjectAlternation().getNumber(), (byte)polarity.getProjectCover().getNumber(), (byte)polarity.getProjectIndependence().getNumber()};
        return new Polarity(projectionFn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SemanticGraph fromProto(CoreNLPProtos.DependencyGraph proto, List<CoreLabel> sentence, String docid, Optional<Annotation> document) {
        SemanticGraph graph = new SemanticGraph();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (CoreNLPProtos.DependencyGraph.Node node : proto.getNodeList()) {
            min = node.getIndex() < min ? node.getIndex() : min;
            max = node.getIndex() > max ? node.getIndex() : max;
        }
        TwoDimensionalMap<Integer, Integer, IndexedWord> nodes = TwoDimensionalMap.hashMap();
        for (CoreNLPProtos.DependencyGraph.Node in : proto.getNodeList()) {
            IndexedWord word;
            CoreLabel token = document.isPresent() ? (CoreLabel)((List)((CoreMap)((List)document.get().get(CoreAnnotations.SentencesAnnotation.class)).get(in.getSentenceIndex())).get(CoreAnnotations.TokensAnnotation.class)).get(in.getIndex() - 1) : sentence.get(in.getIndex() - 1);
            if (in.hasCopyAnnotation() && in.getCopyAnnotation() > 0) {
                word = new IndexedWord(new CoreLabel(token));
                word.setCopyCount(in.getCopyAnnotation());
            } else {
                word = new IndexedWord(token);
            }
            if (word.docID() == null && docid != null) {
                word.setDocID(docid);
            }
            if (word.sentIndex() < 0 && in.getSentenceIndex() >= 0) {
                word.setSentIndex(in.getSentenceIndex());
            }
            if (word.index() < 0 && in.getIndex() >= 0) {
                word.setIndex(in.getIndex());
            }
            assert (in.getIndex() == word.index());
            nodes.put(in.getIndex(), in.getCopyAnnotation(), word);
            graph.addVertex(word);
        }
        for (CoreNLPProtos.DependencyGraph.Edge ie : proto.getEdgeList()) {
            IndexedWord source = (IndexedWord)nodes.get(ie.getSource(), ie.getSourceCopy());
            assert (source != null);
            IndexedWord target = (IndexedWord)nodes.get(ie.getTarget(), ie.getTargetCopy());
            assert (target != null);
            Object object = globalLock;
            synchronized (object) {
                assert (ie.hasDep());
                GrammaticalRelation rel = GrammaticalRelation.valueOf(ProtobufAnnotationSerializer.fromProto(ie.getLanguage()), ie.getDep());
                graph.addEdge(source, target, rel, 1.0, ie.hasIsExtra() && ie.getIsExtra());
            }
        }
        if (proto.getRootCount() > 0) {
            Collection collection = proto.getRootList().stream().map(rootI -> (IndexedWord)nodes.get((Integer)rootI, 0)).collect(Collectors.toList());
            graph.setRoots(collection);
        } else if (!graph.isEmpty()) {
            graph.resetRoots();
        }
        return graph;
    }

    public static SemanticGraph fromProto(CoreNLPProtos.DependencyGraph proto, List<CoreLabel> sentence, String docid) {
        return ProtobufAnnotationSerializer.fromProto(proto, sentence, docid, Optional.empty());
    }

    public static RelationTriple fromProto(CoreNLPProtos.RelationTriple proto, Annotation doc, int sentenceIndex) {
        RelationTriple extraction;
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        List<CoreLabel> subject = proto.getSubjectTokensList().stream().map(loc -> (CoreLabel)((List)((CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(loc.getSentenceIndex())).get(CoreAnnotations.TokensAnnotation.class)).get(loc.getTokenIndex())).collect(Collectors.toList());
        List<CoreLabel> relation = proto.getRelationTokensCount() == 0 ? Collections.singletonList(new CoreLabel(new Word(proto.getRelation()))) : proto.getRelationTokensList().stream().map(loc -> (CoreLabel)((List)((CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(loc.getSentenceIndex())).get(CoreAnnotations.TokensAnnotation.class)).get(loc.getTokenIndex())).collect(Collectors.toList());
        List<CoreLabel> object = proto.getObjectTokensList().stream().map(loc -> (CoreLabel)((List)((CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(loc.getSentenceIndex())).get(CoreAnnotations.TokensAnnotation.class)).get(loc.getTokenIndex())).collect(Collectors.toList());
        double confidence = proto.getConfidence();
        if (proto.hasTree()) {
            SemanticGraph tree = ProtobufAnnotationSerializer.fromProto(proto.getTree(), (List)((CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(sentenceIndex)).get(CoreAnnotations.TokensAnnotation.class), (String)doc.get(CoreAnnotations.DocIDAnnotation.class), Optional.of(doc));
            extraction = new RelationTriple.WithTree(subject, relation, object, tree, confidence);
        } else {
            extraction = new RelationTriple(subject, relation, object, confidence);
        }
        if (proto.hasIstmod()) {
            extraction.istmod(proto.getIstmod());
        }
        if (proto.hasPrefixBe()) {
            extraction.isPrefixBe(proto.getPrefixBe());
        }
        if (proto.hasSuffixBe()) {
            extraction.isSuffixBe(proto.getSuffixBe());
        }
        if (proto.hasSuffixOf()) {
            extraction.isSuffixOf(proto.getSuffixOf());
        }
        return extraction;
    }

    public static SentenceFragment fromProto(CoreNLPProtos.SentenceFragment fragment, SemanticGraph tree) {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        SemanticGraph fragmentTree = new SemanticGraph(tree);
        if (fragment.hasRoot()) {
            fragmentTree.resetRoots();
            fragmentTree.vertexSet().stream().filter(vertex -> vertex.index() - 1 == fragment.getRoot()).forEach(fragmentTree::setRoot);
        }
        HashSet<Integer> keptIndices = new HashSet<Integer>(fragment.getTokenIndexList());
        tree.vertexSet().stream().filter(vertex -> !keptIndices.contains(vertex.index() - 1)).forEach(fragmentTree::removeVertex);
        fragmentTree.vertexSet().stream().filter(vertex -> fragmentTree.getFirstRoot() != vertex && tree.getFirstRoot() != vertex && !fragmentTree.incomingEdgeIterable((IndexedWord)vertex).iterator().hasNext()).forEach(vertex -> {
            SemanticGraphEdge edge = tree.incomingEdgeIterable((IndexedWord)vertex).iterator().next();
            fragmentTree.addEdge(fragmentTree.getFirstRoot(), edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
        });
        return new SentenceFragment(fragmentTree, fragment.hasAssumedTruth() ? fragment.getAssumedTruth() : true, false).changeScore(fragment.hasScore() ? fragment.getScore() : 1.0);
    }

    public static HashMap<String, String> fromProto(CoreNLPProtos.MapStringString proto) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < proto.getKeyCount(); ++i) {
            map.put(proto.getKey(i), proto.getValue(i));
        }
        return map;
    }

    public static HashMap<Integer, String> fromProto(CoreNLPProtos.MapIntString proto) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < proto.getKeyCount(); ++i) {
            map.put(proto.getKey(i), proto.getValue(i));
        }
        return map;
    }

    private CorefChain fromProto(CoreNLPProtos.CorefChain proto, Annotation partialDocument) {
        int cid = proto.getChainID();
        HashMap<IntPair, Set<CorefChain.CorefMention>> mentions = new HashMap<IntPair, Set<CorefChain.CorefMention>>();
        CorefChain.CorefMention representative = null;
        for (int i = 0; i < proto.getMentionCount(); ++i) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            CoreNLPProtos.CorefChain.CorefMention mentionProto = proto.getMention(i);
            StringBuilder mentionSpan = new StringBuilder();
            List sentenceTokens = (List)((CoreMap)((List)partialDocument.get(CoreAnnotations.SentencesAnnotation.class)).get(mentionProto.getSentenceIndex())).get(CoreAnnotations.TokensAnnotation.class);
            for (int k = mentionProto.getBeginIndex(); k < mentionProto.getEndIndex(); ++k) {
                mentionSpan.append(" ").append(((CoreLabel)sentenceTokens.get(k)).word());
            }
            CorefChain.CorefMention mention = new CorefChain.CorefMention(Dictionaries.MentionType.valueOf(mentionProto.getMentionType()), Dictionaries.Number.valueOf(mentionProto.getNumber()), Dictionaries.Gender.valueOf(mentionProto.getGender()), Dictionaries.Animacy.valueOf(mentionProto.getAnimacy()), mentionProto.getBeginIndex() + 1, mentionProto.getEndIndex() + 1, mentionProto.getHeadIndex() + 1, cid, mentionProto.getMentionID(), mentionProto.getSentenceIndex() + 1, new IntTuple(new int[]{mentionProto.getSentenceIndex() + 1, mentionProto.getPosition()}), mentionSpan.substring(mentionSpan.length() > 0 ? 1 : 0));
            IntPair key = new IntPair(mentionProto.getSentenceIndex() - 1, mentionProto.getHeadIndex() - 1);
            if (!mentions.containsKey(key)) {
                mentions.put(key, new HashSet());
            }
            ((Set)mentions.get(key)).add(mention);
            if (!proto.hasRepresentative() || i != proto.getRepresentative()) continue;
            representative = mention;
        }
        return new CorefChain(cid, mentions, representative);
    }

    private Mention fromProtoNoTokens(CoreNLPProtos.Mention protoMention) {
        Mention returnMention = new Mention();
        if (protoMention.getMentionType() != null && !protoMention.getMentionType().equals("")) {
            returnMention.mentionType = Dictionaries.MentionType.valueOf(protoMention.getMentionType());
        }
        if (protoMention.getNumber() != null && !protoMention.getNumber().equals("")) {
            returnMention.number = Dictionaries.Number.valueOf(protoMention.getNumber());
        }
        if (protoMention.getGender() != null && !protoMention.getGender().equals("")) {
            returnMention.gender = Dictionaries.Gender.valueOf(protoMention.getGender());
        }
        if (protoMention.getAnimacy() != null && !protoMention.getAnimacy().equals("")) {
            returnMention.animacy = Dictionaries.Animacy.valueOf(protoMention.getAnimacy());
        }
        if (protoMention.getPerson() != null && !protoMention.getPerson().equals("")) {
            returnMention.person = Dictionaries.Person.valueOf(protoMention.getPerson());
        }
        if (!protoMention.getHeadString().equals("")) {
            returnMention.headString = protoMention.getHeadString();
        }
        if (!protoMention.getNerString().equals("")) {
            returnMention.nerString = protoMention.getNerString();
        }
        returnMention.startIndex = protoMention.getStartIndex();
        returnMention.endIndex = protoMention.getEndIndex();
        returnMention.headIndex = protoMention.getHeadIndex();
        returnMention.mentionID = protoMention.getMentionID();
        returnMention.originalRef = protoMention.getOriginalRef();
        returnMention.goldCorefClusterID = protoMention.getGoldCorefClusterID();
        returnMention.corefClusterID = protoMention.getCorefClusterID();
        returnMention.mentionNum = protoMention.getMentionNum();
        returnMention.sentNum = protoMention.getSentNum();
        returnMention.utter = protoMention.getUtter();
        returnMention.paragraph = protoMention.getParagraph();
        returnMention.isSubject = protoMention.getIsSubject();
        returnMention.isDirectObject = protoMention.getIsDirectObject();
        returnMention.isIndirectObject = protoMention.getIsIndirectObject();
        returnMention.isPrepositionObject = protoMention.getIsPrepositionObject();
        returnMention.hasTwin = protoMention.getHasTwin();
        returnMention.generic = protoMention.getGeneric();
        returnMention.isSingleton = protoMention.getIsSingleton();
        if (protoMention.getDependentsCount() != 0) {
            returnMention.dependents = new HashSet<String>();
            returnMention.dependents.addAll((Collection<String>)protoMention.getDependentsList());
        }
        if (protoMention.getPreprocessedTermsCount() != 0) {
            returnMention.preprocessedTerms = new ArrayList<String>();
            returnMention.preprocessedTerms.addAll((Collection<String>)protoMention.getPreprocessedTermsList());
        }
        return returnMention;
    }

    private SpeakerInfo fromProto(CoreNLPProtos.SpeakerInfo speakerInfo) {
        String speakerName = speakerInfo.getSpeakerName();
        return new SpeakerInfo(speakerName);
    }

    private static Timex fromProto(CoreNLPProtos.Timex proto) {
        return new Timex(proto.hasType() ? proto.getType() : null, proto.hasValue() ? proto.getValue() : null, proto.hasAltValue() ? proto.getAltValue() : null, proto.hasTid() ? proto.getTid() : null, proto.hasText() ? proto.getText() : null, proto.hasBeginPoint() ? proto.getBeginPoint() : -1, proto.hasEndPoint() ? proto.getEndPoint() : -1);
    }

    private EntityMention fromProto(CoreNLPProtos.Entity proto, CoreMap sentence) {
        EntityMention rtn = new EntityMention(proto.hasObjectID() ? proto.getObjectID() : null, sentence, proto.hasHeadStart() ? new Span(proto.getHeadStart(), proto.getHeadEnd()) : null, proto.hasHeadEnd() ? new Span(proto.getExtentStart(), proto.getExtentEnd()) : null, proto.hasType() ? proto.getType() : null, proto.hasSubtype() ? proto.getSubtype() : null, proto.hasMentionType() ? proto.getMentionType() : null);
        if (proto.hasNormalizedName()) {
            rtn.setNormalizedName(proto.getNormalizedName());
        }
        if (proto.hasHeadTokenIndex()) {
            rtn.setHeadTokenPosition(proto.getHeadTokenIndex());
        }
        if (proto.hasCorefID()) {
            rtn.setCorefID(proto.getCorefID());
        }
        return rtn;
    }

    private RelationMention fromProto(CoreNLPProtos.Relation proto, CoreMap sentence) {
        List<ExtractionObject> args = proto.getArgList().stream().map(arg -> this.fromProto((CoreNLPProtos.Entity)arg, sentence)).collect(Collectors.toList());
        RelationMention rtn = new RelationMention(proto.hasObjectID() ? proto.getObjectID() : null, sentence, proto.hasExtentStart() ? new Span(proto.getExtentStart(), proto.getExtentEnd()) : null, proto.hasType() ? proto.getType() : null, proto.hasSubtype() ? proto.getSubtype() : null, args);
        if (proto.hasSignature()) {
            rtn.setSignature(proto.getSignature());
        }
        if (proto.getArgNameCount() > 0 || proto.getArgCount() == 0) {
            rtn.setArgNames((List<String>)proto.getArgNameList());
        }
        return rtn;
    }

    private static Annotation fromProto(CoreNLPProtos.Quote quote, List<CoreLabel> tokens) {
        List<CoreLabel> quotedTokens = null;
        Annotation ann = QuoteAnnotator.makeQuote(quote.hasText() ? quote.getText() : null, quote.hasBegin() ? quote.getBegin() : -1, quote.hasEnd() ? quote.getEnd() : -1, quotedTokens, quote.hasTokenBegin() ? quote.getTokenBegin() : -1, quote.hasSentenceBegin() ? quote.getSentenceBegin() : -1, quote.hasSentenceEnd() ? quote.getSentenceEnd() : -1, quote.hasDocid() ? quote.getDocid() : null);
        if (quote.hasIndex()) {
            ann.set(CoreAnnotations.QuotationIndexAnnotation.class, quote.getIndex());
        }
        if (quote.hasTokenBegin()) {
            ann.set(CoreAnnotations.TokenBeginAnnotation.class, quote.getTokenBegin());
        }
        if (quote.hasTokenEnd()) {
            ann.set(CoreAnnotations.TokenEndAnnotation.class, quote.getTokenEnd());
        }
        if (quote.hasAuthor()) {
            ann.set(CoreAnnotations.AuthorAnnotation.class, quote.getAuthor());
        }
        if (quote.hasMention()) {
            ann.set(QuoteAttributionAnnotator.MentionAnnotation.class, quote.getMention());
        }
        if (quote.hasMentionBegin()) {
            ann.set(QuoteAttributionAnnotator.MentionBeginAnnotation.class, quote.getMentionBegin());
        }
        if (quote.hasMentionEnd()) {
            ann.set(QuoteAttributionAnnotator.MentionEndAnnotation.class, quote.getMentionEnd());
        }
        if (quote.hasMentionType()) {
            ann.set(QuoteAttributionAnnotator.MentionTypeAnnotation.class, quote.getMentionType());
        }
        if (quote.hasMentionSieve()) {
            ann.set(QuoteAttributionAnnotator.MentionSieveAnnotation.class, quote.getMentionSieve());
        }
        if (quote.hasSpeaker()) {
            ann.set(QuoteAttributionAnnotator.SpeakerAnnotation.class, quote.getSpeaker());
        }
        if (quote.hasSpeakerSieve()) {
            ann.set(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class, quote.getSpeakerSieve());
        }
        if (quote.hasCanonicalMention()) {
            ann.set(QuoteAttributionAnnotator.CanonicalMentionAnnotation.class, quote.getCanonicalMention());
        }
        if (quote.hasCanonicalMentionBegin()) {
            ann.set(QuoteAttributionAnnotator.CanonicalMentionBeginAnnotation.class, quote.getCanonicalMentionBegin());
        }
        if (quote.hasCanonicalMentionEnd()) {
            ann.set(QuoteAttributionAnnotator.CanonicalMentionEndAnnotation.class, quote.getCanonicalMentionEnd());
        }
        return ann;
    }

    private CoreMap fromProto(CoreNLPProtos.NERMention mention) {
        ArrayCoreMap map = new ArrayCoreMap(12);
        if (mention.hasSentenceIndex()) {
            map.set(CoreAnnotations.SentenceIndexAnnotation.class, mention.getSentenceIndex());
        }
        if (mention.hasTokenStartInSentenceInclusive()) {
            map.set(CoreAnnotations.TokenBeginAnnotation.class, mention.getTokenStartInSentenceInclusive());
        }
        if (mention.hasTokenEndInSentenceExclusive()) {
            map.set(CoreAnnotations.TokenEndAnnotation.class, mention.getTokenEndInSentenceExclusive());
        }
        if (mention.hasNer()) {
            map.set(CoreAnnotations.NamedEntityTagAnnotation.class, mention.getNer());
        }
        if (mention.hasNormalizedNER()) {
            map.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, mention.getNormalizedNER());
        }
        if (mention.hasEntityType()) {
            map.set(CoreAnnotations.EntityTypeAnnotation.class, mention.getEntityType());
        }
        if (mention.hasTimex()) {
            map.set(TimeAnnotations.TimexAnnotation.class, ProtobufAnnotationSerializer.fromProto(mention.getTimex()));
        }
        if (mention.hasWikipediaEntity()) {
            map.set(CoreAnnotations.WikipediaEntityAnnotation.class, mention.getWikipediaEntity());
        }
        if (mention.hasGender()) {
            map.set(CoreAnnotations.GenderAnnotation.class, mention.getGender());
        }
        if (mention.hasEntityMentionIndex()) {
            map.set(CoreAnnotations.EntityMentionIndexAnnotation.class, mention.getEntityMentionIndex());
        }
        if (mention.hasCanonicalEntityMentionIndex()) {
            map.set(CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class, mention.getCanonicalEntityMentionIndex());
        }
        if (mention.hasEntityMentionText()) {
            map.set(CoreAnnotations.TextAnnotation.class, mention.getEntityMentionText());
        }
        return map;
    }

    private CoreMap fromProto(CoreNLPProtos.Section section, List<CoreMap> annotationSentences) {
        ArrayCoreMap map = new ArrayCoreMap();
        map.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, section.getCharBegin());
        map.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, section.getCharEnd());
        if (section.hasAuthor()) {
            map.set(CoreAnnotations.AuthorAnnotation.class, section.getAuthor());
        }
        if (section.hasDatetime()) {
            map.set(CoreAnnotations.SectionDateAnnotation.class, section.getDatetime());
        }
        ArrayList<CoreMap> sentencesList = new ArrayList<CoreMap>();
        Iterator<Object> iterator = section.getSentenceIndexesList().iterator();
        while (iterator.hasNext()) {
            int sentenceIndex = iterator.next();
            sentencesList.add(annotationSentences.get(sentenceIndex));
        }
        map.set(CoreAnnotations.SentencesAnnotation.class, sentencesList);
        map.set(CoreAnnotations.QuotesAnnotation.class, new ArrayList());
        for (CoreNLPProtos.Quote quote : section.getQuotesList()) {
            int quoteCharStart = quote.getBegin();
            int quoteCharEnd = quote.getEnd();
            String quoteAuthor = null;
            if (quote.hasAuthor()) {
                quoteAuthor = quote.getAuthor();
            }
            ArrayCoreMap quoteCoreMap = new ArrayCoreMap();
            quoteCoreMap.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, quoteCharStart);
            quoteCoreMap.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, quoteCharEnd);
            quoteCoreMap.set(CoreAnnotations.AuthorAnnotation.class, quoteAuthor);
            ((List)map.get(CoreAnnotations.QuotesAnnotation.class)).add(quoteCoreMap);
        }
        if (section.hasAuthorCharBegin()) {
            map.set(CoreAnnotations.SectionAuthorCharacterOffsetBeginAnnotation.class, section.getAuthorCharBegin());
        }
        if (section.hasAuthorCharEnd()) {
            map.set(CoreAnnotations.SectionAuthorCharacterOffsetEndAnnotation.class, section.getAuthorCharEnd());
        }
        map.set(CoreAnnotations.SectionTagAnnotation.class, this.fromProto(section.getXmlTag()));
        return map;
    }

    protected String recoverOriginalText(List<CoreLabel> tokens, CoreNLPProtos.Sentence sentence) {
        StringBuilder text = new StringBuilder();
        CoreLabel last = null;
        if (tokens.size() > 0) {
            CoreLabel token = tokens.get(0);
            if (token.originalText() != null) {
                text.append(token.originalText());
            } else {
                text.append(token.word());
            }
            last = tokens.get(0);
        }
        for (int i = 1; i < tokens.size(); ++i) {
            CoreLabel token = tokens.get(i);
            if (token.before() != null) {
                text.append(token.before());
                assert (last != null);
                for (int missingWhitespace = token.beginPosition() - last.endPosition() - token.before().length(); missingWhitespace > 0; --missingWhitespace) {
                    text.append(' ');
                }
            }
            if (token.originalText() != null) {
                text.append(token.originalText());
            } else {
                text.append(token.word());
            }
            last = token;
        }
        return text.toString();
    }

    public static class LossySerializationException
    extends RuntimeException {
        private static final long serialVersionUID = 741506383659886245L;

        private LossySerializationException(String msg) {
            super(msg);
        }
    }
}

