/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.process.LexerUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuoteAnnotator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(QuoteAnnotator.class);
    private final boolean VERBOSE;
    public boolean USE_SINGLE = false;
    public int MAX_LENGTH = -1;
    public boolean ASCII_QUOTES = false;
    public boolean ALLOW_EMBEDDED_SAME = false;
    public boolean SMART_QUOTES = false;
    public boolean EXTRACT_UNCLOSED = false;
    public boolean ATTRIBUTE_QUOTES = true;
    public QuoteAttributionAnnotator quoteAttributionAnnotator;
    public static final Map<String, String> DIRECTED_QUOTES;

    public QuoteAnnotator(String name, Properties props) {
        this(name, props, false);
    }

    public QuoteAnnotator(Properties props) {
        this("quote", props, false);
    }

    public QuoteAnnotator(String name, Properties props, boolean verbose) {
        this.USE_SINGLE = Boolean.parseBoolean(props.getProperty(name + ".singleQuotes", "false"));
        this.MAX_LENGTH = Integer.parseInt(props.getProperty(name + ".maxLength", "-1"));
        this.ASCII_QUOTES = Boolean.parseBoolean(props.getProperty(name + ".asciiQuotes", "false"));
        this.ALLOW_EMBEDDED_SAME = Boolean.parseBoolean(props.getProperty(name + ".allowEmbeddedSame", "false"));
        this.SMART_QUOTES = Boolean.parseBoolean(props.getProperty(name + ".smartQuotes", "false"));
        this.EXTRACT_UNCLOSED = Boolean.parseBoolean(props.getProperty(name + ".extractUnclosedQuotes", "false"));
        this.ATTRIBUTE_QUOTES = Boolean.parseBoolean(props.getProperty(name + ".attributeQuotes", "true"));
        this.VERBOSE = verbose;
        Timing timer = null;
        if (this.VERBOSE) {
            timer = new Timing();
            log.info("Preparing quote annotator...");
        }
        if (this.ATTRIBUTE_QUOTES) {
            Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(props, "quote.attribution.");
            this.quoteAttributionAnnotator = new QuoteAttributionAnnotator(relevantProperties);
        }
        if (this.VERBOSE) {
            timer.stop("done.");
        }
    }

    public static String xmlFreeText(String documentText, Annotation annotation) {
        int firstTokenCharIndex = (Integer)((CoreLabel)((List)annotation.get(CoreAnnotations.TokensAnnotation.class)).get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        String cleanedText = documentText.substring(0, firstTokenCharIndex).replaceAll("\\S", " ");
        int tokenIndex = 0;
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            cleanedText = cleanedText + token.originalText();
            if (++tokenIndex >= tokens.size()) continue;
            CoreLabel nextToken = (CoreLabel)tokens.get(tokenIndex);
            int inBetweenStart = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            int inBetweenEnd = (Integer)nextToken.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            String inBetweenTokenText = documentText.substring(inBetweenStart, inBetweenEnd);
            inBetweenTokenText = inBetweenTokenText.replaceAll("\\S", " ");
            cleanedText = cleanedText + inBetweenTokenText;
        }
        cleanedText = cleanedText + documentText.substring(cleanedText.length()).replaceAll("\\S", " ");
        return cleanedText;
    }

    @Override
    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        text = QuoteAnnotator.xmlFreeText(text, annotation);
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String quotesFrom = text;
        if (this.SMART_QUOTES) {
            Pair<List<Pair<Integer, Integer>>, List<Pair<Integer, Integer>>> overall = this.getQuotes(quotesFrom);
            String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
            List<CoreMap> cmQuotesUnicode = QuoteAnnotator.getCoreMapQuotes(overall.first(), tokens, sentences, text, docID, false);
            List<CoreMap> cmUnclosedUnicode = null;
            if (this.EXTRACT_UNCLOSED) {
                cmUnclosedUnicode = QuoteAnnotator.getCoreMapQuotes(overall.second(), tokens, sentences, text, docID, true);
            }
            int numUnicode = QuoteAnnotator.countQuotes(cmQuotesUnicode);
            if (this.ASCII_QUOTES) {
                quotesFrom = QuoteAnnotator.replaceUnicode(text);
            }
            overall = this.getQuotes(quotesFrom);
            docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
            List<CoreMap> cmQuotesAscii = QuoteAnnotator.getCoreMapQuotes(overall.first(), tokens, sentences, text, docID, false);
            List<CoreMap> cmUnclosedAscii = null;
            if (this.EXTRACT_UNCLOSED) {
                cmUnclosedAscii = QuoteAnnotator.getCoreMapQuotes(overall.second(), tokens, sentences, text, docID, true);
            }
            int numAsciiSingle = QuoteAnnotator.countQuotes(cmQuotesAscii);
            this.USE_SINGLE = false;
            overall = this.getQuotes(quotesFrom);
            docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
            List<CoreMap> cmQuotesAsciiNoSingle = QuoteAnnotator.getCoreMapQuotes(overall.first(), tokens, sentences, text, docID, false);
            List<CoreMap> cmUnclosedAsciiNoSingle = null;
            if (this.EXTRACT_UNCLOSED) {
                cmUnclosedAsciiNoSingle = QuoteAnnotator.getCoreMapQuotes(overall.second(), tokens, sentences, text, docID, true);
            }
            int numAsciiNoSingle = QuoteAnnotator.countQuotes(cmQuotesAsciiNoSingle);
            log.info("Number of quotes + unicode - single : " + numUnicode);
            log.info("Number of quotes + ascii - single : " + numAsciiNoSingle);
            log.info("Number of quotes + ascii + single : " + numAsciiSingle);
            if (numUnicode >= numAsciiNoSingle && numUnicode > numAsciiSingle / 2) {
                this.setAnnotations(annotation, cmQuotesUnicode, cmUnclosedUnicode, "Using unicode quotes.");
            } else if (numAsciiSingle > numAsciiNoSingle / 2) {
                this.setAnnotations(annotation, cmQuotesAscii, cmUnclosedAscii, "Using ascii quotes.");
            } else {
                this.setAnnotations(annotation, cmQuotesAsciiNoSingle, cmUnclosedAsciiNoSingle, "Using ascii quotes with no single quotes.");
            }
        } else {
            if (this.ASCII_QUOTES) {
                quotesFrom = QuoteAnnotator.replaceUnicode(text);
            }
            Pair<List<Pair<Integer, Integer>>, List<Pair<Integer, Integer>>> overall = this.getQuotes(quotesFrom);
            String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
            List<CoreMap> cmQuotes = QuoteAnnotator.getCoreMapQuotes(overall.first(), tokens, sentences, text, docID, false);
            List<CoreMap> cmQuotesUnclosed = QuoteAnnotator.getCoreMapQuotes(overall.second(), tokens, sentences, text, docID, true);
            this.setAnnotations(annotation, cmQuotes, cmQuotesUnclosed, "Setting quotes.");
        }
        if (this.ATTRIBUTE_QUOTES) {
            this.quoteAttributionAnnotator.annotate(annotation);
        }
    }

    private void setAnnotations(Annotation annotation, List<CoreMap> quotes, List<CoreMap> unclosed, String message) {
        annotation.set(CoreAnnotations.QuotationsAnnotation.class, quotes);
        log.info(message);
        if (this.EXTRACT_UNCLOSED) {
            annotation.set(CoreAnnotations.UnclosedQuotationsAnnotation.class, unclosed);
        }
    }

    private static int countQuotes(List<CoreMap> quotes) {
        int total = quotes.size();
        for (CoreMap quote : quotes) {
            List innerQuotes = (List)quote.get(CoreAnnotations.QuotationsAnnotation.class);
            if (innerQuotes == null) continue;
            total += innerQuotes.size();
        }
        return total;
    }

    public static String replaceUnicode(String text) {
        return LexerUtils.asciiQuotes(text);
    }

    public static Comparator<CoreMap> getQuoteComparator() {
        return (o1, o2) -> {
            int s1 = (Integer)o1.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int s2 = (Integer)o2.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            return Integer.compare(s1, s2);
        };
    }

    public static List<CoreMap> getCoreMapQuotes(List<Pair<Integer, Integer>> quotes, List<CoreLabel> tokens, List<CoreMap> sentences, String text, String docID, boolean unclosed) {
        ArrayList<CoreMap> cmQuotes = Generics.newArrayList();
        for (Pair<Integer, Integer> p : quotes) {
            int begin = p.first();
            int end = p.second();
            ArrayList<CoreLabel> quoteTokens = new ArrayList<CoreLabel>();
            int tokenOffset = -1;
            if (tokens != null) {
                int i;
                int currTok;
                for (currTok = 0; currTok < tokens.size() && tokens.get(currTok).beginPosition() < begin; ++currTok) {
                }
                tokenOffset = i = currTok;
                while (i < tokens.size() && tokens.get(i).endPosition() <= end) {
                    quoteTokens.add(tokens.get(i));
                    ++i;
                }
            }
            int beginSentence = -1;
            int endSentence = -1;
            if (sentences != null) {
                for (CoreMap sentence : sentences) {
                    int sentBegin = (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    int sentEnd = (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    int sentIndex = (Integer)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class);
                    if (sentBegin <= begin) {
                        beginSentence = sentIndex;
                    }
                    if (sentEnd < end || endSentence >= 0) continue;
                    endSentence = sentIndex;
                }
            }
            Annotation quote = QuoteAnnotator.makeQuote(text.substring(begin, end), begin, end, quoteTokens, tokenOffset, beginSentence, endSentence, docID);
            if (quoteTokens.size() == 0 || endSentence <= -1) continue;
            cmQuotes.add(quote);
        }
        Comparator<CoreMap> quoteComparator = QuoteAnnotator.getQuoteComparator();
        cmQuotes.sort(quoteComparator);
        ArrayList<CoreMap> toRemove = new ArrayList<CoreMap>();
        for (CoreMap cmQuote : cmQuotes) {
            int start = (Integer)cmQuote.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int end = (Integer)cmQuote.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            ArrayList<CoreMap> embeddedQuotes = new ArrayList<CoreMap>();
            for (CoreMap cmQuoteComp : cmQuotes) {
                int startComp = (Integer)cmQuoteComp.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int endComp = (Integer)cmQuoteComp.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                if (start >= startComp || end < endComp) continue;
                embeddedQuotes.add(cmQuoteComp);
                toRemove.add(cmQuoteComp);
            }
            if (!unclosed) {
                cmQuote.set(CoreAnnotations.QuotationsAnnotation.class, embeddedQuotes);
                continue;
            }
            cmQuote.set(CoreAnnotations.UnclosedQuotationsAnnotation.class, embeddedQuotes);
        }
        for (CoreMap r : toRemove) {
            cmQuotes.remove(r);
        }
        QuoteAnnotator.setQuoteIndices(cmQuotes, unclosed);
        return cmQuotes;
    }

    private static void setQuoteIndices(List<CoreMap> topLevel, boolean unclosed) {
        List<CoreMap> level = topLevel;
        int index = 0;
        while (!level.isEmpty()) {
            ArrayList<CoreMap> nextLevel = Generics.newArrayList();
            for (CoreMap quote : level) {
                quote.set(CoreAnnotations.QuotationIndexAnnotation.class, index);
                List quoteTokens = (List)quote.get(CoreAnnotations.TokensAnnotation.class);
                if (quoteTokens != null) {
                    for (CoreLabel qt : quoteTokens) {
                        qt.set(CoreAnnotations.QuotationIndexAnnotation.class, index);
                    }
                }
                ++index;
                List key = (List)quote.get(CoreAnnotations.QuotationsAnnotation.class);
                if (unclosed) {
                    key = (List)quote.get(CoreAnnotations.UnclosedQuotationsAnnotation.class);
                }
                if (key == null) continue;
                if (!unclosed) {
                    nextLevel.addAll((Collection)quote.get(CoreAnnotations.QuotationsAnnotation.class));
                    continue;
                }
                nextLevel.addAll((Collection)quote.get(CoreAnnotations.UnclosedQuotationsAnnotation.class));
            }
            level = nextLevel;
        }
    }

    public static Annotation makeQuote(String surfaceForm, int begin, int end, List<CoreLabel> quoteTokens, int tokenOffset, int sentenceBeginIndex, int sentenceEndIndex, String docID) {
        Annotation quote = new Annotation(surfaceForm);
        quote.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
        quote.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
        if (docID != null) {
            quote.set(CoreAnnotations.DocIDAnnotation.class, docID);
        }
        if (quoteTokens != null) {
            quote.set(CoreAnnotations.TokensAnnotation.class, quoteTokens);
            quote.set(CoreAnnotations.TokenBeginAnnotation.class, tokenOffset);
            quote.set(CoreAnnotations.TokenEndAnnotation.class, tokenOffset + quoteTokens.size() - 1);
        }
        quote.set(CoreAnnotations.SentenceBeginAnnotation.class, sentenceBeginIndex);
        quote.set(CoreAnnotations.SentenceEndAnnotation.class, sentenceEndIndex);
        return quote;
    }

    public Pair<List<Pair<Integer, Integer>>, List<Pair<Integer, Integer>>> getQuotes(String text) {
        return this.recursiveQuotes(text, 0, null);
    }

    public Pair<List<Pair<Integer, Integer>>, List<Pair<Integer, Integer>>> recursiveQuotes(String text, int offset, String prevQuote) {
        HashMap<String, List<Pair<Integer, Integer>>> quotesMap = new HashMap<String, List<Pair<Integer, Integer>>>();
        int start = -1;
        int end = -1;
        String quote = null;
        int directed = 0;
        for (int i = 0; i < text.length(); ++i) {
            String c = text.substring(i, i + 1);
            if (c.equals("`") && i < text.length() - 1 && text.charAt(i + 1) == '`') {
                c = c + text.charAt(i + 1);
            } else if (c.equals("'") && quote != null && (quote.equals("``") || quote.equals("`"))) {
                int curr;
                for (curr = i; curr < text.length() && text.charAt(curr) == '\''; ++curr) {
                }
                if (i != curr - quote.length() && (directed <= 0 || i != curr - directed * quote.length())) continue;
                for (int a = i + 1; a < i + quote.length(); ++a) {
                    c = c + text.charAt(a);
                }
            }
            if (DIRECTED_QUOTES.containsKey(quote) && DIRECTED_QUOTES.get(quote).equals(c)) {
                if (c.equals("\u2019")) {
                    if (i == text.length() - 1 || QuoteAnnotator.isSingleQuoteEnd(text, i)) {
                        --directed;
                    }
                } else {
                    --directed;
                }
            }
            if (start < 0 && !QuoteAnnotator.matchesPrevQuote(c, prevQuote) && ((this.isSingleQuoteWithUse(c) || c.equals("`")) && QuoteAnnotator.isSingleQuoteStart(text, i) || c.equals("\"") || DIRECTED_QUOTES.containsKey(c))) {
                start = i;
                quote = c;
            } else if (start >= 0 && end < 0 && (c.equals(quote) && ((c.equals("'") || c.equals("`")) && QuoteAnnotator.isSingleQuoteEnd(text, i) || c.equals("\"") && QuoteAnnotator.isDoubleQuoteEnd(text, i)) || c.equals("'") && quote.equals("`") && QuoteAnnotator.isSingleQuoteEnd(text, i) || DIRECTED_QUOTES.containsKey(quote) && DIRECTED_QUOTES.get(quote).equals(c) && directed == 0)) {
                end = i + c.length();
            }
            if (DIRECTED_QUOTES.containsKey(c) && c.equals(quote)) {
                ++directed;
            }
            if (start >= 0 && end > 0) {
                if (!quotesMap.containsKey(quote)) {
                    quotesMap.put(quote, new ArrayList());
                }
                ((List)quotesMap.get(quote)).add(new Pair<Integer, Integer>(start, end));
                start = -1;
                end = -1;
                quote = null;
            }
            if (c.length() > 1) {
                i += c.length() - 1;
            }
            if (this.MAX_LENGTH <= 0 || start < 0 || i - start <= this.MAX_LENGTH) continue;
            i = start + quote.length();
            start = -1;
            end = -1;
            quote = null;
        }
        if (start >= 0 && start < text.length() - 3) {
            String warning = text;
            if (text.length() > 150) {
                warning = text.substring(0, 150) + "...";
            }
            log.info("WARNING: unmatched quote of type " + quote + " found at index " + start + " in text segment: " + warning);
        }
        ArrayList<Pair<Integer, Integer>> quotes = Generics.newArrayList();
        ArrayList<Pair<Integer, Integer>> unclosedQuotes = Generics.newArrayList();
        if (!QuoteAnnotator.isAQuoteMapStarter(start, quotesMap) && start >= 0 && start < text.length() - 3) {
            if (this.EXTRACT_UNCLOSED) {
                unclosedQuotes.add(new Pair<Integer, Integer>(start, text.length()));
            }
            String toPass = text.substring(start + quote.length());
            Pair<List<Pair<Integer, Integer>>, List<Pair<Integer, Integer>>> embedded = this.recursiveQuotes(toPass, offset, null);
            for (Pair pair : embedded.first()) {
                quotes.add(new Pair<Integer, Integer>((Integer)pair.first() + start + quote.length(), (Integer)pair.second() + start + quote.length()));
            }
            if (this.EXTRACT_UNCLOSED) {
                for (Pair pair : embedded.second()) {
                    unclosedQuotes.add(new Pair<Integer, Integer>((Integer)pair.first() + start + quote.length(), (Integer)pair.second() + start + quote.length()));
                }
            }
        }
        for (String qKind : quotesMap.keySet()) {
            for (Pair pair : (List)quotesMap.get(qKind)) {
                if ((Integer)pair.second() - (Integer)pair.first() >= qKind.length() * 2) {
                    String toPass = text.substring((Integer)pair.first() + qKind.length(), (Integer)pair.second() - qKind.length());
                    String qKindToPass = null;
                    if (!DIRECTED_QUOTES.containsKey(qKind) && !qKind.equals("`") || !this.ALLOW_EMBEDDED_SAME) {
                        qKindToPass = qKind;
                    }
                    Pair<List<Pair<Integer, Integer>>, List<Pair<Integer, Integer>>> embedded = this.recursiveQuotes(toPass, (Integer)pair.first() + qKind.length() + offset, qKindToPass);
                    for (Pair<Integer, Integer> e : embedded.first()) {
                        if (e.second() - e.first() <= 2) continue;
                        quotes.add(new Pair<Integer, Integer>(e.first(), e.second()));
                    }
                    if (this.EXTRACT_UNCLOSED) {
                        for (Pair<Integer, Integer> e : embedded.second()) {
                            unclosedQuotes.add(new Pair<Integer, Integer>(e.first(), e.second()));
                        }
                    }
                }
                quotes.add(new Pair<Integer, Integer>((Integer)pair.first() + offset, (Integer)pair.second() + offset));
            }
        }
        return new Pair<List<Pair<Integer, Integer>>, List<Pair<Integer, Integer>>>(quotes, unclosedQuotes);
    }

    private static boolean isAQuoteMapStarter(int target, Map<String, List<Pair<Integer, Integer>>> quotesMap) {
        for (String k : quotesMap.keySet()) {
            for (Pair<Integer, Integer> pair : quotesMap.get(k)) {
                if (pair.first() != target) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSingleQuoteWithUse(String c) {
        return c.equals("'") && this.USE_SINGLE;
    }

    private static boolean matchesPrevQuote(String c, String prev) {
        return prev != null && prev.equals(c);
    }

    private static boolean isSingleQuoteStart(String text, int i) {
        if (i == 0) {
            return true;
        }
        String prev = text.substring(i - 1, i);
        return QuoteAnnotator.isWhitespaceOrPunct(prev);
    }

    private static boolean isSingleQuoteEnd(String text, int i) {
        if (i == text.length() - 1) {
            return true;
        }
        String next = text.substring(i + 1, i + 2);
        return QuoteAnnotator.isWhitespaceOrPunct(next);
    }

    private static boolean isDoubleQuoteEnd(String text, int i) {
        if (i == text.length() - 1) {
            return true;
        }
        String next = text.substring(i + 1, i + 2);
        if (i == text.length() - 2) {
            return QuoteAnnotator.isWhitespaceOrPunct(next);
        }
        String nextNext = text.substring(i + 2, i + 3);
        return QuoteAnnotator.isWhitespaceOrPunct(next) && !QuoteAnnotator.isSingleQuote(next) || QuoteAnnotator.isSingleQuote(next) && QuoteAnnotator.isWhitespaceOrPunct(nextNext);
    }

    public static boolean isWhitespaceOrPunct(String c) {
        Pattern punctOrWhite = Pattern.compile("[\\s\\p{Punct}]", 256);
        Matcher m = punctOrWhite.matcher(c);
        return m.matches();
    }

    public static boolean isSingleQuote(String c) {
        return c.equals("'");
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        HashSet<Class<? extends CoreAnnotation>> baseRequirements = new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.IsNewlineAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class));
        if (this.ATTRIBUTE_QUOTES) {
            HashSet<Class> attributionRequirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.MentionsAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CorefCoreAnnotations.CorefChainAnnotation.class, CoreAnnotations.MentionsAnnotation.class, CoreAnnotations.EntityMentionIndexAnnotation.class, CoreAnnotations.CanonicalEntityMentionIndexAnnotation.class));
            baseRequirements.addAll(attributionRequirements);
        }
        return baseRequirements;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        if (this.ATTRIBUTE_QUOTES) {
            return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.QuotationsAnnotation.class, CoreAnnotations.QuotationIndexAnnotation.class, QuoteAttributionAnnotator.MentionAnnotation.class, QuoteAttributionAnnotator.MentionBeginAnnotation.class, QuoteAttributionAnnotator.MentionEndAnnotation.class, QuoteAttributionAnnotator.MentionTypeAnnotation.class, QuoteAttributionAnnotator.MentionSieveAnnotation.class, QuoteAttributionAnnotator.SpeakerAnnotation.class, QuoteAttributionAnnotator.SpeakerSieveAnnotation.class, CoreAnnotations.ParagraphIndexAnnotation.class));
        }
        return Collections.singleton(CoreAnnotations.QuotationsAnnotation.class);
    }

    public static List<CoreMap> gatherQuotes(CoreMap curr) {
        List embedded = (List)curr.get(CoreAnnotations.QuotationsAnnotation.class);
        if (embedded != null) {
            ArrayList<CoreMap> extended = Generics.newArrayList();
            for (CoreMap quote : embedded) {
                extended.addAll(QuoteAnnotator.gatherQuotes(quote));
            }
            extended.addAll(embedded);
            extended.sort(Comparator.comparingInt(cm -> (Integer)cm.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
            return extended;
        }
        return Generics.newArrayList();
    }

    static {
        Map<String, String> tmp = Generics.newHashMap();
        tmp.put("\u201c", "\u201d");
        tmp.put("\u2018", "\u2019");
        tmp.put("\u00ab", "\u00bb");
        tmp.put("\u2039", "\u203a");
        tmp.put("\u300c", "\u300d");
        tmp.put("\u300e", "\u300f");
        tmp.put("\u201e", "\u201d");
        tmp.put("\u201a", "\u2019");
        tmp.put("``", "''");
        DIRECTED_QUOTES = Collections.unmodifiableMap(tmp);
    }
}

