/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.LanguageInfo;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.semgrex.ProcessSemgrexRequest;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class StanfordCoreNLPServer
implements Runnable {
    protected HttpServer server;
    @ArgumentParser.Option(name="server_id", gloss="a name for this server")
    protected String serverID;
    @ArgumentParser.Option(name="port", gloss="The port to run the server on")
    protected int serverPort;
    @ArgumentParser.Option(name="status_port", gloss="The port to serve the status check endpoints on. If different from the server port, this will run in a separate thread.")
    protected int statusPort;
    @ArgumentParser.Option(name="uriContext", gloss="The URI context")
    protected String uriContext;
    @ArgumentParser.Option(name="timeout", gloss="The default timeout, in milliseconds")
    protected int timeoutMilliseconds;
    @ArgumentParser.Option(name="strict", gloss="If true, obey strict HTTP standards (e.g., with encoding)")
    protected boolean strict;
    @ArgumentParser.Option(name="quiet", gloss="If true, don't print to stdout and don't log every API POST")
    protected boolean quiet;
    @ArgumentParser.Option(name="ssl", gloss="If true, start the server with an [insecure!] SSL connection")
    protected boolean ssl;
    @ArgumentParser.Option(name="key", gloss="The *.jks key file to load, if -ssl is enabled. By default, it'll load the dummy key from the jar (but this is, of course, insecure!)")
    protected static String key = "edu/stanford/nlp/pipeline/corenlp.jks";
    @ArgumentParser.Option(name="username", gloss="The username component of a username/password basic auth credential")
    protected String username;
    @ArgumentParser.Option(name="password", gloss="The password component of a username/password basic auth credential")
    protected String password;
    @ArgumentParser.Option(name="preload", gloss="Cache all default annotators (if no list provided), or optionally provide comma separated list of annotators to preload (e.g. tokenize,ssplit,pos)")
    protected static String preloadedAnnotators = null;
    @ArgumentParser.Option(name="serverProperties", gloss="Default properties file for server's StanfordCoreNLP instance")
    protected static String serverPropertiesPath = null;
    @ArgumentParser.Option(name="maxCharLength", gloss="Max length string that will be processed (non-positive means no limit)")
    protected static int maxCharLength = 100000;
    @ArgumentParser.Option(name="blockList", gloss="A file containing subnets that should be forbidden from accessing the server. Each line is a subnet. They are specified as an IPv4 address followed by a slash followed by how many leading bits to maintain as the subnet mask. E.g., '54.240.225.0/24'.")
    protected static String blockList = null;
    @ArgumentParser.Option(name="stanford", gloss="If true, do special options (domain blockList, timeout modifications) for public Stanford server")
    protected boolean stanford;
    private static final List<String> serverSpecificProperties = ArgumentParser.listOptions(StanfordCoreNLPServer.class);
    private final String shutdownKey;
    private final Properties serverIOProps;
    private final Properties defaultProps;
    private final ExecutorService serverExecutor;
    private SoftReference<Pair<String, StanfordCoreNLP>> lastPipeline;
    private final ExecutorService corenlpExecutor;
    private final List<Pair<Inet4Address, Integer>> blockListSubnets;
    static final String URL_ENCODED = "application/x-www-form-urlencoded";

    public StanfordCoreNLPServer(Properties props, int port, int timeout, boolean strict) throws IOException {
        this(props);
        this.serverPort = port;
        if (props != null && !props.containsKey("status_port")) {
            this.statusPort = port;
        }
        this.timeoutMilliseconds = timeout;
        this.strict = strict;
    }

    public StanfordCoreNLPServer(int port, int timeout, boolean strict) throws IOException {
        this(null, port, timeout, strict);
    }

    public StanfordCoreNLPServer() throws IOException {
        this(null);
    }

    public StanfordCoreNLPServer(Properties props) throws IOException {
        this.statusPort = this.serverPort = 9000;
        this.uriContext = "";
        this.timeoutMilliseconds = 15000;
        this.strict = false;
        this.quiet = false;
        this.ssl = false;
        this.username = null;
        this.password = null;
        this.stanford = false;
        this.lastPipeline = new SoftReference<Object>(null);
        this.serverIOProps = new Properties();
        this.serverIOProps.setProperty("inputFormat", "text");
        this.serverIOProps.setProperty("outputFormat", "json");
        this.serverIOProps.setProperty("prettyPrint", "false");
        this.defaultProps = new Properties();
        this.defaultProps.putAll((Map<?, ?>)this.serverIOProps);
        if (serverPropertiesPath != null) {
            this.defaultProps.putAll((Map<?, ?>)StringUtils.argsToProperties("-props", serverPropertiesPath));
        }
        Properties pipelinePropsFromCL = new Properties();
        if (props != null) {
            for (String key : props.stringPropertyNames()) {
                if (serverSpecificProperties.contains(key)) continue;
                pipelinePropsFromCL.setProperty(key, props.getProperty(key));
            }
        }
        PropertiesUtils.overWriteProperties(this.defaultProps, pipelinePropsFromCL);
        TreeSet<String> defaultPropertyKeys = new TreeSet<String>(this.defaultProps.stringPropertyNames());
        Redwood.Util.log("Server default properties:\n\t\t\t(Note: unspecified annotator properties are English defaults)\n" + String.join((CharSequence)"\n", defaultPropertyKeys.stream().map(k -> String.format("\t\t\t%s = %s", k, this.defaultProps.get(k))).collect(Collectors.toList())));
        this.serverExecutor = Executors.newFixedThreadPool(ArgumentParser.threads);
        this.corenlpExecutor = Executors.newFixedThreadPool(ArgumentParser.threads);
        String shutdownKeyFileName = props != null && props.getProperty("server_id") != null ? "corenlp.shutdown." + props.getProperty("server_id") : "corenlp.shutdown";
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFile = new File(tmpDir + File.separator + shutdownKeyFileName);
        tmpFile.deleteOnExit();
        if (tmpFile.exists() && !tmpFile.delete()) {
            throw new IllegalStateException("Could not delete shutdown key file");
        }
        this.shutdownKey = new BigInteger(130, new Random()).toString(32);
        IOUtils.writeStringToFile(this.shutdownKey, tmpFile.getPath(), "utf-8");
        if (props != null && props.containsKey("status_port")) {
            this.statusPort = Integer.parseInt(props.getProperty("status_port"));
        } else if (props != null && props.containsKey("port")) {
            this.statusPort = Integer.parseInt(props.getProperty("port"));
        }
        if (blockList == null) {
            this.blockListSubnets = Collections.emptyList();
        } else {
            this.blockListSubnets = new ArrayList<Pair<Inet4Address, Integer>>();
            for (String subnet : IOUtils.readLines(blockList)) {
                try {
                    this.blockListSubnets.add(StanfordCoreNLPServer.parseSubnet(subnet));
                }
                catch (IllegalArgumentException e) {
                    Redwood.Util.warn("Could not parse subnet: " + subnet);
                }
            }
        }
    }

    private static Map<String, String> getURLParams(URI uri) throws UnsupportedEncodingException {
        String query = uri.getRawQuery();
        if (query != null) {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                for (String param : query.split("&")) {
                    String value;
                    String[] keyValue = param.split("=", 2);
                    String key = URLDecoder.decode(keyValue[0], "UTF-8");
                    String string = value = keyValue.length > 1 ? URLDecoder.decode(keyValue[1], "UTF-8") : "";
                    if (key.isEmpty()) continue;
                    params.put(key, value);
                }
                return params;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return Collections.emptyMap();
    }

    private Annotation getDocument(Properties props, HttpExchange httpExchange) throws IOException, ClassNotFoundException {
        String inputFormat = props.getProperty("inputFormat", "text");
        String date = props.getProperty("date");
        switch (inputFormat) {
            case "text": {
                String encoding;
                String defaultEncoding = this.strict ? "ISO-8859-1" : "UTF-8";
                Headers headers = httpExchange.getRequestHeaders();
                String contentType = URL_ENCODED;
                if (headers.containsKey("Content-type")) {
                    contentType = headers.getFirst("Content-type").split(";")[0].trim();
                    String[] charsetPair = Arrays.stream(headers.getFirst("Content-type").split(";")).map(x -> x.split("=")).filter(x -> ((String[])x).length > 0 && "charset".equals(x[0])).findFirst().orElse(new String[]{"charset", defaultEncoding});
                    encoding = charsetPair.length == 2 ? charsetPair[1] : defaultEncoding;
                } else {
                    encoding = defaultEncoding;
                }
                String text = IOUtils.slurpReader(IOUtils.encodedInputStreamReader(httpExchange.getRequestBody(), encoding));
                if (contentType.equals(URL_ENCODED)) {
                    try {
                        text = URLDecoder.decode(text, encoding);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                Annotation annotation = new Annotation(text);
                if (date != null) {
                    annotation.set(CoreAnnotations.DocDateAnnotation.class, date);
                }
                return annotation;
            }
            case "serialized": {
                String inputSerializerName = props.getProperty("inputSerializer", ProtobufAnnotationSerializer.class.getName());
                AnnotationSerializer serializer = (AnnotationSerializer)MetaClass.create(inputSerializerName).createInstance(new Object[0]);
                Pair<Annotation, InputStream> pair = serializer.read(httpExchange.getRequestBody());
                return (Annotation)pair.first;
            }
        }
        throw new IOException("Could not parse input format: " + inputFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StanfordCoreNLP mkStanfordCoreNLP(Properties props) {
        StanfordCoreNLP impl;
        StringBuilder sb = new StringBuilder();
        props.stringPropertyNames().stream().filter(key -> !key.equalsIgnoreCase("date")).forEach(key -> {
            String pvalue = props.getProperty((String)key);
            sb.append((String)key).append(':').append(pvalue).append(';');
        });
        String cacheKey = sb.toString();
        StanfordCoreNLPServer stanfordCoreNLPServer = this;
        synchronized (stanfordCoreNLPServer) {
            Pair<String, StanfordCoreNLP> lastPipeline = this.lastPipeline.get();
            if (lastPipeline != null && Objects.equals(lastPipeline.first, cacheKey)) {
                return (StanfordCoreNLP)lastPipeline.second;
            }
            Iterator<Map.Entry<StanfordCoreNLP.AnnotatorSignature, Lazy<Annotator>>> iter = StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<StanfordCoreNLP.AnnotatorSignature, Lazy<Annotator>> entry = iter.next();
                if (!entry.getValue().isCache()) {
                    Redwood.Util.error("Entry in global cache is not garbage collectable!");
                    iter.remove();
                    continue;
                }
                if (!entry.getValue().isGarbageCollected()) continue;
                iter.remove();
            }
            impl = new StanfordCoreNLP(props);
            this.lastPipeline = new SoftReference<Pair<String, StanfordCoreNLP>>(Pair.makePair(cacheKey, impl));
        }
        return impl;
    }

    private Properties getProperties(HttpExchange httpExchange) throws UnsupportedEncodingException {
        Map<String, String> urlParams = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
        Properties props = new Properties();
        if (!urlParams.getOrDefault("resetDefault", "false").toLowerCase().equals("true")) {
            this.defaultProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key1, value) -> props.setProperty(key1.toString(), value.toString())));
        } else {
            for (String ioKey : this.serverIOProps.stringPropertyNames()) {
                props.setProperty(ioKey, this.defaultProps.getProperty(ioKey));
            }
        }
        urlParams.entrySet().stream().filter(entry -> !"properties".equalsIgnoreCase((String)entry.getKey()) && !"props".equalsIgnoreCase((String)entry.getKey())).forEach(entry -> props.setProperty((String)entry.getKey(), (String)entry.getValue()));
        Map<Object, Object> urlProperties = new HashMap();
        if (urlParams.containsKey("properties")) {
            urlProperties = StringUtils.decodeMap(URLDecoder.decode(urlParams.get("properties"), "UTF-8"));
        } else if (urlParams.containsKey("props")) {
            urlProperties = StringUtils.decodeMap(URLDecoder.decode(urlParams.get("props"), "UTF-8"));
        }
        String language = urlParams.getOrDefault("pipelineLanguage", urlProperties.getOrDefault("pipelineLanguage", "default"));
        if (language != null && !"default".equals(language)) {
            String languagePropertiesFile = LanguageInfo.getLanguagePropertiesFile(language);
            if (languagePropertiesFile != null) {
                try (BufferedReader is = IOUtils.readerFromString(languagePropertiesFile);){
                    Properties languageSpecificProperties = new Properties();
                    languageSpecificProperties.load(is);
                    PropertiesUtils.overWriteProperties(props, languageSpecificProperties);
                    if (!LanguageInfo.getLanguageFromString(language).equals((Object)LanguageInfo.HumanLanguage.ENGLISH)) {
                        props.setProperty("enforceRequirements", "false");
                    }
                }
                catch (IOException e) {
                    Redwood.Util.err("Failure to load language specific properties: " + languagePropertiesFile + " for " + language);
                }
            } else {
                try {
                    StanfordCoreNLPServer.respondError("Invalid language: '" + language + '\'', httpExchange);
                }
                catch (IOException e) {
                    Redwood.Util.warn(e);
                }
                return new Properties();
            }
        }
        if (!props.containsKey("mention.type")) {
            props.setProperty("mention.type", "dep");
            if (urlProperties.containsKey("annotators") && urlProperties.get("annotators") != null && ArrayUtils.contains(((String)urlProperties.get("annotators")).split(","), "parse")) {
                props.remove("mention.type");
            }
        }
        urlProperties.forEach(props::setProperty);
        StanfordCoreNLP.normalizeAnnotators(props);
        String annotators = props.getProperty("annotators");
        if (annotators != null && !PropertiesUtils.hasPropertyPrefix(props, "customAnnotatorClass.") && PropertiesUtils.getBool(props, "enforceRequirements", true)) {
            annotators = StanfordCoreNLP.ensurePrerequisiteAnnotators(props.getProperty("annotators").split("[, \t]+"), props);
        }
        if (annotators != null) {
            props.setProperty("annotators", annotators);
        }
        return props;
    }

    private static void respondError(String response, HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Content-type", "text/plain");
        httpExchange.sendResponseHeaders(500, response.length());
        httpExchange.getResponseBody().write(response.getBytes());
        httpExchange.close();
    }

    private static void respondBadInput(String response, HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Content-type", "text/plain");
        httpExchange.sendResponseHeaders(400, response.length());
        httpExchange.getResponseBody().write(response.getBytes());
        httpExchange.close();
    }

    private static void respondUnauthorized(HttpExchange httpExchange) throws IOException {
        Redwood.Util.log("Responding unauthorized to " + httpExchange.getRemoteAddress());
        httpExchange.getResponseHeaders().add("Content-type", "application/javascript");
        byte[] content = "{\"message\": \"Unauthorized API request\"}".getBytes(StandardCharsets.UTF_8);
        httpExchange.sendResponseHeaders(401, content.length);
        httpExchange.getResponseBody().write(content);
        httpExchange.close();
    }

    private static void setHttpExchangeResponseHeaders(HttpExchange httpExchange) {
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "GET,POST,PUT,DELETE,OPTIONS");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Headers", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Credentials", "true");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Credentials-Header", "*");
    }

    private static Pair<Inet4Address, Integer> parseSubnet(String subnet) {
        String[] parts = subnet.split("/");
        String ip = parts[0];
        int prefix = parts.length < 2 ? 0 : Integer.parseInt(parts[1]);
        try {
            return Pair.makePair((Inet4Address)InetAddress.getByName(ip), prefix);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid subnet: " + subnet);
        }
    }

    private static boolean netMatch(Pair<Inet4Address, Integer> subnet, Inet4Address addr) {
        byte[] b = ((Inet4Address)subnet.first).getAddress();
        int ipInt = (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | (b[3] & 0xFF) << 0;
        byte[] b1 = addr.getAddress();
        int ipInt1 = (b1[0] & 0xFF) << 24 | (b1[1] & 0xFF) << 16 | (b1[2] & 0xFF) << 8 | (b1[3] & 0xFF) << 0;
        int mask = ~((1 << 32 - (Integer)subnet.second) - 1);
        return (ipInt & mask) == (ipInt1 & mask);
    }

    private boolean onBlockList(Inet4Address addr) {
        for (Pair<Inet4Address, Integer> subnet : this.blockListSubnets) {
            if (!StanfordCoreNLPServer.netMatch(subnet, addr)) continue;
            return true;
        }
        return false;
    }

    private boolean onBlockList(HttpExchange exchange) {
        if (!this.stanford) {
            return false;
        }
        InetAddress addr = exchange.getRemoteAddress().getAddress();
        if (addr instanceof Inet4Address) {
            return this.onBlockList((Inet4Address)addr);
        }
        Redwood.Util.log("Not checking IPv6 address against blockList: " + addr);
        return false;
    }

    private int maybeAlterStanfordTimeout(HttpExchange httpExchange, int timeoutMilliseconds) {
        if (!this.stanford) {
            return timeoutMilliseconds;
        }
        try {
            if (timeoutMilliseconds > 15000 && "corenlp.stanford.edu".equals(InetAddress.getLocalHost().getHostName()) && !httpExchange.getRemoteAddress().getHostName().toLowerCase().endsWith("stanford.edu")) {
                timeoutMilliseconds = 15000;
            }
            return timeoutMilliseconds;
        }
        catch (UnknownHostException uhe) {
            return timeoutMilliseconds;
        }
    }

    protected int getTimeout(Properties props, HttpExchange httpExchange) {
        int timeoutMilliseconds;
        try {
            timeoutMilliseconds = Integer.parseInt(props.getProperty("timeout", Integer.toString(this.timeoutMilliseconds)));
            timeoutMilliseconds = this.maybeAlterStanfordTimeout(httpExchange, timeoutMilliseconds);
        }
        catch (NumberFormatException e) {
            timeoutMilliseconds = this.timeoutMilliseconds;
        }
        return timeoutMilliseconds;
    }

    private static void sendAndGetResponse(HttpExchange httpExchange, byte[] response) throws IOException {
        if (response.length > 0) {
            httpExchange.getResponseHeaders().add("Content-type", "application/json");
            httpExchange.getResponseHeaders().add("Content-length", Integer.toString(response.length));
            httpExchange.sendResponseHeaders(200, response.length);
            httpExchange.getResponseBody().write(response);
            httpExchange.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpsServer addSSLContext(HttpsServer server) {
        Redwood.Util.log("Adding SSL context to server; key=" + key);
        try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(key);){
            KeyStore ks = KeyStore.getInstance("JKS");
            if (key == null) throw new IllegalArgumentException("Could not find SSL keystore at " + key);
            if (!IOUtils.existsInClasspathOrFileSystem(key)) throw new IllegalArgumentException("Could not find SSL keystore at " + key);
            ks.load(is, "corenlp".toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, "corenlp".toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), null, null);
            server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                @Override
                public void configure(HttpsParameters params) {
                    SSLContext context = this.getSSLContext();
                    SSLEngine engine = context.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    params.setSSLParameters(context.getDefaultSSLParameters());
                }
            });
            HttpsServer httpsServer = server;
            return httpsServer;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private void livenessServer(AtomicBoolean live) {
        if (this.serverPort != this.statusPort) {
            try {
                this.server = this.ssl ? StanfordCoreNLPServer.addSSLContext(HttpsServer.create(new InetSocketAddress(this.statusPort), 0)) : HttpServer.create(new InetSocketAddress(this.statusPort), 0);
                StanfordCoreNLPServer.withAuth(this.server.createContext("/live", new LiveHandler()), Optional.empty());
                StanfordCoreNLPServer.withAuth(this.server.createContext("/ready", new ReadyHandler(live)), Optional.empty());
                this.server.start();
                Redwood.Util.log("Liveness server started at " + this.server.getAddress());
            }
            catch (IOException e) {
                Redwood.Util.err("Could not start liveness server. This will probably result in very bad things happening soon.", e);
            }
        }
    }

    public Optional<HttpServer> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    public void run() {
        try {
            AtomicBoolean live = new AtomicBoolean(false);
            this.livenessServer(live);
            FileHandler homepage = new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.html");
            this.run(Optional.empty(), req -> true, obj -> {}, homepage, false, live);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static void withAuth(HttpContext context, Optional<Pair<String, String>> credentials) {
        credentials.ifPresent(c -> context.setAuthenticator(new BasicAuthenticator("corenlp", (Pair)c){
            final /* synthetic */ Pair val$c;
            {
                this.val$c = pair;
                super(x0);
            }

            @Override
            public boolean checkCredentials(String user, String pwd) {
                return user.equals(this.val$c.first) && pwd.equals(this.val$c.second);
            }
        }));
    }

    public void run(Optional<Pair<String, String>> basicAuth, Predicate<Properties> authenticator, Consumer<FinishedRequest> callback, FileHandler homepage, boolean https, AtomicBoolean live) {
        try {
            this.server = https ? StanfordCoreNLPServer.addSSLContext(HttpsServer.create(new InetSocketAddress(this.serverPort), 0)) : HttpServer.create(new InetSocketAddress(this.serverPort), 0);
            String contextRoot = this.uriContext;
            if (contextRoot.isEmpty()) {
                contextRoot = "/";
            }
            StanfordCoreNLPServer.withAuth(this.server.createContext(contextRoot, new CoreNLPHandler(this.defaultProps, authenticator, callback, homepage)), basicAuth);
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/tokensregex", new TokensRegexHandler(authenticator, callback)), basicAuth);
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/semgrex", new SemgrexHandler(authenticator, callback)), basicAuth);
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/tregex", new TregexHandler(authenticator, callback)), basicAuth);
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/corenlp-brat.js", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.js", "application/javascript")), basicAuth);
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/corenlp-brat.cs", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.css", "text/css")), basicAuth);
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/corenlp-parseviewer.js", new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-parseviewer.js", "application/javascript")), basicAuth);
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/ping", new PingHandler()), Optional.empty());
            StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/shutdown", new ShutdownHandler()), basicAuth);
            if (this.serverPort == this.statusPort) {
                StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/live", new LiveHandler()), Optional.empty());
                StanfordCoreNLPServer.withAuth(this.server.createContext(this.uriContext + "/ready", new ReadyHandler(live)), Optional.empty());
            }
            this.server.setExecutor(this.serverExecutor);
            this.server.start();
            live.set(true);
            Redwood.Util.log("StanfordCoreNLPServer listening at " + this.server.getAddress());
        }
        catch (IOException e) {
            Redwood.Util.warn(e);
        }
    }

    public static StanfordCoreNLPServer launchServer(String[] args) throws IOException {
        FileHandler homepage;
        Redwood.Util.log("--- " + StanfordCoreNLPServer.class.getSimpleName() + "#main() called ---");
        String build = System.getenv("BUILD");
        if (build != null) {
            Redwood.Util.log("    Build: " + build);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Redwood.Util.log("CoreNLP Server is shutting down.")));
        ArgumentParser.fillOptions(StanfordCoreNLPServer.class, args);
        Properties serverProperties = StringUtils.argsToProperties(args);
        StanfordCoreNLPServer server = new StanfordCoreNLPServer(serverProperties);
        ArgumentParser.fillOptions((Object)server, args);
        if (!serverProperties.containsKey("status_port") && serverProperties.containsKey("port")) {
            server.statusPort = Integer.parseInt(serverProperties.getProperty("port"));
        }
        Redwood.Util.log("Threads: " + ArgumentParser.threads);
        AtomicBoolean live = new AtomicBoolean(false);
        server.livenessServer(live);
        try {
            homepage = new FileHandler("edu/stanford/nlp/pipeline/demo/corenlp-brat.html");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        if (preloadedAnnotators != null) {
            String annotatorsToLoad;
            Properties props = new Properties();
            server.defaultProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key1, value) -> props.setProperty(key1.toString(), value.toString())));
            String string = annotatorsToLoad = preloadedAnnotators.trim().equals("true") ? server.defaultProps.getProperty("annotators") : preloadedAnnotators;
            if (annotatorsToLoad != null) {
                props.setProperty("annotators", annotatorsToLoad);
            }
            try {
                new StanfordCoreNLP(props);
            }
            catch (Throwable throwable) {
                Redwood.Util.err("Could not pre-load annotators in server; encountered exception:");
                Redwood.Util.err(throwable);
            }
        }
        Optional<Pair<String, String>> credentials = Optional.empty();
        if (server.username != null && server.password != null) {
            credentials = Optional.of(Pair.makePair(server.username, server.password));
        }
        Redwood.Util.log("Starting server...");
        server.run(credentials, req -> true, res -> {}, homepage, server.ssl, live);
        return server;
    }

    public static void main(String[] args) throws IOException {
        StanfordCoreNLPServer.launchServer(args);
    }

    protected class TregexHandler
    implements HttpHandler {
        private final Consumer<FinishedRequest> callback;
        private final Predicate<Properties> authenticator;

        public TregexHandler(Predicate<Properties> authenticator, Consumer<FinishedRequest> callback) {
            this.callback = callback;
            this.authenticator = authenticator;
        }

        public void setTregexOffsets(JSONOutputter.Writer writer, Tree match) {
            CoreLabel core;
            List leaves = match.getLeaves();
            Label label = ((Tree)leaves.get(0)).label();
            if (label instanceof CoreLabel) {
                core = (CoreLabel)label;
                writer.set("characterOffsetBegin", core.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class));
                if (core.containsKey(CoreAnnotations.CodepointOffsetBeginAnnotation.class)) {
                    writer.set("codepointOffsetBegin", core.get(CoreAnnotations.CodepointOffsetBeginAnnotation.class));
                }
            }
            if ((label = ((Tree)leaves.get(leaves.size() - 1)).label()) instanceof CoreLabel) {
                core = (CoreLabel)label;
                writer.set("characterOffsetEnd", core.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                if (core.containsKey(CoreAnnotations.CodepointOffsetEndAnnotation.class)) {
                    writer.set("codepointOffsetEnd", core.get(CoreAnnotations.CodepointOffsetEndAnnotation.class));
                }
            }
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            if (StanfordCoreNLPServer.this.onBlockList(httpExchange)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            StanfordCoreNLPServer.setHttpExchangeResponseHeaders(httpExchange);
            Properties props = StanfordCoreNLPServer.this.getProperties(httpExchange);
            if (this.authenticator != null && !this.authenticator.test(props)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            Map params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Future<Pair> response = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!params.containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return Pair.makePair("", null);
                    }
                    String rawPattern = (String)params.get("pattern");
                    TregexPattern pattern = TregexPattern.compile(rawPattern);
                    return Pair.makePair(JSONOutputter.JSONWriter.objectToJSON(docWriter -> docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                        int sentIndex = (Integer)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class);
                        Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                        if (tree == null) {
                            throw new IllegalStateException("Error: cannot process tregex operations with no constituency tree annotations.  Perhaps need to reinitialize the server with the parse annotator");
                        }
                        TregexMatcher matcher = pattern.matcher(tree);
                        int i = 0;
                        while (matcher.find()) {
                            sentWriter.set(Integer.toString(i++), matchWriter -> {
                                matchWriter.set("sentIndex", sentIndex);
                                this.setTregexOffsets((JSONOutputter.Writer)matchWriter, matcher.getMatch());
                                matchWriter.set("match", matcher.getMatch().pennString());
                                matchWriter.set("spanString", matcher.getMatch().spanString());
                                matchWriter.set("namedNodes", matcher.getNodeNames().stream().map(nodeName -> namedNodeWriter -> namedNodeWriter.set((String)nodeName, namedNodeSubWriter -> {
                                    this.setTregexOffsets((JSONOutputter.Writer)namedNodeSubWriter, matcher.getNode((String)nodeName));
                                    namedNodeSubWriter.set("match", matcher.getNode((String)nodeName).pennString());
                                    namedNodeSubWriter.set("spanString", matcher.getNode((String)nodeName).spanString());
                                })));
                            });
                        }
                    }))), doc);
                }
                catch (Exception e) {
                    Redwood.Util.warn(e);
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return Pair.makePair("", null);
                }
            });
            try {
                int timeout = StanfordCoreNLPServer.this.getTimeout(props, httpExchange);
                if (StanfordCoreNLPServer.this.lastPipeline.get() == null) {
                    timeout += 60000;
                }
                Pair pair = response.get(timeout, TimeUnit.MILLISECONDS);
                Annotation completedAnnotation = (Annotation)pair.second;
                byte[] content = ((String)pair.first).getBytes();
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, content);
                if (completedAnnotation != null && !StringUtils.isNullOrEmpty(props.getProperty("annotators"))) {
                    this.callback.accept(new FinishedRequest(props, completedAnnotation, (String)params.get("pattern"), null));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing Tregex query", httpExchange);
            }
        }
    }

    protected class SemgrexHandler
    implements HttpHandler {
        private final Consumer<FinishedRequest> callback;
        private final Predicate<Properties> authenticator;

        public SemgrexHandler(Predicate<Properties> authenticator, Consumer<FinishedRequest> callback) {
            this.callback = callback;
            this.authenticator = authenticator;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            if (StanfordCoreNLPServer.this.onBlockList(httpExchange)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            StanfordCoreNLPServer.setHttpExchangeResponseHeaders(httpExchange);
            Properties props = StanfordCoreNLPServer.this.getProperties(httpExchange);
            if (this.authenticator != null && !this.authenticator.test(props)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            Map params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Future<Pair> response = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!params.containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return Pair.makePair("".getBytes(), null);
                    }
                    String pattern = (String)params.get("pattern");
                    String filterStr = params.getOrDefault("filter", "false");
                    boolean filter = filterStr.trim().isEmpty() || "true".equalsIgnoreCase(filterStr.toLowerCase());
                    String uniqueStr = params.getOrDefault("unique", "false");
                    boolean unique = uniqueStr.trim().isEmpty() || "true".equalsIgnoreCase(uniqueStr.toLowerCase());
                    SemgrexPattern regex = SemgrexPattern.compile(pattern);
                    SemanticGraphCoreAnnotations.DependenciesType dependenciesType = SemanticGraphCoreAnnotations.DependenciesType.valueOf(params.getOrDefault("dependenciesType", "enhancedPlusPlus").toUpperCase(Locale.ROOT));
                    StanfordCoreNLP.OutputFormat of = StanfordCoreNLP.OutputFormat.valueOf(props.getProperty("outputFormat", "json").toUpperCase(Locale.ROOT));
                    switch (of) {
                        case JSON: {
                            String content = JSONOutputter.JSONWriter.objectToJSON(docWriter -> {
                                if (filter) {
                                    docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> regex.matcher((SemanticGraph)sentence.get(dependenciesType.annotation())).matches()).collect(Collectors.toList()));
                                } else {
                                    docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                                        SemgrexMatcher matcher = regex.matcher((SemanticGraph)sentence.get(dependenciesType.annotation()));
                                        int i = 0;
                                        while (unique ? matcher.findNextMatchingNode() : matcher.find()) {
                                            sentWriter.set(Integer.toString(i), matchWriter -> {
                                                IndexedWord match = matcher.getMatch();
                                                matchWriter.set("text", match.word());
                                                matchWriter.set("begin", match.index() - 1);
                                                matchWriter.set("end", match.index());
                                                for (String capture : matcher.getNodeNames()) {
                                                    matchWriter.set("$" + capture, groupWriter -> {
                                                        IndexedWord node = matcher.getNode(capture);
                                                        groupWriter.set("text", node.word());
                                                        groupWriter.set("begin", node.index() - 1);
                                                        groupWriter.set("end", node.index());
                                                    });
                                                }
                                            });
                                            ++i;
                                        }
                                        sentWriter.set("length", i);
                                    }));
                                }
                            });
                            return Pair.makePair(content.getBytes(), doc);
                        }
                        case SERIALIZED: {
                            if (filter) {
                                StanfordCoreNLPServer.respondBadInput("Interface semgrex does not support 'filter' for output format " + (Object)((Object)of), httpExchange);
                                return Pair.makePair("".getBytes(), null);
                            }
                            CoreNLPProtos.SemgrexResponse.Builder responseBuilder = CoreNLPProtos.SemgrexResponse.newBuilder();
                            int sentenceIdx = 0;
                            for (CoreMap sentence : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
                                SemanticGraph graph = (SemanticGraph)sentence.get(dependenciesType.annotation());
                                CoreNLPProtos.SemgrexResponse.GraphResult.Builder graphResultBuilder = CoreNLPProtos.SemgrexResponse.GraphResult.newBuilder();
                                graphResultBuilder.addResult(ProcessSemgrexRequest.matchSentence(regex, graph, 0, sentenceIdx));
                                responseBuilder.addResult(graphResultBuilder.build());
                                ++sentenceIdx;
                            }
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            responseBuilder.build().writeTo(os);
                            os.close();
                            return Pair.makePair(os.toByteArray(), doc);
                        }
                    }
                    StanfordCoreNLPServer.respondBadInput("Interface semgrex does not handle output format " + (Object)((Object)of), httpExchange);
                    return Pair.makePair("".getBytes(), null);
                }
                catch (Exception e) {
                    Redwood.Util.warn(e);
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return Pair.makePair("".getBytes(), null);
                }
            });
            try {
                int timeout = StanfordCoreNLPServer.this.getTimeout(props, httpExchange);
                if (StanfordCoreNLPServer.this.lastPipeline.get() == null) {
                    timeout += 60000;
                }
                Pair pair = response.get(timeout, TimeUnit.MILLISECONDS);
                Annotation completedAnnotation = (Annotation)pair.second;
                byte[] content = (byte[])pair.first;
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, content);
                if (completedAnnotation != null && !StringUtils.isNullOrEmpty(props.getProperty("annotators"))) {
                    this.callback.accept(new FinishedRequest(props, completedAnnotation, (String)params.get("pattern"), null));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing Semgrex query", httpExchange);
            }
        }
    }

    protected class TokensRegexHandler
    implements HttpHandler {
        private final Consumer<FinishedRequest> callback;
        private final Predicate<Properties> authenticator;

        public TokensRegexHandler(Predicate<Properties> authenticator, Consumer<FinishedRequest> callback) {
            this.callback = callback;
            this.authenticator = authenticator;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            if (StanfordCoreNLPServer.this.onBlockList(httpExchange)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            StanfordCoreNLPServer.setHttpExchangeResponseHeaders(httpExchange);
            Properties props = StanfordCoreNLPServer.this.getProperties(httpExchange);
            if (this.authenticator != null && !this.authenticator.test(props)) {
                StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                return;
            }
            Map params = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            Future<Pair> future = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                try {
                    Annotation doc = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    if (!doc.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                        StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                        pipeline.annotate(doc);
                    }
                    if (!params.containsKey("pattern")) {
                        StanfordCoreNLPServer.respondBadInput("Missing required parameter 'pattern'", httpExchange);
                        return new Pair<String, Object>("", null);
                    }
                    String pattern = (String)params.get("pattern");
                    String filterStr = params.getOrDefault("filter", "false");
                    boolean filter = filterStr.trim().isEmpty() || "true".equalsIgnoreCase(filterStr.toLowerCase());
                    TokenSequencePattern regex = TokenSequencePattern.compile(pattern);
                    return new Pair<String, Annotation>(JSONOutputter.JSONWriter.objectToJSON(docWriter -> {
                        if (filter) {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> regex.matcher((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).matches()).collect(Collectors.toList()));
                        } else {
                            docWriter.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> sentWriter -> {
                                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                                TokenSequenceMatcher matcher = regex.matcher(tokens);
                                int i = 0;
                                while (matcher.find()) {
                                    sentWriter.set(Integer.toString(i), matchWriter -> {
                                        matchWriter.set("text", matcher.group());
                                        matchWriter.set("begin", matcher.start());
                                        matchWriter.set("end", matcher.end());
                                        for (int groupI = 0; groupI < matcher.groupCount(); ++groupI) {
                                            SequenceMatchResult.MatchedGroupInfo info = matcher.groupInfo(groupI + 1);
                                            matchWriter.set(info.varName == null ? Integer.toString(groupI + 1) : info.varName, groupWriter -> {
                                                groupWriter.set("text", info.text);
                                                if (!info.nodes.isEmpty()) {
                                                    groupWriter.set("begin", (Integer)((CoreMap)info.nodes.get(0)).get(CoreAnnotations.IndexAnnotation.class) - 1);
                                                    groupWriter.set("end", ((CoreMap)info.nodes.get(info.nodes.size() - 1)).get(CoreAnnotations.IndexAnnotation.class));
                                                }
                                            });
                                        }
                                    });
                                    ++i;
                                }
                                sentWriter.set("length", i);
                            }));
                        }
                    }), doc);
                }
                catch (Exception e) {
                    Redwood.Util.warn(e);
                    try {
                        StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return new Pair<String, Object>("", null);
                }
            });
            try {
                int timeout = StanfordCoreNLPServer.this.getTimeout(props, httpExchange);
                if (StanfordCoreNLPServer.this.lastPipeline.get() == null) {
                    timeout += 60000;
                }
                Pair response = future.get(timeout, TimeUnit.MILLISECONDS);
                Annotation completedAnnotation = (Annotation)response.second;
                byte[] content = ((String)response.first).getBytes();
                StanfordCoreNLPServer.sendAndGetResponse(httpExchange, content);
                if (completedAnnotation != null && !StringUtils.isNullOrEmpty(props.getProperty("annotators"))) {
                    this.callback.accept(new FinishedRequest(props, completedAnnotation, (String)params.get("pattern"), null));
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                StanfordCoreNLPServer.respondError("Timeout when executing TokensRegex query", httpExchange);
            }
        }
    }

    protected class CoreNLPHandler
    implements HttpHandler {
        public final Properties defaultProps;
        private final Predicate<Properties> authenticator;
        private final Consumer<FinishedRequest> callback;
        private final FileHandler homepage;

        public CoreNLPHandler(Properties props, Predicate<Properties> authenticator, Consumer<FinishedRequest> callback, FileHandler homepage) {
            this.defaultProps = props;
            this.callback = callback;
            this.authenticator = authenticator;
            this.homepage = homepage;
        }

        public String getContentType(Properties props, StanfordCoreNLP.OutputFormat of) {
            switch (of) {
                case JSON: {
                    return "application/json";
                }
                case TEXT: 
                case CONLL: {
                    return "text/plain";
                }
                case XML: {
                    return "text/xml";
                }
                case SERIALIZED: {
                    String outputSerializerName = props.getProperty("outputSerializer");
                    if (outputSerializerName == null || !outputSerializerName.equals(ProtobufAnnotationSerializer.class.getName())) break;
                    return "application/x-protobuf";
                }
            }
            return "application/octet-stream";
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            block15: {
                StanfordCoreNLP.OutputFormat of;
                Annotation ann;
                Properties props;
                if (StanfordCoreNLPServer.this.onBlockList(httpExchange)) {
                    StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                    return;
                }
                StanfordCoreNLPServer.setHttpExchangeResponseHeaders(httpExchange);
                try {
                    props = StanfordCoreNLPServer.this.getProperties(httpExchange);
                    if ("GET".equalsIgnoreCase(httpExchange.getRequestMethod())) {
                        this.homepage.handle(httpExchange);
                        return;
                    }
                    if (httpExchange.getRequestMethod().equals("HEAD")) {
                        httpExchange.getRequestBody().close();
                        httpExchange.getResponseHeaders().add("Transfer-encoding", "chunked");
                        httpExchange.sendResponseHeaders(200, -1L);
                        httpExchange.close();
                        return;
                    }
                    if (this.authenticator != null && !this.authenticator.test(props)) {
                        StanfordCoreNLPServer.respondUnauthorized(httpExchange);
                        return;
                    }
                    if (!StanfordCoreNLPServer.this.quiet) {
                        Redwood.Util.log("[" + httpExchange.getRemoteAddress() + "] API call w/annotators " + props.getProperty("annotators", "<unknown>"));
                    }
                    ann = StanfordCoreNLPServer.this.getDocument(props, httpExchange);
                    of = StanfordCoreNLP.OutputFormat.valueOf(props.getProperty("outputFormat", "json").toUpperCase(Locale.ROOT));
                    String text = ((String)ann.get(CoreAnnotations.TextAnnotation.class)).replace('\n', ' ');
                    if (!StanfordCoreNLPServer.this.quiet) {
                        System.out.println(text);
                    }
                    if (maxCharLength > 0 && text.length() > maxCharLength) {
                        StanfordCoreNLPServer.respondBadInput("Request is too long to be handled by server: " + text.length() + " characters. Max length is " + maxCharLength + " characters.", httpExchange);
                        return;
                    }
                }
                catch (Exception e) {
                    Redwood.Util.warn(e);
                    StanfordCoreNLPServer.respondError("Could not handle incoming annotation", httpExchange);
                    return;
                }
                Future<Annotation> completedAnnotationFuture = null;
                try {
                    StanfordCoreNLP pipeline = StanfordCoreNLPServer.this.mkStanfordCoreNLP(props);
                    completedAnnotationFuture = StanfordCoreNLPServer.this.corenlpExecutor.submit(() -> {
                        pipeline.annotate(ann);
                        return ann;
                    });
                    int timeoutMilliseconds = StanfordCoreNLPServer.this.getTimeout(props, httpExchange);
                    Annotation completedAnnotation = completedAnnotationFuture.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
                    completedAnnotationFuture = null;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    AnnotationOutputter.Options options = AnnotationOutputter.getOptions(pipeline.getProperties());
                    StanfordCoreNLP.createOutputter(props, options).accept(completedAnnotation, os);
                    os.close();
                    byte[] response = os.toByteArray();
                    String contentType = this.getContentType(props, of);
                    if (contentType.equals("application/json") || contentType.startsWith("text/")) {
                        contentType = contentType + ";charset=" + options.encoding;
                    }
                    httpExchange.getResponseHeaders().add("Content-type", contentType);
                    httpExchange.getResponseHeaders().add("Content-length", Integer.toString(response.length));
                    httpExchange.sendResponseHeaders(200, response.length);
                    httpExchange.getResponseBody().write(response);
                    httpExchange.close();
                    if (completedAnnotation != null && !StringUtils.isNullOrEmpty(props.getProperty("annotators"))) {
                        this.callback.accept(new FinishedRequest(props, completedAnnotation));
                    }
                }
                catch (TimeoutException e) {
                    Redwood.Util.warn(e);
                    StanfordCoreNLPServer.respondError("CoreNLP request timed out. Your document may be too long.", httpExchange);
                    if (completedAnnotationFuture != null) {
                        completedAnnotationFuture.cancel(true);
                    }
                }
                catch (Exception e) {
                    Redwood.Util.warn(e);
                    StanfordCoreNLPServer.respondError(e.getClass().getName() + ": " + e.getMessage(), httpExchange);
                    if (completedAnnotationFuture == null) break block15;
                    completedAnnotationFuture.cancel(true);
                }
            }
        }
    }

    public static class FileHandler
    implements HttpHandler {
        private final String content;
        private final String contentType;

        public FileHandler(String fileOrClasspath) throws IOException {
            this(fileOrClasspath, "text/html");
        }

        public FileHandler(String fileOrClasspath, String contentType) throws IOException {
            try (BufferedReader r = IOUtils.readerFromString(fileOrClasspath, "utf-8");){
                this.content = IOUtils.slurpReader(r);
            }
            this.contentType = contentType + "; charset=utf-8";
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-type", this.contentType);
            ByteBuffer buffer = StandardCharsets.UTF_8.encode(this.content);
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            httpExchange.sendResponseHeaders(200, bytes.length);
            httpExchange.getResponseBody().write(bytes);
            httpExchange.close();
        }
    }

    protected class ShutdownHandler
    implements HttpHandler {
        protected ShutdownHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            Map urlParams = StanfordCoreNLPServer.getURLParams(httpExchange.getRequestURI());
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            boolean doExit = false;
            String response = "Invalid shutdown key\n";
            if (urlParams.containsKey("key") && ((String)urlParams.get("key")).equals(StanfordCoreNLPServer.this.shutdownKey)) {
                response = "Shutdown successful!\n";
                doExit = true;
            }
            httpExchange.sendResponseHeaders(200, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
            if (doExit) {
                System.exit(0);
            }
        }
    }

    protected static class LiveHandler
    implements HttpHandler {
        protected LiveHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            String response = "live\n";
            httpExchange.sendResponseHeaders(200, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
        }
    }

    protected static class ReadyHandler
    implements HttpHandler {
        public final AtomicBoolean serverReady;
        public final long startTime;

        public ReadyHandler(AtomicBoolean serverReady) {
            this.serverReady = serverReady;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            int status;
            String response;
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            if (this.serverReady.get()) {
                response = "ready\n";
                status = 200;
            } else {
                response = "server is not ready yet. uptime=" + Redwood.formatTimeDifference(System.currentTimeMillis() - this.startTime) + '\n';
                status = 503;
            }
            httpExchange.sendResponseHeaders(status, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
        }
    }

    protected static class PingHandler
    implements HttpHandler {
        protected PingHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            httpExchange.getResponseHeaders().set("Content-type", "text/plain");
            String response = "pong\n";
            httpExchange.sendResponseHeaders(200, response.getBytes().length);
            httpExchange.getResponseBody().write(response.getBytes());
            httpExchange.close();
        }
    }

    public static class FinishedRequest {
        public final Properties props;
        public final Annotation document;
        public final Optional<String> tokensregex;
        public final Optional<String> semgrex;

        public FinishedRequest(Properties props, Annotation document) {
            this.props = props;
            this.document = document;
            this.tokensregex = Optional.empty();
            this.semgrex = Optional.empty();
        }

        public FinishedRequest(Properties props, Annotation document, String tokensregex, String semgrex) {
            this.props = props;
            this.document = document;
            this.tokensregex = Optional.ofNullable(tokensregex);
            this.semgrex = Optional.ofNullable(semgrex);
        }
    }
}

