/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import java.util.regex.Pattern;

public class LexerUtils {
    private static final Pattern CENTS_PATTERN = Pattern.compile("\u00a2");
    private static final Pattern POUND_PATTERN = Pattern.compile("\u00a3");
    private static final Pattern GENERIC_CURRENCY_PATTERN = Pattern.compile("[\u0080\u00a4\u20a0\u20ac\u20b9]");
    private static final Pattern CP1252_EURO_PATTERN = Pattern.compile("\u0080");
    private static final Pattern ONE_FOURTH_PATTERN = Pattern.compile("\u00bc");
    private static final Pattern ONE_HALF_PATTERN = Pattern.compile("\u00bd");
    private static final Pattern THREE_FOURTHS_PATTERN = Pattern.compile("\u00be");
    private static final Pattern ONE_THIRD_PATTERN = Pattern.compile("\u2153");
    private static final Pattern TWO_THIRDS_PATTERN = Pattern.compile("\u2154");
    private static final Pattern SINGLE_SPACE_PATTERN = Pattern.compile("[ ]");
    private static final Pattern NON_WORD_REMOVE_CHARS = Pattern.compile("[\u00ad\u200c\u200d\u2060]");
    private static final String ptb3EllipsisStr = "...";
    private static final String unicodeEllipsisStr = "\u2026";
    private static final Pattern AMP_PATTERN = Pattern.compile("(?i:&amp;)");
    private static final Pattern singleQuote = Pattern.compile("&apos;|'");
    private static final Pattern doubleQuote = Pattern.compile("\"|''|'`|`'|&quot;");
    private static final Pattern asciiSingleQuote = Pattern.compile("&apos;|[\u0082\u008b\u0091\u00b4\u2018\u0092\u2019\u009b\u201a\u201b\u2039\u203a']");
    private static final Pattern asciiDoubleQuote = Pattern.compile("&quot;|[\u0084\u0093\u201c\u0094\u201d\u201e\u00ab\u00bb\"]");
    private static final Pattern leftSingleQuote = Pattern.compile("[\u0082\u008b\u0091\u2018\u201a\u201b\u2039]");
    private static final Pattern rightSingleQuote = Pattern.compile("[\u0092\u009b\u00b4\u2019\u203a]");
    private static final Pattern leftDoubleQuote = Pattern.compile("[\u0084\u0093\u201c\u201e\u00ab]|[\u0091\u2018]'");
    private static final Pattern rightDoubleQuote = Pattern.compile("[\u0094\u201d\u00bb]|[\u0092\u2019]'");
    private static final Pattern unicodeLeftSingleQuote = Pattern.compile("\u0091");
    private static final Pattern unicodeRightSingleQuote = Pattern.compile("\u0092");
    private static final Pattern unicodeLeftDoubleQuote = Pattern.compile("\u0093");
    private static final Pattern unicodeRightDoubleQuote = Pattern.compile("\u0094");
    private static final Pattern leftDuck = Pattern.compile("\u008b");
    private static final Pattern rightDuck = Pattern.compile("\u009b");
    private static final Pattern LEFT_PAREN_PATTERN = Pattern.compile("\\(");
    private static final Pattern RIGHT_PAREN_PATTERN = Pattern.compile("\\)");
    private static final String PENN_LEFT_PAREN = "-LRB-";
    private static final String PENN_RIGHT_PAREN = "-RRB-";

    private LexerUtils() {
    }

    public static String normalizeFractions(boolean normalizeFractions, boolean escapeForwardSlashAsterisk, String in) {
        String out2 = in;
        if (normalizeFractions) {
            if (escapeForwardSlashAsterisk) {
                out2 = ONE_FOURTH_PATTERN.matcher(out2).replaceAll("1\\\\/4");
                out2 = ONE_HALF_PATTERN.matcher(out2).replaceAll("1\\\\/2");
                out2 = THREE_FOURTHS_PATTERN.matcher(out2).replaceAll("3\\\\/4");
                out2 = ONE_THIRD_PATTERN.matcher(out2).replaceAll("1\\\\/3");
                out2 = TWO_THIRDS_PATTERN.matcher(out2).replaceAll("2\\\\/3");
            } else {
                out2 = ONE_FOURTH_PATTERN.matcher(out2).replaceAll("1/4");
                out2 = ONE_HALF_PATTERN.matcher(out2).replaceAll("1/2");
                out2 = THREE_FOURTHS_PATTERN.matcher(out2).replaceAll("3/4");
                out2 = ONE_THIRD_PATTERN.matcher(out2).replaceAll("1/3");
                out2 = TWO_THIRDS_PATTERN.matcher(out2).replaceAll("2/3");
            }
        }
        return out2;
    }

    public static String normalizeCurrency(String in) {
        String s1 = in;
        s1 = CENTS_PATTERN.matcher(s1).replaceAll("cents");
        s1 = POUND_PATTERN.matcher(s1).replaceAll("#");
        s1 = GENERIC_CURRENCY_PATTERN.matcher(s1).replaceAll("\\$");
        s1 = CP1252_EURO_PATTERN.matcher(s1).replaceAll("\u20ac");
        return s1;
    }

    public static String minimallyNormalizeCurrency(String in) {
        return CP1252_EURO_PATTERN.matcher(in).replaceAll("\u20ac");
    }

    public static String removeSoftHyphens(String in) {
        String out2 = NON_WORD_REMOVE_CHARS.matcher(in).replaceAll("");
        if (out2.isEmpty()) {
            out2 = "-";
        }
        return out2;
    }

    public static String processCp1252misc(String arg) {
        switch (arg) {
            case "\u0086": {
                return "\u2020";
            }
            case "\u0087": {
                return "\u2021";
            }
            case "\u0089": {
                return "\u2030";
            }
            case "\u0095": {
                return "\u2022";
            }
            case "\u0098": {
                return "\u02dc";
            }
            case "\u0099": {
                return "\u2122";
            }
        }
        throw new IllegalArgumentException("Bad process cp1252");
    }

    public static String normalizeAmp(String in) {
        return AMP_PATTERN.matcher(in).replaceAll("&");
    }

    public static String escapeChar(String s, char c) {
        int i = s.indexOf(c);
        while (i != -1) {
            if (i == 0 || s.charAt(i - 1) != '\\') {
                s = s.substring(0, i) + '\\' + s.substring(i);
                i = s.indexOf(c, i + 2);
                continue;
            }
            i = s.indexOf(c, i + 1);
        }
        return s;
    }

    public static String asciiQuotes(String in) {
        String s1 = in;
        s1 = asciiSingleQuote.matcher(s1).replaceAll("'");
        s1 = asciiDoubleQuote.matcher(s1).replaceAll("\"");
        return s1;
    }

    private static String latexQuotes(String in, boolean probablyLeft) {
        String s1 = in;
        if (probablyLeft) {
            s1 = singleQuote.matcher(s1).replaceAll("`");
            s1 = doubleQuote.matcher(s1).replaceAll("``");
        } else {
            s1 = singleQuote.matcher(s1).replaceAll("'");
            s1 = doubleQuote.matcher(s1).replaceAll("''");
        }
        s1 = leftSingleQuote.matcher(s1).replaceAll("`");
        s1 = rightSingleQuote.matcher(s1).replaceAll("'");
        s1 = leftDoubleQuote.matcher(s1).replaceAll("``");
        s1 = rightDoubleQuote.matcher(s1).replaceAll("''");
        return s1;
    }

    private static String unicodeQuotes(String in, boolean probablyLeft) {
        String s1 = in;
        if (probablyLeft) {
            s1 = singleQuote.matcher(s1).replaceAll("\u2018");
            s1 = doubleQuote.matcher(s1).replaceAll("\u201c");
        } else {
            s1 = singleQuote.matcher(s1).replaceAll("\u2019");
            s1 = doubleQuote.matcher(s1).replaceAll("\u201d");
        }
        s1 = unicodeLeftSingleQuote.matcher(s1).replaceAll("\u2018");
        s1 = unicodeRightSingleQuote.matcher(s1).replaceAll("\u2019");
        s1 = unicodeLeftDoubleQuote.matcher(s1).replaceAll("\u201c");
        s1 = unicodeRightDoubleQuote.matcher(s1).replaceAll("\u201d");
        s1 = leftDuck.matcher(s1).replaceAll("\u2039");
        s1 = rightDuck.matcher(s1).replaceAll("\u203a");
        return s1;
    }

    private static String nonCp1252Quotes(String in) {
        in = in.replace('\u008b', '\u2039');
        in = in.replace('\u0091', '\u2018');
        in = in.replace('\u0092', '\u2019');
        in = in.replace('\u0093', '\u201c');
        in = in.replace('\u0094', '\u201d');
        in = in.replace('\u009b', '\u203a');
        return in;
    }

    public static String handleQuotes(String tok, boolean probablyLeft, QuotesEnum quoteStyle) {
        switch (quoteStyle) {
            case LATEX: {
                return LexerUtils.latexQuotes(tok, probablyLeft);
            }
            case UNICODE: {
                return LexerUtils.unicodeQuotes(tok, probablyLeft);
            }
            case ASCII: {
                return LexerUtils.asciiQuotes(tok);
            }
            case NOT_CP1252: {
                return LexerUtils.nonCp1252Quotes(tok);
            }
        }
        return tok;
    }

    public static String handleEllipsis(String tok, EllipsesEnum ellipsesStyle) {
        switch (ellipsesStyle) {
            case UNICODE: {
                return unicodeEllipsisStr;
            }
            case ASCII: {
                return ptb3EllipsisStr;
            }
            case NOT_CP1252: {
                if (tok.equals("\u0085")) {
                    return unicodeEllipsisStr;
                }
                return SINGLE_SPACE_PATTERN.matcher(tok).replaceAll("\u00a0");
            }
        }
        return SINGLE_SPACE_PATTERN.matcher(tok).replaceAll("\u00a0");
    }

    public static String handleDashes(String tok, DashesEnum dashesStyle) {
        switch (dashesStyle) {
            case UNICODE: {
                if ("-".equals(tok) || "\u0096".equals(tok) || "&ndash;".equals(tok)) {
                    return "\u2013";
                }
                return "\u2014";
            }
            case ASCII: {
                String mid = tok.replaceAll("[-_\u058a\u2010\u2011\u2012]", "-");
                mid = mid.replaceAll("[\u0096\u0097\u2013\u2014\u2015]|&MD;|&[mn]dash;", "--");
                if ("---".equals(mid)) {
                    mid = "--";
                }
                return mid;
            }
            case NOT_CP1252: {
                if (tok.equals("\u0096")) {
                    return "\u2013";
                }
                if (tok.equals("\u0097")) {
                    return "\u2014";
                }
                return tok;
            }
        }
        return tok;
    }

    public static String pennNormalizeParens(String input, boolean normalizeParentheses) {
        String output = input;
        if (normalizeParentheses) {
            output = LEFT_PAREN_PATTERN.matcher(output).replaceAll(PENN_LEFT_PAREN);
            output = RIGHT_PAREN_PATTERN.matcher(output).replaceAll(PENN_RIGHT_PAREN);
        }
        return output;
    }

    public static enum DashesEnum {
        UNICODE,
        ASCII,
        NOT_CP1252,
        ORIGINAL;

    }

    public static enum EllipsesEnum {
        UNICODE,
        ASCII,
        NOT_CP1252,
        ORIGINAL;

    }

    public static enum QuotesEnum {
        UNICODE,
        LATEX,
        ASCII,
        NOT_CP1252,
        ORIGINAL;

    }
}

