/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChapterAnnotator
implements Annotator {
    public String CHAPTER_BREAK = "CHAPTER";

    @Override
    public void annotate(Annotation doc) {
        HashMap<Integer, Integer> sentenceToChapter = new HashMap<Integer, Integer>();
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        int chapterNum = 0;
        int sentenceIndex = 0;
        for (CoreMap sentence : sentences) {
            if (((String)sentence.get(CoreAnnotations.TextAnnotation.class)).contains(this.CHAPTER_BREAK)) {
                ++chapterNum;
            }
            sentence.set(ChapterAnnotation.class, chapterNum);
            sentenceToChapter.put(sentenceIndex, chapterNum);
            ++sentenceIndex;
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return null;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.SentencesAnnotation.class));
    }

    public static class ChapterAnnotation
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return (Class)ErasureUtils.uncheckedCast(List.class);
        }
    }
}

