/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ExtractQuotesUtil {
    public static boolean rangeContains(Pair<Integer, Integer> r1, Pair<Integer, Integer> r2) {
        return (Integer)r1.first <= (Integer)r2.first && (Integer)r1.second >= (Integer)r2.first || (Integer)r1.first <= (Integer)r2.second && (Integer)r1.second >= (Integer)r2.second;
    }

    public static Annotation readSerializedProtobufFile(File fileIn) {
        try {
            ProtobufAnnotationSerializer pas = new ProtobufAnnotationSerializer();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileIn));
            Pair<Annotation, InputStream> pair = pas.read(is);
            ((InputStream)pair.second).close();
            Annotation annotation = (Annotation)pair.first;
            IOUtils.closeIgnoringExceptions(is);
            return annotation;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

