/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.MSSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.MSSieve;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MajoritySpeakerSieve
extends MSSieve {
    private final Counter<String> topSpeakerList = this.getTopSpeakerList();

    public Counter<String> getTopSpeakerList() {
        ClassicCounter<String> characters = new ClassicCounter<String>();
        ArrayList names = (ArrayList)this.scanForNames(new Pair<Integer, Integer>(Integer.valueOf((int)0), Integer.valueOf((int)(((List)this.doc.get(CoreAnnotations.TokensAnnotation.class)).size() - 1)))).first;
        for (String name : names) {
            name = name.replaceAll("\\s+", " ");
            characters.incrementCount(((Person)((List)this.characterMap.get((Object)name)).get((int)0)).name);
        }
        return characters;
    }

    public MajoritySpeakerSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet);
    }

    @Override
    public void doMentionToSpeaker(Annotation doc) {
        for (CoreMap quote : (List)doc.get(CoreAnnotations.QuotationsAnnotation.class)) {
            if (quote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) != null) continue;
            quote.set(QuoteAttributionAnnotator.SpeakerAnnotation.class, ((Person)((List)this.characterMap.get((Object)Counters.toSortedList(this.topSpeakerList).get((int)0))).get((int)0)).name);
            quote.set(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class, "majority speaker baseline");
        }
    }
}

