/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.graph.CyclicGraphException;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.Alignment;
import edu.stanford.nlp.semgraph.semgrex.VariableStrings;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class SemgrexMatcher {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SemgrexMatcher.class);
    final SemanticGraph sg;
    final Map<String, IndexedWord> namesToNodes;
    final Map<String, String> namesToRelations;
    final Map<String, SemanticGraphEdge> namesToEdges;
    final VariableStrings variableStrings;
    IndexedWord node;
    final Alignment alignment;
    final SemanticGraph sg_aligned;
    final boolean hyp;
    private Iterator<IndexedWord> findIterator;
    private IndexedWord findCurrent;

    SemgrexMatcher(SemanticGraph sg, Alignment alignment, SemanticGraph sg_aligned, boolean hyp, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, Map<String, SemanticGraphEdge> namesToEdges, VariableStrings variableStrings) {
        this.sg = sg;
        this.alignment = alignment;
        this.sg_aligned = sg_aligned;
        this.hyp = hyp;
        this.node = node;
        this.namesToNodes = namesToNodes;
        this.namesToRelations = namesToRelations;
        this.namesToEdges = namesToEdges;
        this.variableStrings = variableStrings;
    }

    SemgrexMatcher(SemanticGraph sg, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, Map<String, SemanticGraphEdge> namesToEdges, VariableStrings variableStrings) {
        this(sg, null, null, true, node, namesToNodes, namesToRelations, namesToEdges, variableStrings);
    }

    public void reset() {
        this.findIterator = null;
        this.namesToNodes.clear();
        this.namesToRelations.clear();
        this.namesToEdges.clear();
    }

    void resetChildIter(IndexedWord node) {
        this.node = node;
        this.resetChildIter();
    }

    void resetChildIter() {
    }

    public abstract boolean matches();

    public boolean matchesAt(IndexedWord node) {
        this.resetChildIter(node);
        return this.matches();
    }

    public abstract IndexedWord getMatch();

    public boolean find() {
        if (this.findIterator == null) {
            if (this.hyp) {
                try {
                    this.findIterator = this.sg.topologicalSort().iterator();
                }
                catch (CyclicGraphException e) {
                    this.findIterator = this.sg.vertexSet().iterator();
                }
            } else {
                if (this.sg_aligned == null) {
                    return false;
                }
                try {
                    this.findIterator = this.sg_aligned.topologicalSort().iterator();
                }
                catch (CyclicGraphException e) {
                    this.findIterator = this.sg_aligned.vertexSet().iterator();
                }
            }
        }
        if (this.findCurrent != null && this.matches()) {
            return true;
        }
        while (this.findIterator.hasNext()) {
            this.findCurrent = this.findIterator.next();
            this.resetChildIter(this.findCurrent);
            if (!this.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findNextMatchingNode() {
        IndexedWord lastMatchingNode = this.getMatch();
        while (this.find()) {
            if (this.getMatch() == lastMatchingNode) continue;
            return true;
        }
        return false;
    }

    public IndexedWord getNode(String name) {
        return this.namesToNodes.get(name);
    }

    public IndexedWord putNode(String name, IndexedWord node) {
        return this.namesToNodes.put(name, node);
    }

    public String getRelnString(String name) {
        return this.namesToRelations.get(name);
    }

    public SemanticGraphEdge getEdge(String name) {
        return this.namesToEdges.get(name);
    }

    public Set<String> getNodeNames() {
        return this.namesToNodes.keySet();
    }

    public Set<String> getRelationNames() {
        return this.namesToRelations.keySet();
    }

    public Set<String> getEdgeNames() {
        return this.namesToEdges.keySet();
    }

    public SemanticGraphEdge putNamedEdge(String name, SemanticGraphEdge edge) {
        return this.namesToEdges.put(name, edge);
    }

    public abstract String toString();

    public SemanticGraph getGraph() {
        return this.sg;
    }
}

