/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.util.Generics;
import java.io.StringWriter;
import java.util.Map;

public class AddNode
extends SsurgeonEdit {
    public static final String LABEL = "addNode";
    String nodeString = null;
    String nodeName = null;
    public static final String WORD_KEY = "word";
    public static final String LEMMA_KEY = "lemma";
    public static final String VALUE_KEY = "value";
    public static final String CURRENT_KEY = "current";
    public static final String POS_KEY = "POS";
    public static final String TUPLE_DELIMITER = "=";
    public static final String ATOM_DELIMITER = " ";

    public AddNode(String nodeString, String nodeName) {
        this.nodeString = nodeString;
        this.nodeName = nodeName;
    }

    public static AddNode createAddNode(String nodeString, String nodeName) {
        return new AddNode(nodeString, nodeName);
    }

    public static AddNode createAddNode(IndexedWord node, String nodeName) {
        String nodeString = AddNode.cheapWordToString(node);
        return new AddNode(nodeString, nodeName);
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord newNode = AddNode.fromCheapString(this.nodeString);
        sg.addVertex(newNode);
        this.addNamedNode(newNode, this.nodeName);
        return true;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-nodearg");
        buf.write(ATOM_DELIMITER);
        buf.write("\"");
        buf.write(this.nodeString);
        buf.write("\"\t");
        buf.write("-name");
        buf.write("\t");
        buf.write(this.nodeName);
        return buf.toString();
    }

    public static String cheapWordToString(IndexedWord node) {
        StringWriter buf = new StringWriter();
        buf.write("{");
        buf.write(WORD_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddNode.nullShield(node.word()));
        buf.write(ATOM_DELIMITER);
        buf.write(LEMMA_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddNode.nullShield(node.lemma()));
        buf.write(ATOM_DELIMITER);
        buf.write(POS_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddNode.nullShield(node.tag()));
        buf.write(ATOM_DELIMITER);
        buf.write(VALUE_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddNode.nullShield(node.value()));
        buf.write(ATOM_DELIMITER);
        buf.write(CURRENT_KEY);
        buf.write(TUPLE_DELIMITER);
        buf.write(AddNode.nullShield(node.originalText()));
        buf.write("}");
        return buf.toString();
    }

    public static String nullShield(String str) {
        return str == null ? "" : str;
    }

    public static IndexedWord fromCheapString(String rawArg) {
        String arg = rawArg.substring(1, rawArg.length() - 1);
        String[] tuples = arg.split(ATOM_DELIMITER);
        Map<String, String> args = Generics.newHashMap();
        for (String tuple : tuples) {
            String[] vals = tuple.split(TUPLE_DELIMITER);
            String key = vals[0];
            String value = "";
            if (vals.length == 2) {
                value = vals[1];
            }
            args.put(key, value);
        }
        IndexedWord newWord = new IndexedWord();
        newWord.setWord((String)args.get(WORD_KEY));
        newWord.setLemma((String)args.get(LEMMA_KEY));
        newWord.setTag((String)args.get(POS_KEY));
        newWord.setValue((String)args.get(VALUE_KEY));
        newWord.setOriginalText((String)args.get(CURRENT_KEY));
        return newWord;
    }
}

