/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class KillNonRootedNodes
extends SsurgeonEdit {
    public static final String LABEL = "killNonRooted";

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        boolean changed = false;
        ArrayList<IndexedWord> nodes = new ArrayList<IndexedWord>(sg.vertexSet());
        for (IndexedWord node : nodes) {
            List<IndexedWord> rootPath = sg.getPathToRoot(node);
            if (rootPath != null) continue;
            changed = changed || sg.removeVertex(node);
        }
        return changed;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.append(LABEL);
        buf.append("\t");
        buf.append(LABEL);
        return buf.toString();
    }
}

