/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonParseException;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.StringWriter;

public class RelabelNamedEdge
extends SsurgeonEdit {
    public static final String LABEL = "relabelNamedEdge";
    protected final String edgeName;
    protected final GrammaticalRelation relation;

    public RelabelNamedEdge(String edgeName, GrammaticalRelation relation) {
        if (edgeName == null) {
            throw new SsurgeonParseException("RelabelNamedEdge created with no edge name!");
        }
        if (relation == null) {
            throw new SsurgeonParseException("RelabelNamedEdge created with no relation!");
        }
        this.edgeName = edgeName;
        this.relation = relation;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-edge");
        buf.write(" ");
        buf.write(this.edgeName);
        buf.write("\t");
        buf.write("-reln");
        buf.write(" ");
        buf.write(this.relation.toString());
        buf.write("\t");
        return buf.toString();
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        SemanticGraphEdge edge = sm.getEdge(this.edgeName);
        if (edge != null) {
            SemanticGraphEdge newEdge;
            block4: {
                if (edge.getRelation().equals(this.relation)) {
                    return false;
                }
                boolean success = sg.removeEdge(edge);
                if (!success) {
                    return false;
                }
                for (SemanticGraphEdge existingEdge : sg.getAllEdges(edge.getSource(), edge.getTarget())) {
                    if (!existingEdge.getRelation().equals(this.relation)) continue;
                    newEdge = existingEdge;
                    break block4;
                }
                newEdge = new SemanticGraphEdge(edge.getSource(), edge.getTarget(), this.relation, edge.getWeight(), edge.isExtra());
                sg.addEdge(newEdge);
            }
            sm.putNamedEdge(this.edgeName, newEdge);
            return true;
        }
        return false;
    }
}

