/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonRuntimeException;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.List;

public class SetRoots
extends SsurgeonEdit {
    public static final String LABEL = "setRoots";
    List<String> newRootNames;

    public SetRoots(List<String> newRootNames) {
        this.newRootNames = newRootNames;
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        LinkedHashSet<IndexedWord> newRoots = new LinkedHashSet<IndexedWord>();
        for (String name : this.newRootNames) {
            IndexedWord root = this.getNamedNode(name, sm);
            if (root == null) {
                throw new SsurgeonRuntimeException("Ssurgeon rule tried to set root to " + name + " but that name does not exist in the semgrex results");
            }
            newRoots.add(root);
        }
        if (newRoots.equals(sg.getRoots())) {
            return false;
        }
        sg.setRoots(newRoots);
        return true;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        for (String name : this.newRootNames) {
            buf.write("\t");
            buf.write(name);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
    }
}

