/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.Ssurgeon;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.SsurgPred;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SsurgeonPattern {
    protected String UID;
    protected String notes = "";
    protected Language language = Language.English;
    protected List<SsurgeonEdit> editScript;
    protected SemgrexPattern semgrexPattern;
    protected SemanticGraph semgrexGraph = null;
    protected SsurgPred predicateTest = null;
    private Map<String, IndexedWord> nodeMap = null;
    public static final String ELT_LIST_TAG = "ssurgeon-pattern-list";
    public static final String UID_ELEM_TAG = "uid";
    public static final String LANGUAGE_TAG = "language";
    public static final String RESOURCE_TAG = "resource";
    public static final String SSURGEON_ELEM_TAG = "ssurgeon-pattern";
    public static final String SEMGREX_ELEM_TAG = "semgrex";
    public static final String SEMGREX_GRAPH_ELEM_TAG = "semgrex-graph";
    public static final String PREDICATE_TAG = "predicate";
    public static final String PREDICATE_AND_TAG = "and";
    public static final String PREDICATE_OR_TAG = "or";
    public static final String PRED_WORDLIST_TEST_TAG = "wordlist-test";
    public static final String PRED_ID_ATTR = "id";
    public static final String NOTES_ELEM_TAG = "notes";
    public static final String EDIT_LIST_ELEM_TAG = "edit-list";
    public static final String EDIT_ELEM_TAG = "edit";
    public static final String ORDINAL_ATTR = "ordinal";

    public SsurgeonPattern(String UID, SemgrexPattern pattern, List<SsurgeonEdit> editScript) {
        this.semgrexPattern = pattern;
        this.UID = UID;
        this.editScript = editScript;
    }

    public SsurgeonPattern(String UID, SemgrexPattern pattern) {
        this.UID = UID;
        this.semgrexPattern = pattern;
        this.editScript = new ArrayList<SsurgeonEdit>();
    }

    public SsurgeonPattern(String UID, SemgrexPattern pattern, SemanticGraph patternGraph) {
        this(UID, pattern);
        this.semgrexGraph = patternGraph;
    }

    public SsurgeonPattern(SemgrexPattern pattern, List<SsurgeonEdit> editScript) {
        this(pattern.toString(), pattern, editScript);
    }

    public SsurgeonPattern(SemgrexPattern pattern) {
        this(pattern.toString(), pattern);
    }

    public SsurgeonPattern(SemgrexPattern pattern, SemanticGraph patternGraph) {
        this(pattern);
        this.semgrexGraph = patternGraph;
    }

    public void setPredicate(SsurgPred predicateTest) {
        this.predicateTest = predicateTest;
    }

    public void addEdit(SsurgeonEdit newEdit) {
        newEdit.setOwningPattern(this);
        this.editScript.add(newEdit);
    }

    public void addNamedNode(IndexedWord node, String name) {
        this.nodeMap.put(name, node);
    }

    public IndexedWord getNamedNode(String name) {
        return this.nodeMap.get(name);
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        buf.append("Semgrex Pattern: UID=");
        buf.write(this.getUID());
        buf.write("\nNotes: ");
        buf.write(this.getNotes());
        buf.write("\n");
        buf.append(this.semgrexPattern.toString());
        if (this.predicateTest != null) {
            buf.write("\nPredicate: ");
            buf.write(this.predicateTest.toString());
        }
        buf.append("\nEdit script:\n");
        for (SsurgeonEdit edit : this.editScript) {
            buf.append("\t");
            buf.append(edit.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public Collection<SemanticGraph> execute(SemanticGraph sg) {
        ArrayList<SemanticGraph> generated = new ArrayList<SemanticGraph>();
        SemgrexMatcher matcher = this.semgrexPattern.matcher(sg);
        block0: while (matcher.find()) {
            Set<String> nodeNames = matcher.getNodeNames();
            Set<IndexedWord> seen = Generics.newHashSet();
            for (String name : nodeNames) {
                IndexedWord curr = matcher.getNode(name);
                if (seen.contains(curr)) break block0;
                seen.add(curr);
            }
            if (this.predicateTest != null && !this.predicateTest.test(matcher)) continue;
            SemanticGraph tgt = SemanticGraphFactory.duplicateKeepNodes(sg);
            this.nodeMap = Generics.newHashMap();
            for (SsurgeonEdit edit : this.editScript) {
                edit.evaluate(tgt, matcher);
            }
            generated.add(tgt);
        }
        return generated;
    }

    public Pair<SemanticGraph, Boolean> iterate(SemanticGraph sg) {
        SemanticGraph copied = new SemanticGraph(sg);
        SemgrexMatcher matcher = this.semgrexPattern.matcher(copied);
        boolean anyChanges = false;
        while (matcher.find()) {
            this.nodeMap = Generics.newHashMap();
            boolean edited = false;
            for (SsurgeonEdit edit : this.editScript) {
                if (!edit.evaluate(copied, matcher)) continue;
                edited = true;
                anyChanges = true;
            }
            if (!edited) continue;
            matcher = this.semgrexPattern.matcher(copied);
        }
        return new Pair<SemanticGraph, Boolean>(copied, anyChanges);
    }

    public Collection<SemanticGraph> execute(SemanticGraph sg, SemgrexPattern overridePattern) throws Exception {
        SemgrexMatcher matcher = overridePattern.matcher(sg);
        ArrayList<SemanticGraph> generated = new ArrayList<SemanticGraph>();
        while (matcher.find()) {
            if (this.predicateTest != null && !this.predicateTest.test(matcher)) continue;
            this.nodeMap = Generics.newHashMap();
            SemanticGraph tgt = new SemanticGraph(sg);
            for (SsurgeonEdit edit : this.editScript) {
                edit.evaluate(tgt, matcher);
            }
            generated.add(tgt);
        }
        return generated;
    }

    public SemgrexPattern getSemgrexPattern() {
        return this.semgrexPattern;
    }

    public List<SsurgeonEdit> getEditScript() {
        return this.editScript;
    }

    public SemanticGraph getSemgrexGraph() {
        return this.semgrexGraph;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getUID() {
        return this.UID;
    }

    public void setUID(String uid) {
        this.UID = uid;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = Language.valueOfSafe(language);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: SsurgeonPattern FILEPATH [\"COMPACT_SEMANTIC_GRAPH\"], FILEPATH=path to ssurgeon pattern to parse and print., SENTENCE=test sentence (in quotes)");
            System.exit(-1);
        }
        File tgtFile = new File(args[0]);
        try {
            Ssurgeon.inst().initLog(new File("./ssurgeon.log"));
            Ssurgeon.inst().setLogPrefix("SsurgeonPattern test");
            List<SsurgeonPattern> patterns = Ssurgeon.inst().readFromFile(tgtFile);
            for (SsurgeonPattern pattern : patterns) {
                System.out.println("- - - - -");
                System.out.println(pattern);
            }
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    String text = args[i];
                    SemanticGraph sg = SemanticGraph.valueOf(text);
                    Collection<SemanticGraph> generated = Ssurgeon.inst().exhaustFromPatterns(patterns, sg);
                    System.out.println("\n= = = = = = = = = =\nSrc text = " + text);
                    System.out.println(sg.toCompactString());
                    System.out.println("# generated  = " + generated.size());
                    for (SemanticGraph genSg : generated) {
                        System.out.println(genSg);
                        System.out.println(". . . . .");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

