/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.function.Predicate;

public class FilteringTreebank
extends Treebank {
    private Predicate<Tree> filter;
    private Treebank treebank;
    private static final boolean VERBOSE = false;

    public FilteringTreebank(Treebank treebank, Predicate<Tree> filter) {
        this.filter = filter;
        this.treebank = treebank;
    }

    @Override
    public void clear() {
        this.treebank.clear();
        this.filter = null;
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        this.treebank.loadPath(path, filt);
    }

    @Override
    public void apply(TreeVisitor tv) {
        for (Tree t : this.treebank) {
            if (!this.filter.test(t)) continue;
            Tree tmpT = t.deepCopy();
            tv.visitTree(tmpT);
        }
    }

    @Override
    public Iterator<Tree> iterator() {
        return new FilteringTreebankIterator(this.treebank.iterator(), this.filter);
    }

    private static class FilteringTreebankIterator
    implements Iterator<Tree> {
        private Iterator<Tree> iter;
        private Predicate<Tree> filter;
        Tree next;

        FilteringTreebankIterator(Iterator<Tree> iter, Predicate<Tree> filter) {
            this.iter = iter;
            this.filter = filter;
            this.primeNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Tree next() {
            Tree answer = this.next;
            this.primeNext();
            return answer;
        }

        public void primeNext() {
            while (this.iter.hasNext()) {
                this.next = this.iter.next();
                if (!this.filter.test(this.next)) continue;
                return;
            }
            this.next = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

