/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.CoordinationTransformer;
import edu.stanford.nlp.trees.EnglishPatterns;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.trees.UniversalSemanticHeadFinder;
import edu.stanford.nlp.trees.ud.EnhancementOptions;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

public class UniversalEnglishGrammaticalStructure
extends GrammaticalStructure {
    private static final Redwood.RedwoodChannels log = Redwood.channels(UniversalEnglishGrammaticalStructure.class);
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = System.getProperty("UniversalEnglishGrammaticalStructure", null) != null;
    private static final boolean USE_NAME = System.getProperty("UDUseNameRelation") != null;
    public static final EnhancementOptions ENHANCED_OPTIONS = new EnhancementOptions(false, true, false, true, true, true, false, false, true);
    public static final EnhancementOptions ENHANCED_PLUS_PLUS_OPTIONS = new EnhancementOptions(true, true, false, true, true, true, true, true, true);
    @Deprecated
    public static final EnhancementOptions COLLAPSED_OPTIONS = new EnhancementOptions(true, true, true, true, false, false, true, false, false);
    private static final Predicate<TypedDependency> extraTreeDepFilter = new ExtraTreeDepFilter();
    private static final SemgrexPattern PASSIVE_AGENT_PATTERN = SemgrexPattern.compile("{}=gov >obl=reln ({}=mod >case {word:/^(?i:by)$/}=c1) >/^aux:pass$/ {}");
    private static final SemgrexPattern[] PREP_MW3_PATTERNS = new SemgrexPattern[]{SemgrexPattern.compile("{}=gov   [>/^(nmod|obl)$/=reln ({}=mod >case ({}=c1 >fixed {}=c2 >fixed ({}=c3 !== {}=c2) ))]"), SemgrexPattern.compile("{}=gov   [>/^(advcl|acl)$/=reln ({}=mod >/^(mark|case)$/ ({}=c1 >fixed {}=c2 >fixed ({}=c3 !== {}=c2) ))]")};
    private static final SemgrexPattern[] PREP_MW2_PATTERNS = new SemgrexPattern[]{SemgrexPattern.compile("{}=gov >/^(nmod|obl)$/=reln ({}=mod >case ({}=c1 >fixed {}=c2))"), SemgrexPattern.compile("{}=gov >/^(advcl|acl)$/=reln ({}=mod >/^(mark|case)$/ ({}=c1 >fixed {}=c2))")};
    private static final SemgrexPattern[] PREP_PATTERNS = new SemgrexPattern[]{SemgrexPattern.compile("{}=gov   >/^(nmod|obl)$/=reln ({}=mod >case {}=c1)"), SemgrexPattern.compile("{}=gov   >/^(advcl|acl)$/=reln ({}=mod >/^(mark|case)$/ {}=c1)")};
    private static final SemgrexPattern PREP_CONJP_PATTERN = SemgrexPattern.compile("{} >/(case|mark)/ ({}=gov  >conj ({} >cc {}=cc) >conj {}=conj)");
    private static final SemgrexPattern PP_CONJP_PATTERN = SemgrexPattern.compile("{} >/^(nmod|obl|acl|advcl)$/ (({}=gov >/(case|mark)/ {}) >conj ({} >/(case|mark)/ {} >cc {}=cc) >conj ({}=conj >/(case|mark)/ {}))");
    private static final SemgrexPattern CONJUNCTION_PATTERN = SemgrexPattern.compile("{}=gov  [>conj ({}=conj >cc {}=cc) |  >conj ({} >cc {}=cc) >conj {}=conj ]");
    private static final SemgrexPattern XCOMP_PATTERN = SemgrexPattern.compile("{}=root >xcomp {}=embedded >/^(dep|obj)$/ {}=wh ?>/(i?obj)/ {}=obj");
    private static final SemgrexPattern CORRECT_SUBJPASS_PATTERN = SemgrexPattern.compile("{}=gov >/^aux:pass$/ {} >/^(nsubj|csubj).*$/ {}=subj");
    private static final String[] TWO_WORD_PREPS_REGULAR = new String[]{"across_from", "along_with", "alongside_of", "apart_from", "as_for", "as_from", "as_of", "as_per", "as_to", "aside_from", "based_on", "close_by", "close_to", "contrary_to", "compared_to", "compared_with", " depending_on", "except_for", "exclusive_of", "far_from", "followed_by", "inside_of", "irrespective_of", "next_to", "near_to", "off_of", "out_of", "outside_of", "owing_to", "preliminary_to", "preparatory_to", "previous_to", " prior_to", "pursuant_to", "regardless_of", "subsequent_to", "thanks_to", "together_with"};
    private static final String[] TWO_WORD_PREPS_COMPLEX = new String[]{"apart_from", "as_from", "aside_from", "away_from", "close_by", "close_to", "contrary_to", "far_from", "next_to", "near_to", "out_of", "outside_of", "pursuant_to", "regardless_of", "together_with"};
    private static final String[] THREE_WORD_PREPS = new String[]{"by_means_of", "in_accordance_with", "in_addition_to", "in_case_of", "in_front_of", "in_lieu_of", "in_place_of", "in_spite_of", "on_account_of", "on_behalf_of", "on_top_of", "with_regard_to", "with_respect_to"};
    private static final SemgrexPattern TWO_WORD_PREPS_REGULAR_PATTERN = SemgrexPattern.compile("{}=gov >/(case|advmod)/ ({}=w1 !> {}) >case ({}=w2 !== {}=w1 !> {})");
    private static final SemgrexPattern TWO_WORD_PREPS_COMPLEX_PATTERN = SemgrexPattern.compile("({}=w1 >/(nmod|obl)/ ({}=gov2 >case ({}=w2 !> {}))) [ == {$} | < {}=gov ]");
    private static final SemgrexPattern THREE_WORD_PREPS_PATTERN = SemgrexPattern.compile("({}=w2 >/(nmod|acl|advcl|obl)/ ({}=gov2 >/(case|mark)/ ({}=w3 !> {}))) >case ({}=w1 !> {}) [ < {}=gov | == {$} ]");
    private static final SemgrexPattern QUANT_MOD_3W_PATTERN = SemgrexPattern.compile("{word:/(?i:lot|assortment|number|couple|bunch|handful|litany|sheaf|slew|dozen|series|variety|multitude|wad|clutch|wave|mountain|array|spate|string|ton|range|plethora|heap|sort|form|kind|type|version|bit|pair|triple|total)/}=w2 >det {word:/(?i:an?)/}=w1 !>amod {} >nmod ({tag:/(NN.*|PRP.*)/}=gov >case {word:/(?i:of)/}=w3) . {}=w3");
    private static final SemgrexPattern[] QUANT_MOD_2W_PATTERNS = new SemgrexPattern[]{SemgrexPattern.compile("{word:/(?i:lots|many|several|plenty|tons|dozens|multitudes|mountains|loads|pairs|tens|hundreds|thousands|millions|billions|trillions|[0-9]+s)/}=w1 >nmod ({tag:/(NN.*|PRP.*)/}=gov >case {word:/(?i:of)/}=w2) . {}=w2"), SemgrexPattern.compile("{word:/(?i:some|all|both|neither|everyone|nobody|one|two|three|four|five|six|seven|eight|nine|ten|hundred|thousand|million|billion|trillion|[0-9]+)/}=w1 [>nmod ({tag:/(NN.*)/}=gov >case ({word:/(?i:of)/}=w2 $+ {}=det) >det {}=det) |  >nmod ({tag:/(PRP.*)/}=gov >case {word:/(?i:of)/}=w2)] . {}=w2")};
    private static final SemgrexPattern[] NAME_PATTERNS = new SemgrexPattern[]{SemgrexPattern.compile("{ner:PERSON}=w1 >compound {}=w2"), SemgrexPattern.compile("{ner:LOCATION}=w1 >compound {}=w2")};
    private static final Predicate<String> PUNCT_TAG_FILTER = new PennTreebankLanguagePack().punctuationWordRejectFilter();

    public UniversalEnglishGrammaticalStructure(Tree t) {
        this(t, new PennTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public UniversalEnglishGrammaticalStructure(Tree t, Predicate<String> tagFilter) {
        this(t, tagFilter, new UniversalSemanticHeadFinder(true));
    }

    public UniversalEnglishGrammaticalStructure(Tree t, Predicate<String> tagFilter, HeadFinder hf) {
        super(t, UniversalEnglishGrammaticalRelations.values(), UniversalEnglishGrammaticalRelations.valuesLock(), new CoordinationTransformer(hf, true), hf, Filters.acceptFilter(), tagFilter);
    }

    public UniversalEnglishGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    @Override
    protected Predicate<TypedDependency> extraTreeDepFilter() {
        return extraTreeDepFilter;
    }

    @Override
    protected void getTreeDeps(List<TypedDependency> deps, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph, Predicate<TypedDependency> puncTypedDepFilter, Predicate<TypedDependency> extraTreeDepFilter) {
    }

    @Override
    protected void correctDependencies(List<TypedDependency> list) {
        SemanticGraph sg = new SemanticGraph(list);
        UniversalEnglishGrammaticalStructure.correctDependencies(sg);
        list.clear();
        list.addAll(sg.typedDependencies());
        Collections.sort(list);
    }

    protected static void correctDependencies(SemanticGraph sg) {
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("At correctDependencies:", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.correctSubjPass(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After correctSubjPass:", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.processNames(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After processNames:", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.removeExactDuplicates(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After removeExactDuplicates:", sg.typedDependencies());
        }
    }

    private static void printListSorted(String title, Collection<TypedDependency> list) {
        ArrayList<TypedDependency> lis = new ArrayList<TypedDependency>(list);
        Collections.sort(lis);
        if (title != null) {
            log.info(title);
        }
        log.info(lis);
    }

    @Override
    protected void postProcessDependencies(List<TypedDependency> list) {
        SemanticGraph sg = new SemanticGraph(list);
        UniversalEnglishGrammaticalStructure.postProcessDependencies(sg);
        list.clear();
        list.addAll(sg.typedDependencies());
    }

    protected static void postProcessDependencies(SemanticGraph sg) {
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("At postProcessDependencies:", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.correctWHAttachment(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After correcting WH attachment:", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.convertRel(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After converting rel:", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.fixCCAttachment(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After fixing CC attachment:", sg.typedDependencies());
        }
    }

    @Override
    protected void getExtras(List<TypedDependency> list) {
        SemanticGraph sg = new SemanticGraph(list);
        UniversalEnglishGrammaticalStructure.addRef(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After adding ref:", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.addExtraNSubj(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("After adding extra nsubj:", sg.typedDependencies());
        }
        list.clear();
        list.addAll(sg.typedDependencies());
    }

    private static void addCaseMarkerInformation(SemanticGraph sg, boolean enhanceOnlyNmods) {
        IndexedWord mod;
        IndexedWord gov;
        ArrayList<IndexedWord> caseMarkers;
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = PASSIVE_AGENT_PATTERN.matcher(sgCopy);
        while (matcher.find()) {
            IndexedWord caseMarker = matcher.getNode("c1");
            IndexedWord gov2 = matcher.getNode("gov");
            IndexedWord mod2 = matcher.getNode("mod");
            UniversalEnglishGrammaticalStructure.addPassiveAgentToReln(sg, gov2, mod2, caseMarker);
        }
        ArrayList<Object> oldCaseMarkers = Generics.newArrayList();
        for (SemgrexPattern p : PREP_MW3_PATTERNS) {
            sgCopy = sg.makeSoftCopy();
            matcher = p.matcher(sgCopy);
            while (matcher.find()) {
                if (enhanceOnlyNmods && !matcher.getRelnString("reln").equals("nmod") && !matcher.getRelnString("reln").equals("obl")) continue;
                caseMarkers = Generics.newArrayList(3);
                caseMarkers.add(matcher.getNode("c1"));
                caseMarkers.add(matcher.getNode("c2"));
                caseMarkers.add(matcher.getNode("c3"));
                Collections.sort(caseMarkers);
                if (caseMarkers.equals(oldCaseMarkers)) continue;
                gov = matcher.getNode("gov");
                mod = matcher.getNode("mod");
                UniversalEnglishGrammaticalStructure.addCaseMarkersToReln(sg, gov, mod, caseMarkers);
                oldCaseMarkers = caseMarkers;
            }
        }
        for (SemgrexPattern p : PREP_MW2_PATTERNS) {
            sgCopy = sg.makeSoftCopy();
            matcher = p.matcher(sgCopy);
            while (matcher.find()) {
                if (enhanceOnlyNmods && !matcher.getRelnString("reln").equals("nmod") && !matcher.getRelnString("reln").equals("obl")) continue;
                caseMarkers = Generics.newArrayList(2);
                caseMarkers.add(matcher.getNode("c1"));
                caseMarkers.add(matcher.getNode("c2"));
                Collections.sort(caseMarkers);
                if (caseMarkers.equals(oldCaseMarkers)) continue;
                gov = matcher.getNode("gov");
                mod = matcher.getNode("mod");
                UniversalEnglishGrammaticalStructure.addCaseMarkersToReln(sg, gov, mod, caseMarkers);
                oldCaseMarkers = caseMarkers;
            }
        }
        for (SemgrexPattern p : PREP_PATTERNS) {
            sgCopy = sg.makeSoftCopy();
            matcher = p.matcher(sgCopy);
            while (matcher.find()) {
                if (enhanceOnlyNmods && !matcher.getRelnString("reln").equals("nmod") && !matcher.getRelnString("reln").equals("obl")) continue;
                caseMarkers = Generics.newArrayList(1);
                caseMarkers.add(matcher.getNode("c1"));
                if (caseMarkers.equals(oldCaseMarkers)) continue;
                gov = matcher.getNode("gov");
                mod = matcher.getNode("mod");
                UniversalEnglishGrammaticalStructure.addCaseMarkersToReln(sg, gov, mod, caseMarkers);
                oldCaseMarkers = caseMarkers;
            }
        }
    }

    private static void addPassiveAgentToReln(SemanticGraph sg, IndexedWord gov, IndexedWord mod, IndexedWord caseMarker) {
        SemanticGraphEdge edge = sg.getEdge(gov, mod);
        sg.updateEdge(edge, UniversalEnglishGrammaticalRelations.AGENT);
    }

    private static void addCaseMarkersToReln(SemanticGraph sg, IndexedWord gov, IndexedWord mod, List<IndexedWord> caseMarkers) {
        SemanticGraphEdge edge = sg.getEdge(gov, mod);
        int lastCaseMarkerIndex = 0;
        StringBuilder sb = new StringBuilder();
        boolean firstWord = true;
        for (IndexedWord cm : caseMarkers) {
            if (lastCaseMarkerIndex == 0 || cm.index() == lastCaseMarkerIndex + 1) {
                if (!firstWord) {
                    sb.append('_');
                }
                sb.append(cm.value());
                firstWord = false;
            } else {
                GrammaticalRelation reln = UniversalEnglishGrammaticalStructure.getCaseMarkedRelation(edge.getRelation(), sb.toString().toLowerCase());
                sg.addEdge(gov, mod, reln, Double.NEGATIVE_INFINITY, true);
                sb = new StringBuilder(cm.value());
                firstWord = true;
            }
            lastCaseMarkerIndex = cm.index();
        }
        GrammaticalRelation reln = UniversalEnglishGrammaticalStructure.getCaseMarkedRelation(edge.getRelation(), sb.toString().toLowerCase());
        sg.updateEdge(edge, reln);
    }

    private static void expandPrepConjunctions(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = PREP_CONJP_PATTERN.matcher(sgCopy);
        IndexedWord oldGov = null;
        IndexedWord oldCcDep = null;
        LinkedList<IndexedWord> conjDeps = Generics.newLinkedList();
        while (matcher.find()) {
            IndexedWord ccDep = matcher.getNode("cc");
            IndexedWord conjDep = matcher.getNode("conj");
            IndexedWord gov = matcher.getNode("gov");
            if (!(oldGov == null || gov.equals(oldGov) && ccDep.equals(oldCcDep))) {
                UniversalEnglishGrammaticalStructure.expandPrepConjunction(sg, oldGov, conjDeps, oldCcDep);
                conjDeps = Generics.newLinkedList();
            }
            oldCcDep = ccDep;
            oldGov = gov;
            conjDeps.add(conjDep);
        }
        if (oldGov != null) {
            UniversalEnglishGrammaticalStructure.expandPrepConjunction(sg, oldGov, conjDeps, oldCcDep);
        }
    }

    private static void expandPrepConjunction(SemanticGraph sg, IndexedWord gov, List<IndexedWord> conjDeps, IndexedWord ccDep) {
        IndexedWord caseGov = sg.getParent(gov);
        if (caseGov == null) {
            return;
        }
        IndexedWord caseGovGov = sg.getParent(caseGov);
        if (caseGovGov == null) {
            return;
        }
        IndexedWord conjGov = caseGovGov.getOriginal() != null ? caseGovGov.getOriginal() : caseGovGov;
        GrammaticalRelation rel = sg.reln(caseGovGov, caseGov);
        LinkedList<IndexedWord> newConjDeps = Generics.newLinkedList();
        for (IndexedWord conjDep : conjDeps) {
            IndexedWord caseGovGovCopy = caseGovGov.makeSoftCopy();
            sg.addEdge(conjGov, caseGovGovCopy, UniversalEnglishGrammaticalRelations.CONJUNCT, Double.NEGATIVE_INFINITY, false);
            newConjDeps.add(caseGovGovCopy);
            sg.addEdge(caseGovGovCopy, caseGov, rel, Double.NEGATIVE_INFINITY, true);
            ArrayList<IndexedWord> caseMarkers = Generics.newArrayList();
            caseMarkers.add(conjDep);
            UniversalEnglishGrammaticalStructure.addCaseMarkersToReln(sg, caseGovGovCopy, caseGov, caseMarkers);
        }
        UniversalEnglishGrammaticalStructure.addConjToReln(sg, conjGov, newConjDeps, ccDep);
    }

    private static void expandPPConjunctions(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = PP_CONJP_PATTERN.matcher(sgCopy);
        IndexedWord oldGov = null;
        IndexedWord oldCcDep = null;
        LinkedList<IndexedWord> conjDeps = Generics.newLinkedList();
        while (matcher.find()) {
            IndexedWord conjDep = matcher.getNode("conj");
            IndexedWord gov = matcher.getNode("gov");
            IndexedWord ccDep = matcher.getNode("cc");
            if (!(oldGov == null || gov.equals(oldGov) && ccDep.equals(oldCcDep))) {
                UniversalEnglishGrammaticalStructure.expandPPConjunction(sg, oldGov, conjDeps, oldCcDep);
                conjDeps = Generics.newLinkedList();
            }
            oldCcDep = ccDep;
            oldGov = gov;
            conjDeps.add(conjDep);
        }
        if (oldGov != null) {
            UniversalEnglishGrammaticalStructure.expandPPConjunction(sg, oldGov, conjDeps, oldCcDep);
        }
    }

    private static void expandPPConjunction(SemanticGraph sg, IndexedWord gov, List<IndexedWord> conjDeps, IndexedWord ccDep) {
        IndexedWord nmodGov = sg.getParent(gov);
        if (nmodGov == null) {
            return;
        }
        IndexedWord conjGov = nmodGov.getOriginal() != null ? nmodGov.getOriginal() : nmodGov;
        GrammaticalRelation rel = sg.reln(nmodGov, gov);
        LinkedList<IndexedWord> newConjDeps = Generics.newLinkedList();
        for (IndexedWord conjDep : conjDeps) {
            IndexedWord nmodGovCopy = nmodGov.makeSoftCopy();
            SemanticGraphEdge edge = sg.getEdge(gov, conjDep);
            if (edge != null) {
                sg.removeEdge(edge);
                sg.addEdge(nmodGovCopy, conjDep, rel, Double.NEGATIVE_INFINITY, false);
            }
            sg.addEdge(conjGov, nmodGovCopy, UniversalEnglishGrammaticalRelations.CONJUNCT, Double.NEGATIVE_INFINITY, false);
            newConjDeps.add(nmodGovCopy);
            SemanticGraphEdge ccEdge = sg.getEdge(conjDep, ccDep);
            if (ccEdge == null) continue;
            sg.removeEdge(ccEdge);
            sg.addEdge(nmodGovCopy, ccDep, UniversalEnglishGrammaticalRelations.COORDINATION, Double.NEGATIVE_INFINITY, false);
        }
        UniversalEnglishGrammaticalStructure.addConjToReln(sg, conjGov, newConjDeps, ccDep);
    }

    private static GrammaticalRelation getCaseMarkedRelation(GrammaticalRelation reln, String relationName) {
        GrammaticalRelation newReln = reln;
        if (reln.getSpecific() != null) {
            reln = reln.getParent();
        }
        if (reln == UniversalEnglishGrammaticalRelations.NOMINAL_MODIFIER) {
            newReln = UniversalEnglishGrammaticalRelations.getNmod(relationName);
        } else if (reln == UniversalEnglishGrammaticalRelations.OBLIQUE_MODIFIER) {
            newReln = UniversalEnglishGrammaticalRelations.getObl(relationName);
        } else if (reln == UniversalEnglishGrammaticalRelations.ADV_CLAUSE_MODIFIER) {
            newReln = UniversalEnglishGrammaticalRelations.getAdvcl(relationName);
        } else if (reln == UniversalEnglishGrammaticalRelations.CLAUSAL_MODIFIER) {
            newReln = UniversalEnglishGrammaticalRelations.getAcl(relationName);
        }
        return newReln;
    }

    private static void addConjInformation(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = CONJUNCTION_PATTERN.matcher(sgCopy);
        IndexedWord oldGov = null;
        IndexedWord oldCcDep = null;
        LinkedList<IndexedWord> conjDeps = Generics.newLinkedList();
        while (matcher.find()) {
            IndexedWord conjDep = matcher.getNode("conj");
            IndexedWord gov = matcher.getNode("gov");
            IndexedWord ccDep = matcher.getNode("cc");
            if (!(oldGov == null || gov.equals(oldGov) && ccDep.equals(oldCcDep))) {
                UniversalEnglishGrammaticalStructure.addConjToReln(sg, oldGov, conjDeps, oldCcDep);
                conjDeps = Generics.newLinkedList();
            }
            oldCcDep = ccDep;
            conjDeps.add(conjDep);
            oldGov = gov;
        }
        if (oldGov != null) {
            UniversalEnglishGrammaticalStructure.addConjToReln(sg, oldGov, conjDeps, oldCcDep);
        }
    }

    private static void addConjToReln(SemanticGraph sg, IndexedWord gov, List<IndexedWord> conjDeps, IndexedWord ccDep) {
        for (IndexedWord conjDep : conjDeps) {
            SemanticGraphEdge edge = sg.getEdge(gov, conjDep);
            if (edge.getRelation() != UniversalEnglishGrammaticalRelations.CONJUNCT && conjDep.index() <= ccDep.index()) continue;
            sg.updateEdge(edge, UniversalEnglishGrammaticalStructure.conjValue(ccDep, sg));
        }
    }

    private static void correctWHAttachment(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = XCOMP_PATTERN.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            SemanticGraphEdge edge;
            String lemma;
            IndexedWord root = matcher.getNode("root");
            IndexedWord embeddedVerb = matcher.getNode("embedded");
            IndexedWord wh = matcher.getNode("wh");
            IndexedWord dobj = matcher.getNode("obj");
            if (wh.tag() == null || !wh.tag().startsWith("W")) continue;
            boolean reattach = false;
            if (dobj != null) {
                reattach = true;
            } else if (root.value() != null && root.tag() != null && (lemma = Morphology.lemmaStatic(root.value(), root.tag())) != null && lemma.matches("(?i:acquiesce|submit|bow|defer|accede|succumb|yield|capitulate|despise|disdain|dislike|regret|like|love|enjoy|fear|hate|pledge|proceed|begin|start|commence|recommence|resume|undertake|ally|collaborate|collude|conspire|discriminate|legislate|partner|protest|rebel|retaliate|scheme|sin|befriend|continue|broadcast|cable|e-mail|fax|modem|netmail|phone|radio|relay|satellite|semaphore|sign|signal|telecast|telegraph|telephone|telex|wire|wireless|ache|crave|fall|hanker|hope|hunger|itch|long|lust|pine|pray|thirst|wish|yearn|dangle|hanker|lust|thirst|yearn|babble|bark|bawl|bellow|bleat|blubber|boom|bray|burble|bluster|cackle|call|carol|chant|chatter|chirp|chortle|chuckle|cluck|coo|croak|croon|crow|cry|drawl|drone|gabble|gasp|gibber|groan|growl|grumble|grunt|hiss|holler|hoot|howl|jabber|keen|lilt|lisp|mewl|moan|mumble|murmur|mutter|nasal|natter|pant|prattle|purr|quaver|rage|rant|rasp|roar|rumble|scream|screech|shout|shriek|sibilate|simper|sigh|sing|smatter|smile|snap|snarl|snivel|snuffle|splutter|squall|squawk|squeak|squeal|stammer|stemmer|stutter|thunder|tisk|trill|trumpet|twang|twitter|vociferate|wail|warble|wheeze|whimper|whine|whisper|whistle|witter|whoop|yammer|yap|yell|yelp|yodel|blare|gurgle|hum|neglect|fail|forego|forgo|flub|overleap|manage|omit|seem|appear|prove|manage|fail|flub|try|attempt|intend|enjoy|expect|wish|hope|intend|mean|plan|propose|think|aim|dream|imagine|yen)")) {
                reattach = true;
            }
            if (!reattach || (edge = sg.getEdge(root, wh)) == null) continue;
            sg.removeEdge(edge);
            sg.addEdge(embeddedVerb, wh, UniversalEnglishGrammaticalRelations.DIRECT_OBJECT, Double.NEGATIVE_INFINITY, false);
        }
    }

    private static void fixCCAttachment(SemanticGraph sg) {
        HashMap<SemanticGraphEdge, Integer> newHeads = new HashMap<SemanticGraphEdge, Integer>();
        for (SemanticGraphEdge semanticGraphEdge : sg.edgeIterable()) {
            if (!semanticGraphEdge.getRelation().equals(UniversalEnglishGrammaticalRelations.COORDINATION) || semanticGraphEdge.getGovernor().index() >= semanticGraphEdge.getDependent().index()) continue;
            Set<IndexedWord> conjuncts = sg.getChildrenWithReln(semanticGraphEdge.getGovernor(), UniversalEnglishGrammaticalRelations.CONJUNCT);
            int newHead = Integer.MAX_VALUE;
            for (IndexedWord conjunct : conjuncts) {
                if (conjunct.index() >= newHead || conjunct.index() <= semanticGraphEdge.getDependent().index()) continue;
                newHead = conjunct.index();
            }
            if (newHead >= Integer.MAX_VALUE) continue;
            newHeads.put(semanticGraphEdge, newHead);
        }
        for (Map.Entry entry : newHeads.entrySet()) {
            SemanticGraphEdge edge = (SemanticGraphEdge)entry.getKey();
            IndexedWord newGovernor = sg.getNodeByIndex((Integer)entry.getValue());
            sg.removeEdge(edge);
            sg.addEdge(newGovernor, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
    }

    private static void convertRel(SemanticGraph sg) {
        for (SemanticGraphEdge prep : sg.findAllRelns(UniversalEnglishGrammaticalRelations.PREPOSITION)) {
            boolean changedPrep = false;
            for (SemanticGraphEdge nmod : sg.outgoingEdgeIterable(prep.getGovernor())) {
                if (nmod.getRelation() != UniversalEnglishGrammaticalRelations.NOMINAL_MODIFIER && nmod.getRelation() != UniversalEnglishGrammaticalRelations.RELATIVE && nmod.getRelation() != UniversalEnglishGrammaticalRelations.OBLIQUE_MODIFIER || prep.getDependent().index() < nmod.getDependent().index()) continue;
                sg.removeEdge(prep);
                sg.addEdge(nmod.getDependent(), prep.getDependent(), UniversalEnglishGrammaticalRelations.CASE_MARKER, Double.NEGATIVE_INFINITY, false);
                changedPrep = true;
                if (nmod.getRelation() != UniversalEnglishGrammaticalRelations.RELATIVE) break;
                if (nmod.getGovernor().tag().startsWith("NN") || nmod.getGovernor().tag().startsWith("PRN") || nmod.getGovernor().tag().startsWith("DT")) {
                    sg.updateEdge(nmod, UniversalEnglishGrammaticalRelations.NOMINAL_MODIFIER);
                    break;
                }
                sg.updateEdge(nmod, UniversalEnglishGrammaticalRelations.OBLIQUE_MODIFIER);
                break;
            }
            if (changedPrep) continue;
            sg.updateEdge(prep, UniversalEnglishGrammaticalRelations.OBLIQUE_MODIFIER);
        }
        for (SemanticGraphEdge edge : sg.findAllRelns(UniversalEnglishGrammaticalRelations.RELATIVE)) {
            sg.updateEdge(edge, UniversalEnglishGrammaticalRelations.DIRECT_OBJECT);
        }
    }

    public static void addEnhancements(SemanticGraph sg, EnhancementOptions options) {
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: before correctDependencies()", sg.typedDependencies());
        }
        UniversalEnglishGrammaticalStructure.correctDependencies(sg);
        if (DEBUG) {
            UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after correctDependencies()", sg.typedDependencies());
        }
        if (options.processMultiWordPrepositions) {
            UniversalEnglishGrammaticalStructure.processMultiwordPreps(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after processMultiwordPreps()", sg.typedDependencies());
            }
        }
        if (options.demoteQuantMod) {
            UniversalEnglishGrammaticalStructure.demoteQuantificationalModifiers(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after demoteQuantificationalModifiers()", sg.typedDependencies());
            }
        }
        if (options.addCopyNodes) {
            UniversalEnglishGrammaticalStructure.expandPPConjunctions(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after expandPPConjunctions()", sg.typedDependencies());
            }
            UniversalEnglishGrammaticalStructure.expandPrepConjunctions(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after expandPrepConjunctions()", sg.typedDependencies());
            }
        }
        if (options.enhancePrepositionalModifiers) {
            UniversalEnglishGrammaticalStructure.addCaseMarkerInformation(sg, options.enhanceOnlyNmods);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after addCaseMarkerInformation()", sg.typedDependencies());
            }
        }
        if (options.enhanceConjuncts) {
            UniversalEnglishGrammaticalStructure.addConjInformation(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after addConjInformation()", sg.typedDependencies());
            }
        }
        if (options.addReferent) {
            UniversalEnglishGrammaticalStructure.addRef(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after addRef()", sg.typedDependencies());
            }
            UniversalEnglishGrammaticalStructure.collapseReferent(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after collapseReferent()", sg.typedDependencies());
            }
        }
        if (options.propagateDependents) {
            UniversalEnglishGrammaticalStructure.treatCC(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after treatCC()", sg.typedDependencies());
            }
        }
        if (options.addXSubj) {
            UniversalEnglishGrammaticalStructure.addExtraNSubj(sg);
            if (DEBUG) {
                UniversalEnglishGrammaticalStructure.printListSorted("addEnhancements: after addExtraNSubj()", sg.typedDependencies());
            }
        }
        UniversalEnglishGrammaticalStructure.correctSubjPass(sg);
    }

    @Override
    protected void addEnhancements(List<TypedDependency> list, EnhancementOptions options) {
        SemanticGraph sg = new SemanticGraph(list);
        UniversalEnglishGrammaticalStructure.addEnhancements(sg, options);
        list.clear();
        list.addAll(sg.typedDependencies());
        Collections.sort(list);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess, GrammaticalStructure.Extras includeExtras) {
        EnhancementOptions options = new EnhancementOptions(COLLAPSED_OPTIONS);
        if (includeExtras.doRef) {
            options.addReferent = true;
        }
        if (includeExtras.doSubj) {
            options.addXSubj = true;
        }
        if (CCprocess) {
            options.propagateDependents = true;
        }
        this.addEnhancements(list, options);
    }

    @Override
    protected void collapseDependenciesTree(List<TypedDependency> list) {
        this.collapseDependencies(list, false, GrammaticalStructure.Extras.NONE);
    }

    private static GrammaticalRelation conjValue(IndexedWord cc, SemanticGraph sg) {
        IndexedWord prevWord;
        int pos = cc.index();
        String newConj = cc.value().toLowerCase();
        if (newConj.equals("not") && (prevWord = sg.getNodeByIndexSafe(pos - 1)) != null && prevWord.value().toLowerCase().equals("but")) {
            return UniversalEnglishGrammaticalRelations.getConj("negcc");
        }
        IndexedWord secondIWord = sg.getNodeByIndexSafe(pos + 1);
        if (secondIWord == null) {
            return UniversalEnglishGrammaticalRelations.getConj(cc.value());
        }
        String secondWord = secondIWord.value().toLowerCase();
        if (newConj.equals("but")) {
            if (secondWord.equals("rather")) {
                newConj = "negcc";
            } else if (secondWord.equals("also")) {
                newConj = "and";
            }
        } else if (newConj.equals("if") && secondWord.equals("not")) {
            newConj = "negcc";
        } else if (newConj.equals("instead") && secondWord.equals("of")) {
            newConj = "negcc";
        } else if (newConj.equals("rather") && secondWord.equals("than")) {
            newConj = "negcc";
        } else if (newConj.equals("as") && secondWord.equals("well")) {
            newConj = "and";
        } else if (newConj.equals("not") && secondWord.equals("to")) {
            String thirdWord;
            IndexedWord thirdIWord = sg.getNodeByIndexSafe(pos + 2);
            String string = thirdWord = thirdIWord != null ? thirdIWord.value().toLowerCase() : null;
            if (thirdWord != null && thirdWord.equals("mention")) {
                newConj = "and";
            }
        }
        return UniversalEnglishGrammaticalRelations.getConj(newConj);
    }

    private static void treatCC(SemanticGraph sg) {
        Map map = Generics.newHashMap();
        Map<IndexedWord, SemanticGraphEdge> subjectMap = Generics.newHashMap();
        Set<IndexedWord> withPassiveAuxiliary = Generics.newHashSet();
        ArrayList<IndexedWord> rcmodHeads = Generics.newArrayList();
        ArrayList<IndexedWord> prepcDep = Generics.newArrayList();
        for (SemanticGraphEdge edge : sg.edgeIterable()) {
            if (!map.containsKey(edge.getDependent())) {
                map.put(edge.getDependent(), new TreeSet());
            }
            ((Set)map.get(edge.getDependent())).add(edge);
            if (edge.getRelation().equals(UniversalEnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER)) {
                withPassiveAuxiliary.add(edge.getGovernor());
            }
            if (!(edge.getRelation().getParent() != UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT && edge.getRelation().getParent() != UniversalEnglishGrammaticalRelations.SUBJECT && edge.getRelation().getParent() != UniversalEnglishGrammaticalRelations.CLAUSAL_SUBJECT || subjectMap.containsKey(edge.getGovernor()))) {
                subjectMap.put(edge.getGovernor(), edge);
            }
            if (edge.getRelation() == UniversalEnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER) {
                rcmodHeads.add(edge.getGovernor());
            }
            if (!edge.getRelation().toString().startsWith("acl:") && !edge.getRelation().toString().startsWith("advcl:")) continue;
            prepcDep.add(edge.getDependent());
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        for (SemanticGraphEdge edge : sgCopy.edgeIterable()) {
            if (!UniversalEnglishGrammaticalRelations.getConjs().contains(edge.getRelation())) continue;
            IndexedWord gov = edge.getGovernor();
            IndexedWord dep = edge.getDependent();
            Set gov_relations = (Set)map.get(gov);
            if (gov_relations != null) {
                for (SemanticGraphEdge edge1 : gov_relations) {
                    GrammaticalRelation newRel;
                    IndexedWord newGov = edge1.getGovernor();
                    if (newGov.equals(dep) || (newRel = edge1.getRelation()) == GrammaticalRelation.ROOT || newRel == UniversalEnglishGrammaticalRelations.CASE_MARKER) continue;
                    if (rcmodHeads.contains(gov) && rcmodHeads.contains(dep)) {
                        if (newRel == UniversalEnglishGrammaticalRelations.DIRECT_OBJECT || newRel == UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT) continue;
                        if (DEBUG) {
                            log.info("Adding new " + newRel + " dependency from " + newGov + " to " + dep + " (subj/obj case)");
                        }
                        sg.addEdge(newGov, dep, newRel, Double.NEGATIVE_INFINITY, true);
                        continue;
                    }
                    if (DEBUG) {
                        log.info("Adding new " + newRel + " dependency from " + newGov + " to " + dep);
                    }
                    sg.addEdge(newGov, dep, newRel, Double.NEGATIVE_INFINITY, true);
                }
            }
            String tag = dep.tag();
            if (!subjectMap.containsKey(gov) || !tag.startsWith("VB") && !tag.startsWith("JJ") || subjectMap.containsKey(dep)) continue;
            SemanticGraphEdge tdsubj = (SemanticGraphEdge)subjectMap.get(gov);
            GrammaticalRelation relation = tdsubj.getRelation();
            if (relation == UniversalEnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT) {
                if (UniversalEnglishGrammaticalStructure.isDefinitelyActive(tag)) {
                    relation = UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT;
                }
            } else if (relation == UniversalEnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT) {
                if (UniversalEnglishGrammaticalStructure.isDefinitelyActive(tag)) {
                    relation = UniversalEnglishGrammaticalRelations.CLAUSAL_SUBJECT;
                }
            } else if (relation == UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT) {
                if (withPassiveAuxiliary.contains(dep)) {
                    relation = UniversalEnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT;
                }
            } else if (relation == UniversalEnglishGrammaticalRelations.CLAUSAL_SUBJECT && withPassiveAuxiliary.contains(dep)) {
                relation = UniversalEnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT;
            }
            if (DEBUG) {
                log.info("Adding new " + relation + " dependency from " + dep + " to " + tdsubj.getDependent() + " (subj propagation case)");
            }
            sg.addEdge(dep, tdsubj.getDependent(), relation, Double.NEGATIVE_INFINITY, true);
        }
    }

    private static boolean isDefinitelyActive(String tag) {
        return tag.equals("VB") || tag.equals("VBZ") || tag.equals("VBP") || tag.startsWith("JJ");
    }

    private static void collapseReferent(SemanticGraph sg) {
        ArrayList<SemanticGraphEdge> refs = new ArrayList<SemanticGraphEdge>(sg.findAllRelns(UniversalEnglishGrammaticalRelations.REFERENT));
        SemanticGraph sgCopy = sg.makeSoftCopy();
        for (SemanticGraphEdge ref : refs) {
            IndexedWord dep = ref.getDependent();
            IndexedWord ant = ref.getGovernor();
            Iterator<SemanticGraphEdge> iter = sgCopy.incomingEdgeIterator(dep);
            while (iter.hasNext()) {
                SemanticGraphEdge edge = iter.next();
                if (edge.getRelation() == UniversalEnglishGrammaticalRelations.REFERENT || edge.getGovernor().equals(ant)) continue;
                sg.removeEdge(edge);
                sg.addEdge(edge.getGovernor(), ant, edge.getRelation(), Double.NEGATIVE_INFINITY, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addRef(SemanticGraph sg) {
        for (SemanticGraphEdge edge : sg.findAllRelns(UniversalEnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER)) {
            void var7_7;
            IndexedWord head = edge.getGovernor();
            IndexedWord modifier = edge.getDependent();
            SemanticGraphEdge leftChildEdge = null;
            for (SemanticGraphEdge semanticGraphEdge : sg.outgoingEdgeIterable(modifier)) {
                if (!EnglishPatterns.RELATIVIZING_WORD_PATTERN.matcher(semanticGraphEdge.getDependent().value()).matches() || leftChildEdge != null && semanticGraphEdge.getDependent().index() >= leftChildEdge.getDependent().index()) continue;
                leftChildEdge = semanticGraphEdge;
            }
            SemanticGraphEdge leftGrandchildEdge = null;
            for (SemanticGraphEdge childEdge3 : sg.outgoingEdgeIterable(modifier)) {
                for (SemanticGraphEdge grandchildEdge : sg.outgoingEdgeIterable(childEdge3.getDependent())) {
                    if (!EnglishPatterns.RELATIVIZING_WORD_PATTERN.matcher(grandchildEdge.getDependent().value()).matches() || leftGrandchildEdge != null && grandchildEdge.getDependent().index() >= leftGrandchildEdge.getDependent().index()) continue;
                    leftGrandchildEdge = grandchildEdge;
                }
            }
            Object var7_11 = null;
            if (leftGrandchildEdge != null && (leftChildEdge == null || leftGrandchildEdge.getDependent().index() < leftChildEdge.getDependent().index())) {
                IndexedWord indexedWord = leftGrandchildEdge.getDependent();
            } else if (leftChildEdge != null) {
                IndexedWord indexedWord = leftChildEdge.getDependent();
            }
            if (var7_7 == null || sg.containsEdge(head, (IndexedWord)var7_7)) continue;
            sg.addEdge(head, (IndexedWord)var7_7, UniversalEnglishGrammaticalRelations.REFERENT, Double.NEGATIVE_INFINITY, false);
        }
    }

    private static void addExtraNSubj(SemanticGraph sg) {
        for (SemanticGraphEdge xcomp : sg.findAllRelns(UniversalEnglishGrammaticalRelations.XCLAUSAL_COMPLEMENT)) {
            IndexedWord modifier = xcomp.getDependent();
            IndexedWord head = xcomp.getGovernor();
            boolean hasSubjectDaughter = false;
            boolean hasAux = false;
            ArrayList<IndexedWord> subjects = Generics.newArrayList();
            ArrayList<IndexedWord> objects = Generics.newArrayList();
            for (SemanticGraphEdge dep : sg.edgeIterable()) {
                if ((dep.getRelation() == UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT || dep.getRelation() == UniversalEnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT) && dep.getGovernor().equals(modifier)) {
                    hasSubjectDaughter = true;
                    break;
                }
                if ((dep.getRelation() == UniversalEnglishGrammaticalRelations.AUX_MODIFIER || dep.getRelation() == UniversalEnglishGrammaticalRelations.MARKER) && dep.getGovernor().equals(modifier)) {
                    hasAux = true;
                }
                if ((dep.getRelation() == UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT || dep.getRelation() == UniversalEnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT) && dep.getGovernor().equals(head)) {
                    subjects.add(dep.getDependent());
                }
                if (dep.getRelation() != UniversalEnglishGrammaticalRelations.DIRECT_OBJECT || !dep.getGovernor().equals(head)) continue;
                objects.add(dep.getDependent());
            }
            if (hasSubjectDaughter || modifier.value().equalsIgnoreCase("to") && hasAux || !modifier.value().equalsIgnoreCase("to") && !hasAux) continue;
            if (!objects.isEmpty()) {
                for (IndexedWord object : objects) {
                    if (sg.containsEdge(modifier, object)) continue;
                    sg.addEdge(modifier, object, UniversalEnglishGrammaticalRelations.CONTROLLING_NOMINAL_SUBJECT, Double.NEGATIVE_INFINITY, true);
                }
                continue;
            }
            for (IndexedWord subject : subjects) {
                if (sg.containsEdge(modifier, subject)) continue;
                sg.addEdge(modifier, subject, UniversalEnglishGrammaticalRelations.CONTROLLING_NOMINAL_SUBJECT, Double.NEGATIVE_INFINITY, true);
            }
        }
    }

    private static void correctSubjPass(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = CORRECT_SUBJPASS_PATTERN.matcher(sgCopy);
        while (matcher.find()) {
            IndexedWord gov = matcher.getNode("gov");
            IndexedWord subj = matcher.getNode("subj");
            SemanticGraphEdge edge = sg.getEdge(gov, subj);
            GrammaticalRelation reln = null;
            if (edge.getRelation() == UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT) {
                reln = UniversalEnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT;
            } else if (edge.getRelation() == UniversalEnglishGrammaticalRelations.CLAUSAL_SUBJECT) {
                reln = UniversalEnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT;
            } else if (edge.getRelation() == UniversalEnglishGrammaticalRelations.CONTROLLING_NOMINAL_SUBJECT) {
                reln = UniversalEnglishGrammaticalRelations.CONTROLLING_NOMINAL_PASSIVE_SUBJECT;
            } else if (edge.getRelation() == UniversalEnglishGrammaticalRelations.CONTROLLING_CLAUSAL_SUBJECT) {
                reln = UniversalEnglishGrammaticalRelations.CONTROLLING_CLAUSAL_PASSIVE_SUBJECT;
            }
            if (reln == null) continue;
            sg.removeEdge(edge);
            sg.addEdge(gov, subj, reln, Double.NEGATIVE_INFINITY, false);
        }
    }

    private static void processMultiwordPreps(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        HashMap<String, HashSet<Integer>> bigrams = new HashMap<String, HashSet<Integer>>();
        HashMap<String, HashSet<Integer>> trigrams = new HashMap<String, HashSet<Integer>>();
        List<IndexedWord> vertexList = sg.vertexListSorted();
        int numWords = vertexList.size();
        for (int i = 1; i < numWords; ++i) {
            String bigram = vertexList.get(i - 1).value().toLowerCase() + '_' + vertexList.get(i).value().toLowerCase();
            bigrams.putIfAbsent(bigram, new HashSet());
            bigrams.get(bigram).add(vertexList.get(i - 1).index());
            if (i <= 1) continue;
            String trigram = vertexList.get(i - 2).value().toLowerCase() + '_' + bigram;
            trigrams.putIfAbsent(trigram, new HashSet());
            trigrams.get(trigram).add(vertexList.get(i - 2).index());
        }
        UniversalEnglishGrammaticalStructure.processSimple2WP(sg, bigrams);
        UniversalEnglishGrammaticalStructure.processComplex2WP(sg, bigrams);
        UniversalEnglishGrammaticalStructure.process3WP(sg, trigrams);
    }

    private static void processSimple2WP(SemanticGraph sg, HashMap<String, HashSet<Integer>> bigrams) {
        for (String bigram : TWO_WORD_PREPS_REGULAR) {
            if (bigrams.get(bigram) == null) continue;
            for (Integer i : bigrams.get(bigram)) {
                IndexedWord w1 = sg.getNodeByIndexSafe(i);
                IndexedWord w2 = sg.getNodeByIndexSafe(i + 1);
                if (w1 == null || w2 == null) continue;
                SemgrexMatcher matcher = TWO_WORD_PREPS_REGULAR_PATTERN.matcher(sg);
                IndexedWord gov = null;
                while (matcher.find()) {
                    if (!w1.equals(matcher.getNode("w1")) || !w2.equals(matcher.getNode("w2"))) continue;
                    gov = matcher.getNode("gov");
                    break;
                }
                if (gov == null) continue;
                UniversalEnglishGrammaticalStructure.createMultiWordExpression(sg, gov, UniversalEnglishGrammaticalRelations.CASE_MARKER, w1, w2);
            }
        }
    }

    private static void processComplex2WP(SemanticGraph sg, HashMap<String, HashSet<Integer>> bigrams) {
        for (String bigram : TWO_WORD_PREPS_COMPLEX) {
            if (bigrams.get(bigram) == null) continue;
            for (Integer i : bigrams.get(bigram)) {
                SemanticGraphEdge edge;
                IndexedWord w1 = sg.getNodeByIndexSafe(i);
                IndexedWord w2 = sg.getNodeByIndexSafe(i + 1);
                if (w1 == null || w2 == null) continue;
                SemgrexMatcher matcher = TWO_WORD_PREPS_COMPLEX_PATTERN.matcher(sg);
                IndexedWord gov = null;
                IndexedWord gov2 = null;
                while (matcher.find()) {
                    if (!w1.equals(matcher.getNode("w1")) || !w2.equals(matcher.getNode("w2"))) continue;
                    gov = matcher.getNode("gov");
                    gov2 = matcher.getNode("gov2");
                    break;
                }
                if (gov2 == null) continue;
                if (sg.getRoots().contains(w1)) {
                    edge = sg.getEdge(w1, gov2);
                    if (edge == null) continue;
                    sg.removeEdge(edge);
                    sg.getRoots().remove(w1);
                    sg.addRoot(gov2);
                } else {
                    GrammaticalRelation reln2;
                    edge = sg.getEdge(w1, gov2);
                    if (edge == null) continue;
                    sg.removeEdge(edge);
                    IndexedWord indexedWord = gov = gov == null ? sg.getParent(w1) : gov;
                    if (gov == null) continue;
                    GrammaticalRelation reln = edge.getRelation();
                    if (sg.hasChildWithReln(w1, UniversalEnglishGrammaticalRelations.COPULA) && UniversalEnglishGrammaticalRelations.clauseRelations.contains(reln2 = sg.getEdge(gov, w1).getRelation())) {
                        reln = reln2;
                    }
                    sg.addEdge(gov, gov2, reln, Double.NEGATIVE_INFINITY, false);
                }
                for (SemanticGraphEdge edge2 : sg.getOutEdgesSorted(w1)) {
                    sg.removeEdge(edge2);
                    sg.addEdge(gov2, edge2.getDependent(), edge2.getRelation(), edge2.getWeight(), edge2.isExtra());
                }
                UniversalEnglishGrammaticalStructure.createMultiWordExpression(sg, gov2, UniversalEnglishGrammaticalRelations.CASE_MARKER, w1, w2);
            }
        }
    }

    private static void process3WP(SemanticGraph sg, HashMap<String, HashSet<Integer>> trigrams) {
        for (String trigram : THREE_WORD_PREPS) {
            if (trigrams.get(trigram) == null) continue;
            for (Integer i : trigrams.get(trigram)) {
                SemanticGraphEdge edge;
                IndexedWord w1 = sg.getNodeByIndexSafe(i);
                IndexedWord w2 = sg.getNodeByIndexSafe(i + 1);
                IndexedWord w3 = sg.getNodeByIndexSafe(i + 2);
                if (w1 == null || w2 == null || w3 == null) continue;
                SemgrexMatcher matcher = THREE_WORD_PREPS_PATTERN.matcher(sg);
                IndexedWord gov = null;
                IndexedWord gov2 = null;
                while (matcher.find()) {
                    if (!w1.equals(matcher.getNode("w1")) || !w2.equals(matcher.getNode("w2")) || !w3.equals(matcher.getNode("w3"))) continue;
                    gov = matcher.getNode("gov");
                    gov2 = matcher.getNode("gov2");
                    break;
                }
                if (gov2 == null) continue;
                GrammaticalRelation markerReln = UniversalEnglishGrammaticalRelations.CASE_MARKER;
                if (sg.getRoots().contains(w2)) {
                    edge = sg.getEdge(w2, gov2);
                    if (edge == null) continue;
                    sg.removeEdge(edge);
                    sg.getRoots().remove(w2);
                    sg.addRoot(gov2);
                } else {
                    edge = sg.getEdge(w2, gov2);
                    if (edge == null) continue;
                    sg.removeEdge(edge);
                    if ((gov = gov == null ? sg.getParent(w2) : gov) == null) continue;
                    GrammaticalRelation reln = sg.getEdge(gov, w2).getRelation();
                    if (reln == UniversalEnglishGrammaticalRelations.NOMINAL_MODIFIER && (edge.getRelation() == UniversalEnglishGrammaticalRelations.CLAUSAL_MODIFIER || edge.getRelation() == UniversalEnglishGrammaticalRelations.ADV_CLAUSE_MODIFIER)) {
                        reln = edge.getRelation();
                        markerReln = UniversalEnglishGrammaticalRelations.MARKER;
                    }
                    sg.addEdge(gov, gov2, reln, Double.NEGATIVE_INFINITY, false);
                }
                for (SemanticGraphEdge edge2 : sg.getOutEdgesSorted(w2)) {
                    sg.removeEdge(edge2);
                    sg.addEdge(gov2, edge2.getDependent(), edge2.getRelation(), edge2.getWeight(), edge2.isExtra());
                }
                UniversalEnglishGrammaticalStructure.createMultiWordExpression(sg, gov2, markerReln, w1, w2, w3);
            }
        }
    }

    private static void createMultiWordExpression(SemanticGraph sg, IndexedWord gov, GrammaticalRelation reln, IndexedWord ... words) {
        if (sg.getRoots().isEmpty() || gov == null || words.length < 1) {
            return;
        }
        boolean first = true;
        IndexedWord mweHead = null;
        for (IndexedWord word : words) {
            SemanticGraphEdge edge;
            IndexedWord wordGov = sg.getParent(word);
            if (wordGov != null && (edge = sg.getEdge(wordGov, word)) != null) {
                sg.removeEdge(edge);
            }
            if (first) {
                sg.addEdge(gov, word, reln, Double.NEGATIVE_INFINITY, false);
                mweHead = word;
                first = false;
                continue;
            }
            sg.addEdge(mweHead, word, UniversalEnglishGrammaticalRelations.MULTI_WORD_EXPRESSION, Double.NEGATIVE_INFINITY, false);
        }
        for (IndexedWord word : words) {
            for (SemanticGraphEdge edge : new ArrayList<SemanticGraphEdge>(sg.getOutEdgesSorted(word))) {
                if (edge.getRelation() == UniversalEnglishGrammaticalRelations.MULTI_WORD_EXPRESSION) continue;
                sg.removeEdge(edge);
                sg.addEdge(gov, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
            }
        }
    }

    private static void demoteQuantificationalModifiers(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = QUANT_MOD_3W_PATTERN.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            IndexedWord w1 = matcher.getNode("w1");
            IndexedWord w2 = matcher.getNode("w2");
            IndexedWord w3 = matcher.getNode("w3");
            IndexedWord gov = matcher.getNode("gov");
            UniversalEnglishGrammaticalStructure.demoteQmodParentHelper(sg, gov, w2);
            LinkedList<IndexedWord> otherDeps = Generics.newLinkedList();
            otherDeps.add(w1);
            otherDeps.add(w2);
            otherDeps.add(w3);
            UniversalEnglishGrammaticalStructure.demoteQmodMWEHelper(sg, otherDeps, gov, w2);
        }
        for (SemgrexPattern p : QUANT_MOD_2W_PATTERNS) {
            sgCopy = sg.makeSoftCopy();
            matcher = p.matcher(sgCopy);
            while (matcher.findNextMatchingNode()) {
                IndexedWord w1 = matcher.getNode("w1");
                IndexedWord w2 = matcher.getNode("w2");
                IndexedWord gov = matcher.getNode("gov");
                UniversalEnglishGrammaticalStructure.demoteQmodParentHelper(sg, gov, w1);
                LinkedList<IndexedWord> otherDeps = Generics.newLinkedList();
                otherDeps.add(w1);
                otherDeps.add(w2);
                UniversalEnglishGrammaticalStructure.demoteQmodMWEHelper(sg, otherDeps, gov, w1);
            }
        }
    }

    private static void demoteQmodMWEHelper(SemanticGraph sg, List<IndexedWord> otherDeps, IndexedWord gov, IndexedWord oldHead) {
        UniversalEnglishGrammaticalStructure.createMultiWordExpression(sg, gov, UniversalEnglishGrammaticalRelations.QMOD, otherDeps.toArray(new IndexedWord[0]));
    }

    private static void demoteQmodParentHelper(SemanticGraph sg, IndexedWord gov, IndexedWord oldHead) {
        if (!sg.getRoots().contains(oldHead)) {
            IndexedWord parent = sg.getParent(oldHead);
            if (parent == null) {
                return;
            }
            SemanticGraphEdge edge = sg.getEdge(parent, oldHead);
            sg.addEdge(parent, gov, edge.getRelation(), edge.getWeight(), edge.isExtra());
            sg.removeEdge(edge);
        } else {
            sg.getRoots().remove(oldHead);
            sg.addRoot(gov);
        }
        sg.addEdge(gov, oldHead, GrammaticalRelation.DEPENDENT, Double.NEGATIVE_INFINITY, false);
        sg.removeEdge(sg.getEdge(oldHead, gov));
    }

    private static void processNames(SemanticGraph sg) {
        if (!USE_NAME) {
            return;
        }
        if (sg.getRoots().isEmpty()) {
            return;
        }
        IndexedWord rootToken = sg.getFirstRoot();
        if (rootToken == null || !rootToken.containsKey(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        for (SemgrexPattern pattern : NAME_PATTERNS) {
            SemgrexMatcher matcher = pattern.matcher(sgCopy);
            ArrayList<IndexedWord> nameParts = new ArrayList<IndexedWord>();
            IndexedWord head = null;
            while (matcher.find()) {
                IndexedWord w1 = matcher.getNode("w1");
                IndexedWord w2 = matcher.getNode("w2");
                if (head != w1) {
                    if (head != null) {
                        UniversalEnglishGrammaticalStructure.processNamesHelper(sg, head, nameParts);
                        nameParts = new ArrayList();
                    }
                    head = w1;
                }
                if (!w2.ner().equals(w1.ner())) continue;
                nameParts.add(w2);
            }
            if (head == null) continue;
            UniversalEnglishGrammaticalStructure.processNamesHelper(sg, head, nameParts);
            sgCopy = sg.makeSoftCopy();
        }
    }

    private static void processNamesHelper(SemanticGraph sg, IndexedWord oldHead, List<IndexedWord> nameParts) {
        if (nameParts.size() < 1) {
            HashSet<IndexedWord> children = new HashSet<IndexedWord>(sg.getChildren(oldHead));
            for (IndexedWord child : children) {
                SemanticGraphEdge oldEdge = sg.getEdge(oldHead, child);
                if (oldEdge.getRelation() != UniversalEnglishGrammaticalRelations.COMPOUND_MODIFIER) continue;
                sg.addEdge(oldHead, child, UniversalEnglishGrammaticalRelations.NOMINAL_MODIFIER, oldEdge.getWeight(), oldEdge.isExtra());
                sg.removeEdge(oldEdge);
            }
            return;
        }
        Collections.sort(nameParts);
        int end = oldHead.index();
        for (int i = nameParts.get(0).index(); i < end; ++i) {
            IndexedWord node = sg.getNodeByIndexSafe(i);
            if (node == null) {
                return;
            }
            if (nameParts.contains(node) || !PUNCT_TAG_FILTER.test(node.tag())) continue;
            return;
        }
        IndexedWord gov = sg.getParent(oldHead);
        if (gov == null && !sg.getRoots().contains(oldHead)) {
            return;
        }
        IndexedWord newHead = nameParts.get(0);
        HashSet<IndexedWord> children = new HashSet<IndexedWord>(sg.getChildren(oldHead));
        for (IndexedWord child : children) {
            SemanticGraphEdge oldEdge;
            if (child == newHead) {
                if (gov == null) {
                    sg.getRoots().add(newHead);
                    sg.getRoots().remove(oldHead);
                } else {
                    oldEdge = sg.getEdge(gov, oldHead);
                    sg.addEdge(gov, newHead, oldEdge.getRelation(), oldEdge.getWeight(), oldEdge.isExtra());
                    sg.removeEdge(oldEdge);
                }
                oldEdge = sg.getEdge(oldHead, newHead);
                sg.addEdge(newHead, oldHead, UniversalEnglishGrammaticalRelations.NAME_MODIFIER, oldEdge.getWeight(), oldEdge.isExtra());
                sg.removeEdge(oldEdge);
                continue;
            }
            if (nameParts.contains(child)) {
                oldEdge = sg.getEdge(oldHead, child);
                sg.addEdge(newHead, child, UniversalEnglishGrammaticalRelations.NAME_MODIFIER, oldEdge.getWeight(), oldEdge.isExtra());
                sg.removeEdge(oldEdge);
                continue;
            }
            oldEdge = sg.getEdge(oldHead, child);
            GrammaticalRelation reln = oldEdge.getRelation() == UniversalEnglishGrammaticalRelations.COMPOUND_MODIFIER ? UniversalEnglishGrammaticalRelations.NOMINAL_MODIFIER : oldEdge.getRelation();
            sg.addEdge(newHead, child, reln, oldEdge.getWeight(), oldEdge.isExtra());
            sg.removeEdge(oldEdge);
        }
    }

    private static void removeExactDuplicates(SemanticGraph sg) {
        sg.deleteDuplicateEdges();
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticalStructureCollection(String fileName) throws IOException {
        return UniversalEnglishGrammaticalStructure.readCoNLLXGrammaticalStructureCollection(fileName, UniversalEnglishGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static UniversalEnglishGrammaticalStructure buildCoNLLXGrammaticalStructure(List<List<String>> tokenFields) {
        return (UniversalEnglishGrammaticalStructure)UniversalEnglishGrammaticalStructure.buildCoNLLXGrammaticalStructure(tokenFields, UniversalEnglishGrammaticalRelations.shortNameToGRel, new FromDependenciesFactory());
    }

    public static class FromDependenciesFactory
    implements GrammaticalStructureFromDependenciesFactory {
        @Override
        public UniversalEnglishGrammaticalStructure build(List<TypedDependency> tdeps, TreeGraphNode root) {
            return new UniversalEnglishGrammaticalStructure(tdeps, root);
        }
    }

    private static class ExtraTreeDepFilter
    implements Predicate<TypedDependency>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ExtraTreeDepFilter() {
        }

        @Override
        public boolean test(TypedDependency d) {
            return d != null && d.reln() != UniversalEnglishGrammaticalRelations.RELATIVE && d.reln() != UniversalEnglishGrammaticalRelations.PREPOSITION;
        }
    }
}

