/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.parser.lexparser.AbstractCollinizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Iterator;

public class ChineseCollinizer
implements AbstractCollinizer {
    private static Redwood.RedwoodChannels log = Redwood.channels(ChineseCollinizer.class);
    private static final boolean VERBOSE = false;
    private final boolean deletePunct;
    ChineseTreebankLanguagePack ctlp;
    protected TreeFactory tf = new LabeledScoredTreeFactory();

    public ChineseCollinizer(ChineseTreebankLanguagePack ctlp) {
        this(ctlp, true);
    }

    public ChineseCollinizer(ChineseTreebankLanguagePack ctlp, boolean deletePunct) {
        this.deletePunct = deletePunct;
        this.ctlp = ctlp;
    }

    @Override
    public Tree transformTree(Tree guess, Tree gold) {
        return this.transformTree(guess, gold, true);
    }

    private Tree transformTree(Tree guess, Tree gold, boolean isRoot) {
        if (guess == null || gold == null) {
            return null;
        }
        if (guess.yield().size() != gold.yield().size()) {
            return null;
        }
        return this.transformTree(guess, Trees.preTerminals(gold).iterator(), isRoot);
    }

    private Tree transformTree(Tree guess, Iterator<Tree> goldPreterminals, boolean isRoot) {
        Tree goldPT;
        String label = guess.label().value();
        if (guess.isPreTerminal() && this.deletePunct && (this.ctlp.isPunctuationTag((goldPT = goldPreterminals.next()).label().value()) || this.ctlp.isPunctuationWord(goldPT.firstChild().label().value()))) {
            return null;
        }
        if (guess.isLeaf()) {
            return this.tf.newLeaf(new StringLabel(label));
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (label.matches("ROOT.*") && guess.numChildren() == 1) {
            return this.transformTree(guess.children()[0], goldPreterminals, true);
        }
        label = label.replaceFirst("[^A-Z].*$", "");
        label = label.replaceFirst("PRN", "ADVP");
        for (int cNum = 0; cNum < guess.children().length; ++cNum) {
            Tree child = guess.children()[cNum];
            Tree newChild = this.transformTree(child, goldPreterminals, false);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.isEmpty() && !isRoot) {
            return null;
        }
        return this.tf.newTreeNode(new StringLabel(label), children);
    }
}

