/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.CoordinationPattern;
import edu.stanford.nlp.trees.tregex.DescriptionPattern;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IdentityHashSet;
import edu.stanford.nlp.util.Interner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class Relation
implements Serializable {
    private static final long serialVersionUID = -1564793674551362909L;
    private final String symbol;
    private static final Pattern parentOfLastChild = Pattern.compile("(<-|<`)");
    private static final Pattern lastChildOfParent = Pattern.compile("(>-|>`)");
    static final Relation ROOT = new Relation("Root"){
        private static final long serialVersionUID = -8311913236233762612L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                }
            };
        }
    };
    private static final Relation EQUALS = new Relation("=="){
        private static final long serialVersionUID = 164629344977943816L;

        @Override
        Iterator<Tree> searchNodeIterator(Tree t, TregexMatcher matcher) {
            return Collections.singletonList(t).iterator();
        }
    };
    private static final Relation PATTERN_SPLITTER = new Relation(":"){
        private static final long serialVersionUID = 3409941930361386114L;

        @Override
        Iterator<Tree> searchNodeIterator(Tree t, TregexMatcher matcher) {
            return matcher.getRoot().iterator();
        }
    };
    private static final Relation DOMINATES = new Relation("<<"){
        private static final long serialVersionUID = -2580199434621268260L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    for (int i = t.numChildren() - 1; i >= 0; --i) {
                        this.searchStack.push(t.getChild(i));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(this.next.getChild(i));
                        }
                    }
                }
            };
        }
    };
    private static final Relation DOMINATED_BY = new Relation(">>"){
        private static final long serialVersionUID = 6140614010121387690L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = matcher.getParent(t);
                }

                @Override
                public void advance() {
                    this.next = matcher.getParent(this.next);
                }
            };
        }
    };
    private static final Relation PARENT_OF = new Relation("<"){
        private static final long serialVersionUID = 9140193735607580808L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                int nextNum;

                @Override
                public void advance() {
                    if (this.nextNum < t.numChildren()) {
                        this.next = t.getChild(this.nextNum);
                        ++this.nextNum;
                    } else {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation CHILD_OF = new Relation(">"){
        private static final long serialVersionUID = 8919710375433372537L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = matcher.getParent(t);
                }
            };
        }
    };
    private static final Relation PRECEDES = new Relation(".."){
        private static final long serialVersionUID = -9065012389549976867L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    Tree current = t;
                    Tree parent = matcher.getParent(t);
                    while (parent != null) {
                        int i = parent.numChildren() - 1;
                        while (parent.getChild(i) != current) {
                            this.searchStack.push(parent.getChild(i));
                            --i;
                        }
                        current = parent;
                        parent = matcher.getParent(parent);
                    }
                    this.advance();
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(this.next.getChild(i));
                        }
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATELY_PRECEDES = new Relation("."){
        private static final long serialVersionUID = 3390147676937292768L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    Tree current;
                    Tree parent = t;
                    do {
                        current = parent;
                        if ((parent = matcher.getParent(parent)) != null) continue;
                        this.next = null;
                        return;
                    } while (parent.lastChild() == current);
                    int n = parent.numChildren();
                    for (int i = 1; i < n; ++i) {
                        if (parent.getChild(i - 1) != current) continue;
                        this.next = parent.getChild(i);
                        return;
                    }
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.firstChild();
                }
            };
        }
    };
    private static final Relation FOLLOWS = new Relation(",,"){
        private static final long serialVersionUID = -5948063114149496983L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    Tree current = t;
                    Tree parent = matcher.getParent(t);
                    while (parent != null) {
                        int i = 0;
                        while (parent.getChild(i) != current) {
                            this.searchStack.push(parent.getChild(i));
                            ++i;
                        }
                        current = parent;
                        parent = matcher.getParent(parent);
                    }
                    this.advance();
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(this.next.getChild(i));
                        }
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATELY_FOLLOWS = new Relation(","){
        private static final long serialVersionUID = -2895075562891296830L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    Tree current;
                    Tree parent = t;
                    do {
                        current = parent;
                        if ((parent = matcher.getParent(parent)) != null) continue;
                        this.next = null;
                        return;
                    } while (parent.firstChild() == current);
                    int n = parent.numChildren() - 1;
                    for (int i = 0; i < n; ++i) {
                        if (parent.getChild(i + 1) != current) continue;
                        this.next = parent.getChild(i);
                        return;
                    }
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.lastChild();
                }
            };
        }
    };
    private static final Relation HAS_LEFTMOST_DESCENDANT = new Relation("<<,"){
        private static final long serialVersionUID = -7352081789429366726L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.firstChild();
                }
            };
        }
    };
    private static final Relation HAS_RIGHTMOST_DESCENDANT = new Relation("<<-"){
        private static final long serialVersionUID = -1405509785337859888L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.lastChild();
                }
            };
        }
    };
    private static final Relation LEFTMOST_DESCENDANT_OF = new Relation(">>,"){
        private static final long serialVersionUID = 3103412865783190437L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    Tree last = this.next;
                    this.next = matcher.getParent(this.next);
                    if (this.next != null && this.next.firstChild() != last) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation RIGHTMOST_DESCENDANT_OF = new Relation(">>-"){
        private static final long serialVersionUID = -2000255467314675477L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    Tree last = this.next;
                    this.next = matcher.getParent(this.next);
                    if (this.next != null && this.next.lastChild() != last) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation SISTER_OF = new Relation("$"){
        private static final long serialVersionUID = -3776688096782419004L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Tree parent;
                int nextNum;

                @Override
                void initialize() {
                    this.parent = matcher.getParent(t);
                    if (this.parent != null) {
                        this.nextNum = 0;
                        this.advance();
                    }
                }

                @Override
                public void advance() {
                    if (this.nextNum < this.parent.numChildren()) {
                        this.next = this.parent.getChild(this.nextNum++);
                        if (this.next == t) {
                            this.advance();
                        }
                    } else {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation LEFT_SISTER_OF = new Relation("$++"){
        private static final long serialVersionUID = -4516161080140406862L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Tree parent;
                int nextNum;

                @Override
                void initialize() {
                    this.parent = matcher.getParent(t);
                    if (this.parent != null) {
                        this.nextNum = this.parent.numChildren() - 1;
                        this.advance();
                    }
                }

                @Override
                public void advance() {
                    this.next = this.parent.getChild(this.nextNum--);
                    if (this.next == t) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation RIGHT_SISTER_OF = new Relation("$--"){
        private static final long serialVersionUID = -5880626025192328694L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Tree parent;
                int nextNum;

                @Override
                void initialize() {
                    this.parent = matcher.getParent(t);
                    if (this.parent != null) {
                        this.nextNum = 0;
                        this.advance();
                    }
                }

                @Override
                public void advance() {
                    this.next = this.parent.getChild(this.nextNum++);
                    if (this.next == t) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATE_LEFT_SISTER_OF = new Relation("$+"){
        private static final long serialVersionUID = 7745237994722126917L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        Tree parent = matcher.getParent(t);
                        int i = 0;
                        while (parent.getChild(i) != t) {
                            ++i;
                        }
                        if (i + 1 < parent.numChildren()) {
                            this.next = parent.getChild(i + 1);
                        }
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATE_RIGHT_SISTER_OF = new Relation("$-"){
        private static final long serialVersionUID = -6555264189937531019L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        Tree parent = matcher.getParent(t);
                        int i = 0;
                        while (parent.getChild(i) != t) {
                            ++i;
                        }
                        if (i > 0) {
                            this.next = parent.getChild(i - 1);
                        }
                    }
                }
            };
        }
    };
    private static final Relation ONLY_CHILD_OF = new Relation(">:"){
        private static final long serialVersionUID = 1719812660770087879L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        this.next = matcher.getParent(t);
                        if (this.next.numChildren() != 1) {
                            this.next = null;
                        }
                    }
                }
            };
        }
    };
    private static final Relation HAS_ONLY_CHILD = new Relation("<:"){
        private static final long serialVersionUID = -8776487500849294279L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (!t.isLeaf() && t.numChildren() == 1) {
                        this.next = t.firstChild();
                    }
                }
            };
        }
    };
    private static final Relation UNARY_PATH_ANCESTOR_OF = new Relation("<<:"){
        private static final long serialVersionUID = -742912038636163403L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    if (!t.isLeaf() && t.children().length == 1) {
                        this.searchStack.push(t.getChild(0));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        if (!this.next.isLeaf() && this.next.children().length == 1) {
                            this.searchStack.push(this.next.getChild(0));
                        }
                    }
                }
            };
        }
    };
    private static final Relation UNARY_PATH_DESCENDANT_OF = new Relation(">>:"){
        private static final long serialVersionUID = 4364021807752979404L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    Tree parent = matcher.getParent(t);
                    if (parent != null && !parent.isLeaf() && parent.children().length == 1) {
                        this.searchStack.push(parent);
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        Tree parent = matcher.getParent(this.next);
                        if (parent != null && !parent.isLeaf() && parent.children().length == 1) {
                            this.searchStack.push(parent);
                        }
                    }
                }
            };
        }
    };
    private static final Relation PARENT_EQUALS = new Relation("<="){
        private static final long serialVersionUID = 98745298745198245L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                int nextNum;
                boolean usedParent;

                @Override
                public void advance() {
                    if (!this.usedParent) {
                        this.next = t;
                        this.usedParent = true;
                    } else if (this.nextNum < t.numChildren()) {
                        this.next = t.getChild(this.nextNum);
                        ++this.nextNum;
                    } else {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation ANCESTOR_OF_LEAF = new Relation("<<<"){
        private static final long serialVersionUID = -78542691313554L;

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    for (int i = t.numChildren() - 1; i >= 0; --i) {
                        this.searchStack.push(t.getChild(i));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    this.next = null;
                    while (this.next == null && !this.searchStack.isEmpty()) {
                        this.next = this.searchStack.pop();
                        for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(this.next.getChild(i));
                        }
                        if (this.next.isLeaf()) continue;
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation[] SIMPLE_RELATIONS = new Relation[]{DOMINATES, DOMINATED_BY, PARENT_OF, CHILD_OF, PRECEDES, IMMEDIATELY_PRECEDES, FOLLOWS, IMMEDIATELY_FOLLOWS, HAS_LEFTMOST_DESCENDANT, HAS_RIGHTMOST_DESCENDANT, LEFTMOST_DESCENDANT_OF, RIGHTMOST_DESCENDANT_OF, SISTER_OF, LEFT_SISTER_OF, RIGHT_SISTER_OF, IMMEDIATE_LEFT_SISTER_OF, IMMEDIATE_RIGHT_SISTER_OF, ONLY_CHILD_OF, HAS_ONLY_CHILD, EQUALS, PATTERN_SPLITTER, UNARY_PATH_ANCESTOR_OF, UNARY_PATH_DESCENDANT_OF, PARENT_EQUALS, ANCESTOR_OF_LEAF};
    private static final Map<String, Relation> SIMPLE_RELATIONS_MAP = Generics.newHashMap();

    abstract Iterator<Tree> searchNodeIterator(Tree var1, TregexMatcher var2);

    static Relation getRelation(String s, Function<String, String> basicCatFunction, HeadFinder headFinder) throws ParseException {
        Relation r;
        if (SIMPLE_RELATIONS_MAP.containsKey(s)) {
            return SIMPLE_RELATIONS_MAP.get(s);
        }
        if (s.equals("<,")) {
            return Relation.getRelation("<", "1", basicCatFunction, headFinder);
        }
        if (parentOfLastChild.matcher(s).matches()) {
            return Relation.getRelation("<", "-1", basicCatFunction, headFinder);
        }
        if (s.equals(">,")) {
            return Relation.getRelation(">", "1", basicCatFunction, headFinder);
        }
        if (lastChildOfParent.matcher(s).matches()) {
            return Relation.getRelation(">", "-1", basicCatFunction, headFinder);
        }
        switch (s) {
            case ">>#": {
                r = new Heads(headFinder);
                break;
            }
            case "<<#": {
                r = new HeadedBy(headFinder);
                break;
            }
            case ">#": {
                r = new ImmediatelyHeads(headFinder);
                break;
            }
            case "<#": {
                r = new ImmediatelyHeadedBy(headFinder);
                break;
            }
            default: {
                throw new ParseException("Unrecognized simple relation " + s);
            }
        }
        return Interner.globalIntern(r);
    }

    static Relation getRelation(String s, String arg, Function<String, String> basicCatFunction, HeadFinder headFinder) throws ParseException {
        Relation r;
        if (arg == null) {
            return Relation.getRelation(s, basicCatFunction, headFinder);
        }
        switch (s) {
            case "<": {
                r = new HasIthChild(Integer.parseInt(arg));
                break;
            }
            case ">": {
                r = new IthChildOf(Integer.parseInt(arg));
                break;
            }
            case "<+": {
                r = new UnbrokenCategoryDominates(arg, basicCatFunction);
                break;
            }
            case ">+": {
                r = new UnbrokenCategoryIsDominatedBy(arg, basicCatFunction);
                break;
            }
            case ".+": {
                r = new UnbrokenCategoryPrecedes(arg, basicCatFunction);
                break;
            }
            case ",+": {
                r = new UnbrokenCategoryFollows(arg, basicCatFunction);
                break;
            }
            case "<<<": {
                r = new AncestorOfIthLeaf(Integer.parseInt(arg));
                break;
            }
            default: {
                throw new ParseException("Unrecognized compound relation " + s + ' ' + arg);
            }
        }
        return Interner.globalIntern(r);
    }

    static TregexPattern constructMultiRelation(String s, List<DescriptionPattern> children, Function<String, String> basicCatFunction, HeadFinder headFinder) throws ParseException {
        if (s.equals("<...")) {
            ArrayList<TregexPattern> newChildren = Generics.newArrayList();
            for (int i = 0; i < children.size(); ++i) {
                Relation rel = Relation.getRelation("<", Integer.toString(i + 1), basicCatFunction, headFinder);
                DescriptionPattern oldChild = children.get(i);
                DescriptionPattern newChild = new DescriptionPattern(rel, oldChild);
                newChildren.add(newChild);
            }
            Relation rel = Relation.getRelation("<", Integer.toString(children.size() + 1), basicCatFunction, headFinder);
            DescriptionPattern noExtraChildren = new DescriptionPattern(rel, false, "__", null, false, basicCatFunction, Collections.emptyList(), false, null);
            noExtraChildren.negate();
            newChildren.add(noExtraChildren);
            return new CoordinationPattern(newChildren, true);
        }
        throw new ParseException("Unknown multi relation " + s);
    }

    private Relation(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation relation = (Relation)o;
        return this.symbol.equals(relation.symbol);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    static {
        for (Relation r : SIMPLE_RELATIONS) {
            SIMPLE_RELATIONS_MAP.put(r.symbol, r);
        }
        SIMPLE_RELATIONS_MAP.put("<<`", HAS_RIGHTMOST_DESCENDANT);
        SIMPLE_RELATIONS_MAP.put("<<,", HAS_LEFTMOST_DESCENDANT);
        SIMPLE_RELATIONS_MAP.put(">>`", RIGHTMOST_DESCENDANT_OF);
        SIMPLE_RELATIONS_MAP.put(">>,", LEFTMOST_DESCENDANT_OF);
        SIMPLE_RELATIONS_MAP.put("$..", LEFT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$,,", RIGHT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$.", IMMEDIATE_LEFT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$,", IMMEDIATE_RIGHT_SISTER_OF);
    }

    private static class UnbrokenCategoryFollows
    extends Relation {
        private static final long serialVersionUID = -7890430001297866437L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryFollows(String arg, Function<String, String> basicCatFunction) {
            super(",+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = basicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                IdentityHashSet<Tree> nodesToSearch;
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.nodesToSearch = new IdentityHashSet();
                    this.searchStack = new Stack();
                    this.initializeHelper(this.searchStack, t, matcher.getRoot());
                    this.advance();
                }

                private void initializeHelper(Stack<Tree> stack, Tree node, Tree root) {
                    if (node == root) {
                        return;
                    }
                    Tree parent = matcher.getParent(node);
                    int i = parent.objectIndexOf(node);
                    while (i == 0 && parent != root) {
                        node = parent;
                        parent = matcher.getParent(parent);
                        i = parent.objectIndexOf(node);
                    }
                    Tree precedingNode = i > 0 ? parent.children()[i - 1] : null;
                    while (precedingNode != null) {
                        if (!this.nodesToSearch.contains(precedingNode)) {
                            stack.add(precedingNode);
                            this.nodesToSearch.add(precedingNode);
                        }
                        if (this.pathMatchesNode(precedingNode)) {
                            this.initializeHelper(stack, precedingNode, root);
                        }
                        if (!precedingNode.isLeaf()) {
                            precedingNode = precedingNode.children()[0];
                            continue;
                        }
                        precedingNode = null;
                    }
                }

                @Override
                void advance() {
                    this.next = this.searchStack.isEmpty() ? null : this.searchStack.pop();
                }
            };
        }
    }

    private static class UnbrokenCategoryPrecedes
    extends Relation {
        private static final long serialVersionUID = 6866888667804306111L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryPrecedes(String arg, Function<String, String> basicCatFunction) {
            super(".+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = basicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                private IdentityHashSet<Tree> nodesToSearch;
                private Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.nodesToSearch = new IdentityHashSet();
                    this.searchStack = new Stack();
                    this.initializeHelper(this.searchStack, t, matcher.getRoot());
                    this.advance();
                }

                private void initializeHelper(Stack<Tree> stack, Tree node, Tree root) {
                    if (node == root) {
                        return;
                    }
                    Tree parent = matcher.getParent(node);
                    int i = parent.objectIndexOf(node);
                    while (i == parent.children().length - 1 && parent != root) {
                        node = parent;
                        parent = matcher.getParent(parent);
                        i = parent.objectIndexOf(node);
                    }
                    Tree followingNode = i + 1 < parent.children().length ? parent.children()[i + 1] : null;
                    while (followingNode != null) {
                        if (!this.nodesToSearch.contains(followingNode)) {
                            stack.add(followingNode);
                            this.nodesToSearch.add(followingNode);
                        }
                        if (this.pathMatchesNode(followingNode)) {
                            this.initializeHelper(stack, followingNode, root);
                        }
                        if (!followingNode.isLeaf()) {
                            followingNode = followingNode.children()[0];
                            continue;
                        }
                        followingNode = null;
                    }
                }

                @Override
                void advance() {
                    this.next = this.searchStack.isEmpty() ? null : this.searchStack.pop();
                }
            };
        }
    }

    private static class UnbrokenCategoryIsDominatedBy
    extends Relation {
        private static final long serialVersionUID = 2867922828235355129L;
        private final UnbrokenCategoryDominates unbrokenCategoryDominates;

        UnbrokenCategoryIsDominatedBy(String arg, Function<String, String> basicCatFunction) {
            super(">+(" + arg + ')');
            this.unbrokenCategoryDominates = Interner.globalIntern(new UnbrokenCategoryDominates(arg, basicCatFunction));
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = matcher.getParent(t);
                }

                @Override
                public void advance() {
                    this.next = unbrokenCategoryDominates.pathMatchesNode(this.next) ? matcher.getParent(this.next) : null;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnbrokenCategoryIsDominatedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnbrokenCategoryIsDominatedBy unbrokenCategoryIsDominatedBy = (UnbrokenCategoryIsDominatedBy)o;
            return this.unbrokenCategoryDominates.equals(unbrokenCategoryIsDominatedBy.unbrokenCategoryDominates);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + this.unbrokenCategoryDominates.hashCode();
            return result;
        }
    }

    private static class UnbrokenCategoryDominates
    extends Relation {
        private static final long serialVersionUID = -4174923168221859262L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryDominates(String arg, Function<String, String> basicCatFunction) {
            super("<+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = basicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    for (int i = t.numChildren() - 1; i >= 0; --i) {
                        this.searchStack.push(t.getChild(i));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        if (this.pathMatchesNode(this.next)) {
                            for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                                this.searchStack.push(this.next.getChild(i));
                            }
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnbrokenCategoryDominates)) {
                return false;
            }
            UnbrokenCategoryDominates unbrokenCategoryDominates = (UnbrokenCategoryDominates)o;
            if (this.negatedPattern != unbrokenCategoryDominates.negatedPattern) {
                return false;
            }
            return this.pattern.equals(unbrokenCategoryDominates.pattern);
        }

        @Override
        public int hashCode() {
            int result = this.pattern.hashCode();
            result = 29 * result + (this.negatedPattern ? 1 : 0);
            return result;
        }
    }

    private static class HasIthChild
    extends Relation {
        private static final long serialVersionUID = 3546853729291582806L;
        private final IthChildOf ithChildOf;

        HasIthChild(int i) {
            super('<' + String.valueOf(i));
            this.ithChildOf = Interner.globalIntern(new IthChildOf(i));
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    int childNum = ithChildOf.childNum;
                    if (t.numChildren() >= Math.abs(childNum)) {
                        this.next = childNum > 0 ? t.getChild(childNum - 1) : t.getChild(t.numChildren() + childNum);
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HasIthChild)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HasIthChild hasIthChild = (HasIthChild)o;
            return !(this.ithChildOf != null ? !this.ithChildOf.equals(hasIthChild.ithChildOf) : hasIthChild.ithChildOf != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.ithChildOf != null ? this.ithChildOf.hashCode() : 0);
            return result;
        }
    }

    private static class IthChildOf
    extends Relation {
        private static final long serialVersionUID = -1463126827537879633L;
        private final int childNum;

        IthChildOf(int i) {
            super('>' + String.valueOf(i));
            if (i == 0) {
                throw new IllegalArgumentException("Error -- no such thing as zeroth child!");
            }
            this.childNum = i;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        this.next = matcher.getParent(t);
                        if (childNum > 0 && (this.next.numChildren() < childNum || this.next.getChild(childNum - 1) != t) || childNum < 0 && (this.next.numChildren() < -childNum || this.next.getChild(this.next.numChildren() + childNum) != t)) {
                            this.next = null;
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IthChildOf)) {
                return false;
            }
            IthChildOf ithChildOf = (IthChildOf)o;
            return this.childNum == ithChildOf.childNum;
        }

        @Override
        public int hashCode() {
            return this.childNum;
        }
    }

    private static class ImmediatelyHeadedBy
    extends Relation {
        private static final long serialVersionUID = 5910075663419780905L;
        private final ImmediatelyHeads immediatelyHeads;

        ImmediatelyHeadedBy(HeadFinder hf) {
            super("<#");
            this.immediatelyHeads = Interner.globalIntern(new ImmediatelyHeads(hf));
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (!t.isLeaf()) {
                        this.next = matcher.getHeadFinder() != null ? matcher.getHeadFinder().determineHead(t) : immediatelyHeads.hf.determineHead(t);
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImmediatelyHeadedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ImmediatelyHeadedBy immediatelyHeadedBy = (ImmediatelyHeadedBy)o;
            return !(this.immediatelyHeads != null ? !this.immediatelyHeads.equals(immediatelyHeadedBy.immediatelyHeads) : immediatelyHeadedBy.immediatelyHeads != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.immediatelyHeads != null ? this.immediatelyHeads.hashCode() : 0);
            return result;
        }
    }

    private static class ImmediatelyHeads
    extends Relation {
        private static final long serialVersionUID = 2085410152913894987L;
        private final HeadFinder hf;

        ImmediatelyHeads(HeadFinder hf) {
            super(">#");
            this.hf = hf;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        HeadFinder headFinder;
                        this.next = matcher.getParent(t);
                        HeadFinder headFinder2 = headFinder = matcher.getHeadFinder() == null ? hf : matcher.getHeadFinder();
                        if (headFinder.determineHead(this.next) != t) {
                            this.next = null;
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImmediatelyHeads)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ImmediatelyHeads immediatelyHeads = (ImmediatelyHeads)o;
            return !(this.hf != null ? !this.hf.equals(immediatelyHeads.hf) : immediatelyHeads.hf != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.hf != null ? this.hf.hashCode() : 0);
            return result;
        }
    }

    private static class HeadedBy
    extends Relation {
        private static final long serialVersionUID = 2825997185749055693L;
        private final Heads heads;

        HeadedBy(HeadFinder hf) {
            super("<<#");
            this.heads = Interner.globalIntern(new Heads(hf));
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : (matcher.getHeadFinder() != null ? matcher.getHeadFinder().determineHead(this.next) : ((HeadedBy)this).heads.hf.determineHead(this.next));
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeadedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HeadedBy headedBy = (HeadedBy)o;
            return !(this.heads != null ? !this.heads.equals(headedBy.heads) : headedBy.heads != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.heads != null ? this.heads.hashCode() : 0);
            return result;
        }
    }

    private static class Heads
    extends Relation {
        private static final long serialVersionUID = 4681433462932265831L;
        final HeadFinder hf;

        Heads(HeadFinder hf) {
            super(">>#");
            this.hf = hf;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    HeadFinder headFinder = matcher.getHeadFinder();
                    if (headFinder == null) {
                        headFinder = hf;
                    }
                    Tree last = this.next;
                    this.next = matcher.getParent(this.next);
                    if (this.next != null && headFinder.determineHead(this.next) != last) {
                        this.next = null;
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Heads)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Heads heads = (Heads)o;
            return !(this.hf != null ? !this.hf.equals(heads.hf) : heads.hf != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.hf != null ? this.hf.hashCode() : 0);
            return result;
        }
    }

    private static class AncestorOfIthLeaf
    extends Relation {
        private static final long serialVersionUID = -6495191354526L;
        private final int leafNum;

        AncestorOfIthLeaf(int i) {
            super("<<<" + String.valueOf(i));
            if (i == 0) {
                throw new IllegalArgumentException("Error -- no such thing as zeroth leaf!");
            }
            this.leafNum = i;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    List leaves = t.getLeaves();
                    if (leaves.size() >= Math.abs(leafNum)) {
                        int index = leafNum > 0 ? leafNum - 1 : leafNum + leaves.size();
                        this.next = (Tree)leaves.get(index);
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AncestorOfIthLeaf)) {
                return false;
            }
            AncestorOfIthLeaf other = (AncestorOfIthLeaf)o;
            return this.leafNum == other.leafNum;
        }

        @Override
        public int hashCode() {
            return this.leafNum + 20;
        }
    }

    static abstract class SearchNodeIterator
    implements Iterator<Tree> {
        Tree next;

        public SearchNodeIterator() {
            this.initialize();
        }

        void initialize() {
            this.advance();
        }

        void advance() {
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Tree next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Tree ret = this.next;
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SearchNodeIterator does not support remove().");
        }
    }
}

