/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ProcessProtobufRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessTsurgeonRequest
extends ProcessProtobufRequest {
    private static List<Pair<TregexPattern, TsurgeonPattern>> parseOperations(List<CoreNLPProtos.TsurgeonRequest.Operation> protoOperations) {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> operations = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        TregexPatternCompiler compiler = new TregexPatternCompiler();
        for (CoreNLPProtos.TsurgeonRequest.Operation protoOp : protoOperations) {
            TregexPattern tregex = compiler.compile(protoOp.getTregex());
            List<TsurgeonPattern> surgeries = protoOp.getTsurgeonList().stream().map(Tsurgeon::parseOperation).collect(Collectors.toList());
            TsurgeonPattern tsurgeon = Tsurgeon.collectOperations(surgeries);
            operations.add(new Pair<TregexPattern, TsurgeonPattern>(tregex, tsurgeon));
        }
        return operations;
    }

    public static CoreNLPProtos.TsurgeonResponse processRequest(CoreNLPProtos.TsurgeonRequest request) {
        ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer();
        CoreNLPProtos.TsurgeonResponse.Builder responseBuilder = CoreNLPProtos.TsurgeonResponse.newBuilder();
        List<Pair<TregexPattern, TsurgeonPattern>> operations = ProcessTsurgeonRequest.parseOperations(request.getOperationsList());
        List trees = request.getTreesList().stream().map(ProtobufAnnotationSerializer::fromProto).collect(Collectors.toList());
        for (Tree tree : trees) {
            tree = Tsurgeon.processPatternsOnTree(operations, tree);
            responseBuilder.addTrees(ProtobufAnnotationSerializer.toFlattenedTree(tree));
        }
        return responseBuilder.build();
    }

    @Override
    public void processInputStream(InputStream in, OutputStream out2) throws IOException {
        CoreNLPProtos.TsurgeonRequest request = CoreNLPProtos.TsurgeonRequest.parseFrom(in);
        CoreNLPProtos.TsurgeonResponse response = ProcessTsurgeonRequest.processRequest(request);
        response.writeTo(out2);
    }

    public static void main(String[] args) throws IOException {
        ProcessProtobufRequest.process(new ProcessTsurgeonRequest(), args);
    }
}

