/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class ProcessProtobufRequest {
    public abstract void processInputStream(InputStream var1, OutputStream var2) throws IOException;

    public void processMultipleInputs(InputStream in, OutputStream out2) throws IOException {
        DataInputStream din = new DataInputStream(new BufferedInputStream(in));
        DataOutputStream dout = new DataOutputStream(out2);
        int size = 0;
        do {
            int chunk;
            try {
                size = din.readInt();
            }
            catch (EOFException e) {
                size = 0;
            }
            if (size == 0) {
                dout.writeInt(0);
                break;
            }
            byte[] inputArray = new byte[size];
            for (int lenRead = 0; lenRead < size; lenRead += chunk) {
                chunk = din.read(inputArray, lenRead, size - lenRead);
                if (chunk > 0) continue;
                throw new IOException("Failed to read as much data as we were supposed to!");
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(inputArray);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.processInputStream(bin, result);
            byte[] outputArray = result.toByteArray();
            dout.writeInt(outputArray.length);
            dout.write(outputArray);
        } while (size > 0);
    }

    public static String[] leftoverArgs(String[] args) {
        args = (String[])Arrays.stream(args).filter(x -> !x.equals("-multiple") && !x.equals("--multiple")).toArray(String[]::new);
        return args;
    }

    public static void process(ProcessProtobufRequest processor, String ... args) throws IOException {
        if (args.length > 0 && (args[0].equalsIgnoreCase("-multiple") || args[0].equalsIgnoreCase("--multiple"))) {
            processor.processMultipleInputs(System.in, System.out);
        } else {
            processor.processInputStream(System.in, System.out);
        }
    }
}

