/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.wordseg.CorpusDictionary;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class NonDict2 {
    public static final String DEFAULT_HOME = "/u/nlp/data/gale/segtool/stanford-seg/data/";
    public final String corporaDict;
    private final CorpusDictionary cd;
    private static Redwood.RedwoodChannels logger = Redwood.channels(NonDict2.class);

    public NonDict2(SeqClassifierFlags flags) {
        String path;
        this.corporaDict = flags.sighanCorporaDict != null ? flags.sighanCorporaDict : DEFAULT_HOME;
        if (flags.dict2name != null && !flags.dict2name.equals("")) {
            path = this.corporaDict + "/dict/" + flags.dict2name;
            logger.info("INFO: dict2name specified | building NonDict2 from " + path);
        } else {
            if (flags.useAs || flags.useHk || flags.useMsr) {
                throw new RuntimeException("only support settings for CTB and PKU now.");
            }
            if (flags.usePk) {
                path = this.corporaDict + "/dict/pku.non";
                logger.info("INFO: flags.usePk=true | building NonDict2 from " + path);
            } else {
                path = this.corporaDict + "/dict/ctb.non";
                logger.info("INFO: flags.usePk=false | building NonDict2 from " + path);
            }
        }
        this.cd = new CorpusDictionary(path);
    }

    public String checkDic(String c2, SeqClassifierFlags flags) {
        if (this.cd.getW(c2).equals("1")) {
            return "1";
        }
        return "0";
    }

    public static void main(String[] args) throws IOException {
        Properties props = StringUtils.argsToProperties(args, SeqClassifierFlags.flagsToNumArgs());
        SeqClassifierFlags flags = new SeqClassifierFlags(props);
        String inputFilename = flags.textFile;
        String outputFilename = flags.outputFile;
        DocumentReaderAndWriter readerAndWriter = AbstractSequenceClassifier.makePlainTextReaderAndWriter(flags);
        readerAndWriter.init(flags);
        HashSet<String> splitBigrams = new HashSet<String>();
        FileReader fin = new FileReader(inputFilename);
        Iterable iterable = () -> readerAndWriter.getIterator(fin);
        List prevSentence = null;
        for (List sentence : iterable) {
            for (int i = 0; i < sentence.size() - 1; ++i) {
                String prevWord = ((CoreLabel)sentence.get(i)).value();
                String nextWord = ((CoreLabel)sentence.get(i + 1)).value();
                String bigram = prevWord.substring(prevWord.length() - 1) + nextWord.substring(0, 1);
                splitBigrams.add(bigram);
            }
            if (prevSentence != null) {
                String prevWord = ((CoreLabel)prevSentence.get(prevSentence.size() - 1)).value();
                String nextWord = ((CoreLabel)sentence.get(0)).value();
                String bigram = prevWord.substring(prevWord.length() - 1) + nextWord.substring(0, 1);
                splitBigrams.add(bigram);
            }
            prevSentence = sentence;
        }
        fin.close();
        PrintWriter fout = IOUtils.getPrintWriter(outputFilename, "utf-8");
        for (String bigram : splitBigrams) {
            fout.print(bigram);
            fout.println();
        }
        fout.close();
    }
}

